/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.exports;

import it.uniud.mads.jlibbig.core.attachedProperties.Property;
import it.uniud.mads.jlibbig.core.ldb.Child;
import it.uniud.mads.jlibbig.core.ldb.DirectedBigraph;
import it.uniud.mads.jlibbig.core.ldb.DirectedControl;
import it.uniud.mads.jlibbig.core.ldb.DirectedSignature;
import it.uniud.mads.jlibbig.core.ldb.Edge;
import it.uniud.mads.jlibbig.core.ldb.Handle;
import it.uniud.mads.jlibbig.core.ldb.InPort;
import it.uniud.mads.jlibbig.core.ldb.Node;
import it.uniud.mads.jlibbig.core.ldb.OutPort;
import it.uniud.mads.jlibbig.core.ldb.Point;
import it.uniud.mads.jlibbig.core.ldb.Root;
import it.uniud.mads.jlibbig.core.ldb.Site;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ExportsDirectedBigraph {
    private static String tab4 = "    ";
    private static String jsonPreFix = "{\n" + tab4 + "\"graph\": {\n";
    private static String jsonPostFix = tab4 + "}\n}\n";

    public static String export(DirectedBigraph bigraph) {
        Object jsonOut = jsonPreFix;
        jsonOut = (String)jsonOut + ExportsDirectedBigraph.getNodes(bigraph);
        jsonOut = (String)jsonOut + ExportsDirectedBigraph.getEdge(bigraph);
        jsonOut = (String)jsonOut + tab4 + tab4 + "\"type\": \"ldb\",\n";
        jsonOut = (String)jsonOut + ExportsDirectedBigraph.getMetadata(bigraph);
        jsonOut = (String)jsonOut + jsonPostFix;
        return jsonOut;
    }

    /*
     * WARNING - void declaration
     */
    private static String getNodes(DirectedBigraph bigraph) {
        String[] nameArr;
        String name;
        String jsonPre = tab4 + tab4 + "\"nodes\": {\n";
        String jsonPost = tab4 + tab4 + "},\n";
        Object jsonOut = jsonPre;
        List<? extends Root> roots = bigraph.getRoots();
        for (int i = 0; i < roots.size(); ++i) {
            Root root = roots.get(i);
            String string = tab4 + tab4 + tab4 + "\"" + root.toString() + "\": {\n" + tab4 + tab4 + tab4 + tab4 + "\"metadata\": {\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"type\": \"root\",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"location\": " + i + "\n" + tab4 + tab4 + tab4 + tab4 + "},\n" + tab4 + tab4 + tab4 + tab4 + "\"label\": \"" + root.toString() + "\"\n" + tab4 + tab4 + tab4 + "},\n";
            jsonOut = (String)jsonOut + string;
        }
        Collection<? extends Node> nodes = bigraph.getNodes();
        for (Node node : nodes) {
            String label;
            try {
                label = (String)node.getProperty("Label").get();
            }
            catch (NullPointerException e) {
                label = "";
            }
            String jsonSingle = tab4 + tab4 + tab4 + "\"" + node.getName() + "\": {\n" + tab4 + tab4 + tab4 + tab4 + "\"metadata\": {\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"type\": \"node\",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"control\": \"" + node.getControl().getName() + "\",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"properties\": {\n";
            Collection<Property<?>> properties = node.getProperties();
            for (Property<?> property : properties) {
                String propertyName = property.getName();
                String propertyJson = tab4 + tab4 + tab4 + tab4 + tab4 + tab4 + "\"" + propertyName + "\": ";
                if (propertyName.equals("Label") || propertyName.equals("Owner")) continue;
                String propertyContent = property.get().toString();
                try {
                    if (propertyContent.substring(0, 3).equals("[#]")) {
                        String[] stringArray = propertyContent.substring(3).split("#, ");
                        propertyJson = propertyJson + "[ \n";
                        for (int i = 0; i < stringArray.length; ++i) {
                            propertyJson = propertyJson + tab4 + tab4 + tab4 + tab4 + tab4 + tab4 + tab4 + "\"" + stringArray[i] + "\",\n";
                        }
                        propertyJson = propertyJson.substring(0, propertyJson.length() - 2) + "\n";
                        propertyJson = propertyJson + tab4 + tab4 + tab4 + tab4 + tab4 + tab4 + " ],\n";
                        jsonSingle = jsonSingle + propertyJson;
                        continue;
                    }
                    propertyJson = propertyJson + "\"" + propertyContent + "\",\n";
                    jsonSingle = jsonSingle + propertyJson;
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    propertyJson = propertyJson + "\"" + propertyContent + "\",\n";
                    jsonSingle = jsonSingle + propertyJson;
                }
            }
            jsonSingle = jsonSingle.substring(0, jsonSingle.length() - 2) + "\n";
            jsonSingle = jsonSingle + tab4 + tab4 + tab4 + tab4 + tab4 + "}\n" + tab4 + tab4 + tab4 + tab4 + "},\n" + tab4 + tab4 + tab4 + tab4 + "\"label\": \"" + label + "\"\n" + tab4 + tab4 + tab4 + "},\n";
            jsonOut = (String)jsonOut + jsonSingle;
        }
        List<? extends Site> list = bigraph.getSites();
        for (int i = 0; i < list.size(); ++i) {
            Site site = list.get(i);
            String jsonSingle = tab4 + tab4 + tab4 + "\"" + site.toString() + "\": {\n" + tab4 + tab4 + tab4 + tab4 + "\"metadata\": {\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"type\": \"site\"\n" + tab4 + tab4 + tab4 + tab4 + "},\n" + tab4 + tab4 + tab4 + tab4 + "\"label\": \"" + site.toString() + "\"\n" + tab4 + tab4 + tab4 + "},\n";
            jsonOut = (String)jsonOut + jsonSingle;
        }
        DirectedBigraph.Interface in = bigraph.getInnerInterface();
        DirectedBigraph.Interface out = bigraph.getOuterInterface();
        Set<String> setIn = in.keySet();
        Iterator<String> setInIterator = setIn.iterator();
        Set<String> setOut = out.keySet();
        Iterator<String> setOutIterator = setOut.iterator();
        while (setInIterator.hasNext()) {
            void var16_30;
            name = setInIterator.next();
            nameArr = name.split(" ");
            String string = nameArr[1];
            if (string.equals("r")) {
                String string2 = "-";
            } else if (string.equals("l")) {
                String string3 = "+";
            }
            String jsonSingle = tab4 + tab4 + tab4 + "\"" + nameArr[2] + "\": {\n" + tab4 + tab4 + tab4 + tab4 + "\"metadata\": {\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"type\": \"name\",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"interface\": \"inner\",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"locality\": " + nameArr[0] + ",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"polarity\": \"" + (String)var16_30 + "\"\n" + tab4 + tab4 + tab4 + tab4 + "},\n" + tab4 + tab4 + tab4 + tab4 + "\"label\": \"" + nameArr[2] + "\"\n" + tab4 + tab4 + tab4 + "},\n";
            jsonOut = (String)jsonOut + jsonSingle;
        }
        while (setOutIterator.hasNext()) {
            void var16_35;
            name = setOutIterator.next();
            nameArr = name.split(" ");
            String string = nameArr[1];
            if (string.equals("r")) {
                String string4 = "-";
            } else if (string.equals("l")) {
                String string5 = "+";
            }
            String jsonSingle = tab4 + tab4 + tab4 + "\"" + nameArr[2] + "\": {\n" + tab4 + tab4 + tab4 + tab4 + "\"metadata\": {\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"type\": \"name\",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"interface\": \"outer\",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"locality\": " + nameArr[0] + ",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"polarity\": \"" + (String)var16_35 + "\"\n" + tab4 + tab4 + tab4 + tab4 + "},\n" + tab4 + tab4 + tab4 + tab4 + "\"label\": \"" + nameArr[2] + "\"\n" + tab4 + tab4 + tab4 + "},\n";
            jsonOut = (String)jsonOut + jsonSingle;
        }
        Collection<? extends Edge> edges = bigraph.getEdges();
        for (Edge edge : edges) {
            String jsonSingle = tab4 + tab4 + tab4 + "\"" + edge.toString() + "\": {\n" + tab4 + tab4 + tab4 + tab4 + "\"metadata\": {\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"type\": \"edge\"\n" + tab4 + tab4 + tab4 + tab4 + "},\n" + tab4 + tab4 + tab4 + tab4 + "\"label\": \"" + edge.toString() + "\"\n" + tab4 + tab4 + tab4 + "},\n";
            jsonOut = (String)jsonOut + jsonSingle;
        }
        jsonOut = ((String)jsonOut).substring(0, ((String)jsonOut).length() - 3);
        jsonOut = (String)jsonOut + "}\n";
        jsonOut = (String)jsonOut + jsonPost;
        return jsonOut;
    }

    private static String getEdge(DirectedBigraph bigraph) {
        String jsonPre = tab4 + tab4 + "\"edges\": [\n";
        String jsonPost = tab4 + tab4 + "],\n";
        Object jsonOut = jsonPre;
        jsonOut = (String)jsonOut + ExportsDirectedBigraph.getPlaceRelationship(bigraph);
        jsonOut = (String)jsonOut + ExportsDirectedBigraph.getLinkedToRelationship(bigraph);
        jsonOut = ((String)jsonOut).substring(0, ((String)jsonOut).length() - 3);
        jsonOut = (String)jsonOut + "}\n";
        jsonOut = (String)jsonOut + jsonPost;
        return jsonOut;
    }

    private static String getPlaceRelationship(DirectedBigraph bigraph) {
        Object jsonOut = "";
        List<? extends Root> roots = bigraph.getRoots();
        for (int i = 0; i < roots.size(); ++i) {
            Root root = roots.get(i);
            Collection<? extends Child> collection = root.getChildren();
            for (Child child : collection) {
                String string = tab4 + tab4 + tab4 + tab4 + "{\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"source\": \"" + root.toString() + "\",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"relation\": \"place\",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"target\": \"" + child.toString().split(":")[0] + "\",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"metadata\": {\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "}\n" + tab4 + tab4 + tab4 + tab4 + "},\n";
                jsonOut = (String)jsonOut + string;
            }
        }
        Collection<? extends Node> nodes = bigraph.getNodes();
        for (Node node : nodes) {
            if (!node.isParent()) continue;
            Collection<? extends Child> children = node.getChildren();
            for (Child child : children) {
                String jsonSingle = tab4 + tab4 + tab4 + tab4 + "{\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"source\": \"" + node.getName() + "\",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"relation\": \"place\",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"target\": \"" + child.toString().split(":")[0] + "\",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"metadata\": {\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "}\n" + tab4 + tab4 + tab4 + tab4 + "},\n";
                jsonOut = (String)jsonOut + jsonSingle;
            }
        }
        return jsonOut;
    }

    /*
     * WARNING - void declaration
     */
    private static String getLinkedToRelationship(DirectedBigraph bigraph) {
        Object jsonOut = "";
        Collection<? extends Node> nodes = bigraph.getNodes();
        for (Node node : nodes) {
            List<? extends OutPort> nodeOutPortList = node.getOutPorts();
            for (OutPort outPort : nodeOutPortList) {
                void var9_14;
                Handle handle = outPort.getHandle();
                String string = handle.toString();
                String portFrom = Integer.toString(outPort.getNumber());
                String portTo = "";
                if (handle.isPort()) {
                    portTo = handle.toString().substring(0, 1);
                    String string2 = string.substring(3, 7);
                }
                String string3 = tab4 + tab4 + tab4 + tab4 + "{\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"source\": \"" + outPort.getNode().getName() + "\",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"relation\": \"linkedTo\",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"target\": \"" + (String)var9_14 + "\",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"metadata\": {\n" + tab4 + tab4 + tab4 + tab4 + tab4 + tab4 + "\"portFrom\": \"" + portFrom + "\",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + tab4 + "\"portTo\": \"" + portTo + "\"\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "}\n" + tab4 + tab4 + tab4 + tab4 + "},\n";
                jsonOut = (String)jsonOut + string3;
            }
            List<? extends InPort> list = node.getInPorts();
            for (InPort inPort : list) {
                Collection<? extends Point> points = inPort.getPoints();
                for (Point point : points) {
                    if (point.isPort()) continue;
                    String portFrom = "";
                    String portTo = Integer.toString(inPort.getNumber());
                    String jsonSingle = tab4 + tab4 + tab4 + tab4 + "{\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"source\": \"" + point.toString() + "\",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"relation\": \"linkedTo\",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"target\": \"" + inPort.getNode().getName() + "\",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"metadata\": {\n" + tab4 + tab4 + tab4 + tab4 + tab4 + tab4 + "\"portFrom\": \"" + portFrom + "\",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + tab4 + "\"portTo\": \"" + portTo + "\"\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "}\n" + tab4 + tab4 + tab4 + tab4 + "},\n";
                    jsonOut = (String)jsonOut + jsonSingle;
                }
            }
        }
        jsonOut = (String)jsonOut + ExportsDirectedBigraph.getLinkNameToName(bigraph);
        return jsonOut;
    }

    private static String getLinkNameToName(DirectedBigraph bigraph) {
        Object jsonOut = "";
        String bigraphToString = bigraph.toString();
        String[] bigraphArr = bigraphToString.split("\n");
        for (int i = 0; i < bigraphArr.length; ++i) {
            if (!bigraphArr[i].startsWith("I") && !bigraphArr[i].startsWith("O") || !bigraphArr[i].startsWith("I", 10) && !bigraphArr[i].startsWith("O", 10)) continue;
            String source = bigraphArr[i].substring(13, 14);
            String target = bigraphArr[i].substring(4, 5);
            String jsonSingle = tab4 + tab4 + tab4 + tab4 + "{\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"source\": \"" + source + "\",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"relation\": \"linkedTo\",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"target\": \"" + target + "\",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"metadata\": {\n" + tab4 + tab4 + tab4 + tab4 + tab4 + tab4 + "\"portFrom\": \"\",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + tab4 + "\"portTo\": \"\"\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "}\n" + tab4 + tab4 + tab4 + tab4 + "},\n";
            jsonOut = (String)jsonOut + jsonSingle;
        }
        return jsonOut;
    }

    private static String getMetadata(DirectedBigraph bigraph) {
        String jsonPre = tab4 + tab4 + "\"metadata\": {\n" + tab4 + tab4 + tab4 + "\"signature\": {\n";
        String jsonPost = tab4 + tab4 + tab4 + "}\n" + tab4 + tab4 + "}\n";
        Object jsonOut = jsonPre;
        DirectedSignature signature = bigraph.getSignature();
        for (DirectedControl control : signature) {
            String jsonSingle = tab4 + tab4 + tab4 + tab4 + "\"" + control.getName() + "\": {\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"active\": " + control.isActive() + ",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"arityOut\": " + control.getArityOut() + ",\n" + tab4 + tab4 + tab4 + tab4 + tab4 + "\"arityIn\": " + control.getArityIn() + "\n" + tab4 + tab4 + tab4 + tab4 + "},\n";
            jsonOut = (String)jsonOut + jsonSingle;
        }
        jsonOut = ((String)jsonOut).substring(0, ((String)jsonOut).length() - 3);
        jsonOut = (String)jsonOut + "}\n";
        jsonOut = (String)jsonOut + jsonPost;
        return jsonOut;
    }
}

