/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.imports.ldb.buildgraph;

import it.uniud.mads.jlibbig.core.Owned;
import it.uniud.mads.jlibbig.core.attachedProperties.PropertyListener;
import it.uniud.mads.jlibbig.core.attachedProperties.SharedProperty;
import it.uniud.mads.jlibbig.core.attachedProperties.SimpleProperty;
import it.uniud.mads.jlibbig.core.imports.buildgraph.DirectedBuildGraph;
import it.uniud.mads.jlibbig.core.imports.constant.Constants;
import it.uniud.mads.jlibbig.core.imports.exception.NoExistingId;
import it.uniud.mads.jlibbig.core.imports.exception.NoExistingParent;
import it.uniud.mads.jlibbig.core.imports.exception.NoValidPort;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphControlRecord;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphLinkRecord;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphListOfControlRecord;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphListOfObjectRecord;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphNameRecord;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphNodeRecord;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphObjectRecord;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphPropertyRecord;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphRootRecord;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphSiteRecord;
import it.uniud.mads.jlibbig.core.imports.records.BigraphObjectRecord;
import it.uniud.mads.jlibbig.core.ldb.DirectedBigraph;
import it.uniud.mads.jlibbig.core.ldb.DirectedBigraphBuilder;
import it.uniud.mads.jlibbig.core.ldb.DirectedSignature;
import it.uniud.mads.jlibbig.core.ldb.DirectedSignatureBuilder;
import it.uniud.mads.jlibbig.core.ldb.Handle;
import it.uniud.mads.jlibbig.core.ldb.InPort;
import it.uniud.mads.jlibbig.core.ldb.InnerName;
import it.uniud.mads.jlibbig.core.ldb.Node;
import it.uniud.mads.jlibbig.core.ldb.OutPort;
import it.uniud.mads.jlibbig.core.ldb.OuterName;
import it.uniud.mads.jlibbig.core.ldb.Parent;
import it.uniud.mads.jlibbig.core.ldb.Root;
import it.uniud.mads.jlibbig.core.ldb.Site;
import java.util.ArrayList;
import java.util.List;

public class BuildGraph
implements DirectedBuildGraph {
    private List<Root> rootsList = new ArrayList<Root>();
    private List<String> rootListId = new ArrayList<String>();
    private List<OuterName> outerNames = new ArrayList<OuterName>();
    private List<String> outerNamesId = new ArrayList<String>();
    private List<InnerName> innerNames = new ArrayList<InnerName>();
    private List<String> innerNamesId = new ArrayList<String>();
    private List<Node> nodesList = new ArrayList<Node>();
    private List<String> nodesListId = new ArrayList<String>();
    private List<Site> sitesList = new ArrayList<Site>();
    private List<String> siteListId = new ArrayList<String>();
    private DirectedBigraphBuilder builderRecord = null;

    @Override
    public DirectedBigraph build(DirectedBigraphListOfObjectRecord listOfObject, DirectedBigraphListOfControlRecord listOfControl) {
        DirectedSignature signature = this.buildSignatures(listOfControl);
        DirectedBigraphBuilder builder = this.createBuilder(signature);
        this.buildRoots(builder, listOfObject);
        this.buildOuterName(builder, listOfObject);
        this.buildObject(builder, listOfObject);
        this.buildInnerName(builder, listOfObject);
        try {
            this.reLinkGraph(builder, listOfObject);
        }
        catch (NoValidPort e) {
            System.err.println(e);
            System.exit(1);
        }
        this.builderRecord = builder;
        DirectedBigraph bigraph = builder.makeBigraph();
        return bigraph;
    }

    private DirectedSignature buildSignatures(DirectedBigraphListOfControlRecord listOfControl) {
        DirectedSignatureBuilder signatureBuilder = new DirectedSignatureBuilder();
        for (int i = 0; i < listOfControl.size(); ++i) {
            DirectedBigraphControlRecord control = (DirectedBigraphControlRecord)listOfControl.get(i);
            signatureBuilder.add(control.getName(), control.isActive(), control.getArityOut(), control.getArityIn());
        }
        DirectedSignature signature = signatureBuilder.makeSignature();
        return signature;
    }

    private DirectedBigraphBuilder createBuilder(DirectedSignature signature) {
        DirectedBigraphBuilder builder = new DirectedBigraphBuilder(signature);
        return builder;
    }

    private void buildRoots(DirectedBigraphBuilder builder, DirectedBigraphListOfObjectRecord listOfObject) {
        List<DirectedBigraphObjectRecord> rootList = listOfObject.getListRootSorted();
        for (int i = 0; i < rootList.size(); ++i) {
            DirectedBigraphRootRecord obj = (DirectedBigraphRootRecord)rootList.get(i);
            Root root = builder.addRoot();
            String rootId = obj.getId();
            this.rootsList.add(root);
            this.rootListId.add(rootId);
        }
    }

    private void buildOuterName(DirectedBigraphBuilder builder, DirectedBigraphListOfObjectRecord listOfObject) {
        for (int i = 0; i < listOfObject.size(); ++i) {
            String newOuterNameId;
            OuterName newOuterName;
            if (!((DirectedBigraphObjectRecord)listOfObject.get(i)).getType().equals((Object)Constants.TypeOfNodes.name)) continue;
            DirectedBigraphNameRecord name = (DirectedBigraphNameRecord)listOfObject.get(i);
            if (name.getNameInterface().equals((Object)Constants.TypeOfInterface.outer) && name.getPolarity().equals((Object)Constants.TypeOfPolarity.plus)) {
                newOuterName = builder.addAscNameOuterInterface(name.getLocality(), name.getId());
                newOuterNameId = name.getId();
                this.outerNames.add(newOuterName);
                this.outerNamesId.add(newOuterNameId);
                continue;
            }
            if (!name.getNameInterface().equals((Object)Constants.TypeOfInterface.inner) || !name.getPolarity().equals((Object)Constants.TypeOfPolarity.minus)) continue;
            newOuterName = builder.addDescNameInnerInterface(name.getLocality(), name.getId());
            newOuterNameId = name.getId();
            this.outerNames.add(newOuterName);
            this.outerNamesId.add(newOuterNameId);
        }
    }

    private void buildObject(DirectedBigraphBuilder builder, DirectedBigraphListOfObjectRecord listOfObject) {
        block10: for (int i = 0; i < listOfObject.size(); ++i) {
            DirectedBigraphObjectRecord obj = (DirectedBigraphObjectRecord)listOfObject.get(i);
            switch (obj.getType()) {
                case node: {
                    Parent parent;
                    try {
                        DirectedBigraphNodeRecord elementNode = (DirectedBigraphNodeRecord)obj;
                        parent = this.searchParent(elementNode.getParent().getId(), elementNode.getParent().getType());
                        try {
                            List<Handle> handles = this.searchHandles(elementNode.getToLinks());
                            Node node = builder.addNode(elementNode.getControl().getName(), parent, handles);
                            List<DirectedBigraphPropertyRecord> properties = elementNode.getProperties();
                            for (DirectedBigraphPropertyRecord property : properties) {
                                if (property.getType().equals((Object)Constants.TypeOfProperty.string)) {
                                    node.attachProperty(new SharedProperty<String>(new SimpleProperty<String>(property.getId(), property.getProperties().get(0), true, new PropertyListener[0])));
                                    continue;
                                }
                                Object propertiesArg = "[#]";
                                for (int j = 0; j < property.getProperties().size(); ++j) {
                                    propertiesArg = (String)propertiesArg + property.getProperty(j) + "#, ";
                                }
                                propertiesArg = ((String)propertiesArg).substring(0, ((String)propertiesArg).length() - 3);
                                node.attachProperty(new SharedProperty<Object>(new SimpleProperty<Object>(property.getId(), propertiesArg, true, new PropertyListener[0])));
                            }
                            if (!elementNode.getLabel().equals("")) {
                                node.attachProperty(new SharedProperty<String>(new SimpleProperty<String>("Label", elementNode.getLabel(), true, new PropertyListener[0])));
                            }
                            String nodeId = elementNode.getId();
                            this.nodesList.add(node);
                            this.nodesListId.add(nodeId);
                        }
                        catch (NoValidPort e) {
                            System.err.println(e);
                            System.exit(1);
                        }
                    }
                    catch (NoExistingParent e) {
                        System.err.println(e);
                        System.exit(1);
                    }
                    continue block10;
                }
                case site: {
                    Parent parent;
                    try {
                        DirectedBigraphSiteRecord elementSite = (DirectedBigraphSiteRecord)obj;
                        parent = this.searchParent(elementSite.getParent().getId(), elementSite.getParent().getType());
                        Site site = builder.addSite(parent);
                        String siteId = elementSite.getId();
                        this.sitesList.add(site);
                        this.siteListId.add(siteId);
                    }
                    catch (NoExistingParent e) {
                        System.err.println(e);
                        System.exit(1);
                    }
                    continue block10;
                }
            }
        }
    }

    private Parent searchParent(String id, Constants.TypeOfNodes type) throws NoExistingParent {
        switch (type) {
            case root: {
                for (int i = 0; i < this.rootListId.size(); ++i) {
                    if (!this.rootListId.get(i).equals(id)) continue;
                    return this.rootsList.get(i);
                }
                throw new NoExistingParent();
            }
            case node: {
                for (int i = 0; i < this.nodesListId.size(); ++i) {
                    if (!this.nodesListId.get(i).equals(id)) continue;
                    return this.nodesList.get(i);
                }
                throw new NoExistingParent();
            }
        }
        throw new NoExistingParent();
    }

    private List<Handle> searchHandles(List<DirectedBigraphLinkRecord> links) throws NoValidPort {
        int j;
        int i;
        ArrayList<Handle> list = new ArrayList<Handle>();
        for (i = 0; i < this.outerNamesId.size(); ++i) {
            for (j = 0; j < links.size(); ++j) {
                if (!this.outerNamesId.get(i).equals(links.get(j).getLink().getId())) continue;
                list.add(this.outerNames.get(i));
            }
        }
        for (i = 0; i < this.nodesListId.size(); ++i) {
            for (j = 0; j < links.size(); ++j) {
                if (!this.nodesListId.get(i).equals(links.get(j).getLink().getId())) continue;
                try {
                    list.add(this.nodesList.get(i).getInPort(links.get(j).getLinkedPort()));
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new NoValidPort("Error: the port of " + links.get(j).getLink().getId() + " it's not valid. Recived port: " + links.get(j).getLinkedPort() + ".");
                }
            }
        }
        return list;
    }

    private void buildInnerName(DirectedBigraphBuilder builder, DirectedBigraphListOfObjectRecord listOfObject) {
        for (int i = 0; i < listOfObject.size(); ++i) {
            String newInnerNameId;
            InnerName newInnerName;
            List<Handle> handles;
            List<DirectedBigraphLinkRecord> links;
            if (!((DirectedBigraphObjectRecord)listOfObject.get(i)).getType().equals((Object)Constants.TypeOfNodes.name)) continue;
            DirectedBigraphNameRecord name = (DirectedBigraphNameRecord)listOfObject.get(i);
            if (name.getNameInterface().equals((Object)Constants.TypeOfInterface.outer) && name.getPolarity().equals((Object)Constants.TypeOfPolarity.minus)) {
                links = name.getInnerName();
                try {
                    handles = this.searchHandles(links);
                    newInnerName = handles.isEmpty() ? builder.addDescNameOuterInterface(name.getLocality(), name.getId()) : builder.addDescNameOuterInterface(name.getLocality(), name.getId(), handles.get(0));
                    newInnerNameId = name.getId();
                    this.innerNames.add(newInnerName);
                    this.innerNamesId.add(newInnerNameId);
                }
                catch (NoValidPort e) {
                    System.err.println(e);
                    System.exit(1);
                }
                continue;
            }
            if (!name.getNameInterface().equals((Object)Constants.TypeOfInterface.inner) || !name.getPolarity().equals((Object)Constants.TypeOfPolarity.plus)) continue;
            links = name.getInnerName();
            try {
                handles = this.searchHandles(links);
                newInnerName = handles.isEmpty() ? builder.addAscNameInnerInterface(name.getLocality(), name.getId()) : builder.addAscNameInnerInterface(name.getLocality(), name.getId(), handles.get(0));
                newInnerNameId = name.getId();
                this.innerNames.add(newInnerName);
                this.innerNamesId.add(newInnerNameId);
                continue;
            }
            catch (NoValidPort e) {
                System.err.println(e);
                System.exit(1);
            }
        }
    }

    private void reLinkGraph(DirectedBigraphBuilder builder, DirectedBigraphListOfObjectRecord listOfObject) throws NoValidPort {
        block20: for (int i = 0; i < listOfObject.size(); ++i) {
            DirectedBigraphObjectRecord obj = (DirectedBigraphObjectRecord)listOfObject.get(i);
            switch (obj.getType()) {
                case node: {
                    DirectedBigraphNodeRecord node = (DirectedBigraphNodeRecord)obj;
                    List<DirectedBigraphLinkRecord> nodeLinksTo = node.getToLinks();
                    for (DirectedBigraphLinkRecord singleLinkto : nodeLinksTo) {
                        BigraphObjectRecord linkedObj = singleLinkto.getLink();
                        int ownerPort = singleLinkto.getOwnerPort();
                        try {
                            Owned target;
                            Node source = this.searchNode(node.getId());
                            if (linkedObj.getType().equals((Object)Constants.TypeOfNodes.name)) {
                                try {
                                    target = this.searchOuterName(linkedObj.getId());
                                    OutPort pointSource = source.getOutPort(ownerPort);
                                    OuterName handleTarget = target;
                                    builder.relink((Handle)handleTarget, pointSource);
                                    continue;
                                }
                                catch (NoExistingId e) {
                                    System.err.println(e);
                                    System.exit(1);
                                    continue;
                                }
                                catch (IndexOutOfBoundsException e) {
                                    throw new NoValidPort("Error: the port of " + source.getName() + " it's not valid. Recived port: " + ownerPort + ".");
                                }
                            }
                            if (linkedObj.getType().equals((Object)Constants.TypeOfNodes.node)) {
                                target = null;
                                int linkedPort = singleLinkto.getLinkedPort();
                                try {
                                    target = this.searchNode(linkedObj.getId());
                                    OutPort pointSource = source.getOutPort(ownerPort);
                                    InPort handleTarget = target.getInPort(linkedPort);
                                    builder.relink((Handle)handleTarget, pointSource);
                                    continue;
                                }
                                catch (NoExistingId e) {
                                    System.err.println(e);
                                    System.exit(1);
                                    continue;
                                }
                                catch (IndexOutOfBoundsException e) {
                                    throw new NoValidPort("Error: the port of " + source.getName() + " or " + target.getName() + " it's not valid. Recived owner port: " + ownerPort + ". Recived target port: " + linkedPort);
                                }
                            }
                            if (!linkedObj.getType().equals((Object)Constants.TypeOfNodes.edge)) continue;
                        }
                        catch (NoExistingId e) {
                            System.err.println(e);
                            System.exit(1);
                        }
                    }
                    continue block20;
                }
                case name: {
                    DirectedBigraphNameRecord name = (DirectedBigraphNameRecord)obj;
                    List<DirectedBigraphLinkRecord> nameLinksTo = name.getToLinks();
                    for (DirectedBigraphLinkRecord singleLinkto : nameLinksTo) {
                        BigraphObjectRecord linkedObj = singleLinkto.getLink();
                        try {
                            List<InnerName> sourceList = this.searchInnerName(name.getId());
                            for (InnerName source : sourceList) {
                                Owned target;
                                if (linkedObj.getType().equals((Object)Constants.TypeOfNodes.name)) {
                                    try {
                                        target = this.searchOuterName(linkedObj.getId());
                                        InnerName pointSource = source;
                                        OuterName handleTarget = target;
                                        builder.relink((Handle)handleTarget, pointSource);
                                    }
                                    catch (NoExistingId e) {
                                        System.err.println(e);
                                        System.exit(1);
                                    }
                                    continue;
                                }
                                if (linkedObj.getType().equals((Object)Constants.TypeOfNodes.node)) {
                                    target = null;
                                    int linkedPort = singleLinkto.getLinkedPort();
                                    try {
                                        target = this.searchNode(linkedObj.getId());
                                        InnerName pointSource = source;
                                        InPort handleTarget = target.getInPort(linkedPort);
                                        builder.relink((Handle)handleTarget, pointSource);
                                        continue;
                                    }
                                    catch (NoExistingId e) {
                                        System.err.println(e);
                                        System.exit(1);
                                        continue;
                                    }
                                    catch (IndexOutOfBoundsException e) {
                                        throw new NoValidPort("Error: the port of " + target.getName() + " it's not valid. Recived port: " + linkedPort + ".");
                                    }
                                }
                                if (!linkedObj.getType().equals((Object)Constants.TypeOfNodes.edge)) continue;
                            }
                        }
                        catch (NoExistingId e) {
                            System.err.println(e);
                            System.exit(1);
                        }
                    }
                    continue block20;
                }
                case edge: {
                    continue block20;
                }
            }
        }
    }

    private Node searchNode(String id) throws NoExistingId {
        for (int i = 0; i < this.nodesListId.size(); ++i) {
            if (!this.nodesListId.get(i).equals(id)) continue;
            Node node = this.nodesList.get(i);
            return node;
        }
        throw new NoExistingId();
    }

    private OuterName searchOuterName(String id) throws NoExistingId {
        for (int i = 0; i < this.outerNamesId.size(); ++i) {
            if (!this.outerNamesId.get(i).equals(id)) continue;
            OuterName outerName = this.outerNames.get(i);
            return outerName;
        }
        throw new NoExistingId();
    }

    private List<InnerName> searchInnerName(String id) throws NoExistingId {
        ArrayList<InnerName> innerNameList = new ArrayList<InnerName>();
        for (int i = 0; i < this.innerNamesId.size(); ++i) {
            if (!this.innerNamesId.get(i).contains(id)) continue;
            innerNameList.add(this.innerNames.get(i));
            return innerNameList;
        }
        throw new NoExistingId();
    }

    public DirectedBigraphBuilder getBuilderRecord() {
        return this.builderRecord;
    }
}

