/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.imports.ldb.parseinput;

import it.uniud.mads.jlibbig.core.imports.constant.Constants;
import it.uniud.mads.jlibbig.core.imports.exception.NoExistingId;
import it.uniud.mads.jlibbig.core.imports.exception.NoImplementedLink;
import it.uniud.mads.jlibbig.core.imports.exception.NoValidPlaceRelationship;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphLinkRecord;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphListOfObjectRecord;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphObjectRecord;
import it.uniud.mads.jlibbig.core.imports.parseinput.DirectedParserEdge;
import org.json.JSONArray;
import org.json.JSONObject;

public class ParserEdge
implements DirectedParserEdge {
    @Override
    public void parseEdges(JSONArray arr, DirectedBigraphListOfObjectRecord listOfObject) {
        for (int i = 0; i < arr.length(); ++i) {
            try {
                this.parseSingleLink(arr.getJSONObject(i), listOfObject);
                continue;
            }
            catch (NoImplementedLink e) {
                System.err.println(e);
                System.exit(1);
            }
        }
    }

    private void parseSingleLink(JSONObject obj, DirectedBigraphListOfObjectRecord listOfObject) throws NoImplementedLink {
        String source = obj.getString("source");
        String target = obj.getString("target");
        String relation = obj.getString("relation");
        JSONObject metadata = obj.getJSONObject("metadata");
        try {
            Constants.TypeOfLink typeOfLink = Constants.TypeOfLink.valueOf(relation);
            switch (typeOfLink) {
                case place: {
                    this.parsePlace(source, target, listOfObject);
                    break;
                }
                case linkedTo: {
                    this.parseLink(source, target, metadata, listOfObject);
                    break;
                }
                default: {
                    throw new NoImplementedLink();
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new NoImplementedLink("Error: Wrong type of link found. Types expexted: " + Constants.TypeOfLink.place + " or " + Constants.TypeOfLink.linkedTo);
        }
    }

    private void parsePlace(String source, String target, DirectedBigraphListOfObjectRecord listOfObject) {
        try {
            this.setPlaceRelationship(this.findObject(source, listOfObject), this.findObject(target, listOfObject));
        }
        catch (NoExistingId e) {
            System.err.println(e);
            System.exit(1);
        }
        catch (NoValidPlaceRelationship e) {
            System.err.println(e);
            System.exit(1);
        }
    }

    private DirectedBigraphObjectRecord findObject(String id, DirectedBigraphListOfObjectRecord listOfObject) throws NoExistingId {
        for (int i = 0; i < listOfObject.size(); ++i) {
            DirectedBigraphObjectRecord object = (DirectedBigraphObjectRecord)listOfObject.get(i);
            if (!object.getId().equals(id)) continue;
            return object;
        }
        throw new NoExistingId("Error: the id " + id + " doesn't exist");
    }

    private void setPlaceRelationship(DirectedBigraphObjectRecord parent, DirectedBigraphObjectRecord son) throws NoValidPlaceRelationship {
        if (son.getType().equals((Object)Constants.TypeOfNodes.root)) {
            throw new NoValidPlaceRelationship("Error: a root cannot be a son. See place relationship for " + son.getId());
        }
        if (parent.getType().equals((Object)Constants.TypeOfNodes.site)) {
            throw new NoValidPlaceRelationship("Error: a site cannot be a parent. See place relationship for " + parent.getId());
        }
        parent.addSon(son);
        son.setParent(parent);
    }

    private void parseLink(String source, String target, JSONObject metadata, DirectedBigraphListOfObjectRecord listOfObject) {
        try {
            ParserEdge.setLinkRelationship(this.findObject(source, listOfObject), this.findObject(target, listOfObject), metadata);
        }
        catch (NoExistingId e) {
            System.err.println(e);
            System.exit(1);
        }
    }

    private static void setLinkRelationship(DirectedBigraphObjectRecord source, DirectedBigraphObjectRecord target, JSONObject metadata) {
        int sourcePort = source.getType().equals((Object)Constants.TypeOfNodes.name) || source.getType().equals((Object)Constants.TypeOfNodes.edge) ? -1 : metadata.getInt("portFrom");
        int targetPort = target.getType().equals((Object)Constants.TypeOfNodes.name) || target.getType().equals((Object)Constants.TypeOfNodes.edge) ? -1 : metadata.getInt("portTo");
        DirectedBigraphLinkRecord sourceLink = new DirectedBigraphLinkRecord(target, sourcePort, targetPort, Constants.DirectionOfLink.to);
        DirectedBigraphLinkRecord targetLink = new DirectedBigraphLinkRecord(source, targetPort, sourcePort, Constants.DirectionOfLink.from);
        source.addLink(sourceLink);
        target.addLink(targetLink);
    }
}

