/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.imports.ldb.parseinput;

import it.uniud.mads.jlibbig.core.imports.constant.Constants;
import it.uniud.mads.jlibbig.core.imports.exception.IdAlreadyExists;
import it.uniud.mads.jlibbig.core.imports.exception.NoExistingControl;
import it.uniud.mads.jlibbig.core.imports.exception.NoValidInterface;
import it.uniud.mads.jlibbig.core.imports.exception.NoValidPolarity;
import it.uniud.mads.jlibbig.core.imports.exception.NotImplementedType;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphControlRecord;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphEdgeRecord;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphListOfControlRecord;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphListOfObjectRecord;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphNameRecord;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphNodeRecord;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphObjectRecord;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphPropertyRecord;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphRootRecord;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphSiteRecord;
import it.uniud.mads.jlibbig.core.imports.parseinput.DirectedParserNode;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ParserNode
implements DirectedParserNode {
    @Override
    public void parseNodes(JSONObject nodes, DirectedBigraphListOfObjectRecord listOfObject, DirectedBigraphListOfControlRecord listOfControl) {
        JSONArray nodeNames = nodes.names();
        int n = nodeNames.length();
        for (int i = 0; i < n; ++i) {
            try {
                JSONObject element = nodes.getJSONObject(nodeNames.getString(i));
                this.parseSingleObjectOfNodes(element, nodeNames.getString(i), listOfObject, listOfControl);
                continue;
            }
            catch (JSONException e) {
                System.err.println((Object)e);
                System.exit(1);
                continue;
            }
            catch (NotImplementedType e) {
                System.err.println(e);
                System.exit(1);
            }
        }
    }

    private void parseSingleObjectOfNodes(JSONObject obj, String id, DirectedBigraphListOfObjectRecord listOfObject, DirectedBigraphListOfControlRecord listOfControl) throws NotImplementedType {
        JSONObject metadata = obj.getJSONObject("metadata");
        String type = metadata.getString("type");
        try {
            Constants.TypeOfNodes typeOfNodes = Constants.TypeOfNodes.valueOf(type);
            switch (typeOfNodes) {
                case root: {
                    this.parseRootObject(obj, id, listOfObject);
                    break;
                }
                case node: {
                    this.parseNodeObject(obj, id, listOfObject, listOfControl);
                    break;
                }
                case site: {
                    this.parseSiteObject(obj, id, listOfObject);
                    break;
                }
                case name: {
                    this.parseNameObject(obj, id, listOfObject);
                    break;
                }
                case edge: {
                    this.parseEdgeObject(obj, id, listOfObject);
                    break;
                }
                default: {
                    throw new NotImplementedType();
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new NotImplementedType("Error: Object " + obj.getString("label") + " doesn't have a valid Type. Type found: " + type + ". Types expexted: " + Constants.TypeOfNodes.root + ", " + Constants.TypeOfNodes.node + ", " + Constants.TypeOfNodes.site + ", " + Constants.TypeOfNodes.name + ", " + Constants.TypeOfNodes.edge);
        }
        catch (IdAlreadyExists e) {
            System.err.println(e);
            System.exit(1);
        }
        catch (NoExistingControl e) {
            System.err.println(e);
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
    }

    private void parseRootObject(JSONObject obj, String id, DirectedBigraphListOfObjectRecord listOfObject) throws IdAlreadyExists {
        String label;
        for (int i = 0; i < listOfObject.size(); ++i) {
            if (!((DirectedBigraphObjectRecord)listOfObject.get(i)).getId().equals(id)) continue;
            throw new IdAlreadyExists("Error: The root id " + id + " already exists.");
        }
        JSONObject metadata = obj.getJSONObject("metadata");
        int location = metadata.getInt("location");
        try {
            label = obj.getString("label");
        }
        catch (JSONException e) {
            label = "";
        }
        DirectedBigraphRootRecord root = new DirectedBigraphRootRecord(id, label, location);
        listOfObject.add(root);
    }

    private void parseNodeObject(JSONObject obj, String id, DirectedBigraphListOfObjectRecord listOfObject, DirectedBigraphListOfControlRecord listOfControl) throws NoExistingControl, IdAlreadyExists {
        for (int i = 0; i < listOfObject.size(); ++i) {
            if (!((DirectedBigraphObjectRecord)listOfObject.get(i)).getId().equals(id)) continue;
            throw new IdAlreadyExists("Error: The node id " + id + " already exists.");
        }
        JSONObject metadata = obj.getJSONObject("metadata");
        boolean found = false;
        for (int i = 0; i < listOfControl.size(); ++i) {
            String label;
            DirectedBigraphControlRecord control = (DirectedBigraphControlRecord)listOfControl.get(i);
            if (!control.getName().equals(metadata.getString("control"))) continue;
            try {
                label = obj.getString("label");
            }
            catch (JSONException e) {
                label = "";
            }
            JSONObject propertiesJson = metadata.getJSONObject("properties");
            Iterator propertiesKeys = propertiesJson.keys();
            ArrayList<DirectedBigraphPropertyRecord> properties = new ArrayList<DirectedBigraphPropertyRecord>();
            while (propertiesKeys.hasNext()) {
                String propertyKey = (String)propertiesKeys.next();
                try {
                    JSONArray propertyJsonArray = propertiesJson.getJSONArray(propertyKey);
                    ArrayList<String> property = new ArrayList<String>();
                    for (int j = 0; j < propertyJsonArray.length(); ++j) {
                        property.add(propertyJsonArray.get(j).toString());
                    }
                    DirectedBigraphPropertyRecord propertyArray = new DirectedBigraphPropertyRecord(propertyKey, Constants.TypeOfProperty.array, property);
                    properties.add(propertyArray);
                }
                catch (JSONException e) {
                    String propertyJsonString = propertiesJson.getString(propertyKey);
                    ArrayList<String> property = new ArrayList<String>();
                    property.add(propertyJsonString);
                    DirectedBigraphPropertyRecord propertyString = new DirectedBigraphPropertyRecord(propertyKey, Constants.TypeOfProperty.string, property);
                    properties.add(propertyString);
                }
            }
            DirectedBigraphNodeRecord node = new DirectedBigraphNodeRecord(id, label, control, properties);
            listOfObject.add(node);
            found = true;
        }
        if (!found) {
            throw new NoExistingControl("Error: No valid control found. The control " + metadata.getString("control") + " of the node " + obj.getString("label") + " must be defined in the signature section.");
        }
    }

    private void parseSiteObject(JSONObject obj, String id, DirectedBigraphListOfObjectRecord listOfObject) throws IdAlreadyExists {
        String label;
        for (int i = 0; i < listOfObject.size(); ++i) {
            if (!((DirectedBigraphObjectRecord)listOfObject.get(i)).getId().equals(id)) continue;
            throw new IdAlreadyExists("Error: The site id " + id + " already exists.");
        }
        try {
            label = obj.getString("label");
        }
        catch (JSONException e) {
            label = "";
        }
        DirectedBigraphSiteRecord site = new DirectedBigraphSiteRecord(id, label);
        listOfObject.add(site);
    }

    private void parseNameObject(JSONObject obj, String id, DirectedBigraphListOfObjectRecord listOfObject) throws NoValidInterface, IdAlreadyExists, NoValidPolarity {
        Constants.TypeOfPolarity polarity;
        int locality;
        for (int i = 0; i < listOfObject.size(); ++i) {
            if (!((DirectedBigraphObjectRecord)listOfObject.get(i)).getId().equals(id)) continue;
            throw new IdAlreadyExists("Error: The name id " + id + " already exists.");
        }
        JSONObject metadata = obj.getJSONObject("metadata");
        String nameInterface = metadata.getString("interface");
        try {
            locality = metadata.getInt("locality");
        }
        catch (JSONException e) {
            locality = 0;
        }
        String pol = metadata.getString("polarity");
        if (pol.equals("+")) {
            polarity = Constants.TypeOfPolarity.plus;
        } else if (pol.equals("-")) {
            polarity = Constants.TypeOfPolarity.minus;
        } else {
            throw new NoValidPolarity("Error: No valid polarity for name " + id);
        }
        try {
            String label;
            Constants.TypeOfInterface nameInt = Constants.TypeOfInterface.valueOf(nameInterface);
            try {
                label = obj.getString("label");
            }
            catch (JSONException e) {
                label = "";
            }
            DirectedBigraphNameRecord name = new DirectedBigraphNameRecord(id, label, nameInt, locality, polarity);
            listOfObject.add(name);
        }
        catch (IllegalArgumentException e) {
            throw new NoValidInterface("Error: Object " + obj.getString("label") + " doesn't have a valid interface. Interface found: " + nameInterface + ". Interface expexted: " + Constants.TypeOfInterface.outer + ", " + Constants.TypeOfInterface.inner);
        }
    }

    private void parseEdgeObject(JSONObject obj, String id, DirectedBigraphListOfObjectRecord listOfObject) throws IdAlreadyExists {
        String label;
        for (int i = 0; i < listOfObject.size(); ++i) {
            if (!((DirectedBigraphObjectRecord)listOfObject.get(i)).getId().equals(id)) continue;
            throw new IdAlreadyExists("Error: The name id " + id + " already exists.");
        }
        try {
            label = obj.getString("label");
        }
        catch (JSONException e) {
            label = "";
        }
        DirectedBigraphEdgeRecord edge = new DirectedBigraphEdgeRecord(id, label);
        listOfObject.add(edge);
    }
}

