/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.imports.ldb.parseinput;

import it.uniud.mads.jlibbig.core.imports.exception.ControlAlreadyExists;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphControlRecord;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphListOfControlRecord;
import it.uniud.mads.jlibbig.core.imports.parseinput.DirectedParserSignature;
import org.json.JSONArray;
import org.json.JSONObject;

public class ParserSignature
implements DirectedParserSignature {
    @Override
    public void parseSignature(JSONObject obj, DirectedBigraphListOfControlRecord listOfControl) {
        JSONArray arr = obj.names();
        int n = arr.length();
        for (int i = 0; i < n; ++i) {
            try {
                JSONObject element = obj.getJSONObject(arr.getString(i));
                this.parseSingleSignatureObject(element, arr.getString(i), listOfControl);
                continue;
            }
            catch (ControlAlreadyExists e) {
                System.err.println(e);
                System.exit(1);
            }
        }
    }

    private void parseSingleSignatureObject(JSONObject obj, String id, DirectedBigraphListOfControlRecord listOfControl) throws ControlAlreadyExists {
        for (int i = 0; i < listOfControl.size(); ++i) {
            if (!((DirectedBigraphControlRecord)listOfControl.get(i)).getName().equals(id)) continue;
            throw new ControlAlreadyExists("Error: The control " + id + " already exists. ");
        }
        DirectedBigraphControlRecord control = new DirectedBigraphControlRecord(id, obj.getInt("arityIn"), obj.getInt("arityOut"), obj.getBoolean("active"));
        listOfControl.add(control);
    }
}

