/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.imports.ldb.records;

import it.uniud.mads.jlibbig.core.imports.constant.Constants;
import it.uniud.mads.jlibbig.core.imports.exception.NoExistingLink;
import it.uniud.mads.jlibbig.core.imports.exception.NoExistingSon;
import it.uniud.mads.jlibbig.core.imports.ldb.records.DirectedBigraphLinkRecord;
import it.uniud.mads.jlibbig.core.imports.records.BigraphObjectRecord;
import java.util.ArrayList;
import java.util.List;

public abstract class DirectedBigraphObjectRecord
extends BigraphObjectRecord
implements Comparable<DirectedBigraphObjectRecord> {
    private DirectedBigraphObjectRecord parent = null;
    private List<DirectedBigraphObjectRecord> sons = new ArrayList<DirectedBigraphObjectRecord>();
    private List<DirectedBigraphLinkRecord> links = new ArrayList<DirectedBigraphLinkRecord>();

    public DirectedBigraphObjectRecord(String id, String label, Constants.TypeOfNodes type) {
        super(id, label, type);
    }

    public final DirectedBigraphObjectRecord getParent() {
        return this.parent;
    }

    public final void setParent(DirectedBigraphObjectRecord parent) {
        this.parent = parent;
    }

    public final boolean hasParent() {
        return this.parent != null;
    }

    public final List<DirectedBigraphObjectRecord> getSons() {
        return this.sons;
    }

    public final DirectedBigraphObjectRecord getSon(int index) {
        return this.sons.get(index);
    }

    public final DirectedBigraphObjectRecord getSon(String id) throws NoExistingSon {
        for (int i = 0; i < this.sons.size(); ++i) {
            DirectedBigraphObjectRecord son = this.sons.get(i);
            if (!son.getId().equals(id)) continue;
            return son;
        }
        throw new NoExistingSon("Error: No existing son with id " + id + "for this parent");
    }

    public final void setSons(List<DirectedBigraphObjectRecord> sons) {
        this.sons = sons;
    }

    public final void addSon(DirectedBigraphObjectRecord son) {
        this.sons.add(son);
    }

    public final boolean hasSon() {
        return !this.sons.isEmpty();
    }

    public final List<DirectedBigraphLinkRecord> getLinks() {
        return this.links;
    }

    public final DirectedBigraphLinkRecord getLink(int index) {
        return this.links.get(index);
    }

    public final List<DirectedBigraphLinkRecord> getLink(DirectedBigraphObjectRecord obj) throws NoExistingLink {
        ArrayList<DirectedBigraphLinkRecord> toLinks = new ArrayList<DirectedBigraphLinkRecord>();
        for (int i = 0; i < this.links.size(); ++i) {
            DirectedBigraphLinkRecord link = this.links.get(i);
            if (!link.getLink().getId().equals(obj.getId())) continue;
            toLinks.add(link);
        }
        if (toLinks.isEmpty()) {
            throw new NoExistingLink("Error: no existing link to/from the object " + obj.getId());
        }
        return toLinks;
    }

    public final List<DirectedBigraphLinkRecord> getLink(String id) throws NoExistingLink {
        ArrayList<DirectedBigraphLinkRecord> toLinks = new ArrayList<DirectedBigraphLinkRecord>();
        for (int i = 0; i < this.links.size(); ++i) {
            DirectedBigraphLinkRecord link = this.links.get(i);
            if (!link.getLink().getId().equals(id)) continue;
            toLinks.add(link);
        }
        if (toLinks.isEmpty()) {
            throw new NoExistingLink("Error: no existing link to/from the object " + id);
        }
        return toLinks;
    }

    public final List<DirectedBigraphLinkRecord> getToLinks() {
        ArrayList<DirectedBigraphLinkRecord> toLinks = new ArrayList<DirectedBigraphLinkRecord>();
        for (int i = 0; i < this.links.size(); ++i) {
            DirectedBigraphLinkRecord link = this.links.get(i);
            if (!link.getDirection().equals((Object)Constants.DirectionOfLink.to)) continue;
            toLinks.add(link);
        }
        return toLinks;
    }

    public final List<DirectedBigraphLinkRecord> getFromLinks() {
        ArrayList<DirectedBigraphLinkRecord> toLinks = new ArrayList<DirectedBigraphLinkRecord>();
        for (int i = 0; i < this.links.size(); ++i) {
            DirectedBigraphLinkRecord link = this.links.get(i);
            if (!link.getDirection().equals((Object)Constants.DirectionOfLink.from)) continue;
            toLinks.add(link);
        }
        return toLinks;
    }

    public final void setLinks(List<DirectedBigraphLinkRecord> links) {
        this.links = links;
    }

    public final void addLink(DirectedBigraphLinkRecord link) {
        this.links.add(link);
    }

    public final boolean hasLink() {
        return !this.links.isEmpty();
    }

    private int depht() {
        if (!this.hasParent()) {
            return 0;
        }
        return this.parent.depht() + 1;
    }

    @Override
    public final int compareTo(DirectedBigraphObjectRecord o) {
        return this.depht() - o.depht();
    }
}

