/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.ldb;

import it.uniud.mads.jlibbig.core.ldb.DirectedBigraph;
import it.uniud.mads.jlibbig.core.ldb.DirectedBigraphBuilder;
import it.uniud.mads.jlibbig.core.ldb.DirectedMatch;
import it.uniud.mads.jlibbig.core.ldb.Node;
import it.uniud.mads.jlibbig.core.util.BidMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DirectedAgentMatch
extends DirectedMatch {
    protected final List<DirectedBigraph> params;
    protected final DirectedBigraph lambda;

    DirectedAgentMatch(DirectedBigraph context, DirectedBigraph redexImage, DirectedBigraph redexId, DirectedBigraph paramWiring, DirectedBigraph[] params, BidMap<Node, Node> nodeEmbedding) {
        super(context, redexImage, redexId, null, nodeEmbedding);
        this.params = Collections.unmodifiableList(Arrays.asList(params));
        this.lambda = paramWiring;
    }

    @Override
    public DirectedBigraph getParam() {
        if (this.param == null) {
            DirectedBigraphBuilder bb = new DirectedBigraphBuilder(((DirectedBigraph)this.context).signature);
            for (DirectedBigraph prm : this.params) {
                bb.rightParallelProduct(prm);
            }
            bb.outerCompose(this.lambda);
            this.param = bb.makeBigraph();
        }
        return (DirectedBigraph)this.param;
    }

    public List<DirectedBigraph> getParams() {
        return this.params;
    }

    public DirectedBigraph getParamWiring() {
        return this.lambda;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AgentMatch:\ncontext = ").append(this.context).append("\nredexImage = ").append(this.rdxImage).append("\nredexId = ").append(this.rdxId).append("\nparamWiring = ").append(this.lambda);
        int i = 0;
        for (DirectedBigraph prm : this.params) {
            builder.append("\nparam[").append(i++).append("] = ").append(prm);
        }
        return builder.toString();
    }
}

