/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.ldb;

import it.uniud.mads.jlibbig.core.Owner;
import it.uniud.mads.jlibbig.core.exceptions.IncompatibleInterfaceException;
import it.uniud.mads.jlibbig.core.exceptions.IncompatibleSignatureException;
import it.uniud.mads.jlibbig.core.exceptions.NameClashException;
import it.uniud.mads.jlibbig.core.ldb.Child;
import it.uniud.mads.jlibbig.core.ldb.DirectedBigraphBuilder;
import it.uniud.mads.jlibbig.core.ldb.DirectedControl;
import it.uniud.mads.jlibbig.core.ldb.DirectedSignature;
import it.uniud.mads.jlibbig.core.ldb.Edge;
import it.uniud.mads.jlibbig.core.ldb.EditableChild;
import it.uniud.mads.jlibbig.core.ldb.EditableEdge;
import it.uniud.mads.jlibbig.core.ldb.EditableHandle;
import it.uniud.mads.jlibbig.core.ldb.EditableInnerName;
import it.uniud.mads.jlibbig.core.ldb.EditableLinkFacet;
import it.uniud.mads.jlibbig.core.ldb.EditableNode;
import it.uniud.mads.jlibbig.core.ldb.EditableOuterName;
import it.uniud.mads.jlibbig.core.ldb.EditableOwned;
import it.uniud.mads.jlibbig.core.ldb.EditableParent;
import it.uniud.mads.jlibbig.core.ldb.EditablePoint;
import it.uniud.mads.jlibbig.core.ldb.EditableRoot;
import it.uniud.mads.jlibbig.core.ldb.EditableSite;
import it.uniud.mads.jlibbig.core.ldb.Handle;
import it.uniud.mads.jlibbig.core.ldb.InPort;
import it.uniud.mads.jlibbig.core.ldb.InnerName;
import it.uniud.mads.jlibbig.core.ldb.InterfacePair;
import it.uniud.mads.jlibbig.core.ldb.LinkFacet;
import it.uniud.mads.jlibbig.core.ldb.Node;
import it.uniud.mads.jlibbig.core.ldb.OutPort;
import it.uniud.mads.jlibbig.core.ldb.OuterName;
import it.uniud.mads.jlibbig.core.ldb.Parent;
import it.uniud.mads.jlibbig.core.ldb.Point;
import it.uniud.mads.jlibbig.core.ldb.Root;
import it.uniud.mads.jlibbig.core.ldb.Site;
import it.uniud.mads.jlibbig.core.util.CachingProxy;
import it.uniud.mads.jlibbig.core.util.Provider;
import java.lang.invoke.CallSite;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public final class DirectedBigraph
implements it.uniud.mads.jlibbig.core.DirectedBigraph<DirectedControl>,
Cloneable {
    static final Collection<Parent> EMPTY_ANCS_LST = Collections.unmodifiableList(Collections.emptyList());
    private static final boolean DEBUG_CONSISTENCY_CHECK = Boolean.getBoolean("it.uniud.mads.jlibbig.consistency") || Boolean.getBoolean("it.uniud.mads.jlibbig.consistency.bigraphops");
    private static final Comparator<DirectedControl> controlComparator = new Comparator<DirectedControl>(){

        @Override
        public int compare(DirectedControl o1, DirectedControl o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final Comparator<Node> nodeComparator = new Comparator<Node>(){

        @Override
        public int compare(Node o1, Node o2) {
            int c = controlComparator.compare(o1.getControl(), o2.getControl());
            if (c == 0) {
                return o1.getEditable().getName().compareTo(o2.getEditable().getName());
            }
            return c;
        }
    };
    private static final Comparator<InPort> inPortComparator = new Comparator<InPort>(){

        @Override
        public int compare(InPort i1, InPort i2) {
            if (i1 == i2) {
                return 0;
            }
            int c = nodeComparator.compare(i1.getNode(), i2.getNode());
            if (c == 0) {
                return i1.getNumber() < i2.getNumber() ? -1 : 1;
            }
            return c;
        }
    };
    private static final Comparator<OutPort> outPortComparator = new Comparator<OutPort>(){

        @Override
        public int compare(OutPort o1, OutPort o2) {
            if (o1 == o2) {
                return 0;
            }
            int c = nodeComparator.compare(o1.getNode(), o2.getNode());
            if (c == 0) {
                return o1.getNumber() < o2.getNumber() ? -1 : 1;
            }
            return c;
        }
    };
    private static final Comparator<InnerName> innerComparator = new Comparator<InnerName>(){

        @Override
        public int compare(InnerName o1, InnerName o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final Comparator<Point> pointComparator = new Comparator<Point>(){

        @Override
        public int compare(Point o1, Point o2) {
            if (o1.isPort()) {
                if (o2.isPort()) {
                    return outPortComparator.compare((OutPort)o1, (OutPort)o2);
                }
                return -1;
            }
            if (o2.isPort()) {
                return 1;
            }
            return innerComparator.compare((InnerName)o1, (InnerName)o2);
        }
    };
    private static final Comparator<OuterName> outerComparator = new Comparator<OuterName>(){

        @Override
        public int compare(OuterName o1, OuterName o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final Comparator<Edge> edgeComparator = new Comparator<Edge>(){

        @Override
        public int compare(Edge o1, Edge o2) {
            return o1.getEditable().getName().compareTo(o2.getEditable().getName());
        }
    };
    final DirectedSignature signature;
    final List<EditableRoot> roots = new ArrayList<EditableRoot>();
    final List<EditableSite> sites = new ArrayList<EditableSite>();
    final Interface<EditableOuterName, EditableInnerName> outers = new Interface();
    final Interface<EditableInnerName, EditableOuterName> inners = new Interface();
    private final Comparator<Child> childComparator = new Comparator<Child>(){

        @Override
        public int compare(Child o1, Child o2) {
            if (o1.isSite()) {
                if (o2.isSite()) {
                    return DirectedBigraph.this.sites.indexOf(o1) < DirectedBigraph.this.sites.indexOf(o2) ? -1 : 1;
                }
                return 1;
            }
            if (o2.isSite()) {
                return -1;
            }
            return nodeComparator.compare((Node)o1, (Node)o2);
        }
    };
    private final List<? extends Root> ro_roots = Collections.unmodifiableList(this.roots);
    private final List<? extends Site> ro_sites = Collections.unmodifiableList(this.sites);
    CachingProxy<Collection<EditableNode>> nodesProxy = new CachingProxy<Collection<EditableNode>>(new Provider<Collection<EditableNode>>(){

        @Override
        public Collection<EditableNode> get() {
            return DirectedBigraph.this.provideNodes();
        }
    });
    CachingProxy<Collection<EditableEdge>> edgesProxy = new CachingProxy<Collection<EditableEdge>>(new Provider<Collection<EditableEdge>>(){

        @Override
        public Collection<EditableEdge> get() {
            return DirectedBigraph.this.provideEdges();
        }
    });
    private Map<Child, Collection<Parent>> ancestors = new WeakHashMap<Child, Collection<Parent>>();

    DirectedBigraph(DirectedSignature sig) {
        if (sig == null) {
            throw new IllegalArgumentException("Signature can not be null.");
        }
        this.signature = sig;
    }

    public static DirectedBigraph juxtapose(DirectedBigraph left, DirectedBigraph right) {
        return DirectedBigraph.juxtapose(left, right, false);
    }

    static DirectedBigraph juxtapose(DirectedBigraph left, DirectedBigraph right, boolean reuse) {
        if (left == right) {
            throw new IllegalArgumentException("Operand shuld be distinct; a bigraph can not be juxtaposed with itself.");
        }
        if (!left.signature.equals(right.signature)) {
            throw new IncompatibleSignatureException(left.getSignature(), right.getSignature());
        }
        if (!(Collections.disjoint(left.inners.getAsc(0).keySet(), right.inners.getAsc(0).keySet()) && Collections.disjoint(left.inners.getDesc(0).keySet(), right.inners.getDesc(0).keySet()) && Collections.disjoint(left.outers.getAsc(0).keySet(), right.outers.getAsc(0).keySet()) && Collections.disjoint(left.outers.getDesc(0).keySet(), right.outers.getDesc(0).keySet()))) {
            throw new IncompatibleInterfaceException(new NameClashException(Interface.intersectNames(left.inners.getAsc(0).values(), right.inners.getAsc(0).values(), Interface.intersectNames(left.outers.getAsc(0).values(), right.outers.getAsc(0).values(), Interface.intersectNames(left.outers.getDesc(0).values(), right.outers.getDesc(0).values(), Interface.intersectNames(left.inners.getDesc(0).values(), right.inners.getDesc(0).values()))))));
        }
        DirectedBigraph l = reuse ? left : left.clone();
        DirectedBigraph r = reuse ? right : right.clone();
        for (EditableOwned editableOwned : r.roots) {
            editableOwned.setOwner(l);
        }
        for (EditableOwned editableOwned : r.outers.getAsc().values()) {
            editableOwned.setOwner(l);
        }
        for (EditableOwned editableOwned : r.inners.getDesc().values()) {
            editableOwned.setOwner(l);
        }
        Collection<EditableEdge> es = r.edgesProxy.get();
        for (EditableEdge e : es) {
            e.setOwner(l);
        }
        l.onEdgeAdded(es);
        l.onNodeAdded(r.nodesProxy.get());
        r.onEdgeSetChanged();
        r.onNodeSetChanged();
        l.roots.addAll(0, r.roots);
        l.sites.addAll(0, r.sites);
        l.outers.join(r.outers);
        l.inners.join(r.inners);
        if (DEBUG_CONSISTENCY_CHECK && !l.isConsistent()) {
            throw new RuntimeException("Inconsistent bigraph");
        }
        return l;
    }

    public static DirectedBigraph compose(DirectedBigraph out, DirectedBigraph in) {
        return DirectedBigraph.compose(out, in, false);
    }

    static DirectedBigraph compose(DirectedBigraph out, DirectedBigraph in, boolean reuse) {
        if (out == in) {
            throw new IllegalArgumentException("Operand shuld be distinct; a bigraph can not be composed with itself.");
        }
        if (!out.signature.equals(in.signature)) {
            throw new IncompatibleSignatureException(out.getSignature(), in.getSignature());
        }
        HashSet<String> xs = new HashSet<String>(out.inners.keySet());
        HashSet<String> ys = new HashSet<String>(in.outers.keySet());
        HashSet<String> zs = new HashSet<String>(xs);
        xs.removeAll(ys);
        ys.removeAll(zs);
        if (!xs.isEmpty() || !ys.isEmpty() || out.sites.size() != in.roots.size()) {
            throw new IncompatibleInterfaceException("The outer face of the first graph must be equal to inner face of the second");
        }
        DirectedBigraph a = reuse ? out : out.clone();
        DirectedBigraph b = reuse ? in : in.clone();
        Collection<EditableEdge> es = b.edgesProxy.get();
        Collection<EditableNode> ns = b.nodesProxy.get();
        Iterator<EditableRoot> ir = b.roots.iterator();
        Iterator<EditableSite> is = a.sites.iterator();
        while (ir.hasNext()) {
            EditableSite s = is.next();
            EditableParent p = s.getParent();
            p.removeChild(s);
            for (EditableChild c : new ArrayList(ir.next().getEditableChildren())) {
                c.setParent(p);
            }
        }
        for (int l = 0; l < a.inners.getWidth(); ++l) {
            EditableHandle h;
            HashMap<CallSite, EditableHandle> handleMap = new HashMap<CallSite, EditableHandle>();
            for (EditableInnerName i : a.inners.getAsc(l).values()) {
                handleMap.put((CallSite)((Object)("A" + i.getName())), i.getHandle());
                i.setHandle(null);
            }
            for (EditableOuterName o : b.outers.getAsc(l).values()) {
                h = (EditableHandle)handleMap.get("A" + o.getName());
                for (EditablePoint p : new HashSet<EditablePoint>(o.getEditablePoints())) {
                    p.setHandle(h);
                }
            }
            for (EditableInnerName i : b.outers.getDesc(l).values()) {
                handleMap.put((CallSite)((Object)("D" + i.getName())), i.getHandle());
                i.setHandle(null);
            }
            for (EditableOuterName o : a.inners.getDesc(l).values()) {
                h = (EditableHandle)handleMap.get("D" + o.getName());
                for (EditablePoint p : new HashSet<EditablePoint>(o.getEditablePoints())) {
                    p.setHandle(h);
                }
            }
        }
        a.inners.names.clear();
        a.sites.clear();
        a.inners.names.addAll(b.inners.names);
        a.sites.addAll(b.sites);
        a.onNodeAdded(ns);
        b.onNodeSetChanged();
        for (EditableEdge e : es) {
            e.setOwner(a);
        }
        a.onEdgeAdded(es);
        b.onEdgeSetChanged();
        if (DEBUG_CONSISTENCY_CHECK && !a.isConsistent()) {
            throw new RuntimeException("Inconsistent bigraph");
        }
        return a;
    }

    public static DirectedBigraph compose(Iterable<DirectedBigraph> outs, Iterable<DirectedBigraph> ins) {
        return DirectedBigraph.compose(outs, ins, false);
    }

    static DirectedBigraph compose(Iterable<DirectedBigraph> outs, Iterable<DirectedBigraph> ins, boolean reuse) {
        DirectedBigraph b;
        int sumout = 1;
        int sumin = 1;
        for (DirectedBigraph o : outs) {
            sumout += o.inners.getWidth() - 1;
        }
        for (DirectedBigraph i : ins) {
            sumin += i.outers.getWidth() - 1;
        }
        if (sumout != sumin) {
            throw new RuntimeException("The outer faces of the inner bigraphs together must match the inner faces of the outers.");
        }
        Iterator<DirectedBigraph> outIt = outs.iterator();
        Iterator<DirectedBigraph> inIt = ins.iterator();
        DirectedBigraph out = outIt.next();
        DirectedBigraph in = inIt.next();
        DirectedBigraph a = reuse ? out : out.clone();
        DirectedBigraph directedBigraph = b = reuse ? in : in.clone();
        while (outIt.hasNext()) {
            a = DirectedBigraph.juxtapose(a, outIt.next(), reuse);
        }
        while (inIt.hasNext()) {
            b = DirectedBigraph.juxtapose(b, inIt.next(), reuse);
        }
        return DirectedBigraph.compose(a, b, reuse);
    }

    public static DirectedBigraph makeEmpty(DirectedSignature signature) {
        return new DirectedBigraph(signature);
    }

    public static DirectedBigraph makeId(DirectedSignature signature, List<Set<String>> names) {
        DirectedBigraphBuilder bb = new DirectedBigraphBuilder(signature);
        for (int i = 0; i < names.size(); ++i) {
            bb.addSite(bb.addRoot());
        }
        for (Set<String> name : names) {
            int ind = names.indexOf(name);
            for (String s : name) {
                bb.addDescNameOuterInterface(ind, s, bb.addDescNameInnerInterface(ind, s));
            }
        }
        return bb.makeBigraph();
    }

    boolean isConsistent() {
        return this.isConsistent(this);
    }

    boolean isConsistent(Owner owner) {
        HashSet<Point> seen_points = new HashSet<Point>();
        HashSet<EditableHandle> seen_handles = new HashSet<EditableHandle>();
        HashSet<EditableSite> unseen_sites = new HashSet<EditableSite>();
        unseen_sites.addAll(this.sites);
        HashSet<Child> seen_children = new HashSet<Child>();
        ArrayDeque<EditableParent> q = new ArrayDeque<EditableParent>();
        for (EditableRoot editableRoot : this.roots) {
            if (editableRoot.getOwner() != owner) {
                System.err.println("INCOSISTENCY: foreign root");
                return false;
            }
            q.add(editableRoot);
        }
        while (!q.isEmpty()) {
            Parent p = (Parent)q.poll();
            for (Child child : p.getChildren()) {
                if (!p.equals(child.getParent())) {
                    System.err.println("INCOSISTENCY: parent/child mismatch");
                    return false;
                }
                if (!seen_children.add(child)) {
                    System.err.println("INCOSISTENCY: cyclic place");
                    return false;
                }
                if (child.isNode()) {
                    EditableNode editableNode = (EditableNode)child;
                    if (editableNode.getControl().getArityIn() != editableNode.getInPorts().size() || editableNode.getControl().getArityOut() != editableNode.getOutPorts().size() || !this.signature.contains(editableNode.getControl())) {
                        System.err.println("INCOSISTENCY: control/arity");
                        return false;
                    }
                    q.add(editableNode);
                    for (Point point : editableNode.getOutPorts()) {
                        EditableHandle h = ((EditablePoint)point).getHandle();
                        if (h == null || h.getOwner() != owner) {
                            System.out.println(this);
                            System.err.println("INCOSISTENCY: broken or foreign handle");
                            return false;
                        }
                        if (!h.getPoints().contains(point)) {
                            System.err.println("INCOSISTENCY: handle/point mismatch");
                            return false;
                        }
                        seen_points.add(point);
                        seen_handles.add(h);
                    }
                    for (Handle handle : editableNode.getInPorts()) {
                        EditableHandle eh = handle.getEditable();
                        if (eh == null || eh.getOwner() != owner) {
                            System.out.println(this);
                            System.err.println("INCOSISTENCY: broken or foreign handle");
                            return false;
                        }
                        seen_handles.add(eh);
                    }
                    continue;
                }
                if (child.isSite()) {
                    Site site = (Site)child;
                    unseen_sites.remove(site);
                    if (this.sites.contains(site)) continue;
                    System.err.println("INCOSISTENCY: foreign site");
                    return false;
                }
                System.err.println("INCOSISTENCY: neither a node nor a site");
                return false;
            }
        }
        for (EditableOuterName editableOuterName : this.outers.getAsc().values()) {
            if (editableOuterName.getOwner() != owner) {
                System.err.println("INCOSISTENCY: foreign ascendant name in outer interface");
                return false;
            }
            seen_handles.add(editableOuterName);
        }
        for (EditableOuterName editableOuterName : this.inners.getDesc().values()) {
            if (editableOuterName.getOwner() != owner) {
                System.err.println("INCOSISTENCY: foreign descendant name in inner interface");
                return false;
            }
            seen_handles.add(editableOuterName);
        }
        for (EditableInnerName editableInnerName : this.inners.getAsc().values()) {
            if (editableInnerName.getOwner() != owner) {
                System.err.println("INCOSISTENCY: foreign ascendant name in inner interface");
                return false;
            }
            seen_handles.add(editableInnerName.getHandle());
            seen_points.add(editableInnerName);
        }
        for (EditableInnerName editableInnerName : this.outers.getDesc().values()) {
            if (editableInnerName.getOwner() != owner) {
                System.err.println("INCOSISTENCY: foreign descendant name in outer interface");
                return false;
            }
            seen_handles.add(editableInnerName.getHandle());
            seen_points.add(editableInnerName);
        }
        for (Handle handle : seen_handles) {
            for (Point point : handle.getPoints()) {
                if (seen_points.remove(point)) continue;
                System.err.println("INCOSISTENCY: foreign point");
                return false;
            }
        }
        if (seen_points.size() > 0) {
            System.err.println("INCOSISTENCY: handle chain broken");
            return false;
        }
        if (unseen_sites.size() > 0) {
            System.err.println("INCOSISTENCY: unreachable site");
            return false;
        }
        return true;
    }

    DirectedBigraph setOwner(Owner owner) {
        if (owner == null) {
            owner = this;
        }
        for (EditableOwned editableOwned : this.roots) {
            editableOwned.setOwner(owner);
        }
        for (EditableOwned editableOwned : this.inners.getDesc().values()) {
            editableOwned.setOwner(owner);
        }
        for (EditableOwned editableOwned : this.outers.getAsc().values()) {
            editableOwned.setOwner(owner);
        }
        for (Edge edge : this.getEdges()) {
            ((EditableOwned)((Object)edge)).setOwner(owner);
        }
        return this;
    }

    public DirectedBigraph clone() {
        return this.clone(null);
    }

    DirectedBigraph clone(Owner owner) {
        InterfacePair ip2;
        int j;
        EditableHandle h2;
        EditableHandle h1;
        EditableInnerName i2;
        EditableOuterName o2;
        DirectedBigraph big = new DirectedBigraph(this.signature);
        big.inners.names.clear();
        big.outers.names.clear();
        if (owner == null) {
            owner = big;
        }
        HashMap<Object, EditableHandle> hnd_dic = new HashMap<Object, EditableHandle>();
        ArrayList newInnersRight = new ArrayList();
        ArrayList newInnersLeft = new ArrayList();
        ArrayList newOutersRight = new ArrayList();
        ArrayList newOutersLeft = new ArrayList();
        for (InterfacePair interfacePair : this.inners.names) {
            HashSet<EditableOuterName> right = new HashSet<EditableOuterName>();
            for (Object o1 : interfacePair.getRight()) {
                o2 = ((EditableOuterName)o1).replicate();
                right.add(o2);
                o2.setOwner(owner);
                hnd_dic.put(o1, o2);
            }
            newInnersRight.add(right);
        }
        for (InterfacePair interfacePair : this.outers.names) {
            HashSet<EditableOuterName> left = new HashSet<EditableOuterName>();
            for (Object o1 : interfacePair.getLeft()) {
                o2 = ((EditableOuterName)o1).replicate();
                left.add(o2);
                o2.setOwner(owner);
                hnd_dic.put(o1, o2);
            }
            newOutersLeft.add(left);
        }
        class Pair {
            final EditableChild c;
            final EditableParent p;

            Pair(EditableParent p, EditableChild c) {
                this.c = c;
                this.p = p;
            }
        }
        LinkedList<Pair> q = new LinkedList<Pair>();
        for (EditableRoot r1 : this.roots) {
            EditableRoot r2 = r1.replicate();
            big.roots.add(r2);
            r2.setOwner(owner);
            for (EditableChild c : r1.getEditableChildren()) {
                q.add(new Pair(r2, c));
            }
        }
        EditableSite[] editableSiteArray = new EditableSite[this.sites.size()];
        LinkedList<EditableNode> nodes = new LinkedList<EditableNode>();
        LinkedList<EditableNode> nodeReplicas = new LinkedList<EditableNode>();
        while (!q.isEmpty()) {
            Iterator t = (Pair)q.poll();
            if (((Pair)((Object)t)).c.isNode()) {
                EditableNode n1 = (EditableNode)((Pair)((Object)t)).c;
                EditableNode n2 = n1.replicate();
                nodes.add(n1);
                nodeReplicas.add(n2);
                n2.setParent(((Pair)((Object)t)).p);
                for (int i = n1.getControl().getArityIn() - 1; 0 <= i; --i) {
                    EditableNode.EditableInPort p1 = n1.getInPort(i);
                    EditableHandle h22 = (EditableHandle)hnd_dic.get(p1);
                    EditableNode.EditableInPort p2 = n2.getInPort(i);
                    hnd_dic.put(p1, p2);
                }
                for (EditableChild c : n1.getEditableChildren()) {
                    q.add(new Pair(n2, c));
                }
                continue;
            }
            EditableSite s1 = (EditableSite)((Pair)((Object)t)).c;
            EditableSite s2 = s1.replicate();
            s2.setParent(((Pair)((Object)t)).p);
            editableSiteArray[this.sites.indexOf((Object)s1)] = s2;
        }
        big.sites.addAll(Arrays.asList(editableSiteArray));
        for (InterfacePair ip1 : this.inners.names) {
            HashSet<EditableInnerName> left = new HashSet<EditableInnerName>();
            for (EditableInnerName i1 : ip1.getLeft()) {
                i2 = i1.replicate();
                h1 = i1.getHandle();
                h2 = (EditableHandle)hnd_dic.get(h1);
                if (h2 == null) {
                    h2 = h1.replicate();
                    h2.setOwner(owner);
                    hnd_dic.put(h1, h2);
                }
                i2.setHandle(h2);
                left.add(i2);
            }
            newInnersLeft.add(left);
        }
        for (InterfacePair ip1 : this.outers.names) {
            HashSet<EditableInnerName> right = new HashSet<EditableInnerName>();
            for (EditableInnerName i1 : ip1.getRight()) {
                i2 = i1.replicate();
                h1 = i1.getHandle();
                h2 = (EditableHandle)hnd_dic.get(h1);
                if (h2 == null) {
                    h2 = h1.replicate();
                    h2.setOwner(owner);
                    hnd_dic.put(h1, h2);
                }
                i2.setHandle(h2);
                right.add(i2);
            }
            newOutersRight.add(right);
        }
        for (j = 0; j < newInnersLeft.size(); ++j) {
            ip2 = new InterfacePair((Set)newInnersLeft.get(j), (Set)newInnersRight.get(j));
            big.inners.names.add(ip2);
        }
        for (j = 0; j < newOutersLeft.size(); ++j) {
            ip2 = new InterfacePair((Set)newOutersLeft.get(j), (Set)newOutersRight.get(j));
            big.outers.names.add(ip2);
        }
        while (!nodes.isEmpty()) {
            EditableNode n1 = (EditableNode)nodes.poll();
            EditableNode n2 = (EditableNode)nodeReplicas.poll();
            for (int i = n1.getControl().getArityOut() - 1; 0 <= i; --i) {
                EditableNode.EditableOutPort p1 = n1.getOutPort(i);
                EditableHandle h12 = p1.getHandle();
                EditableHandle h22 = (EditableHandle)hnd_dic.get(h12);
                if (h12 != null && h22 == null) {
                    h22 = h12.replicate();
                    h22.setOwner(owner);
                    hnd_dic.put(h12, h22);
                }
                n2.getOutPort(i).setHandle(h22);
            }
        }
        return big;
    }

    public DirectedSignature getSignature() {
        return this.signature;
    }

    @Override
    public boolean isEmpty() {
        return this.outers.isEmpty() && this.inners.isEmpty() && this.roots.isEmpty() && this.sites.isEmpty();
    }

    @Override
    public boolean isGround() {
        return this.inners.isEmpty() && this.sites.isEmpty();
    }

    @Override
    public List<? extends Root> getRoots() {
        return this.ro_roots;
    }

    @Override
    public List<? extends Site> getSites() {
        return this.ro_sites;
    }

    @Override
    public Interface getOuterInterface() {
        return this.outers;
    }

    @Override
    public Interface getInnerInterface() {
        return this.inners;
    }

    void onNodeAdded(EditableNode node) {
        Collection<EditableNode> ns = this.nodesProxy.softGet();
        if (ns != null) {
            ns.add(node);
        }
    }

    void onNodeAdded(Collection<EditableNode> nodes) {
        Collection<EditableNode> ns = this.nodesProxy.softGet();
        if (ns != null) {
            ns.addAll(nodes);
        }
    }

    void onNodeRemoved(EditableNode node) {
        this.ancestors.clear();
        Collection<EditableNode> ns = this.nodesProxy.softGet();
        if (ns != null) {
            ns.remove(node);
        }
    }

    void onNodeRemoved(Collection<EditableNode> nodes) {
        this.ancestors.clear();
        Collection<EditableNode> ns = this.nodesProxy.softGet();
        if (ns != null) {
            ns.removeAll(nodes);
        }
    }

    void onNodeSetChanged() {
        this.nodesProxy.invalidate();
        this.ancestors.clear();
    }

    private Collection<EditableNode> provideNodes() {
        HashSet<EditableNode> s = new HashSet<EditableNode>();
        LinkedList<EditableNode> q = new LinkedList<EditableNode>();
        for (Root root : this.roots) {
            for (Child child : root.getChildren()) {
                if (!child.isNode()) continue;
                EditableNode n = (EditableNode)child;
                q.add(n);
            }
        }
        while (!q.isEmpty()) {
            EditableNode p = (EditableNode)q.poll();
            s.add(p);
            for (Child child : p.getChildren()) {
                if (!child.isNode()) continue;
                EditableNode editableNode = (EditableNode)child;
                q.add(editableNode);
            }
        }
        return s;
    }

    @Override
    public Collection<? extends Node> getNodes() {
        return this.nodesProxy.get();
    }

    void onEdgeAdded(EditableEdge edge) {
        Collection<EditableEdge> ns = this.edgesProxy.softGet();
        if (ns != null) {
            ns.add(edge);
        }
    }

    void onEdgeAdded(Collection<EditableEdge> edges) {
        Collection<EditableEdge> ns = this.edgesProxy.softGet();
        if (ns != null) {
            ns.addAll(edges);
        }
    }

    void onEdgeRemoved(EditableEdge edge) {
        Collection<EditableEdge> ns = this.edgesProxy.softGet();
        if (ns != null) {
            ns.remove(edge);
        }
    }

    void onEdgeRemoved(Collection<EditableEdge> edges) {
        Collection<EditableEdge> ns = this.edgesProxy.softGet();
        if (ns != null) {
            ns.removeAll(edges);
        }
    }

    void onEdgeSetChanged() {
        this.nodesProxy.invalidate();
    }

    public Collection<EditableEdge> provideEdges() {
        Handle h;
        Collection<? extends Node> nodes = this.getNodes();
        HashSet<EditableEdge> s = new HashSet<EditableEdge>();
        for (Node node : nodes) {
            for (OutPort outPort : node.getOutPorts()) {
                Handle h2 = outPort.getHandle();
                if (h2 == null || !h2.isEdge()) continue;
                s.add((EditableEdge)h2);
            }
        }
        for (InnerName innerName : this.inners.getAsc().values()) {
            h = innerName.getHandle();
            if (!h.isEdge()) continue;
            s.add((EditableEdge)h);
        }
        for (InnerName innerName : this.outers.getDesc().values()) {
            h = innerName.getHandle();
            if (h == null || !h.isEdge()) continue;
            s.add((EditableEdge)h);
        }
        return s;
    }

    @Override
    public Collection<? extends Edge> getEdges() {
        return this.edgesProxy.get();
    }

    Collection<Parent> getAncestors(Child child) {
        if (child == null) {
            throw new IllegalArgumentException("The argument can not be null.");
        }
        Collection<Parent> s = this.ancestors.get(child);
        if (s == null) {
            Parent parent = child.getParent();
            if (parent.isRoot()) {
                s = EMPTY_ANCS_LST;
            } else {
                s = new LinkedList<Parent>(this.getAncestors((Child)((Object)parent)));
                s.add(parent);
            }
            this.ancestors.put(child, s);
        }
        return s;
    }

    public String toString() {
        Point p;
        Iterator ip;
        String nl = System.getProperty("line.separator");
        StringBuilder b = new StringBuilder();
        b.append(this.signature.getUSID());
        b.append(" {");
        Iterator is = this.signature.iterator();
        while (is.hasNext()) {
            b.append(((DirectedControl)is.next()).toString());
            if (!is.hasNext()) continue;
            b.append(", ");
        }
        b.append("} :: ");
        b.append(this.inners.toString());
        b.append(" -> ");
        b.append(this.outers.toString());
        b.append("}>");
        Map<String, EditableOuterName> inMap = this.inners.getDesc();
        for (Map.Entry<String, EditableOuterName> entry : inMap.entrySet()) {
            Handle handle = entry.getValue();
            b.append(nl).append("I").append(entry.getKey());
            b.append(" <- {");
            ArrayList<? extends Point> arrayList = new ArrayList<Point>(handle.getPoints());
            Collections.sort(arrayList, pointComparator);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Point p2 = (Point)iterator.next();
                if (p2.isInnerName()) {
                    b.append("O-.");
                }
                b.append(p2);
                if (!iterator.hasNext()) continue;
                b.append(", ");
            }
            b.append('}');
        }
        Map<String, EditableOuterName> outMap = this.outers.getAsc();
        for (Map.Entry<String, EditableOuterName> entry : outMap.entrySet()) {
            Handle handle = entry.getValue();
            b.append(nl).append("O").append(entry.getKey());
            b.append(" <- {");
            ArrayList<? extends Point> arrayList = new ArrayList<Point>(handle.getPoints());
            Collections.sort(arrayList, pointComparator);
            ip = arrayList.iterator();
            while (ip.hasNext()) {
                p = (Point)ip.next();
                if (p.isInnerName()) {
                    b.append("I+.");
                }
                b.append(p);
                if (!ip.hasNext()) continue;
                b.append(", ");
            }
            b.append('}');
        }
        for (Node node : this.getNodes()) {
            for (Handle handle : node.getInPorts()) {
                b.append(nl).append(handle);
                b.append(" <- {");
                ArrayList<? extends Point> ps3 = new ArrayList<Point>(handle.getPoints());
                Collections.sort(ps3, pointComparator);
                Iterator ip3 = ps3.iterator();
                while (ip3.hasNext()) {
                    Point p3 = (Point)ip3.next();
                    b.append(p3);
                    if (p3.isInnerName()) {
                        b.append(":i");
                    }
                    if (!ip3.hasNext()) continue;
                    b.append(", ");
                }
                b.append('}');
            }
        }
        ArrayList<? extends Edge> arrayList = new ArrayList<Edge>(this.getEdges());
        Collections.sort(arrayList, edgeComparator);
        for (Handle handle : arrayList) {
            b.append(nl).append(handle);
            b.append(":e <- {");
            ArrayList<? extends Point> arrayList2 = new ArrayList<Point>(handle.getPoints());
            Collections.sort(arrayList2, pointComparator);
            ip = arrayList2.iterator();
            while (ip.hasNext()) {
                p = (Point)ip.next();
                b.append(p);
                if (p.isInnerName()) {
                    b.append(":i");
                }
                if (!ip.hasNext()) continue;
                b.append(", ");
            }
            b.append('}');
        }
        LinkedList<Parent> linkedList = new LinkedList<Parent>();
        linkedList.addAll(this.roots);
        while (!linkedList.isEmpty()) {
            Parent parent = (Parent)linkedList.poll();
            b.append(nl);
            if (parent.isRoot()) {
                b.append(this.roots.indexOf(parent));
            } else {
                b.append(parent);
            }
            b.append(" <- {");
            ArrayList<? extends Child> arrayList3 = new ArrayList<Child>(parent.getChildren());
            Collections.sort(arrayList3, this.childComparator);
            Iterator ic = arrayList3.iterator();
            while (ic.hasNext()) {
                Child c = (Child)ic.next();
                if (c.isSite()) {
                    b.append(this.sites.indexOf(c));
                } else {
                    b.append(c);
                    linkedList.add((Parent)((Object)c));
                }
                if (!ic.hasNext()) continue;
                b.append(", ");
            }
            b.append('}');
        }
        return b.toString();
    }

    static class Interface<Asc extends EditableLinkFacet, Desc extends EditableLinkFacet>
    implements it.uniud.mads.jlibbig.core.Interface {
        final List<InterfacePair<Asc, Desc>> names = new ArrayList<InterfacePair<Asc, Desc>>();

        Interface() {
            this.names.add(0, new InterfacePair(new HashSet(), new HashSet()));
        }

        Interface(InterfacePair<Asc, Desc> interfacePair0) {
            this.names.add(0, interfacePair0);
        }

        static Collection<String> intersectNames(Collection<? extends LinkFacet> arg0, Collection<? extends LinkFacet> arg1) {
            return Interface.intersectNames(arg0, arg1, new HashSet<String>());
        }

        static Collection<String> intersectNames(Collection<? extends LinkFacet> arg0, Collection<? extends LinkFacet> arg1, Collection<String> ns0) {
            HashSet<String> ns1 = new HashSet<String>();
            for (LinkFacet linkFacet : arg0) {
                ns1.add(linkFacet.getName());
            }
            for (LinkFacet linkFacet : arg1) {
                String s = linkFacet.getName();
                if (!ns1.contains(s)) continue;
                ns0.add(s);
                ns1.remove(s);
            }
            return ns0;
        }

        static <Asc extends EditableLinkFacet, Desc extends EditableLinkFacet> Interface<Asc, Desc> joinInterfaces(Interface<Asc, Desc> i1, Interface<Asc, Desc> i2) {
            Interface<Asc, Desc> i = new Interface<Asc, Desc>(InterfacePair.mergePairs(i1.names.get(0), i2.names.get(0)));
            i.names.addAll(i1.names.subList(1, i1.names.size()));
            i.names.addAll(i2.names.subList(1, i2.names.size()));
            return i;
        }

        void join(Interface<Asc, Desc> i) {
            this.names.set(0, InterfacePair.mergePairs(this.names.get(0), i.names.get(0)));
            this.names.addAll(i.names.subList(1, i.names.size()));
        }

        public int getWidth() {
            return this.names.size();
        }

        boolean isEmpty() {
            return this.names.isEmpty();
        }

        public void addPair(InterfacePair<Asc, Desc> interfacePair) {
            this.names.add(interfacePair);
        }

        public void addAsc(int index, Asc a) {
            this.names.get(index).getLeft().add(a);
        }

        Map<String, Asc> getAsc() {
            HashMap<CallSite, EditableLinkFacet> asc = new HashMap<CallSite, EditableLinkFacet>();
            for (InterfacePair<Asc, Desc> ip : this.names) {
                for (EditableLinkFacet a : ip.getLeft()) {
                    asc.put((CallSite)((Object)(this.names.indexOf(ip) + "+." + a.getName())), a);
                }
            }
            return asc;
        }

        public Map<String, Asc> getAsc(int index) {
            if (index < 0 || index >= this.names.size()) {
                throw new IndexOutOfBoundsException("Index '" + index + "' not in list");
            }
            HashMap<String, EditableLinkFacet> ascInd = new HashMap<String, EditableLinkFacet>();
            for (EditableLinkFacet a : this.names.get(index).getLeft()) {
                ascInd.put(a.getName(), a);
            }
            return ascInd;
        }

        public void addDesc(int index, Desc d) {
            this.names.get(index).getRight().add(d);
        }

        Map<String, Desc> getDesc() {
            HashMap<CallSite, EditableLinkFacet> desc = new HashMap<CallSite, EditableLinkFacet>();
            for (InterfacePair<Asc, Desc> ip : this.names) {
                for (EditableLinkFacet d : ip.getRight()) {
                    desc.put((CallSite)((Object)(this.names.indexOf(ip) + "-." + d.getName())), d);
                }
            }
            return desc;
        }

        public Map<String, Desc> getDesc(int index) {
            if (index < 0 || index >= this.names.size()) {
                throw new IndexOutOfBoundsException("Index '" + index + "' not in list");
            }
            HashMap<String, EditableLinkFacet> descInd = new HashMap<String, EditableLinkFacet>();
            for (EditableLinkFacet d : this.names.get(index).getRight()) {
                descInd.put(d.getName(), d);
            }
            return descInd;
        }

        void removeAsc(int locality, String name) {
            this.names.get(locality).getLeft().remove(this.getAsc(locality).get(name));
        }

        void removeDesc(int locality, String name) {
            this.names.get(locality).getRight().remove(this.getDesc(locality).get(name));
        }

        @Override
        public Set<String> keySet() {
            HashSet<String> ss = new HashSet<String>();
            for (InterfacePair<Asc, Desc> ip : this.names) {
                int id = this.names.indexOf(ip);
                for (EditableLinkFacet l : ip.getLeft()) {
                    ss.add(id + " l " + l);
                }
                for (EditableLinkFacet r : ip.getRight()) {
                    ss.add(id + " r " + r);
                }
            }
            return ss;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("<");
            Iterator<InterfacePair<Asc, Desc>> ii = this.names.iterator();
            while (ii.hasNext()) {
                sb.append(ii.next().toString());
                if (!ii.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(">");
            return sb.toString();
        }
    }
}

