/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.ldb;

import it.uniud.mads.jlibbig.core.Interface;
import it.uniud.mads.jlibbig.core.Owned;
import it.uniud.mads.jlibbig.core.Owner;
import it.uniud.mads.jlibbig.core.exceptions.IncompatibleInterfaceException;
import it.uniud.mads.jlibbig.core.exceptions.IncompatibleSignatureException;
import it.uniud.mads.jlibbig.core.exceptions.NameClashException;
import it.uniud.mads.jlibbig.core.exceptions.UnexpectedOwnerException;
import it.uniud.mads.jlibbig.core.ldb.DirectedBigraph;
import it.uniud.mads.jlibbig.core.ldb.DirectedControl;
import it.uniud.mads.jlibbig.core.ldb.DirectedSignature;
import it.uniud.mads.jlibbig.core.ldb.Edge;
import it.uniud.mads.jlibbig.core.ldb.EditableChild;
import it.uniud.mads.jlibbig.core.ldb.EditableEdge;
import it.uniud.mads.jlibbig.core.ldb.EditableHandle;
import it.uniud.mads.jlibbig.core.ldb.EditableInnerName;
import it.uniud.mads.jlibbig.core.ldb.EditableNode;
import it.uniud.mads.jlibbig.core.ldb.EditableOuterName;
import it.uniud.mads.jlibbig.core.ldb.EditableOwned;
import it.uniud.mads.jlibbig.core.ldb.EditableParent;
import it.uniud.mads.jlibbig.core.ldb.EditablePoint;
import it.uniud.mads.jlibbig.core.ldb.EditableRoot;
import it.uniud.mads.jlibbig.core.ldb.EditableSite;
import it.uniud.mads.jlibbig.core.ldb.Handle;
import it.uniud.mads.jlibbig.core.ldb.InnerName;
import it.uniud.mads.jlibbig.core.ldb.InterfacePair;
import it.uniud.mads.jlibbig.core.ldb.Node;
import it.uniud.mads.jlibbig.core.ldb.OuterName;
import it.uniud.mads.jlibbig.core.ldb.Parent;
import it.uniud.mads.jlibbig.core.ldb.Point;
import it.uniud.mads.jlibbig.core.ldb.Root;
import it.uniud.mads.jlibbig.core.ldb.Site;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class DirectedBigraphBuilder
implements it.uniud.mads.jlibbig.core.DirectedBigraphBuilder<DirectedControl>,
Cloneable {
    private static final boolean DEBUG_CONSISTENCY_CHECK = Boolean.getBoolean("it.uniud.mads.jlibbig.consistency") || Boolean.getBoolean("it.uniud.mads.jlibbig.consistency.bigraphops");
    private DirectedBigraph big;
    private boolean closed = false;

    public DirectedBigraphBuilder(DirectedSignature sig) {
        this.big = DirectedBigraph.makeEmpty(sig);
    }

    public DirectedBigraphBuilder(DirectedBigraph big) {
        this(big, false);
    }

    DirectedBigraphBuilder(DirectedBigraph big, boolean reuse) {
        if (big == null) {
            throw new IllegalArgumentException("Argument can not be null.");
        }
        if (!big.isConsistent()) {
            throw new IllegalArgumentException("Inconsistent bigraph.");
        }
        this.big = reuse ? big.setOwner(this) : big.clone(this);
    }

    private static void clearOwnedCollection(Collection<? extends EditableOwned> col) {
        for (EditableOwned editableOwned : col) {
            editableOwned.setOwner(null);
        }
        col.clear();
    }

    private static void clearChildCollection(Collection<? extends EditableChild> col) {
        for (EditableChild editableChild : col) {
            editableChild.setParent(null);
        }
        col.clear();
    }

    private static void clearOuterInterface(DirectedBigraph.Interface<EditableOuterName, EditableInnerName> i) {
        i.names.clear();
    }

    private static void clearInnerInterface(DirectedBigraph.Interface<EditableInnerName, EditableOuterName> i) {
        i.names.clear();
    }

    public String toString() {
        this.assertOpen();
        return this.big.toString();
    }

    public DirectedBigraph makeBigraph() {
        return this.makeBigraph(false);
    }

    public DirectedBigraph makeBigraph(boolean close) {
        DirectedBigraph b;
        this.assertOpen();
        this.assertConsistency();
        if (close) {
            b = this.big.setOwner(this.big);
            this.closed = true;
        } else {
            b = this.big.clone();
            if (DEBUG_CONSISTENCY_CHECK && !b.isConsistent()) {
                throw new RuntimeException("Inconsistent bigraph.");
            }
        }
        return b;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void assertOpen() throws UnsupportedOperationException {
        if (this.closed) {
            throw new UnsupportedOperationException("The operation is not supported by a closed BigraphBuilder");
        }
    }

    public DirectedBigraphBuilder clone() {
        this.assertOpen();
        DirectedBigraphBuilder bb = new DirectedBigraphBuilder(this.big.getSignature());
        bb.big = this.big.clone(bb);
        return bb;
    }

    public DirectedSignature getSignature() {
        this.assertOpen();
        return this.big.getSignature();
    }

    @Override
    public boolean isEmpty() {
        this.assertOpen();
        return this.big.isEmpty();
    }

    @Override
    public boolean isGround() {
        this.assertOpen();
        return this.big.isGround();
    }

    @Override
    public List<? extends Root> getRoots() {
        this.assertOpen();
        return this.big.getRoots();
    }

    @Override
    public List<? extends Site> getSites() {
        this.assertOpen();
        return this.big.getSites();
    }

    @Override
    public Interface getOuterInterface() {
        return null;
    }

    @Override
    public Interface getInnerInterface() {
        return null;
    }

    public boolean containsOuterName(String name) {
        this.assertOpen();
        return this.big.outers.getAsc().containsKey(name) || this.big.inners.getDesc().containsKey(name);
    }

    public boolean containsInnerName(String name) {
        this.assertOpen();
        return this.big.inners.getAsc().containsKey(name) || this.big.outers.getDesc().containsKey(name);
    }

    @Override
    public Collection<? extends Node> getNodes() {
        this.assertOpen();
        return this.big.getNodes();
    }

    @Override
    public Collection<? extends Edge> getEdges() {
        this.assertOpen();
        return this.big.getEdges();
    }

    public Root addRoot() {
        this.assertOpen();
        EditableRoot r = new EditableRoot();
        r.setOwner(this);
        this.big.roots.add(r);
        this.big.outers.addPair(new InterfacePair(new HashSet(), new HashSet()));
        this.assertConsistency();
        return r;
    }

    public Root addRoot(int index) {
        this.assertOpen();
        EditableRoot r = new EditableRoot();
        r.setOwner(this);
        this.big.roots.add(index, r);
        this.big.outers.addPair(new InterfacePair(new HashSet(), new HashSet()));
        this.assertConsistency();
        return r;
    }

    public Site addSite(Parent parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument can not be null.");
        }
        this.assertOpen();
        this.assertOwner(parent, "Parent");
        EditableSite s = new EditableSite((EditableParent)parent);
        this.big.sites.add(s);
        this.big.inners.addPair(new InterfacePair(new HashSet(), new HashSet()));
        this.assertConsistency();
        return s;
    }

    public Node addNode(String controlName, Parent parent) {
        return this.addNode(controlName, parent, new LinkedList<Handle>());
    }

    public Node addNode(String controlName, Parent parent, Handle ... handles) {
        if (controlName == null) {
            throw new IllegalArgumentException("Control name can not be null.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Parent can not be null.");
        }
        this.assertOpen();
        DirectedControl c = (DirectedControl)this.big.getSignature().getByName(controlName);
        if (c == null) {
            throw new IllegalArgumentException("Control should be in the signature.");
        }
        this.assertOwner(parent, "Parent");
        EditableHandle[] hs = new EditableHandle[c.getArityOut()];
        for (int i = 0; i < hs.length; ++i) {
            EditableHandle h = null;
            if (i < handles.length) {
                h = (EditableHandle)handles[i];
            }
            if (h != null) {
                this.assertOwner(h, "Handle");
            } else {
                EditableEdge e = new EditableEdge(this);
                this.big.onEdgeAdded(e);
                h = e;
            }
            hs[i] = h;
        }
        EditableNode n = new EditableNode(c, (EditableParent)parent, hs);
        this.big.onNodeAdded(n);
        this.assertConsistency();
        return n;
    }

    public Node addNode(String controlName, Parent parent, List<Handle> handles) {
        if (controlName == null) {
            throw new IllegalArgumentException("Control name can not be null.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Parent can not be null.");
        }
        this.assertOpen();
        DirectedControl c = (DirectedControl)this.big.getSignature().getByName(controlName);
        if (c == null) {
            throw new IllegalArgumentException("Control should be in the signature.");
        }
        this.assertOwner(parent, "Parent");
        int ar = c.getArityOut();
        ArrayList<EditableHandle> hs = new ArrayList<EditableHandle>(ar);
        Iterator<Handle> hi = handles == null ? null : handles.iterator();
        for (int i = 0; i < ar; ++i) {
            EditableHandle h = null;
            if (hi != null && hi.hasNext()) {
                h = (EditableHandle)hi.next();
            }
            if (h != null) {
                this.assertOwner(h, "Handle");
            } else {
                EditableEdge e = new EditableEdge(this);
                this.big.onEdgeAdded(e);
                h = e;
            }
            hs.add(h);
        }
        EditableNode n = new EditableNode(c, (EditableParent)parent, hs);
        this.big.onNodeAdded(n);
        this.assertConsistency();
        return n;
    }

    public OuterName addAscNameOuterInterface(int locality) {
        return this.addAscNameOuterInterface(locality, new EditableOuterName());
    }

    public OuterName addAscNameOuterInterface(int locality, String name) {
        if (locality < 0 || locality >= this.big.outers.getWidth()) {
            throw new IndexOutOfBoundsException("Locality '" + locality + "' is not valid.");
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Argument can not be null.");
        }
        return this.addAscNameOuterInterface(locality, new EditableOuterName(name));
    }

    private OuterName addAscNameOuterInterface(int locality, EditableOuterName name) {
        this.assertOpen();
        if (this.big.outers.getAsc().containsKey(locality + "#" + name.getName())) {
            throw new IllegalArgumentException("Name '" + name.getName() + "' already present.");
        }
        name.setOwner(this);
        this.big.outers.addAsc(locality, name);
        this.assertConsistency();
        return name;
    }

    public OuterName addDescNameInnerInterface(int locality) {
        return this.addDescNameInnerInterface(locality, new EditableOuterName());
    }

    public OuterName addDescNameInnerInterface(int locality, String name) {
        if (locality < 0 || locality >= this.big.inners.getWidth()) {
            throw new IndexOutOfBoundsException("Locality '" + locality + "' is not valid.");
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Argument can not be null.");
        }
        return this.addDescNameInnerInterface(locality, new EditableOuterName(name));
    }

    private OuterName addDescNameInnerInterface(int locality, EditableOuterName name) {
        this.assertOpen();
        if (this.big.inners.getDesc().containsKey(locality + "#" + name.getName())) {
            throw new IllegalArgumentException("Name '" + name.getName() + "' already present.");
        }
        name.setOwner(this);
        this.big.inners.addDesc(locality, name);
        this.assertConsistency();
        return name;
    }

    public InnerName addDescNameOuterInterface(int locality) {
        EditableEdge e = new EditableEdge(this);
        this.big.onEdgeAdded(e);
        return this.addDescNameOuterInterface(locality, new EditableInnerName(), e);
    }

    public InnerName addDescNameOuterInterface(int locality, Handle handle) {
        Owner o = handle.getOwner();
        this.assertOrSetOwner(handle, "Handle");
        if (handle.isEdge() && o != null) {
            this.big.onEdgeAdded((EditableEdge)handle);
        }
        return this.addDescNameOuterInterface(locality, new EditableInnerName(), (EditableHandle)handle);
    }

    public InnerName addDescNameOuterInterface(int locality, String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name can not be null.");
        }
        EditableEdge e = new EditableEdge(this);
        this.big.onEdgeAdded(e);
        return this.addDescNameOuterInterface(locality, name, (Handle)e);
    }

    public InnerName addDescNameOuterInterface(int locality, String name, Handle handle) {
        if (name == null) {
            throw new IllegalArgumentException("Name can not be null.");
        }
        if (this.big.outers.getAsc().values().contains(handle) && handle.getPoints().size() >= 1) {
            throw new IllegalArgumentException("Can not connect more than one name to an upward outer name.");
        }
        if (this.big.inners.getDesc().values().contains(handle) && handle.getPoints().size() >= 1) {
            for (Point point : handle.getPoints()) {
                if (!this.big.inners.getAsc().values().contains(point)) continue;
                throw new IllegalArgumentException("Can not connect more than one name to a downward inner name.");
            }
        }
        Owner o = handle.getOwner();
        this.assertOrSetOwner(handle, "Handle");
        if (handle.isEdge() && o != null) {
            this.big.onEdgeAdded((EditableEdge)handle);
        }
        return this.addDescNameOuterInterface(locality, new EditableInnerName(name), (EditableHandle)handle);
    }

    private InnerName addDescNameOuterInterface(int locality, EditableInnerName n, EditableHandle h) {
        this.assertOpen();
        if (this.big.outers.getDesc(locality).containsKey(n.getName())) {
            throw new IllegalArgumentException("Name already present.");
        }
        n.setHandle(h);
        this.big.outers.addDesc(locality, n);
        this.assertConsistency();
        return n;
    }

    public InnerName addAscNameInnerInterface(int locality) {
        EditableEdge e = new EditableEdge(this);
        this.big.onEdgeAdded(e);
        return this.addAscNameInnerInterface(locality, new EditableInnerName(), e);
    }

    public InnerName addAscNameInnerInterface(int locality, Handle handle) {
        Owner o = handle.getOwner();
        this.assertOrSetOwner(handle, "Handle");
        if (handle.isEdge() && o != null) {
            this.big.onEdgeAdded((EditableEdge)handle);
        }
        return this.addAscNameInnerInterface(locality, new EditableInnerName(), (EditableHandle)handle);
    }

    public InnerName addAscNameInnerInterface(int locality, String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name can not be null.");
        }
        EditableEdge e = new EditableEdge(this);
        this.big.onEdgeAdded(e);
        return this.addAscNameInnerInterface(locality, name, (Handle)e);
    }

    public InnerName addAscNameInnerInterface(int locality, String name, Handle handle) {
        if (name == null) {
            throw new IllegalArgumentException("Name can not be null.");
        }
        if (this.big.inners.getDesc().values().contains(handle) && handle.getPoints().size() >= 1) {
            throw new IllegalArgumentException("Can not connect more than one name to a downward inner name.");
        }
        if (this.big.outers.getAsc().values().contains(handle) && handle.getPoints().size() >= 1) {
            for (Point point : handle.getPoints()) {
                if (!this.big.outers.getDesc().values().contains(point)) continue;
                throw new IllegalArgumentException("Can not connect more than one name to an upward outer name.");
            }
        }
        Owner o = handle.getOwner();
        this.assertOrSetOwner(handle, "Handle");
        if (handle.isEdge() && o != null) {
            this.big.onEdgeAdded((EditableEdge)handle);
        }
        return this.addAscNameInnerInterface(locality, new EditableInnerName(name), (EditableHandle)handle);
    }

    private InnerName addAscNameInnerInterface(int locality, EditableInnerName n, EditableHandle h) {
        this.assertOpen();
        if (this.big.inners.getAsc(locality).containsKey(n.getName())) {
            throw new IllegalArgumentException("Name already present.");
        }
        n.setHandle(h);
        this.big.inners.addAsc(locality, n);
        this.assertConsistency();
        return n;
    }

    public Edge relink(Point ... points) {
        return (Edge)this.relink((Handle)new EditableEdge(), points);
    }

    public Edge relink(Collection<? extends Point> points) {
        if (points == null) {
            throw new IllegalArgumentException("Argument can not be null.");
        }
        return this.relink(points.toArray(new EditablePoint[points.size()]));
    }

    public Handle relink(Handle handle, Point ... points) {
        int i;
        this.assertOpen();
        this.assertOrSetOwner(handle, "Handle");
        EditablePoint[] ps = new EditablePoint[points.length];
        EditableHandle h = (EditableHandle)handle;
        for (i = 0; i < points.length; ++i) {
            ps[i] = (EditablePoint)points[i];
            this.assertOwner(ps[i], "Point");
        }
        for (i = 0; i < points.length; ++i) {
            EditableHandle old = ps[i].getHandle();
            ps[i].setHandle(h);
            if (!old.isEdge() || !old.getPoints().isEmpty()) continue;
            this.big.onEdgeRemoved((EditableEdge)old);
        }
        if (handle.isEdge()) {
            this.big.onEdgeAdded((EditableEdge)handle);
        }
        this.assertConsistency();
        return h;
    }

    public Handle relink(Handle handle, Collection<? extends Point> points) {
        if (points == null) {
            throw new IllegalArgumentException("Argument can not be null.");
        }
        return this.relink(handle, (Point[])points.toArray(new EditablePoint[points.size()]));
    }

    public Edge unlink(Point point) {
        return this.relink(point);
    }

    public Edge closeOuterNameOuterInterface(int locality, String name) {
        return this.closeOuterNameOuterInterface(locality, this.big.outers.getAsc(locality).get(name));
    }

    public Edge closeOuterNameOuterInterface(int locality, OuterName name) {
        this.assertOwner(name, "OuterName ");
        if (!this.big.outers.getAsc(locality).containsKey(name.getName())) {
            throw new IllegalArgumentException("Name '" + name.getName() + "' not present.");
        }
        EditableOuterName n1 = (EditableOuterName)name;
        Edge e = this.relink(n1.getEditablePoints());
        this.big.outers.removeAsc(locality, name.getName());
        n1.setOwner(null);
        return e;
    }

    public Edge closeOuterNameInnerInterface(int locality, String name) {
        return this.closeOuterNameInnerInterface(locality, this.big.inners.getDesc(locality).get(name));
    }

    public Edge closeOuterNameInnerInterface(int locality, OuterName name) {
        this.assertOwner(name, "OuterName ");
        if (!this.big.inners.getDesc(locality).containsKey(name.getName())) {
            throw new IllegalArgumentException("Name '" + name.getName() + "' not present.");
        }
        EditableOuterName n1 = (EditableOuterName)name;
        Edge e = this.relink(n1.getEditablePoints());
        this.big.inners.removeDesc(locality, name.getName());
        n1.setOwner(null);
        return e;
    }

    public void closeInnerNameOuterInterface(int locality, String name) {
        this.closeInnerNameOuterInterface(locality, this.big.outers.getDesc(locality).get(name));
    }

    public void closeInnerNameOuterInterface(int locality, InnerName name) {
        this.assertOwner(name, "InnerName ");
        if (!this.big.outers.getDesc(locality).containsKey(name.getName())) {
            throw new IllegalArgumentException("Name '" + name.getName() + "' not present.");
        }
        EditableInnerName n1 = (EditableInnerName)name;
        EditableHandle h = n1.getHandle();
        n1.setHandle(null);
        this.big.outers.removeDesc(locality, n1.getName());
        if (h.isEdge() && h.getPoints().isEmpty()) {
            this.big.onEdgeRemoved((EditableEdge)h);
        }
    }

    public void closeInnerNameInnerInterface(int locality, String name) {
        this.closeInnerNameInnerInterface(locality, this.big.inners.getAsc(locality).get(name));
    }

    public void closeInnerNameInnerInterface(int locality, InnerName name) {
        this.assertOwner(name, "InnerName ");
        if (!this.big.inners.getAsc(locality).containsKey(name.getName())) {
            throw new IllegalArgumentException("Name '" + name.getName() + "' not present.");
        }
        EditableInnerName n1 = (EditableInnerName)name;
        EditableHandle h = n1.getHandle();
        n1.setHandle(null);
        this.big.inners.removeAsc(locality, n1.getName());
        if (h.isEdge() && h.getPoints().isEmpty()) {
            this.big.onEdgeRemoved((EditableEdge)h);
        }
    }

    public void renameOuterNameOuterInterface(int locality, String oldName, String newName) {
        if (newName == null || oldName == null) {
            throw new IllegalArgumentException("Arguments can not be null");
        }
        EditableOuterName n1 = this.big.outers.getAsc(locality).get(oldName);
        if (n1 == null) {
            throw new IllegalArgumentException("Name '" + oldName + "' is not present.");
        }
        this.renameOuterNameOuterInterface(locality, n1, newName);
    }

    public void renameOuterNameOuterInterface(int locality, OuterName oldName, String newName) {
        if (newName == null || oldName == null) {
            throw new IllegalArgumentException("Arguments can not be null");
        }
        this.assertOwner(oldName, "OuterName ");
        if (newName.equals(oldName.getName())) {
            return;
        }
        EditableOuterName n2 = this.big.outers.getAsc(locality).get(newName);
        if (n2 != null) {
            throw new IllegalArgumentException("Name '" + newName + "' already in use");
        }
        ((EditableOuterName)oldName).setName(newName);
    }

    public void renameOuterNameInnerInterface(int locality, String oldName, String newName) {
        if (newName == null || oldName == null) {
            throw new IllegalArgumentException("Arguments can not be null");
        }
        EditableOuterName n1 = this.big.inners.getDesc(locality).get(oldName);
        if (n1 == null) {
            throw new IllegalArgumentException("Name '" + oldName + "' is not present.");
        }
        this.renameOuterNameInnerInterface(locality, n1, newName);
    }

    public void renameOuterNameInnerInterface(int locality, OuterName oldName, String newName) {
        if (newName == null || oldName == null) {
            throw new IllegalArgumentException("Arguments can not be null");
        }
        this.assertOwner(oldName, "OuterName ");
        if (newName.equals(oldName.getName())) {
            return;
        }
        EditableOuterName n2 = this.big.inners.getDesc(locality).get(newName);
        if (n2 != null) {
            throw new IllegalArgumentException("Name '" + newName + "' already in use");
        }
        ((EditableOuterName)oldName).setName(newName);
    }

    public void renameInnerNameOuterInterface(int locality, String oldName, String newName) {
        if (newName == null || oldName == null) {
            throw new IllegalArgumentException("Arguments can not be null");
        }
        EditableInnerName n1 = this.big.outers.getDesc(locality).get(oldName);
        if (n1 == null) {
            throw new IllegalArgumentException("Name '" + oldName + "' is not present.");
        }
        this.renameInnerNameOuterInterface(locality, n1, newName);
    }

    public void renameInnerNameOuterInterface(int locality, InnerName oldName, String newName) {
        if (newName == null || oldName == null) {
            throw new IllegalArgumentException("Arguments can not be null");
        }
        this.assertOwner(oldName, "InnerName ");
        if (newName.equals(oldName.getName())) {
            return;
        }
        EditableInnerName n2 = this.big.outers.getDesc(locality).get(newName);
        if (n2 != null) {
            throw new IllegalArgumentException("Name '" + newName + "' is present already.");
        }
        ((EditableInnerName)oldName).setName(newName);
    }

    public void renameInnerNameInnerInterface(int locality, String oldName, String newName) {
        if (newName == null || oldName == null) {
            throw new IllegalArgumentException("Arguments can not be null");
        }
        EditableInnerName n1 = this.big.inners.getAsc(locality).get(oldName);
        if (n1 == null) {
            throw new IllegalArgumentException("Name '" + oldName + "' is not present.");
        }
        this.renameInnerNameInnerInterface(locality, n1, newName);
    }

    public void renameInnerNameInnerInterface(int locality, InnerName oldName, String newName) {
        if (newName == null || oldName == null) {
            throw new IllegalArgumentException("Arguments can not be null");
        }
        this.assertOwner(oldName, "InnerName ");
        if (newName.equals(oldName.getName())) {
            return;
        }
        EditableInnerName n2 = this.big.inners.getAsc(locality).get(newName);
        if (n2 != null) {
            throw new IllegalArgumentException("Name '" + newName + "' is present already.");
        }
        ((EditableInnerName)oldName).setName(newName);
    }

    public Root merge() {
        this.assertOpen();
        EditableRoot r = new EditableRoot();
        r.setOwner(this);
        for (EditableParent editableParent : this.big.roots) {
            for (EditableChild c : new HashSet<EditableChild>(editableParent.getEditableChildren())) {
                c.setParent(r);
            }
        }
        DirectedBigraphBuilder.clearOwnedCollection(this.big.roots);
        this.big.roots.add(r);
        this.assertConsistency();
        return r;
    }

    public Root merge(int index, int ... roots) {
        this.assertOpen();
        EditableRoot r = new EditableRoot();
        r.setOwner(this);
        EditableRoot[] rs = new EditableRoot[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            rs[i] = this.big.roots.get(roots[i]);
            Iterator ir = rs[i].getEditableChildren().iterator();
            while (ir.hasNext()) {
                ((EditableChild)ir.next()).setParent(r);
            }
        }
        for (EditableRoot r1 : rs) {
            this.big.roots.remove(r1);
            r1.setOwner(null);
        }
        this.big.roots.add(index, r);
        this.assertConsistency();
        return r;
    }

    public void removeRoot(Root root) {
        this.assertOwner(root, "Root ");
        if (!root.getChildren().isEmpty()) {
            throw new IllegalArgumentException("Unempty region.");
        }
        EditableRoot editableRoot = (EditableRoot)root;
        editableRoot.setOwner(null);
        this.big.roots.remove(editableRoot);
        if (!root.getChildren().isEmpty()) {
            this.big.onNodeSetChanged();
        }
        this.assertConsistency();
    }

    public void removeRoot(int index) {
        if (index < 0 || index >= this.big.roots.size()) {
            throw new IndexOutOfBoundsException("The argument does not refer to a root.");
        }
        this.removeRoot(this.big.roots.get(index));
    }

    public void closeSite(Site site) {
        this.assertOwner(site, "Site ");
        EditableSite editableSite = (EditableSite)site;
        editableSite.setParent(null);
        this.big.sites.remove(editableSite);
        this.assertConsistency();
    }

    public void closeSite(int index) {
        if (index < 0 || index >= this.big.sites.size()) {
            throw new IndexOutOfBoundsException("The argument does not refer to a site.");
        }
        this.closeSite(this.big.sites.get(index));
    }

    public void ground() {
        this.assertOpen();
        DirectedBigraphBuilder.clearChildCollection(this.big.sites);
        DirectedBigraphBuilder.clearInnerInterface(this.big.inners);
        this.assertConsistency();
    }

    public void leftJuxtapose(DirectedBigraph graph) {
        this.leftJuxtapose(graph, false);
    }

    public void leftJuxtapose(DirectedBigraph graph, boolean reuse) {
        this.assertOpen();
        DirectedBigraph left = graph;
        DirectedBigraph right = this.big;
        if (left == right) {
            throw new IllegalArgumentException("Operand shuld be distinct; a bigraph can not be juxtaposed with itself.");
        }
        if (!left.signature.equals(right.signature)) {
            throw new IncompatibleSignatureException(left.getSignature(), right.getSignature());
        }
        if (!(Collections.disjoint(left.inners.getAsc(0).keySet(), right.inners.getAsc(0).keySet()) && Collections.disjoint(left.inners.getDesc(0).keySet(), right.inners.getDesc(0).keySet()) && Collections.disjoint(left.outers.getAsc(0).keySet(), right.outers.getAsc(0).keySet()) && Collections.disjoint(left.outers.getDesc(0).keySet(), right.outers.getDesc(0).keySet()))) {
            throw new IncompatibleInterfaceException(new NameClashException(DirectedBigraph.Interface.intersectNames(left.inners.getAsc(0).values(), right.inners.getAsc(0).values(), DirectedBigraph.Interface.intersectNames(left.outers.getAsc(0).values(), right.outers.getAsc(0).values(), DirectedBigraph.Interface.intersectNames(left.outers.getDesc(0).values(), right.outers.getDesc(0).values(), DirectedBigraph.Interface.intersectNames(left.inners.getDesc(0).values(), right.inners.getDesc(0).values()))))));
        }
        DirectedBigraph l = reuse ? left : left.clone();
        DirectedBigraph r = right;
        for (EditableOwned editableOwned : l.roots) {
            editableOwned.setOwner(this);
        }
        for (EditableOwned editableOwned : l.outers.getAsc().values()) {
            editableOwned.setOwner(this);
        }
        for (EditableOwned editableOwned : l.inners.getDesc().values()) {
            editableOwned.setOwner(this);
        }
        Collection<EditableEdge> es = l.edgesProxy.get();
        for (EditableEdge e : es) {
            e.setOwner(this);
        }
        r.onEdgeAdded(es);
        r.onNodeAdded(l.nodesProxy.get());
        l.onEdgeSetChanged();
        l.onNodeSetChanged();
        r.roots.addAll(0, l.roots);
        r.sites.addAll(0, l.sites);
        r.outers.join(l.outers);
        r.inners.join(l.inners);
        this.assertConsistency();
    }

    public void rightJuxtapose(DirectedBigraph graph) {
        this.rightJuxtapose(graph, false);
    }

    public void rightJuxtapose(DirectedBigraph graph, boolean reuse) {
        this.assertOpen();
        DirectedBigraph left = this.big;
        DirectedBigraph right = graph;
        if (left == right) {
            throw new IllegalArgumentException("Operand shuld be distinct; a bigraph can not be juxtaposed with itself.");
        }
        if (!left.signature.equals(right.signature)) {
            throw new IncompatibleSignatureException(left.signature, right.signature);
        }
        if (!(Collections.disjoint(left.inners.getAsc(0).keySet(), right.inners.getAsc(0).keySet()) && Collections.disjoint(left.inners.getDesc(0).keySet(), right.inners.getDesc(0).keySet()) && Collections.disjoint(left.outers.getAsc(0).keySet(), right.outers.getAsc(0).keySet()) && Collections.disjoint(left.outers.getDesc(0).keySet(), right.outers.getDesc(0).keySet()))) {
            throw new IncompatibleInterfaceException(new NameClashException(DirectedBigraph.Interface.intersectNames(left.inners.getAsc(0).values(), right.inners.getAsc(0).values(), DirectedBigraph.Interface.intersectNames(left.outers.getAsc(0).values(), right.outers.getAsc(0).values(), DirectedBigraph.Interface.intersectNames(left.outers.getDesc(0).values(), right.outers.getDesc(0).values(), DirectedBigraph.Interface.intersectNames(left.inners.getDesc(0).values(), right.inners.getDesc(0).values()))))));
        }
        DirectedBigraph l = left;
        DirectedBigraph r = reuse ? right : right.clone();
        for (EditableOwned editableOwned : r.roots) {
            editableOwned.setOwner(this);
        }
        for (EditableOwned editableOwned : r.outers.getAsc().values()) {
            editableOwned.setOwner(this);
        }
        for (EditableOwned editableOwned : r.inners.getDesc().values()) {
            editableOwned.setOwner(this);
        }
        Collection<EditableEdge> es = r.edgesProxy.get();
        for (EditableEdge e : es) {
            e.setOwner(this);
        }
        l.onEdgeAdded(es);
        l.onNodeAdded(r.nodesProxy.get());
        r.onEdgeSetChanged();
        r.onNodeSetChanged();
        l.roots.addAll(r.roots);
        l.sites.addAll(r.sites);
        l.outers.join(r.outers);
        l.inners.join(r.inners);
        this.assertConsistency();
    }

    public void innerCompose(DirectedBigraph graph) {
        this.innerCompose(graph, false);
    }

    public void innerCompose(DirectedBigraph graph, boolean reuse) {
        this.assertOpen();
        DirectedBigraph in = graph;
        DirectedBigraph out = this.big;
        if (out == in) {
            throw new IllegalArgumentException("Operand shuld be distinct; a bigraph can not be composed with itself.");
        }
        if (!out.signature.equals(in.signature)) {
            throw new IncompatibleSignatureException(out.signature, in.signature);
        }
        HashSet<String> xs = new HashSet<String>(out.inners.keySet());
        HashSet<String> ys = new HashSet<String>(in.outers.keySet());
        HashSet<String> zs = new HashSet<String>(xs);
        xs.removeAll(ys);
        ys.removeAll(zs);
        if (!xs.isEmpty() || !ys.isEmpty() || out.sites.size() != in.roots.size()) {
            throw new IncompatibleInterfaceException("The outer face of the first graph must be equal to inner face of the second");
        }
        DirectedBigraph a = out;
        DirectedBigraph b = reuse ? in : in.clone();
        Collection<EditableEdge> es = b.edgesProxy.get();
        Collection<EditableNode> ns = b.nodesProxy.get();
        Iterator<EditableRoot> ir = b.roots.iterator();
        Iterator<EditableSite> is = a.sites.iterator();
        while (ir.hasNext()) {
            EditableSite s = is.next();
            EditableParent p = s.getParent();
            p.removeChild(s);
            for (EditableChild c : new HashSet(ir.next().getEditableChildren())) {
                c.setParent(p);
            }
        }
        for (int l = 0; l < a.inners.getWidth(); ++l) {
            EditableHandle h;
            HashMap<CallSite, EditableHandle> handleMap = new HashMap<CallSite, EditableHandle>();
            for (EditableInnerName i : a.inners.getAsc(l).values()) {
                handleMap.put((CallSite)((Object)("A" + i.getName())), i.getHandle());
                i.setHandle(null);
            }
            for (EditableOuterName o : b.outers.getAsc(l).values()) {
                h = (EditableHandle)handleMap.get("A" + o.getName());
                for (EditablePoint p : new HashSet<EditablePoint>(o.getEditablePoints())) {
                    p.setHandle(h);
                }
            }
            for (EditableInnerName i : b.outers.getDesc(l).values()) {
                handleMap.put((CallSite)((Object)("D" + i.getName())), i.getHandle());
                i.setHandle(null);
            }
            for (EditableOuterName o : a.inners.getDesc(l).values()) {
                h = (EditableHandle)handleMap.get("D" + o.getName());
                for (EditablePoint p : new HashSet<EditablePoint>(o.getEditablePoints())) {
                    p.setHandle(h);
                }
            }
        }
        DirectedBigraphBuilder.clearInnerInterface(a.inners);
        DirectedBigraphBuilder.clearChildCollection(a.sites);
        a.inners.names.addAll(b.inners.names);
        a.sites.addAll(b.sites);
        a.onNodeAdded(ns);
        b.onNodeSetChanged();
        for (EditableEdge e : es) {
            e.setOwner(this);
        }
        a.onEdgeAdded(es);
        b.onEdgeSetChanged();
        this.assertConsistency();
    }

    public void outerCompose(DirectedBigraph graph) {
        this.outerCompose(graph, false);
    }

    public void outerCompose(DirectedBigraph graph, boolean reuse) {
        this.assertOpen();
        DirectedBigraph in = this.big;
        DirectedBigraph out = graph;
        if (out == in) {
            throw new IllegalArgumentException("Operand shuld be distinct; a bigraph can not be composed with itself.");
        }
        if (!out.signature.equals(in.signature)) {
            throw new IncompatibleSignatureException(out.signature, in.signature);
        }
        HashSet<String> xs = new HashSet<String>(out.inners.keySet());
        HashSet<String> ys = new HashSet<String>(in.outers.keySet());
        HashSet<String> zs = new HashSet<String>(xs);
        xs.removeAll(ys);
        ys.removeAll(zs);
        if (!xs.isEmpty() || !ys.isEmpty() || out.sites.size() != in.roots.size()) {
            throw new IncompatibleInterfaceException("The outer face of the first graph must be equal to inner face of the second");
        }
        DirectedBigraph a = reuse ? out : out.clone();
        DirectedBigraph b = in;
        Collection<EditableEdge> es = a.edgesProxy.get();
        Collection<EditableNode> ns = a.nodesProxy.get();
        Iterator<EditableRoot> ir = b.roots.iterator();
        Iterator<EditableSite> is = a.sites.iterator();
        while (ir.hasNext()) {
            EditableSite s = is.next();
            EditableParent editableParent = s.getParent();
            editableParent.removeChild(s);
            for (EditableChild c : new HashSet(ir.next().getEditableChildren())) {
                c.setParent(editableParent);
            }
        }
        for (int l = 0; l < a.inners.getWidth(); ++l) {
            EditableHandle h;
            HashMap<CallSite, EditableHandle> hashMap = new HashMap<CallSite, EditableHandle>();
            for (EditableInnerName i : a.inners.getAsc(l).values()) {
                hashMap.put((CallSite)((Object)("A" + i.getName())), i.getHandle());
                i.setHandle(null);
            }
            for (EditableOuterName o : b.outers.getAsc(l).values()) {
                h = (EditableHandle)hashMap.get("A" + o.getName());
                for (EditablePoint p : new HashSet<EditablePoint>(o.getEditablePoints())) {
                    p.setHandle(h);
                }
            }
            for (EditableInnerName i : b.outers.getDesc(l).values()) {
                hashMap.put((CallSite)((Object)("D" + i.getName())), i.getHandle());
                i.setHandle(null);
            }
            for (EditableOuterName o : a.inners.getDesc(l).values()) {
                h = (EditableHandle)hashMap.get("D" + o.getName());
                for (EditablePoint p : new HashSet<EditablePoint>(o.getEditablePoints())) {
                    p.setHandle(h);
                }
            }
        }
        DirectedBigraphBuilder.clearOuterInterface(b.outers);
        DirectedBigraphBuilder.clearOwnedCollection(b.roots);
        b.outers.names.addAll(a.outers.names);
        b.roots.addAll(a.roots);
        for (EditableOwned editableOwned : b.roots) {
            editableOwned.setOwner(this);
        }
        for (EditableOwned editableOwned : b.outers.getAsc().values()) {
            editableOwned.setOwner(this);
        }
        for (EditableOwned editableOwned : b.inners.getDesc().values()) {
            editableOwned.setOwner(this);
        }
        b.onNodeAdded(ns);
        a.onNodeSetChanged();
        for (EditableEdge editableEdge : es) {
            editableEdge.setOwner(this);
        }
        b.onEdgeAdded(es);
        a.onEdgeSetChanged();
        this.assertConsistency();
    }

    public void leftParallelProduct(DirectedBigraph graph) {
        this.leftParallelProduct(graph, false);
    }

    public void leftParallelProduct(DirectedBigraph graph, boolean reuse) {
        this.assertOpen();
        DirectedBigraph left = graph;
        DirectedBigraph right = this.big;
        if (!left.signature.equals(right.signature)) {
            throw new IncompatibleSignatureException(left.signature, right.signature);
        }
        if (!Collections.disjoint(left.inners.keySet(), right.inners.keySet())) {
            throw new IncompatibleInterfaceException(new NameClashException(DirectedBigraph.Interface.intersectNames(left.inners.getAsc().values(), right.inners.getAsc().values(), DirectedBigraph.Interface.intersectNames(left.outers.getAsc().values(), right.outers.getAsc().values(), DirectedBigraph.Interface.intersectNames(left.outers.getDesc().values(), right.outers.getDesc().values(), DirectedBigraph.Interface.intersectNames(left.inners.getDesc().values(), right.inners.getDesc().values()))))));
        }
        DirectedBigraph l = reuse ? left : left.clone();
        DirectedBigraph r = right;
        for (EditableOwned editableOwned : l.roots) {
            editableOwned.setOwner(this);
        }
        for (int loc = 0; loc < l.outers.getWidth(); ++loc) {
            for (EditableOuterName o : l.outers.getAsc(loc).values()) {
                EditableOuterName q = null;
                for (EditableOuterName editableOuterName : r.outers.getAsc(loc).values()) {
                    if (!editableOuterName.getName().equals(o.getName())) continue;
                    q = editableOuterName;
                    break;
                }
                if (q == null) {
                    r.outers.addAsc(loc, o);
                    o.setOwner(this);
                    continue;
                }
                for (EditablePoint editablePoint : new HashSet<EditablePoint>(o.getEditablePoints())) {
                    q.linkPoint(editablePoint);
                }
            }
            for (EditableInnerName i : l.outers.getDesc(loc).values()) {
                EditableInnerName j = null;
                for (EditableInnerName editableInnerName : r.outers.getDesc(loc).values()) {
                    if (!editableInnerName.getName().equals(i.getName())) continue;
                    j = editableInnerName;
                    break;
                }
                if (j != null) continue;
                r.outers.addDesc(loc, i);
            }
        }
        Collection<EditableEdge> es = l.edgesProxy.get();
        for (EditableEdge e : es) {
            e.setOwner(this);
        }
        r.onEdgeAdded(es);
        r.onNodeAdded(l.nodesProxy.get());
        l.onEdgeSetChanged();
        l.onNodeSetChanged();
        r.roots.addAll(l.roots);
        r.sites.addAll(l.sites);
        r.inners.join(l.inners);
        this.assertConsistency();
    }

    public void rightParallelProduct(DirectedBigraph graph) {
        this.rightParallelProduct(graph, false);
    }

    /*
     * WARNING - void declaration
     */
    public void rightParallelProduct(DirectedBigraph graph, boolean reuse) {
        void var8_10;
        this.assertOpen();
        DirectedBigraph left = this.big;
        DirectedBigraph right = graph;
        if (left == right) {
            throw new IllegalArgumentException("Operand shuld be distinct; a bigraph can not be juxtaposed with itself.");
        }
        if (!left.signature.equals(right.signature)) {
            throw new IncompatibleSignatureException(left.signature, right.signature);
        }
        if (!Collections.disjoint(left.inners.keySet(), right.inners.keySet())) {
            throw new IncompatibleInterfaceException(new NameClashException(DirectedBigraph.Interface.intersectNames(left.inners.getAsc().values(), right.inners.getAsc().values(), DirectedBigraph.Interface.intersectNames(left.outers.getAsc().values(), right.outers.getAsc().values(), DirectedBigraph.Interface.intersectNames(left.outers.getDesc().values(), right.outers.getDesc().values(), DirectedBigraph.Interface.intersectNames(left.inners.getDesc().values(), right.inners.getDesc().values()))))));
        }
        DirectedBigraph l = left;
        DirectedBigraph r = reuse ? right : right.clone();
        for (EditableOwned editableOwned : r.roots) {
            editableOwned.setOwner(this);
        }
        HashMap os = new HashMap();
        boolean bl = false;
        while (var8_10 < r.outers.getWidth()) {
            for (EditableOuterName o : r.outers.getAsc((int)var8_10).values()) {
                EditableOuterName q = null;
                for (EditableOuterName editableOuterName : l.outers.getAsc((int)var8_10).values()) {
                    if (!editableOuterName.getName().equals(o.getName())) continue;
                    q = editableOuterName;
                    break;
                }
                if (q == null) {
                    l.outers.addAsc((int)var8_10, o);
                    o.setOwner(this);
                    continue;
                }
                for (EditablePoint editablePoint : new HashSet<EditablePoint>(o.getEditablePoints())) {
                    q.linkPoint(editablePoint);
                }
            }
            for (EditableInnerName i : r.outers.getDesc((int)var8_10).values()) {
                EditableInnerName j = null;
                for (EditableInnerName editableInnerName : l.outers.getDesc((int)var8_10).values()) {
                    if (!editableInnerName.getName().equals(i.getName())) continue;
                    j = editableInnerName;
                    break;
                }
                if (j != null) continue;
                r.outers.addDesc((int)var8_10, i);
            }
            ++var8_10;
        }
        Collection<EditableEdge> collection = r.edgesProxy.get();
        for (EditableEdge e : collection) {
            e.setOwner(this);
        }
        l.onEdgeAdded(collection);
        l.onNodeAdded(r.nodesProxy.get());
        r.onEdgeSetChanged();
        r.onNodeSetChanged();
        l.roots.addAll(r.roots);
        l.sites.addAll(r.sites);
        l.inners.join(r.inners);
        this.assertConsistency();
    }

    public void leftMergeProduct(DirectedBigraph graph) {
        this.leftMergeProduct(graph, false);
    }

    public void leftMergeProduct(DirectedBigraph graph, boolean reuse) {
        this.leftJuxtapose(graph, reuse);
        this.merge();
    }

    public void rightMergeProduct(DirectedBigraph graph) {
        this.rightMergeProduct(graph, false);
    }

    public void rightMergeProduct(DirectedBigraph graph, boolean reuse) {
        this.rightJuxtapose(graph, reuse);
        this.merge();
    }

    private void assertConsistency() {
        if (DEBUG_CONSISTENCY_CHECK && !this.big.isConsistent(this)) {
            throw new RuntimeException("Inconsistent bigraph.");
        }
    }

    private void assertOwner(Owned owned, String obj) {
        if (owned == null) {
            throw new IllegalArgumentException(obj + " can not be null.");
        }
        Owner o = owned.getOwner();
        if (o != this) {
            throw new UnexpectedOwnerException(obj + " should be owned by this structure.");
        }
    }

    private void assertOrSetOwner(Owned owned, String obj) {
        if (owned == null) {
            throw new IllegalArgumentException(obj + " can not be null.");
        }
        Owner o = owned.getOwner();
        if (o == null) {
            ((EditableOwned)owned).setOwner(this);
        } else if (o != this) {
            throw new UnexpectedOwnerException(obj + " already owned by an other structure.");
        }
    }
}

