/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.ldb;

import it.uniud.mads.jlibbig.core.DirectedInstantiationRule;
import it.uniud.mads.jlibbig.core.exceptions.IncompatibleInterfaceException;
import it.uniud.mads.jlibbig.core.ldb.DirectedBigraph;
import it.uniud.mads.jlibbig.core.ldb.EditableChild;
import it.uniud.mads.jlibbig.core.ldb.EditableHandle;
import it.uniud.mads.jlibbig.core.ldb.EditableInnerName;
import it.uniud.mads.jlibbig.core.ldb.EditableNode;
import it.uniud.mads.jlibbig.core.ldb.EditableOuterName;
import it.uniud.mads.jlibbig.core.ldb.EditableParent;
import it.uniud.mads.jlibbig.core.ldb.EditablePoint;
import it.uniud.mads.jlibbig.core.ldb.EditableRoot;
import it.uniud.mads.jlibbig.core.ldb.EditableSite;
import it.uniud.mads.jlibbig.core.ldb.InnerName;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;

public class DirectedInstantiationMap
implements DirectedInstantiationRule<DirectedBigraph> {
    private static final boolean DEBUG_CONSISTENCY_CHECK = Boolean.getBoolean("it.uniud.mads.jlibbig.consistency") || Boolean.getBoolean("it.uniud.mads.jlibbig.consistency.reactions");
    private final int[] map;
    private final int dom;
    private final int cod;
    private final int[] multiplicity;

    public DirectedInstantiationMap(int codomain, int ... map) {
        this.dom = map.length;
        this.cod = codomain--;
        this.map = new int[this.dom];
        this.multiplicity = new int[this.cod];
        for (int i = 0; i < map.length; ++i) {
            int j;
            if (map[i] < 0 || map[i] > codomain) {
                throw new IllegalArgumentException("Invalid image");
            }
            this.map[i] = j = map[i];
            int n = j;
            this.multiplicity[n] = this.multiplicity[n] + 1;
        }
    }

    public int getPlaceDomain() {
        return this.dom;
    }

    public int getPlaceCodomain() {
        return this.cod;
    }

    public int getPlaceInstance(int arg) {
        if (-1 < arg && arg < this.dom) {
            return this.map[arg];
        }
        return -1;
    }

    public boolean isNeeded(int prm) {
        return -1 < prm && prm < this.cod && this.multiplicity[prm] > 0;
    }

    @Override
    public Iterable<DirectedBigraph> instantiate(DirectedBigraph parameters) {
        return this.instantiate(parameters, false);
    }

    /*
     * WARNING - void declaration
     */
    Iterable<DirectedBigraph> instantiate(DirectedBigraph parameters, boolean reuse) {
        EditableHandle h1;
        EditableInnerName i2;
        EditableOuterName o2;
        if (parameters.roots.size() < this.cod) {
            throw new IncompatibleInterfaceException();
        }
        LinkedList<DirectedBigraph> l = new LinkedList<DirectedBigraph>();
        DirectedBigraph prm = new DirectedBigraph(parameters.signature);
        EditableRoot[] rs = new EditableRoot[this.dom];
        EditableSite[][] ss = new EditableSite[parameters.sites.size()][];
        HashMap<EditableHandle, EditableHandle> hnd_dic = new HashMap<EditableHandle, EditableHandle>();
        HashMap<EditableInnerName, EditableInnerName> pnt_dic = new HashMap<EditableInnerName, EditableInnerName>();
        for (EditableOuterName o1 : parameters.outers.getAsc().values()) {
            o2 = reuse ? o1 : o1.replicate();
            prm.outers.addAsc(0, o2);
            o2.setOwner(prm);
            hnd_dic.put(o1, o2);
        }
        for (EditableInnerName i1 : parameters.inners.getAsc().values()) {
            void var13_20;
            i2 = reuse ? i1 : i1.replicate();
            pnt_dic.put(i1, i2);
            h1 = i1.getHandle();
            EditableHandle editableHandle = (EditableHandle)hnd_dic.get(h1);
            if (editableHandle == null) {
                EditableHandle editableHandle2 = reuse ? h1 : h1.replicate();
                editableHandle2.setOwner(prm);
                hnd_dic.put(h1, editableHandle2);
            }
            i2.setHandle((EditableHandle)var13_20);
            prm.inners.addAsc(0, i2);
        }
        for (EditableOuterName o1 : parameters.inners.getDesc().values()) {
            o2 = reuse ? o1 : o1.replicate();
            prm.inners.addDesc(0, o2);
            o2.setOwner(prm);
            hnd_dic.put(o1, o2);
        }
        for (EditableInnerName i1 : parameters.outers.getDesc().values()) {
            void var13_26;
            i2 = reuse ? i1 : i1.replicate();
            pnt_dic.put(i1, i2);
            h1 = i1.getHandle();
            EditableHandle editableHandle = (EditableHandle)hnd_dic.get(h1);
            if (editableHandle == null) {
                EditableHandle editableHandle3 = reuse ? h1 : h1.replicate();
                editableHandle3.setOwner(prm);
                hnd_dic.put(h1, editableHandle3);
            }
            i2.setHandle((EditableHandle)var13_26);
            prm.outers.addDesc(0, i2);
        }
        class VState {
            final EditableChild c;
            final EditableParent[] ps;

            VState(EditableParent[] ps, EditableChild c) {
                this.c = c;
                this.ps = ps;
            }
        }
        ArrayDeque<VState> q = new ArrayDeque<VState>();
        for (int j = 0; j < this.cod; ++j) {
            int m = this.multiplicity[j];
            if (m <= 0) continue;
            EditableRoot r1 = parameters.roots.get(j);
            EditableParent[] editableParentArray = new EditableRoot[m];
            int k = 0;
            for (int i = 0; i < this.dom; ++i) {
                if (this.map[i] != j) continue;
                rs[i] = reuse && k > 0 ? r1 : r1.replicate();
                editableParentArray[k] = rs[i];
                ++k;
            }
            for (EditableChild c : r1.getEditableChildren()) {
                q.add(new VState(editableParentArray, c));
            }
        }
        while (!q.isEmpty()) {
            void var13_37;
            VState s = (VState)q.poll();
            if (s.c.isNode()) {
                void var13_34;
                void var13_32;
                void var13_30;
                EditableNode n1 = (EditableNode)s.c;
                EditableParent[] n2s = new EditableNode[s.ps.length];
                boolean bl = false;
                while (var13_30 < n2s.length) {
                    n2s[var13_30] = reuse && var13_30 > 0 ? n1 : n1.replicate();
                    n2s[var13_30].setParent(s.ps[var13_30]);
                    ++var13_30;
                }
                int n = n1.getControl().getArityOut() - 1;
                while (false <= var13_32) {
                    EditableNode.EditableOutPort p1 = n1.getOutPort((int)var13_32);
                    EditableHandle h12 = p1.getHandle();
                    EditableHandle h22 = (EditableHandle)hnd_dic.get(h12);
                    if (h22 == null) {
                        h22 = reuse ? h12 : h12.replicate();
                        h22.setOwner(prm);
                        hnd_dic.put(h12, h22);
                    }
                    EditableParent[] editableParentArray = n2s;
                    int n2 = editableParentArray.length;
                    for (int i = 0; i < n2; ++i) {
                        EditableNode n22 = editableParentArray[i];
                        n22.getOutPort((int)var13_32).setHandle(h22);
                    }
                    --var13_32;
                }
                int n3 = n1.getControl().getArityIn() - 1;
                while (false <= var13_34) {
                    EditableNode.EditableInPort ip1 = n1.getInPort((int)var13_34);
                    EditableHandle h23 = (EditableHandle)hnd_dic.get(ip1);
                    if (h23 == null) {
                        for (EditableParent n2 : n2s) {
                            EditableNode.EditableInPort ip2 = ((EditableNode)n2).getInPort((int)var13_34);
                            hnd_dic.put(ip1, ip2);
                            for (InnerName innerName : parameters.outers.getDesc().values()) {
                                EditablePoint pnt = (EditablePoint)pnt_dic.get(innerName);
                                if (pnt == null) continue;
                                pnt.setHandle(ip2);
                            }
                        }
                    }
                    --var13_34;
                }
                for (EditableChild c : n1.getEditableChildren()) {
                    q.add(new VState(n2s, c));
                }
                continue;
            }
            EditableSite s1 = (EditableSite)s.c;
            EditableSite[] s2s = new EditableSite[s.ps.length];
            ss[parameters.sites.indexOf((Object)s1)] = s2s;
            boolean bl = false;
            while (var13_37 < s2s.length) {
                s2s[var13_37] = reuse && var13_37 > 0 ? s1 : s1.replicate();
                ++var13_37;
            }
        }
        for (EditableRoot editableRoot : rs) {
            prm.roots.add(editableRoot);
            editableRoot.setOwner(prm);
        }
        for (EditableRoot editableRoot : ss) {
            if (editableRoot == null) continue;
            prm.sites.addAll(Arrays.asList(editableRoot));
        }
        if (reuse) {
            parameters.sites.clear();
            parameters.roots.clear();
            parameters.inners.names.clear();
            parameters.outers.names.clear();
        }
        if (DEBUG_CONSISTENCY_CHECK && !prm.isConsistent()) {
            throw new RuntimeException("Inconsistent bigraph");
        }
        l.add(prm);
        return l;
    }
}

