/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.ldb;

import it.uniud.mads.jlibbig.core.AbstractDirectedMatch;
import it.uniud.mads.jlibbig.core.ldb.DirectedBigraph;
import it.uniud.mads.jlibbig.core.ldb.DirectedSignature;
import it.uniud.mads.jlibbig.core.ldb.Node;
import it.uniud.mads.jlibbig.core.util.BidMap;

public class DirectedMatch
extends AbstractDirectedMatch<DirectedBigraph> {
    protected DirectedBigraph rdxImage;
    protected DirectedBigraph rdxId;
    private BidMap<Node, Node> emb_nodes;

    protected DirectedMatch(DirectedBigraph context, DirectedBigraph redexImage, DirectedBigraph redexId, DirectedBigraph param, BidMap<Node, Node> nodeEmbedding) {
        super(context, null, param);
        DirectedSignature sig = context.signature;
        this.rdxImage = redexImage;
        this.rdxId = redexId != null ? redexId : DirectedBigraph.makeEmpty(sig);
        this.emb_nodes = nodeEmbedding;
    }

    public Node getImage(Node node) {
        return this.emb_nodes.get(node);
    }

    public Node getPreImage(Node node) {
        return this.emb_nodes.getKey(node);
    }

    @Override
    public DirectedBigraph getRedex() {
        if (this.redex == null) {
            this.redex = DirectedBigraph.juxtapose(this.rdxImage, this.rdxId);
        }
        return (DirectedBigraph)this.redex;
    }

    public DirectedBigraph getRedexImage() {
        return this.rdxImage;
    }

    public DirectedBigraph getRedexId() {
        return this.rdxId;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Match:\ncontext = ").append(this.context).append("\nredexImage = ").append(this.rdxImage).append("\nredexId = ").append(this.rdxId).append("\nparam = ").append(this.param);
        return builder.toString();
    }
}

