/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.ldb;

import it.uniud.mads.jlibbig.core.attachedProperties.Replicable;
import it.uniud.mads.jlibbig.core.ldb.Child;
import it.uniud.mads.jlibbig.core.ldb.DirectedBigraph;
import it.uniud.mads.jlibbig.core.ldb.DirectedMatch;
import it.uniud.mads.jlibbig.core.ldb.Edge;
import it.uniud.mads.jlibbig.core.ldb.EditableEdge;
import it.uniud.mads.jlibbig.core.ldb.EditableHandle;
import it.uniud.mads.jlibbig.core.ldb.EditableInnerName;
import it.uniud.mads.jlibbig.core.ldb.EditableLinkFacet;
import it.uniud.mads.jlibbig.core.ldb.EditableNode;
import it.uniud.mads.jlibbig.core.ldb.EditableOuterName;
import it.uniud.mads.jlibbig.core.ldb.EditableParent;
import it.uniud.mads.jlibbig.core.ldb.EditablePoint;
import it.uniud.mads.jlibbig.core.ldb.EditableRoot;
import it.uniud.mads.jlibbig.core.ldb.EditableSite;
import it.uniud.mads.jlibbig.core.ldb.Handle;
import it.uniud.mads.jlibbig.core.ldb.InPort;
import it.uniud.mads.jlibbig.core.ldb.InnerName;
import it.uniud.mads.jlibbig.core.ldb.LinkEntity;
import it.uniud.mads.jlibbig.core.ldb.Node;
import it.uniud.mads.jlibbig.core.ldb.OutPort;
import it.uniud.mads.jlibbig.core.ldb.Parent;
import it.uniud.mads.jlibbig.core.ldb.PlaceEntity;
import it.uniud.mads.jlibbig.core.ldb.Point;
import it.uniud.mads.jlibbig.core.ldb.Root;
import it.uniud.mads.jlibbig.core.ldb.Site;
import it.uniud.mads.jlibbig.core.util.BidMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.expression.discrete.arithmetic.ArExpression;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;

public class DirectedMatcher
implements it.uniud.mads.jlibbig.core.DirectedMatcher<DirectedBigraph, DirectedBigraph> {
    private static final boolean DEBUG;
    private static final boolean DEBUG_PRINT_CSP_SOLUTIONS;
    private static final boolean DEBUG_PRINT_SOLUTION_FETCH;
    private static final boolean DEBUG_CONSISTENCY_CHECK;
    public static final DirectedMatcher DEFAULT;

    @Override
    public Iterable<? extends DirectedMatch> match(DirectedBigraph agent, DirectedBigraph redex) {
        return new MatchIterable(agent, redex);
    }

    protected boolean areMatchable(DirectedBigraph agent, Node fromAgent, DirectedBigraph redex, Node fromRedex) {
        return fromAgent.getControl().equals(fromRedex.getControl());
    }

    static {
        DEBUG_PRINT_CSP_SOLUTIONS = DEBUG = Boolean.getBoolean("it.uniud.mads.jlibbig.debug") || Boolean.getBoolean("it.uniud.mads.jlibbig.debug.matchers");
        DEBUG_PRINT_SOLUTION_FETCH = DEBUG;
        DEBUG_CONSISTENCY_CHECK = Boolean.getBoolean("it.uniud.mads.jlibbig.consistency") || Boolean.getBoolean("it.uniud.mads.jlibbig.consistency.matchers");
        DEFAULT = new DirectedMatcher();
    }

    private class MatchIterable
    implements Iterable<DirectedMatch> {
        final DirectedBigraph agent;
        final DirectedBigraph redex;
        final List<? extends Root> agent_roots;
        final List<? extends Site> agent_sites;
        final Collection<? extends Node> agent_nodes;
        final Collection<InPort> agent_inports;
        final Collection<OutPort> agent_outports;
        final Collection<Point> agent_points;
        final Collection<? extends Edge> agent_edges;
        final List<Handle> agent_handles;
        final List<? extends Root> redex_roots;
        final List<? extends Site> redex_sites;
        final Collection<? extends Node> redex_nodes;
        final Collection<Point> redex_points;
        final Collection<? extends Edge> redex_edges;
        final List<Handle> redex_handles;
        final int ars;
        final int ans;
        final int ass;
        final int ahs;
        final int aps;
        final int aiprs;
        final int aoprs;
        final int rrs;
        final int rns;
        final int rss;
        final int rhs;
        final int rps;
        final int rprs;
        final int rins;

        private MatchIterable(DirectedBigraph agent, DirectedBigraph redex) {
            if (!agent.signature.equals(redex.signature)) {
                throw new UnsupportedOperationException("Agent and redex should have the same singature.");
            }
            this.agent = agent;
            this.redex = redex;
            this.agent_roots = agent.getRoots();
            this.agent_nodes = agent.getNodes();
            this.agent_sites = agent.getSites();
            this.agent_edges = agent.getEdges();
            this.agent_handles = new LinkedList<Edge>(this.agent_edges);
            for (Node node : this.agent_nodes) {
                this.agent_handles.addAll(node.getInPorts());
            }
            this.agent_handles.addAll(agent.getInnerInterface().getDesc().values());
            this.agent_handles.addAll(agent.getOuterInterface().getAsc().values());
            this.ars = this.agent_roots.size();
            this.ans = this.agent_nodes.size();
            this.ass = this.agent_sites.size();
            this.ahs = this.agent_handles.size();
            this.agent_inports = new HashSet<InPort>(2 * this.ans);
            this.agent_outports = new HashSet<OutPort>(2 * this.ans);
            for (Node node : this.agent_nodes) {
                this.agent_outports.addAll(node.getOutPorts());
                this.agent_inports.addAll(node.getInPorts());
            }
            this.aiprs = this.agent_inports.size();
            this.aoprs = this.agent_outports.size();
            int innerup_size = agent.getInnerInterface().getAsc().size();
            int n = agent.getOuterInterface().getDesc().size();
            this.agent_points = new HashSet<Point>(this.ans + innerup_size + n);
            for (Node node : this.agent_nodes) {
                this.agent_points.addAll(node.getOutPorts());
            }
            this.agent_points.addAll(agent.getInnerInterface().getAsc().values());
            this.agent_points.addAll(agent.getOuterInterface().getDesc().values());
            this.aps = this.agent_points.size();
            this.redex_roots = redex.getRoots();
            this.redex_sites = redex.getSites();
            this.redex_nodes = redex.getNodes();
            this.redex_edges = redex.getEdges();
            this.redex_handles = new LinkedList<Edge>(this.redex_edges);
            for (Node node : this.redex_nodes) {
                this.redex_handles.addAll(node.getInPorts());
            }
            this.redex_handles.addAll(redex.getInnerInterface().getDesc().values());
            this.redex_handles.addAll(redex.getOuterInterface().getAsc().values());
            this.rrs = this.redex_roots.size();
            this.rns = this.redex_nodes.size();
            this.rss = this.redex_sites.size();
            this.rhs = this.redex_handles.size();
            innerup_size = redex.getInnerInterface().getAsc().size();
            int n2 = redex.getOuterInterface().getDesc().size();
            this.redex_points = new HashSet<Point>(this.rns + innerup_size + n2);
            for (Node node : this.redex_nodes) {
                this.redex_points.addAll(node.getOutPorts());
            }
            int rprts = 0;
            for (Node node : this.redex_nodes) {
                rprts += node.getOutPorts().size() + node.getInPorts().size();
            }
            this.rprs = rprts;
            this.redex_points.addAll(redex.getInnerInterface().getAsc().values());
            this.redex_points.addAll(redex.getOuterInterface().getDesc().values());
            this.rps = this.redex_points.size();
            this.rins = redex.getInnerInterface().getAsc().size() + redex.getInnerInterface().getDesc().size();
        }

        @Override
        public Iterator<DirectedMatch> iterator() {
            return new MatchIterator();
        }

        private class MatchIterator
        implements Iterator<DirectedMatch> {
            private boolean mayHaveNext = true;
            private boolean firstRun = true;
            private DirectedMatch nextMatch = null;
            private final Model model;
            private final Solver solver;
            final Map<PlaceEntity, Map<PlaceEntity, IntVar>> p_vars;
            final Map<LinkEntity, Map<LinkEntity, IntVar>> e_vars;
            final Map<Handle, Map<Handle, IntVar>> f_vars;

            MatchIterator() {
                this.p_vars = new IdentityHashMap<PlaceEntity, Map<PlaceEntity, IntVar>>(MatchIterable.this.ars + MatchIterable.this.ans + MatchIterable.this.ass);
                this.e_vars = new IdentityHashMap<LinkEntity, Map<LinkEntity, IntVar>>(MatchIterable.this.ahs * MatchIterable.this.rhs + MatchIterable.this.aps * (1 + MatchIterable.this.rps));
                this.f_vars = new IdentityHashMap<Handle, Map<Handle, IntVar>>(MatchIterable.this.rhs);
                this.model = new Model();
                this.solver = this.instantiateModel();
                if (DEBUG) {
                    System.out.println("- MODEL CREATED ---------------------");
                    System.out.println("- AGENT -----------------------------");
                    System.out.println(MatchIterable.this.agent);
                    System.out.println("- REDEX -----------------------------");
                    System.out.println(MatchIterable.this.redex);
                    System.out.println("-------------------------------------");
                }
            }

            private Variable findVariable(String name, Variable[] vars) {
                for (Variable v : vars) {
                    if (!name.equals(v.getName())) continue;
                    return v;
                }
                return null;
            }

            /*
             * WARNING - void declaration
             */
            private Solver instantiateModel() {
                int ki = 0;
                for (Root root : MatchIterable.this.agent_roots) {
                    int n = 0;
                    HashMap<PlaceEntity, BoolVar> hashMap = new HashMap<PlaceEntity, BoolVar>(MatchIterable.this.rrs + MatchIterable.this.rns + MatchIterable.this.rss);
                    for (Root root2 : MatchIterable.this.redex_roots) {
                        BoolVar boolVar = this.model.boolVar(ki + "_" + n++);
                        hashMap.put(root2, boolVar);
                    }
                    for (Node node : MatchIterable.this.redex_nodes) {
                        BoolVar boolVar = this.model.boolVar(ki + "_" + n++);
                        this.model.arithm((IntVar)boolVar, "=", 0).post();
                        hashMap.put(node, boolVar);
                    }
                    for (Site site : MatchIterable.this.redex_sites) {
                        BoolVar boolVar = this.model.boolVar(ki + "_" + n++);
                        this.model.arithm((IntVar)boolVar, "=", 0).post();
                        hashMap.put(site, boolVar);
                    }
                    this.p_vars.put(root, hashMap);
                    ++ki;
                }
                for (Node node : MatchIterable.this.agent_nodes) {
                    int n = 0;
                    HashMap<PlaceEntity, BoolVar> hashMap = new HashMap<PlaceEntity, BoolVar>(MatchIterable.this.rrs + MatchIterable.this.rns + MatchIterable.this.rss);
                    for (Root root : MatchIterable.this.redex_roots) {
                        BoolVar boolVar = this.model.boolVar(ki + "_" + n++);
                        hashMap.put(root, boolVar);
                    }
                    for (Node node2 : MatchIterable.this.redex_nodes) {
                        BoolVar boolVar = this.model.boolVar(ki + "_" + n++);
                        hashMap.put(node2, boolVar);
                    }
                    for (Site site : MatchIterable.this.redex_sites) {
                        BoolVar boolVar = this.model.boolVar(ki + "_" + n++);
                        hashMap.put(site, boolVar);
                    }
                    this.p_vars.put(node, hashMap);
                    ++ki;
                }
                for (Site site : MatchIterable.this.agent_sites) {
                    int n = 0;
                    HashMap<Site, BoolVar> hashMap = new HashMap<Site, BoolVar>(MatchIterable.this.rss);
                    for (Site site2 : MatchIterable.this.redex_sites) {
                        BoolVar boolVar = this.model.boolVar(ki + "_" + n++);
                        hashMap.put(site2, boolVar);
                    }
                    this.p_vars.put(site, hashMap);
                    ++ki;
                }
                ki = 0;
                for (Handle handle : MatchIterable.this.redex_handles) {
                    int n = 0;
                    IdentityHashMap<Handle, BoolVar> identityHashMap = new IdentityHashMap<Handle, BoolVar>(MatchIterable.this.ahs);
                    for (Handle handle2 : MatchIterable.this.agent_handles) {
                        BoolVar boolVar = this.model.boolVar("F_" + ki + "_" + n++);
                        identityHashMap.put(handle2, boolVar);
                    }
                    this.f_vars.put(handle, identityHashMap);
                    ++ki;
                }
                ki = 0;
                for (Point point : MatchIterable.this.agent_points) {
                    int n = 0;
                    IdentityHashMap<LinkEntity, BoolVar> identityHashMap = new IdentityHashMap<LinkEntity, BoolVar>(MatchIterable.this.rps + 1);
                    Handle handle = point.getHandle();
                    BoolVar boolVar = this.model.boolVar("PH_" + ki);
                    identityHashMap.put(handle, boolVar);
                    for (Point point2 : MatchIterable.this.redex_points) {
                        BoolVar boolVar2 = this.model.boolVar("PP_" + ki + "_" + n++);
                        identityHashMap.put(point2, boolVar2);
                    }
                    this.e_vars.put(point, identityHashMap);
                    ++ki;
                }
                ki = 0;
                for (Handle handle : MatchIterable.this.redex_handles) {
                    int n = 0;
                    IdentityHashMap<Handle, IntVar> identityHashMap = new IdentityHashMap<Handle, IntVar>(MatchIterable.this.ahs);
                    for (Handle handle3 : MatchIterable.this.agent_handles) {
                        IntVar intVar = this.model.intVar("HH_" + ki + "_" + n++, 0, handle3.getPoints().size());
                        identityHashMap.put(handle3, intVar);
                    }
                    this.e_vars.put(handle, identityHashMap);
                    ++ki;
                }
                for (Node node : MatchIterable.this.agent_nodes) {
                    Parent parent = node.getParent();
                    Map<PlaceEntity, IntVar> map = this.p_vars.get(node);
                    Map<PlaceEntity, IntVar> map2 = this.p_vars.get(parent);
                    for (Child child : MatchIterable.this.redex_nodes) {
                        Parent parent2 = child.getParent();
                        this.model.arithm(map.get(child), "<=", map2.get(parent2)).post();
                    }
                    for (Child child : MatchIterable.this.redex_sites) {
                        Parent parent3 = child.getParent();
                        this.model.arithm(map.get(child), "<=", map2.get(parent3)).post();
                    }
                }
                for (Site site : MatchIterable.this.agent_sites) {
                    Parent parent = site.getParent();
                    Map<PlaceEntity, IntVar> map = this.p_vars.get(site);
                    Map<PlaceEntity, IntVar> map3 = this.p_vars.get(parent);
                    for (Child child : MatchIterable.this.redex_sites) {
                        Parent parent4 = child.getParent();
                        this.model.arithm(map.get(child), "<=", map3.get(parent4)).post();
                    }
                }
                ArrayDeque<Node> qa = new ArrayDeque<Node>();
                ArrayDeque<Node> arrayDeque = new ArrayDeque<Node>();
                for (Root root : MatchIterable.this.agent_roots) {
                    for (Child child : root.getChildren()) {
                        if (!child.isNode()) continue;
                        qa.add((Node)child);
                    }
                }
                while (!qa.isEmpty()) {
                    Node node = (Node)qa.poll();
                    if (node.getControl().isActive()) {
                        for (Child child : node.getChildren()) {
                            if (!child.isNode()) continue;
                            qa.add((Node)child);
                        }
                        continue;
                    }
                    arrayDeque.add(node);
                }
                qa.clear();
                while (!arrayDeque.isEmpty()) {
                    Child child = (Child)arrayDeque.poll();
                    Map<PlaceEntity, IntVar> map = this.p_vars.get(child);
                    for (Root root : MatchIterable.this.redex_roots) {
                        this.model.arithm(map.get(root), "=", 0).post();
                    }
                    if (!child.isNode()) continue;
                    for (Child child2 : ((Node)child).getChildren()) {
                        if (!child2.isNode()) continue;
                        arrayDeque.add((Node)child2);
                    }
                }
                Object vars = new IntVar[MatchIterable.this.ars + MatchIterable.this.ans];
                for (Root root : MatchIterable.this.redex_roots) {
                    int n = 0;
                    for (PlaceEntity placeEntity : this.p_vars.keySet()) {
                        if (placeEntity.isSite()) continue;
                        vars[n++] = this.p_vars.get(placeEntity).get(root);
                    }
                    this.model.sum((IntVar[])vars, "=", 1).post();
                }
                vars = new IntVar[MatchIterable.this.ans + MatchIterable.this.ass];
                for (Node node : MatchIterable.this.redex_nodes) {
                    int n = 0;
                    for (PlaceEntity placeEntity : this.p_vars.keySet()) {
                        if (placeEntity.isRoot()) continue;
                        vars[n++] = this.p_vars.get(placeEntity).get(node);
                    }
                    this.model.sum((IntVar[])vars, "=", 1).post();
                }
                for (Node node : MatchIterable.this.agent_nodes) {
                    void var6_220;
                    void var7_284;
                    Map<PlaceEntity, IntVar> map = this.p_vars.get(node);
                    IntVar[] intVarArray = new IntVar[MatchIterable.this.rns + MatchIterable.this.rss];
                    boolean bl = false;
                    for (PlaceEntity placeEntity : MatchIterable.this.redex_nodes) {
                        intVarArray[++var5_167] = map.get(placeEntity);
                    }
                    for (PlaceEntity placeEntity : MatchIterable.this.redex_sites) {
                        intVarArray[bl2++] = map.get(placeEntity);
                    }
                    IntVar intVar = this.model.intVar(MatchIterable.this.rrs);
                    IntVar intVar2 = this.model.intVar(0);
                    for (IntVar intVar3 : intVarArray) {
                        IntVar intVar4 = var7_284.add((ArExpression)intVar3).intVar();
                    }
                    IntVar intVar5 = var7_284.mul((ArExpression)intVar).intVar();
                    IntVar[] intVarArray2 = new IntVar[MatchIterable.this.rrs];
                    boolean bl2 = false;
                    for (Root root : MatchIterable.this.redex_roots) {
                        intVarArray2[++var5_169] = map.get(root);
                    }
                    IntVar intVar6 = this.model.intVar(0);
                    for (IntVar intVar7 : intVarArray2) {
                        IntVar intVar8 = var6_220.add((ArExpression)intVar7).intVar();
                    }
                    IntVar intVar9 = var6_220.add((ArExpression)intVar5).intVar();
                    this.model.arithm(intVar9, "<=", MatchIterable.this.rrs).post();
                }
                for (Parent parent : MatchIterable.this.agent_nodes) {
                    Collection<? extends Child> collection = parent.getChildren();
                    for (Parent parent5 : MatchIterable.this.redex_nodes) {
                        Collection<? extends Child> collection2 = parent5.getChildren();
                        IntVar[] intVarArray = new IntVar[collection.size() * collection2.size()];
                        boolean bl = false;
                        for (PlaceEntity placeEntity : collection) {
                            for (Object j : collection2) {
                                intVarArray[++var8_341] = this.p_vars.get(placeEntity).get(j);
                            }
                        }
                        IntVar intVar = this.p_vars.get(parent).get(parent5);
                        this.model.sum(intVarArray, ">=", intVar.mul(collection.size()).intVar()).post();
                    }
                }
                HashMap cgs = new HashMap(MatchIterable.this.rrs);
                for (Root root : MatchIterable.this.redex_roots) {
                    HashSet<? extends Child> hashSet = new HashSet<Child>(root.getChildren());
                    hashSet.removeAll(MatchIterable.this.redex_sites);
                    cgs.put(root, hashSet);
                }
                for (PlaceEntity placeEntity : this.p_vars.keySet()) {
                    if (placeEntity.isSite()) continue;
                    Collection<? extends Child> collection = ((Parent)placeEntity).getChildren();
                    for (Root root : MatchIterable.this.redex_roots) {
                        Collection collection3 = (Collection)cgs.get(root);
                        IntVar[] intVarArray = new IntVar[collection.size() * collection3.size()];
                        int n = 0;
                        for (Child child : collection) {
                            for (Child child3 : collection3) {
                                intVarArray[n++] = this.p_vars.get(child).get(child3);
                            }
                        }
                        IntVar intVar = this.p_vars.get(placeEntity).get(root);
                        this.model.sum(intVarArray, ">=", intVar.mul(collection3.size()).intVar()).post();
                    }
                }
                for (Node node : MatchIterable.this.agent_nodes) {
                    void var6_230;
                    void var9_364;
                    Collection<Parent> collection = MatchIterable.this.agent.getAncestors(node);
                    IntVar[] intVarArray = new IntVar[collection.size() * MatchIterable.this.rss];
                    boolean bl = false;
                    for (Parent parent : collection) {
                        if (!parent.isNode()) continue;
                        Map<PlaceEntity, IntVar> map = this.p_vars.get(parent);
                        for (Site site : MatchIterable.this.redex_sites) {
                            intVarArray[++var5_173] = map.get(site);
                        }
                    }
                    IntVar intVar = this.model.intVar(0);
                    IntVar[] intVarArray3 = intVarArray;
                    int n = intVarArray3.length;
                    boolean bl3 = false;
                    while (var9_364 < n) {
                        IntVar intVar10 = intVarArray3[var9_364];
                        IntVar intVar11 = var6_230.add((ArExpression)intVar10).intVar();
                        ++var9_364;
                    }
                    Map<PlaceEntity, IntVar> map = this.p_vars.get(node);
                    for (Root root : MatchIterable.this.redex_roots) {
                        this.model.arithm(var6_230.add((ArExpression)map.get(root)).intVar(), "<=", 1).post();
                    }
                }
                vars = new IntVar[MatchIterable.this.rrs + MatchIterable.this.rns + MatchIterable.this.rss];
                for (Site site : MatchIterable.this.agent_sites) {
                    vars = (IntVar[])this.p_vars.get(site).values().toArray((T[])vars);
                    this.model.sum((IntVar[])vars, "<=", 1).post();
                }
                vars = new IntVar[MatchIterable.this.rps + 1];
                for (Point point : MatchIterable.this.agent_points) {
                    vars = (IntVar[])this.e_vars.get(point).values().toArray((T[])vars);
                    this.model.sum((IntVar[])vars, "=", 1).post();
                }
                for (Handle handle : MatchIterable.this.agent_handles) {
                    if (handle.getPoints().size() <= 0) continue;
                    Collection<? extends Point> collection = handle.getPoints();
                    IntVar[] intVarArray = new IntVar[MatchIterable.this.rhs + collection.size()];
                    int n = 0;
                    for (Point point : collection) {
                        intVarArray[n++] = this.e_vars.get(point).get(handle);
                    }
                    for (Handle handle4 : MatchIterable.this.redex_handles) {
                        intVarArray[n++] = this.e_vars.get(handle4).get(handle);
                    }
                    this.model.sum(intVarArray, "=", collection.size()).post();
                }
                IntVar[] vars1 = new IntVar[MatchIterable.this.ahs];
                for (Handle handle : MatchIterable.this.redex_handles) {
                    void var7_302;
                    void var10_384;
                    Collection<? extends Point> collection = handle.getPoints();
                    int n = 0;
                    IntVar[] intVarArray = new IntVar[MatchIterable.this.aps * collection.size()];
                    for (Point point : MatchIterable.this.agent_points) {
                        Map<LinkEntity, IntVar> map = this.e_vars.get(point);
                        for (Point point3 : collection) {
                            intVarArray[n++] = map.get(point3);
                        }
                    }
                    vars1 = this.e_vars.get(handle).values().toArray(vars1);
                    IntVar intVar = this.model.intVar(0);
                    IntVar[] intVarArray4 = vars1;
                    int n2 = intVarArray4.length;
                    boolean bl = false;
                    while (var10_384 < n2) {
                        IntVar intVar12 = intVarArray4[var10_384];
                        IntVar intVar13 = var7_302.add((ArExpression)intVar12).intVar();
                        ++var10_384;
                    }
                    this.model.sum(intVarArray, "=", (IntVar)var7_302).post();
                }
                IntVar[] vars_tmp = new IntVar[MatchIterable.this.aps];
                for (Point point : MatchIterable.this.redex_points) {
                    IntVar[] intVarArray;
                    if (point.isPort() || point.isInnerName()) {
                        boolean bl = false;
                        for (Point point4 : MatchIterable.this.agent_points) {
                            vars_tmp[++var4_128] = this.e_vars.get(point4).get(point);
                        }
                    }
                    if ((intVarArray = (IntVar[])Arrays.stream(vars_tmp).filter(Objects::nonNull).toArray(IntVar[]::new)).length <= 0) continue;
                    this.model.sum(intVarArray, "<=", 1).post();
                }
                for (Point point : MatchIterable.this.redex_points) {
                    if (!point.isInnerName() || !MatchIterable.this.redex.outers.getDesc().values().contains(point)) continue;
                    for (Point point5 : MatchIterable.this.agent_points) {
                        if (!point5.isPort()) continue;
                        this.model.arithm(this.e_vars.get(point5).get(point), "=", 0).post();
                    }
                }
                for (Handle handle : MatchIterable.this.redex_handles) {
                    Map<Handle, IntVar> map = this.f_vars.get(handle);
                    Map<LinkEntity, IntVar> map4 = this.e_vars.get(handle);
                    if (handle.getPoints().isEmpty()) continue;
                    for (Handle handle5 : MatchIterable.this.agent_handles) {
                        if (handle5.getPoints().isEmpty()) continue;
                        IntVar intVar = map.get(handle5);
                        IntVar intVar14 = map4.get(handle5);
                        this.model.arithm(intVar14, "<=", intVar.mul(handle5.getPoints().size()).intVar()).post();
                        this.model.arithm(intVar, "<=", intVar14).post();
                    }
                }
                for (Handle handle : MatchIterable.this.redex_handles) {
                    Map<Handle, IntVar> map = this.f_vars.get(handle);
                    Collection<? extends Point> collection = handle.getPoints();
                    for (Handle handle6 : MatchIterable.this.agent_handles) {
                        IntVar intVar = map.get(handle6);
                        int n = 0;
                        IntVar[] intVarArray = new IntVar[collection.size() * handle6.getPoints().size()];
                        for (Point point : handle6.getPoints()) {
                            Map<LinkEntity, IntVar> e_row = this.e_vars.get(point);
                            for (Point point6 : collection) {
                                IntVar ve = e_row.get(point6);
                                intVarArray[n++] = ve;
                                this.model.arithm(ve, "<=", intVar).post();
                            }
                            if (!handle.isEdge()) continue;
                            this.model.arithm(intVar.add((ArExpression)this.e_vars.get(point).get(handle6)).intVar(), "<=", 1).post();
                        }
                        if (collection.isEmpty() || handle6.getPoints().isEmpty()) continue;
                        this.model.sum(intVarArray, ">=", intVar).post();
                    }
                }
                vars = new IntVar[MatchIterable.this.ahs];
                for (Handle handle : MatchIterable.this.redex_handles) {
                    Map<Handle, IntVar> map = this.f_vars.get(handle);
                    this.model.sum((IntVar[])map.values().toArray((T[])vars), "<=", 1).post();
                }
                ListIterator<Handle> ir1 = MatchIterable.this.redex_handles.listIterator(0);
                while (ir1.hasNext()) {
                    Handle handle = ir1.next();
                    Map<Handle, IntVar> map = this.f_vars.get(handle);
                    if (handle.isEdge()) {
                        for (Handle handle7 : MatchIterable.this.agent_handles) {
                            if (!handle7.isOuterName() && !handle7.isPort()) continue;
                            this.model.arithm(map.get(handle7), "=", 0).post();
                        }
                    }
                    ListIterator<Handle> listIterator = MatchIterable.this.redex_handles.listIterator(ir1.nextIndex());
                    while (listIterator.hasNext()) {
                        Handle handle8 = listIterator.next();
                        Map<Handle, IntVar> map5 = this.f_vars.get(handle8);
                        if (handle.isEdge() == handle8.isEdge()) continue;
                        for (Handle handle9 : MatchIterable.this.agent_handles) {
                            this.model.arithm(map.get(handle9).add((ArExpression)map5.get(handle9)).intVar(), "<=", 1).post();
                        }
                    }
                }
                if (MatchIterable.this.redex_edges.size() != 0) {
                    vars = new IntVar[MatchIterable.this.redex_edges.size()];
                    for (Handle handle : MatchIterable.this.agent_handles) {
                        int n = 0;
                        for (Handle handle10 : MatchIterable.this.redex_edges) {
                            vars[n++] = this.f_vars.get(handle10).get(handle);
                        }
                        this.model.sum((IntVar[])vars, "<=", 1).post();
                    }
                }
                for (Node node : MatchIterable.this.agent_nodes) {
                    Map<PlaceEntity, IntVar> map = this.p_vars.get(node);
                    for (Node node3 : MatchIterable.this.redex_nodes) {
                        int n;
                        int n3;
                        IntVar intVar = map.get(node3);
                        boolean bl = DirectedMatcher.this.areMatchable(MatchIterable.this.agent, node, MatchIterable.this.redex, node3);
                        if (!bl) {
                            this.model.arithm(intVar, "=", 0).post();
                        }
                        for (n3 = node.getControl().getArityOut() - 1; 0 <= n3; --n3) {
                            Map<LinkEntity, IntVar> map6 = this.e_vars.get(node.getOutPort(n3));
                            for (n = node3.getControl().getArityOut() - 1; 0 <= n; --n) {
                                if (bl && n3 == n) {
                                    this.model.arithm(map6.get(node3.getOutPort(n)), "=", intVar).post();
                                    continue;
                                }
                                this.model.arithm(map6.get(node3.getOutPort(n)), "=", 0).post();
                            }
                        }
                        for (n3 = node3.getControl().getArityIn() - 1; 0 <= n3; --n3) {
                            Map<Handle, IntVar> map7 = this.f_vars.get(node3.getInPort(n3));
                            for (n = node.getControl().getArityIn() - 1; 0 <= n; --n) {
                                if (bl && n3 == n) {
                                    this.model.arithm(map7.get(node.getInPort(n)), "=", intVar).post();
                                    continue;
                                }
                                this.model.arithm(map7.get(node.getInPort(n)), "=", 0).post();
                            }
                        }
                    }
                }
                for (Node node : MatchIterable.this.agent_nodes) {
                    void var6_253;
                    void var9_373;
                    Collection<Parent> collection = MatchIterable.this.agent.getAncestors(node);
                    IntVar[] intVarArray = new IntVar[(1 + collection.size()) * MatchIterable.this.rss];
                    boolean bl = false;
                    for (Parent parent : collection) {
                        Map<PlaceEntity, IntVar> map = this.p_vars.get(parent);
                        for (Site site : MatchIterable.this.redex_sites) {
                            intVarArray[++var5_184] = map.get(site);
                        }
                    }
                    Map<PlaceEntity, IntVar> map = this.p_vars.get(node);
                    for (Site site : MatchIterable.this.redex_sites) {
                        intVarArray[++var5_185] = map.get(site);
                    }
                    IntVar intVar = this.model.intVar(0);
                    IntVar[] intVarArray5 = intVarArray;
                    int n = intVarArray5.length;
                    boolean bl4 = false;
                    while (var9_373 < n) {
                        IntVar intVar15 = intVarArray5[var9_373];
                        IntVar intVar16 = var6_253.add((ArExpression)intVar15).intVar();
                        ++var9_373;
                    }
                    for (OutPort outPort : node.getOutPorts()) {
                        Map<LinkEntity, IntVar> map8 = this.e_vars.get(outPort);
                        IntVar[] intVarArray6 = new IntVar[MatchIterable.this.redex.inners.getAsc().size()];
                        int n4 = 0;
                        for (Point point : MatchIterable.this.redex.inners.getAsc().values()) {
                            IntVar intVar17 = map8.get(point);
                            intVarArray6[n4++] = intVar17;
                        }
                        this.model.sum(intVarArray6, "<=", (IntVar)var6_253).post();
                    }
                }
                return this.model.getSolver();
            }

            @Override
            public boolean hasNext() {
                if (this.mayHaveNext && this.nextMatch == null) {
                    this.fetchSolution();
                }
                return this.mayHaveNext && this.nextMatch != null;
            }

            @Override
            public DirectedMatch next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                DirectedMatch res = this.nextMatch;
                this.nextMatch = null;
                return res;
            }

            @Override
            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException("");
            }

            private void noMoreSolutions() {
                this.mayHaveNext = false;
                this.solver.hardReset();
            }

            /*
             * WARNING - void declaration
             */
            private void fetchSolution() {
                EditableLinkFacet i2;
                boolean first = this.firstRun;
                this.firstRun = false;
                if (DEBUG_PRINT_SOLUTION_FETCH) {
                    System.out.println("fetch solution has been invoked...");
                }
                if (first && !this.solver.solve() || !first && !this.solver.solve()) {
                    if (DEBUG_PRINT_SOLUTION_FETCH) {
                        System.out.println("...but no more solutions where found.");
                    }
                    this.noMoreSolutions();
                    return;
                }
                if (DEBUG_PRINT_CSP_SOLUTIONS) {
                    IntVar v;
                    void var4_16;
                    Iterator<LinkEntity> row;
                    Object v2;
                    int j;
                    void var4_13;
                    void var4_11;
                    void var4_8;
                    System.out.println("Solution: #" + this.solver.getSolutionCount());
                    System.out.print('\n');
                    int[] p_cell_width = new int[1 + MatchIterable.this.rrs + MatchIterable.this.rns + MatchIterable.this.rss];
                    p_cell_width[0] = 6;
                    for (Node node : MatchIterable.this.agent_nodes) {
                        p_cell_width[0] = Math.max(p_cell_width[0], node.toString().length());
                    }
                    System.out.printf("%-" + p_cell_width[0] + "s|", "P_VARS");
                    int c = 1;
                    boolean bl = false;
                    while (var4_8 < MatchIterable.this.rrs) {
                        String string = "R_" + (int)var4_8;
                        p_cell_width[c] = string.length();
                        System.out.printf("%-" + p_cell_width[c] + "s|", string);
                        ++var4_8;
                        ++c;
                    }
                    for (Node node : MatchIterable.this.redex_nodes) {
                        String s3 = node.toString();
                        p_cell_width[c] = s3.length();
                        System.out.printf("%-" + p_cell_width[c++] + "s|", s3);
                    }
                    boolean bl2 = false;
                    while (var4_11 < MatchIterable.this.rss) {
                        String string = "S_" + (int)var4_11;
                        p_cell_width[c] = string.length();
                        System.out.printf("%-" + p_cell_width[c] + "s|", string);
                        ++var4_11;
                        ++c;
                    }
                    boolean bl3 = false;
                    while (var4_13 < MatchIterable.this.ars) {
                        System.out.printf("\nR_%-" + (p_cell_width[0] - 2) + "d|", (int)var4_13);
                        c = 1;
                        Root root = MatchIterable.this.agent_roots.get((int)var4_13);
                        Map<PlaceEntity, IntVar> row2 = this.p_vars.get(root);
                        for (j = 0; j < MatchIterable.this.rrs; ++j) {
                            Root root2 = MatchIterable.this.redex_roots.get(j);
                            IntVar v22 = this.findVariable(row2.get(root2).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v22.getValue());
                        }
                        for (Node node : MatchIterable.this.redex_nodes) {
                            v2 = this.findVariable(row2.get(node).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v2.getValue());
                        }
                        for (j = 0; j < MatchIterable.this.rss; ++j) {
                            Site site = MatchIterable.this.redex_sites.get(j);
                            v2 = this.findVariable(row2.get(site).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v2.getValue());
                        }
                        ++var4_13;
                    }
                    for (Node node : MatchIterable.this.agent_nodes) {
                        System.out.printf("\n%-" + p_cell_width[0] + "s|", node);
                        c = 1;
                        row = this.p_vars.get(node);
                        for (j = 0; j < MatchIterable.this.rrs; ++j) {
                            Root root = MatchIterable.this.redex_roots.get(j);
                            v2 = this.findVariable(row.get(root).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v2.getValue());
                        }
                        for (Node node2 : MatchIterable.this.redex_nodes) {
                            v2 = this.findVariable(row.get(node2).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v2.getValue());
                        }
                        for (j = 0; j < MatchIterable.this.rss; ++j) {
                            Site site = MatchIterable.this.redex_sites.get(j);
                            v2 = this.findVariable(((IntVar)row.get(site)).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v2.getValue());
                        }
                    }
                    boolean bl4 = false;
                    while (var4_16 < MatchIterable.this.ass) {
                        System.out.printf("\nS_%-" + (p_cell_width[0] - 2) + "d|", (int)var4_16);
                        c = 1;
                        Root root = MatchIterable.this.agent_roots.get((int)var4_16);
                        row = this.p_vars.get(root);
                        for (j = 0; j < MatchIterable.this.rrs; ++j) {
                            System.out.printf("%" + p_cell_width[c++] + "d|", Character.valueOf(' '));
                        }
                        for (j = 0; j < MatchIterable.this.rns; ++j) {
                            System.out.printf("%" + p_cell_width[c++] + "d|", Character.valueOf(' '));
                        }
                        for (j = 0; j < MatchIterable.this.rss; ++j) {
                            Site site = MatchIterable.this.redex_sites.get(j);
                            v2 = this.findVariable(((IntVar)row.get(site)).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v2.getValue());
                        }
                        ++var4_16;
                    }
                    System.out.println('\n');
                    int[] nArray = new int[1 + MatchIterable.this.ahs];
                    int[] nArray2 = new int[1 + MatchIterable.this.rps + MatchIterable.this.ahs];
                    nArray[0] = 6;
                    for (Handle n : MatchIterable.this.redex_handles) {
                        nArray[0] = Math.max(nArray[0], n.toString().length());
                    }
                    nArray2[0] = nArray[0];
                    for (Point n : MatchIterable.this.agent_points) {
                        nArray2[0] = Math.max(nArray2[0], n.toString().length());
                    }
                    System.out.printf("%-" + nArray2[0] + "s|", "E_VARS");
                    c = 1;
                    for (Point p : MatchIterable.this.redex_points) {
                        String string = p.toString();
                        nArray2[c] = string.length();
                        System.out.printf("%-" + nArray2[c++] + "s|", string);
                    }
                    for (Handle h : MatchIterable.this.agent_handles) {
                        String string = h.toString();
                        nArray2[c] = string.length();
                        System.out.printf("%-" + nArray2[c++] + "s|", string);
                    }
                    for (Point pi : MatchIterable.this.agent_points) {
                        System.out.printf("\n%-" + nArray2[0] + "s|", pi);
                        c = 1;
                        Map<LinkEntity, IntVar> map = this.e_vars.get(pi);
                        for (Point pj : MatchIterable.this.redex_points) {
                            v = this.findVariable(map.get(pj).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + nArray2[c++] + "d|", v.getValue());
                        }
                        for (Handle hj : MatchIterable.this.agent_handles) {
                            if (map.containsKey(hj)) {
                                v = this.findVariable(map.get(hj).getName(), this.model.getVars()).asIntVar();
                                System.out.printf("%" + nArray2[c++] + "d|", v.getValue());
                                continue;
                            }
                            System.out.printf("%" + nArray2[c++] + "c|", Character.valueOf(' '));
                        }
                    }
                    for (Handle hi : MatchIterable.this.redex_handles) {
                        System.out.printf("\n%-" + nArray2[0] + "s|", hi);
                        c = 1;
                        Map<LinkEntity, IntVar> map = this.e_vars.get(hi);
                        for (int j2 = MatchIterable.this.rps; 0 < j2; --j2) {
                            System.out.printf("%" + nArray2[c++] + "c|", Character.valueOf(' '));
                        }
                        for (Handle hj : MatchIterable.this.agent_handles) {
                            v = this.findVariable(map.get(hj).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + nArray2[c++] + "d|", v.getValue());
                        }
                    }
                    System.out.println('\n');
                    System.out.printf("%" + nArray[0] + "s|", "F_VARS");
                    c = 1;
                    for (Handle h : MatchIterable.this.agent_handles) {
                        String string = h.toString();
                        nArray[c] = string.length();
                        System.out.printf("%-" + nArray[c++] + "s|", string);
                    }
                    for (Handle hi : MatchIterable.this.redex_handles) {
                        System.out.printf("\n%-" + nArray[0] + "s|", hi);
                        c = 1;
                        Map<Handle, IntVar> map = this.f_vars.get(hi);
                        for (Handle hj : MatchIterable.this.agent_handles) {
                            v = this.findVariable(map.get(hj).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + nArray[c++] + "d|", v.getValue());
                        }
                    }
                    System.out.println('\n');
                }
                DirectedBigraph ctx = new DirectedBigraph(MatchIterable.this.agent.signature);
                DirectedBigraph rdx = new DirectedBigraph(MatchIterable.this.agent.signature);
                DirectedBigraph directedBigraph = new DirectedBigraph(MatchIterable.this.agent.signature);
                DirectedBigraph directedBigraph2 = new DirectedBigraph(MatchIterable.this.agent.signature);
                BidMap<Node, Node> nEmb = new BidMap<Node, Node>(MatchIterable.this.rns);
                EditableSite[] ctx_sites_dic = new EditableSite[MatchIterable.this.rrs];
                EditableSite[] editableSiteArray = new EditableSite[MatchIterable.this.rss];
                EditableRoot[] rdx_roots_dic = new EditableRoot[MatchIterable.this.rrs];
                EditableRoot[] prm_roots_dic = new EditableRoot[MatchIterable.this.rss];
                EditableSite[] prm_sites_dic = new EditableSite[MatchIterable.this.ass];
                IdentityHashMap<Object, EditableHandle> ctx_hnd_dic = new IdentityHashMap<Object, EditableHandle>();
                IdentityHashMap<EditableHandle, Replicable> rdx_hnd_dic = new IdentityHashMap<EditableHandle, Replicable>();
                IdentityHashMap<Object, Object> prm_hnd_dic = new IdentityHashMap<Object, Object>();
                IdentityHashMap<EditableInnerName, EditableLinkFacet> ctx_pnt_dic = new IdentityHashMap<EditableInnerName, EditableLinkFacet>();
                IdentityHashMap<EditableInnerName, EditableLinkFacet> rdx_pnt_dic = new IdentityHashMap<EditableInnerName, EditableLinkFacet>();
                IdentityHashMap<EditableInnerName, EditableOuterName> prm_dic = new IdentityHashMap<EditableInnerName, EditableOuterName>();
                IdentityHashMap<EditableNode, EditableNode> node_dic = new IdentityHashMap<EditableNode, EditableNode>();
                IdentityHashMap<EditableHandle, void> handle_img = new IdentityHashMap<EditableHandle, void>(MatchIterable.this.rhs);
                class VState {
                    final PlaceEntity c;
                    final PlaceEntity i;
                    final EditableParent p;
                    final DirectedBigraph b;

                    VState(DirectedBigraph b, EditableParent p, PlaceEntity c) {
                        this(b, p, c, null);
                    }

                    VState(DirectedBigraph b, EditableParent p, PlaceEntity c, PlaceEntity i) {
                        this.i = i;
                        this.c = c;
                        this.p = p;
                        this.b = b;
                    }
                }
                ArrayDeque<VState> q = new ArrayDeque<VState>();
                for (EditableOuterName editableOuterName : MatchIterable.this.agent.outers.getAsc().values()) {
                    EditableOuterName editableOuterName2 = editableOuterName.replicate();
                    ctx.outers.addAsc(0, editableOuterName2);
                    editableOuterName2.setOwner(ctx);
                    ctx_hnd_dic.put(editableOuterName, editableOuterName2);
                }
                for (EditableInnerName editableInnerName : MatchIterable.this.agent.outers.getDesc().values()) {
                    String string = editableInnerName.getName();
                    i2 = new EditableInnerName(string);
                    ctx.outers.addDesc(0, (EditableInnerName)i2);
                    ctx_pnt_dic.put(editableInnerName, i2);
                }
                for (EditableOuterName editableOuterName : MatchIterable.this.redex.outers.getAsc().values()) {
                    void var27_218;
                    EditableHandle editableHandle;
                    void var26_178;
                    String string = editableOuterName.getName();
                    EditableOuterName o22 = new EditableOuterName(string);
                    rdx.outers.addAsc(0, o22);
                    o22.setOwner(rdx);
                    rdx_hnd_dic.put(editableOuterName, o22);
                    EditableInnerName editableInnerName = new EditableInnerName(string);
                    ctx.inners.addAsc(0, editableInnerName);
                    EditableHandle editableHandle2 = (EditableHandle)handle_img.get(editableOuterName);
                    if (editableHandle2 == null) {
                        void var26_181;
                        Map<Handle, IntVar> map = this.f_vars.get(editableOuterName);
                        for (Handle handle : MatchIterable.this.agent_handles) {
                            IntVar intVar = this.findVariable(map.get(handle).getName(), this.model.getVars()).asIntVar();
                            if (intVar.getValue() != 1) continue;
                            EditableHandle editableHandle3 = handle.getEditable();
                            break;
                        }
                        if (var26_181 == null) {
                            EditableEdge editableEdge = new EditableEdge();
                        }
                        handle_img.put(editableOuterName, var26_178);
                    }
                    if ((editableHandle = (EditableHandle)ctx_hnd_dic.get(var26_178)) == null) {
                        EditableHandle editableHandle4 = var26_178.replicate();
                        editableHandle4.setOwner(ctx);
                        ctx_hnd_dic.put(var26_178, editableHandle4);
                    }
                    editableInnerName.setHandle((EditableHandle)var27_218);
                }
                for (EditableInnerName editableInnerName : MatchIterable.this.redex.outers.getDesc().values()) {
                    void var26_186;
                    String string = editableInnerName.getName();
                    i2 = new EditableInnerName(string);
                    EditableHandle editableHandle = editableInnerName.getHandle();
                    EditableHandle editableHandle5 = (EditableHandle)rdx_hnd_dic.get(editableHandle);
                    if (editableHandle5 == null) {
                        void var27_228;
                        EditableHandle editableHandle6 = (EditableHandle)handle_img.get(editableHandle);
                        if (editableHandle6 == null) {
                            void var27_226;
                            Map<Handle, IntVar> map = this.f_vars.get(editableHandle);
                            for (Handle handle : MatchIterable.this.agent_handles) {
                                IntVar intVar = this.findVariable(map.get(handle).getName(), this.model.getVars()).asIntVar();
                                if (intVar.getValue() != 1) continue;
                                EditableHandle editableHandle7 = handle.getEditable();
                                break;
                            }
                            if (var27_226 == null) {
                                EditableEdge editableEdge = new EditableEdge();
                            }
                            handle_img.put(editableHandle, var27_228);
                        }
                        EditableHandle editableHandle8 = var27_228.replicate();
                        editableHandle8.setOwner(rdx);
                        rdx_hnd_dic.put(editableHandle, editableHandle8);
                    }
                    ((EditableInnerName)i2).setHandle((EditableHandle)var26_186);
                    rdx.outers.addDesc(0, (EditableInnerName)i2);
                    rdx_pnt_dic.put(editableInnerName, i2);
                    EditableOuterName editableOuterName = new EditableOuterName(string);
                    editableOuterName.setOwner(ctx);
                    ctx.inners.addDesc(0, editableOuterName);
                    for (EditableInnerName editableInnerName2 : MatchIterable.this.agent.outers.getDesc().values()) {
                        EditablePoint editablePoint = (EditablePoint)ctx_pnt_dic.get(editableInnerName2);
                        if (editablePoint == null) continue;
                        editablePoint.setHandle(editableOuterName);
                    }
                }
                for (EditableInnerName editableInnerName : MatchIterable.this.redex.inners.getAsc().values()) {
                    void var26_190;
                    String string = editableInnerName.getName();
                    i2 = new EditableInnerName(string);
                    EditableHandle editableHandle = editableInnerName.getHandle();
                    EditableHandle editableHandle9 = (EditableHandle)rdx_hnd_dic.get(editableHandle);
                    if (editableHandle9 == null) {
                        void var27_236;
                        EditableHandle editableHandle10 = (EditableHandle)handle_img.get(editableHandle);
                        if (editableHandle10 == null) {
                            void var27_234;
                            Map<Handle, IntVar> map = this.f_vars.get(editableHandle);
                            for (Handle handle : MatchIterable.this.agent_handles) {
                                IntVar intVar = this.findVariable(map.get(handle).getName(), this.model.getVars()).asIntVar();
                                if (intVar.getValue() != 1) continue;
                                EditableHandle editableHandle11 = handle.getEditable();
                                break;
                            }
                            if (var27_234 == null) {
                                EditableEdge editableEdge = new EditableEdge();
                            }
                            handle_img.put(editableHandle, var27_236);
                        }
                        EditableHandle editableHandle12 = var27_236.replicate();
                        editableHandle12.setOwner(rdx);
                        rdx_hnd_dic.put(editableHandle, editableHandle12);
                    }
                    ((EditableInnerName)i2).setHandle((EditableHandle)var26_190);
                    rdx.inners.addAsc(0, (EditableInnerName)i2);
                    rdx_pnt_dic.put(editableInnerName, i2);
                    EditableOuterName editableOuterName = new EditableOuterName(string);
                    editableOuterName.setOwner(directedBigraph);
                    directedBigraph.outers.addAsc(0, editableOuterName);
                    prm_dic.put(editableInnerName, editableOuterName);
                }
                for (EditableOuterName editableOuterName : MatchIterable.this.redex.inners.getDesc().values()) {
                    void var27_244;
                    EditableHandle editableHandle;
                    void var26_196;
                    String string = editableOuterName.getName();
                    i2 = new EditableOuterName(string);
                    rdx.inners.addDesc(0, (EditableOuterName)i2);
                    ((EditableOuterName)i2).setOwner(rdx);
                    rdx_hnd_dic.put(editableOuterName, i2);
                    EditableInnerName editableInnerName = new EditableInnerName(string);
                    directedBigraph.outers.addDesc(0, editableInnerName);
                    EditableHandle editableHandle13 = (EditableHandle)handle_img.get(editableOuterName);
                    if (editableHandle13 == null) {
                        void var26_194;
                        Map<Handle, IntVar> map = this.f_vars.get(editableOuterName);
                        for (Handle handle : MatchIterable.this.agent_handles) {
                            IntVar intVar = this.findVariable(map.get(handle).getName(), this.model.getVars()).asIntVar();
                            if (intVar.getValue() != 1) continue;
                            EditableHandle editableHandle14 = handle.getEditable();
                            break;
                        }
                        if (var26_194 == null) {
                            EditableEdge editableEdge = new EditableEdge();
                        }
                        handle_img.put(editableOuterName, var26_196);
                    }
                    if ((editableHandle = (EditableHandle)prm_hnd_dic.get(var26_196)) == null) {
                        EditableHandle editableHandle15 = var26_196.replicate();
                        editableHandle15.setOwner(directedBigraph);
                        prm_hnd_dic.put(var26_196, editableHandle15);
                    }
                    editableInnerName.setHandle((EditableHandle)var27_244);
                }
                for (EditableInnerName editableInnerName : MatchIterable.this.agent.inners.getAsc().values()) {
                    void var25_157;
                    block129: {
                        Map<LinkEntity, IntVar> map;
                        block128: {
                            void var25_154;
                            String string = editableInnerName.getName();
                            i2 = new EditableInnerName(string);
                            Object var25_150 = null;
                            map = this.e_vars.get(editableInnerName);
                            EditableHandle editableHandle = editableInnerName.getHandle();
                            ctx_pnt_dic.put(editableInnerName, i2);
                            IntVar intVar = this.findVariable(map.get(editableHandle).getName(), this.model.getVars()).asIntVar();
                            if (intVar.getValue() != 1) break block128;
                            EditableHandle editableHandle16 = (EditableHandle)prm_hnd_dic.get(editableHandle);
                            if (editableHandle16 != null) break block129;
                            EditableHandle editableHandle17 = (EditableHandle)ctx_hnd_dic.get(editableHandle);
                            if (editableHandle17 != null) {
                                EditableInnerName editableInnerName3 = new EditableInnerName();
                                editableInnerName3.setHandle(editableHandle17);
                                String string2 = editableInnerName3.getName();
                                ctx.inners.addAsc(0, editableInnerName3);
                                EditableOuterName editableOuterName = new EditableOuterName(string2);
                                editableOuterName.setOwner(directedBigraph2);
                                directedBigraph2.outers.addAsc(0, editableOuterName);
                                EditableInnerName editableInnerName4 = new EditableInnerName(string2);
                                editableInnerName4.setHandle(editableOuterName);
                                directedBigraph2.inners.addAsc(0, editableInnerName4);
                                EditableOuterName editableOuterName3 = new EditableOuterName(string2);
                                editableOuterName3.setOwner(directedBigraph);
                                directedBigraph.outers.addAsc(0, editableOuterName3);
                                EditableOuterName editableOuterName4 = editableOuterName3;
                            } else {
                                EditableEdge editableEdge = new EditableEdge(directedBigraph);
                            }
                            prm_hnd_dic.put(editableHandle, var25_154);
                            break block129;
                        }
                        for (InnerName innerName : MatchIterable.this.redex.inners.getAsc().values()) {
                            IntVar intVar = this.findVariable(map.get(innerName).getName(), this.model.getVars()).asIntVar();
                            if (intVar.getValue() != 1) continue;
                            String string = innerName.getName();
                            EditableHandle editableHandle = directedBigraph.outers.getAsc(0).get(string);
                            if (editableHandle != null) break;
                            EditableOuterName editableOuterName = new EditableOuterName(string);
                            editableOuterName.setOwner(directedBigraph);
                            directedBigraph.outers.addAsc(0, editableOuterName);
                            EditableOuterName editableOuterName5 = editableOuterName;
                            break;
                        }
                    }
                    ((EditableInnerName)i2).setHandle((EditableHandle)var25_157);
                    directedBigraph.inners.addAsc(0, (EditableInnerName)i2);
                }
                for (EditableOuterName editableOuterName : MatchIterable.this.agent.inners.getDesc().values()) {
                    String string = editableOuterName.getName();
                    EditableOuterName o2 = new EditableOuterName(string);
                    Object var25_159 = null;
                    for (Point point : editableOuterName.getEditablePoints()) {
                        void var30_350;
                        Map<LinkEntity, IntVar> map = this.e_vars.get(point);
                        IntVar intVar = this.findVariable(map.get(editableOuterName).getName(), this.model.getVars()).asIntVar();
                        Object var30_349 = null;
                        if (intVar.getValue() == 0) {
                            block44: for (EditableOuterName editableOuterName6 : MatchIterable.this.redex.inners.getDesc().values()) {
                                for (Point point2 : editableOuterName6.getEditablePoints()) {
                                    IntVar intVar2 = this.findVariable(map.get(point2).getName(), this.model.getVars()).asIntVar();
                                    if (intVar2.getValue() != 1) continue;
                                    String name3 = editableOuterName6.getName();
                                    EditableInnerName editableInnerName = directedBigraph.outers.getDesc(0).get(name3);
                                    if (editableInnerName != null) continue block44;
                                    EditableInnerName editableInnerName5 = new EditableInnerName(name3);
                                    directedBigraph.outers.addDesc(0, editableInnerName5);
                                    EditableInnerName editableInnerName6 = editableInnerName5;
                                    continue block44;
                                }
                            }
                        }
                        o2.setOwner(directedBigraph);
                        if (var30_350 != null) {
                            var30_350.setHandle(o2);
                        }
                        directedBigraph.inners.addDesc(0, o2);
                        prm_hnd_dic.put(editableOuterName, o2);
                    }
                }
                for (EditableRoot editableRoot : MatchIterable.this.agent.roots) {
                    q.add(new VState(ctx, null, editableRoot));
                }
                LinkedList<? extends Root> unseen_rdx_roots = new LinkedList<Root>(MatchIterable.this.redex_roots);
                while (!q.isEmpty()) {
                    VState vState;
                    block130: {
                        void var25_170;
                        vState = (VState)q.poll();
                        if (vState.b == rdx) {
                            if (vState.i.isNode()) {
                                void var26_205;
                                void var26_203;
                                EditableNode editableNode = (EditableNode)vState.i;
                                EditableNode n1 = (EditableNode)vState.c;
                                EditableNode editableNode2 = n1.replicate();
                                nEmb.put(editableNode, n1);
                                editableNode2.setParent(vState.p);
                                node_dic.put(editableNode, editableNode2);
                                int n = editableNode.getControl().getArityOut() - 1;
                                while (-1 < var26_203) {
                                    void var29_322;
                                    EditableNode.EditableOutPort editableOutPort = editableNode.getOutPortsForEdit().get((int)var26_203);
                                    EditableHandle editableHandle = editableOutPort.getHandle();
                                    EditableHandle editableHandle18 = (EditableHandle)rdx_hnd_dic.get(editableHandle);
                                    if (editableHandle18 == null) {
                                        EditableHandle editableHandle19 = n1.getOutPortsForEdit().get((int)var26_203).getHandle().replicate();
                                        editableHandle19.setOwner(rdx);
                                        rdx_hnd_dic.put(editableHandle, editableHandle19);
                                    }
                                    editableNode2.getOutPortsForEdit().get((int)var26_203).setHandle((EditableHandle)var29_322);
                                    --var26_203;
                                }
                                int n2 = n1.getControl().getArityIn() - 1;
                                while (false <= var26_205) {
                                    EditableNode.EditableInPort editableInPort = n1.getInPort((int)var26_205);
                                    EditableHandle editableHandle = (EditableHandle)rdx_hnd_dic.get(editableInPort);
                                    ArrayList<EditablePoint> arrayList = new ArrayList<EditablePoint>(editableInPort.getEditablePoints());
                                    for (EditablePoint editablePoint : arrayList) {
                                        void var35_462;
                                        Map<LinkEntity, IntVar> map = this.e_vars.get(editablePoint);
                                        IntVar intVar = this.findVariable(map.get(editableInPort).getName(), this.model.getVars()).asIntVar();
                                        if (intVar.getValue() != 1) continue;
                                        Collection<EditableInnerName> collection = MatchIterable.this.agent.inners.getAsc().values();
                                        collection.removeAll(MatchIterable.this.redex.inners.getAsc().values());
                                        Collection<EditableInnerName> collection2 = MatchIterable.this.redex.inners.getAsc().values();
                                        Object var35_461 = null;
                                        for (InnerName innerName : collection2) {
                                            EditableHandle editableHandle20 = (EditableHandle)prm_dic.get(innerName);
                                        }
                                        if (ctx_pnt_dic.get(editablePoint) == null) continue;
                                        EditablePoint pnt2 = (EditablePoint)ctx_pnt_dic.get(editablePoint);
                                        if (var35_462 == null) continue;
                                        pnt2.setHandle((EditableHandle)var35_462);
                                    }
                                    if (editableHandle == null) {
                                        EditableNode.EditableInPort editableInPort2 = editableNode2.getInPort((int)var26_205);
                                        rdx_hnd_dic.put(editableInPort, editableInPort2);
                                        for (InnerName innerName : MatchIterable.this.redex.inners.getAsc().values()) {
                                            EditablePoint editablePoint = (EditablePoint)rdx_pnt_dic.get(innerName);
                                            if (editablePoint == null || !editableNode.getInPort((int)var26_205).getPoints().contains(innerName)) continue;
                                            editablePoint.setHandle(editableInPort2);
                                        }
                                        for (InnerName innerName : MatchIterable.this.redex.outers.getDesc().values()) {
                                            EditablePoint editablePoint = (EditablePoint)rdx_pnt_dic.get(innerName);
                                            if (editablePoint == null || !editableNode.getInPort((int)var26_205).getPoints().contains(innerName)) continue;
                                            editablePoint.setHandle(editableInPort2);
                                        }
                                    }
                                    --var26_205;
                                }
                                HashSet<? extends Child> hashSet = new HashSet<Child>(n1.getChildren());
                                for (Child child : editableNode.getChildren()) {
                                    Iterator iterator = hashSet.iterator();
                                    boolean bl = true;
                                    while (iterator.hasNext()) {
                                        Child child2 = (Child)iterator.next();
                                        IntVar intVar = this.findVariable(this.p_vars.get(child2).get(child).getName(), this.model.getVars()).asIntVar();
                                        if (intVar.getValue() != 1) continue;
                                        bl = false;
                                        q.add(new VState(rdx, editableNode2, child2, child));
                                        iterator.remove();
                                    }
                                    if (!bl || !child.isSite()) continue;
                                    q.add(new VState(rdx, editableNode2, null, child));
                                }
                                continue;
                            }
                            EditableSite editableSite = (EditableSite)vState.i;
                            int k = MatchIterable.this.redex_sites.indexOf(editableSite);
                            if (editableSiteArray[k] == null) {
                                EditableSite editableSite2 = new EditableSite();
                                editableSite2.setParent(vState.p);
                                editableSiteArray[k] = editableSite2;
                            }
                            if (prm_roots_dic[k] == null) {
                                prm_roots_dic[k] = new EditableRoot(directedBigraph);
                            }
                            EditableRoot editableRoot = prm_roots_dic[k];
                            if (vState.c == null) continue;
                            q.add(new VState(directedBigraph, editableRoot, vState.c));
                            continue;
                        }
                        if (vState.b == ctx) {
                            EditableParent editableParent = (EditableParent)vState.c;
                            EditableParent p2 = editableParent.replicate();
                            if (editableParent.isRoot()) {
                                EditableRoot editableRoot = (EditableRoot)p2;
                                ctx.roots.add(editableRoot);
                                editableRoot.setOwner(ctx);
                            } else {
                                void var27_260;
                                EditableInnerName i4;
                                void var27_258;
                                void var27_256;
                                EditableNode editableNode = (EditableNode)editableParent;
                                EditableNode editableNode3 = (EditableNode)p2;
                                editableNode3.setParent(vState.p);
                                node_dic.put(editableNode, editableNode3);
                                int n = editableNode.getControl().getArityOut() - 1;
                                while (-1 < var27_256) {
                                    void var30_359;
                                    EditableNode.EditableOutPort editableOutPort = editableNode.getOutPortsForEdit().get((int)var27_256);
                                    EditableHandle editableHandle = editableOutPort.getHandle();
                                    EditableHandle editableHandle21 = (EditableHandle)ctx_hnd_dic.get(editableHandle);
                                    if (editableHandle21 == null) {
                                        EditableHandle editableHandle22 = editableHandle.replicate();
                                        editableHandle22.setOwner(ctx);
                                        ctx_hnd_dic.put(editableHandle, editableHandle22);
                                    }
                                    editableNode3.getOutPortsForEdit().get((int)var27_256).setHandle((EditableHandle)var30_359);
                                    --var27_256;
                                }
                                int n3 = editableNode.getControl().getArityIn() - 1;
                                while (false <= var27_258) {
                                    EditableNode.EditableInPort editableInPort = editableNode.getInPort((int)var27_258);
                                    EditableHandle editableHandle = (EditableHandle)ctx_hnd_dic.get(editableInPort);
                                    ArrayList<? extends Point> arrayList = new ArrayList<Point>(editableInPort.getPoints());
                                    for (Point point : arrayList) {
                                        Map<LinkEntity, IntVar> map = this.e_vars.get(point);
                                        IntVar intVar = this.findVariable(map.get(editableInPort).getName(), this.model.getVars()).asIntVar();
                                        if (intVar.getValue() != 1 || !MatchIterable.this.agent.inners.getAsc().values().contains(point)) continue;
                                        String string = ((InnerName)point).getName();
                                        EditableInnerName i3 = new EditableInnerName(string);
                                        i3.setHandle(editableNode3.getInPort((int)var27_258));
                                        ctx.inners.addAsc(0, i3);
                                        EditableOuterName editableOuterName = new EditableOuterName(string);
                                        directedBigraph2.outers.addAsc(0, editableOuterName);
                                        editableOuterName.setOwner(directedBigraph2);
                                        i4 = new EditableInnerName(string);
                                        i4.setHandle(editableOuterName);
                                        directedBigraph2.inners.addAsc(0, i4);
                                        EditableOuterName o4 = new EditableOuterName(string);
                                        directedBigraph.outers.addAsc(0, o4);
                                        o4.setOwner(directedBigraph);
                                        if (ctx_pnt_dic.get(point) == null) continue;
                                        EditablePoint pnt2 = (EditablePoint)ctx_pnt_dic.get(point);
                                        pnt2.setHandle(o4);
                                    }
                                    if (editableHandle == null) {
                                        EditableNode.EditableInPort editableInPort3 = editableNode3.getInPort((int)var27_258);
                                        ctx_hnd_dic.put(editableInPort, editableInPort3);
                                        for (InnerName innerName : MatchIterable.this.agent.outers.getDesc().values()) {
                                            EditablePoint editablePoint = (EditablePoint)ctx_pnt_dic.get(innerName);
                                            if (editablePoint == null || !editableInPort.getEditablePoints().contains(innerName)) continue;
                                            editablePoint.setHandle(editableInPort3);
                                        }
                                    }
                                    --var27_258;
                                }
                                int n4 = editableNode.getControl().getArityOut() - 1;
                                while (-1 < var27_260) {
                                    void var30_368;
                                    EditableNode.EditableOutPort editableOutPort;
                                    block127: {
                                        EditableHandle editableHandle;
                                        EditableNode.EditableOutPort editableOutPort2 = editableNode.getOutPortsForEdit().get((int)var27_260);
                                        editableOutPort = editableNode3.getOutPortsForEdit().get((int)var27_260);
                                        Object var30_361 = null;
                                        Map<LinkEntity, IntVar> map = this.e_vars.get(editableOutPort2);
                                        IntVar intVar = this.findVariable(map.get(editableHandle = editableOutPort2.getHandle()).getName(), this.model.getVars()).asIntVar();
                                        if (intVar.getValue() == 1) {
                                            if (MatchIterable.this.agent.inners.getDesc().values().contains(editableHandle)) {
                                                EditableOuterName editableOuterName = new EditableOuterName();
                                                String string = editableOuterName.getName();
                                                editableOuterName.setOwner(vState.b);
                                                vState.b.inners.addDesc(0, editableOuterName);
                                                EditableInnerName i3 = new EditableInnerName(string);
                                                i3.setHandle(editableOuterName);
                                                directedBigraph2.outers.addDesc(0, i3);
                                                EditableOuterName editableOuterName7 = new EditableOuterName(string);
                                                editableOuterName7.setOwner(directedBigraph2);
                                                directedBigraph2.inners.addDesc(0, editableOuterName7);
                                                i3.setHandle(editableOuterName7);
                                                i4 = new EditableInnerName(string);
                                                directedBigraph.outers.addDesc(0, i4);
                                                if (prm_hnd_dic.get(editableHandle) != null) {
                                                    EditableHandle h3 = (EditableHandle)prm_hnd_dic.get(editableHandle);
                                                    h3.linkPoint(i4);
                                                }
                                                EditableOuterName editableOuterName8 = editableOuterName;
                                                ctx_hnd_dic.put(editableHandle, editableOuterName8);
                                            } else if (editableHandle.isPort()) {
                                                EditableHandle editableHandle23 = (EditableHandle)rdx_hnd_dic.get(editableHandle);
                                                if (editableHandle23 != null) {
                                                    for (EditableInnerName i24 : rdx.outers.getDesc().values()) {
                                                        if (!editableHandle23.getPoints().contains(i24)) continue;
                                                        for (EditableOuterName o2 : vState.b.inners.getDesc().values()) {
                                                            if (!o2.getName().equals(i24.getName())) continue;
                                                            EditableOuterName editableOuterName = o2;
                                                            break block127;
                                                        }
                                                        break;
                                                    }
                                                }
                                            } else {
                                                EditableHandle editableHandle24 = (EditableHandle)ctx_hnd_dic.get(editableHandle);
                                            }
                                        } else {
                                            for (InnerName innerName : MatchIterable.this.redex.outers.getDesc().values()) {
                                                IntVar var_tmp = this.findVariable(map.get(innerName).getName(), this.model.getVars()).asIntVar();
                                                if (var_tmp.getValue() != 1) continue;
                                                String string = innerName.getName();
                                                EditableHandle editableHandle25 = ctx.inners.getDesc(0).get(string);
                                                if (editableHandle25 != null) break;
                                                EditableOuterName o26 = new EditableOuterName(string);
                                                o26.setOwner(vState.b);
                                                vState.b.inners.addDesc(0, o26);
                                                EditableOuterName editableOuterName = o26;
                                                break;
                                            }
                                        }
                                    }
                                    editableOutPort.setHandle((EditableHandle)var30_368);
                                    --var27_260;
                                }
                            }
                            HashSet<? extends Child> hashSet = new HashSet<Child>(editableParent.getChildren());
                            Map<PlaceEntity, IntVar> map = this.p_vars.get(editableParent);
                            Iterator iterator = unseen_rdx_roots.iterator();
                            while (iterator.hasNext()) {
                                Root root = (Root)iterator.next();
                                IntVar intVar = this.findVariable(map.get(root).getName(), this.model.getVars()).asIntVar();
                                if (intVar.getValue() != 1) continue;
                                iterator.remove();
                                int n = MatchIterable.this.redex_roots.indexOf(root);
                                EditableSite editableSite = new EditableSite();
                                editableSite.setParent(p2);
                                ctx_sites_dic[n] = editableSite;
                                EditableRoot editableRoot = new EditableRoot();
                                editableRoot.setOwner(rdx);
                                rdx_roots_dic[n] = editableRoot;
                                for (Child child : root.getChildren()) {
                                    Iterator iterator2 = hashSet.iterator();
                                    boolean notMatched = true;
                                    while (iterator2.hasNext()) {
                                        Child child3 = (Child)iterator2.next();
                                        IntVar var8 = this.findVariable(this.p_vars.get(child3).get(child).getName(), this.model.getVars()).asIntVar();
                                        if (var8.getValue() != 1) continue;
                                        notMatched = false;
                                        q.add(new VState(rdx, editableRoot, child3, child));
                                        iterator2.remove();
                                    }
                                    if (!notMatched || !child.isSite()) continue;
                                    q.add(new VState(rdx, editableRoot, null, child));
                                }
                            }
                            for (Child child : hashSet) {
                                q.add(new VState(ctx, p2, child));
                            }
                            continue;
                        }
                        if (!vState.c.isNode()) break block130;
                        EditableNode editableNode = (EditableNode)vState.c;
                        EditableNode n2 = editableNode.replicate();
                        n2.setParent(vState.p);
                        int n = editableNode.getControl().getArityOut() - 1;
                        while (-1 < var25_170) {
                            void var28_302;
                            EditableNode.EditableOutPort editableOutPort;
                            block132: {
                                Map<LinkEntity, IntVar> map;
                                block131: {
                                    void var28_299;
                                    EditableHandle editableHandle;
                                    EditableNode.EditableOutPort editableOutPort3 = editableNode.getOutPortsForEdit().get((int)var25_170);
                                    editableOutPort = n2.getOutPortsForEdit().get((int)var25_170);
                                    Object var28_295 = null;
                                    map = this.e_vars.get(editableOutPort3);
                                    IntVar intVar = this.findVariable(map.get(editableHandle = editableOutPort3.getHandle()).getName(), this.model.getVars()).asIntVar();
                                    if (intVar.getValue() != 1) break block131;
                                    EditableHandle editableHandle26 = (EditableHandle)prm_hnd_dic.get(editableHandle);
                                    if (editableHandle26 != null) break block132;
                                    EditableHandle editableHandle27 = (EditableHandle)ctx_hnd_dic.get(editableHandle);
                                    if (editableHandle27 != null) {
                                        EditableInnerName editableInnerName = new EditableInnerName();
                                        editableInnerName.setHandle(editableHandle27);
                                        String string = editableInnerName.getName();
                                        ctx.inners.addAsc(0, editableInnerName);
                                        EditableOuterName editableOuterName = new EditableOuterName(string);
                                        editableOuterName.setOwner(directedBigraph2);
                                        directedBigraph2.outers.addAsc(0, editableOuterName);
                                        EditableInnerName i4 = new EditableInnerName(string);
                                        i4.setHandle(editableOuterName);
                                        directedBigraph2.inners.addAsc(0, i4);
                                        EditableOuterName editableOuterName9 = new EditableOuterName(string);
                                        editableOuterName9.setOwner(vState.b);
                                        vState.b.outers.addAsc(0, editableOuterName9);
                                        EditableOuterName editableOuterName10 = editableOuterName9;
                                    } else {
                                        EditableEdge editableEdge = new EditableEdge(directedBigraph);
                                    }
                                    prm_hnd_dic.put(editableHandle, var28_299);
                                    break block132;
                                }
                                for (InnerName innerName : MatchIterable.this.redex.inners.getAsc().values()) {
                                    IntVar intVar = this.findVariable(map.get(innerName).getName(), this.model.getVars()).asIntVar();
                                    if (intVar.getValue() != 1) continue;
                                    String string = innerName.getName();
                                    EditableHandle editableHandle = directedBigraph.outers.getAsc(0).get(string);
                                    if (editableHandle != null) break;
                                    EditableOuterName o28 = new EditableOuterName(string);
                                    o28.setOwner(vState.b);
                                    vState.b.outers.addAsc(0, o28);
                                    EditableOuterName editableOuterName = o28;
                                    break;
                                }
                            }
                            editableOutPort.setHandle((EditableHandle)var28_302);
                            --var25_170;
                        }
                        for (Child child : editableNode.getChildren()) {
                            q.add(new VState(vState.b, n2, child));
                        }
                        continue;
                    }
                    EditableSite editableSite = (EditableSite)vState.c;
                    EditableSite s2 = editableSite.replicate();
                    s2.setParent(vState.p);
                    prm_sites_dic[MatchIterable.this.agent_sites.indexOf((Object)editableSite)] = s2;
                }
                ctx.sites.addAll(Arrays.asList(ctx_sites_dic));
                rdx.sites.addAll(Arrays.asList(editableSiteArray));
                rdx.roots.addAll(Arrays.asList(rdx_roots_dic));
                directedBigraph.roots.addAll(Arrays.asList(prm_roots_dic));
                directedBigraph.sites.addAll(Arrays.asList(prm_sites_dic));
                for (Node node : MatchIterable.this.redex.getNodes()) {
                    for (Node node3 : MatchIterable.this.redex.getNodes()) {
                        for (OutPort outPort : node.getOutPorts()) {
                            int n = node.getOutPorts().indexOf(outPort);
                            EditableNode.EditableOutPort editableOutPort = outPort.getEditable();
                            EditableHandle editableHandle = editableOutPort.getHandle();
                            if (!editableHandle.isPort()) continue;
                            InPort inPort = (InPort)((Object)editableHandle);
                            ArrayList<? extends InPort> arrayList = new ArrayList<InPort>(node3.getInPorts());
                            int n5 = arrayList.indexOf(inPort);
                            if (n5 == -1) continue;
                            EditableNode editableNode = (EditableNode)node_dic.get(node);
                            EditableNode editableNode4 = (EditableNode)node_dic.get(node3);
                            editableNode.getOutPort(n).setHandle(editableNode4.getInPort(n5));
                        }
                    }
                }
                for (Node node : MatchIterable.this.agent.getNodes()) {
                    for (Node node4 : MatchIterable.this.agent.getNodes()) {
                        for (OutPort outPort : node.getOutPorts()) {
                            int n = node.getOutPorts().indexOf(outPort);
                            EditableNode.EditableOutPort editableOutPort = outPort.getEditable();
                            EditableHandle editableHandle = editableOutPort.getHandle();
                            if (!editableHandle.isPort()) continue;
                            InPort inPort = (InPort)((Object)editableHandle);
                            ArrayList<? extends InPort> arrayList = new ArrayList<InPort>(node4.getInPorts());
                            int n6 = arrayList.indexOf(inPort);
                            if (n6 == -1) continue;
                            EditableNode editableNode = (EditableNode)node_dic.get(node);
                            EditableNode editableNode5 = (EditableNode)node_dic.get(node4);
                            if (editableNode == null || editableNode5 == null || !editableNode.getOwner().equals(ctx) || !editableNode5.getOwner().equals(ctx)) continue;
                            editableNode.getOutPort(n).setHandle(editableNode5.getInPort(n6));
                        }
                    }
                }
                for (Node node : MatchIterable.this.agent.getNodes()) {
                    for (Node node5 : MatchIterable.this.agent.getNodes()) {
                        for (OutPort outPort : node.getOutPorts()) {
                            int n = node.getOutPorts().indexOf(outPort);
                            EditableNode.EditableOutPort editableOutPort = outPort.getEditable();
                            EditableHandle editableHandle = editableOutPort.getHandle();
                            if (!editableHandle.isPort()) continue;
                            InPort inPort = (InPort)((Object)editableHandle);
                            ArrayList<? extends InPort> arrayList = new ArrayList<InPort>(node5.getInPorts());
                            int n7 = arrayList.indexOf(inPort);
                            if (n7 == -1) continue;
                            EditableNode editableNode = (EditableNode)node_dic.get(node);
                            EditableNode editableNode6 = (EditableNode)node_dic.get(node5);
                            if (editableNode == null || editableNode6 == null || !editableNode.getOwner().equals(directedBigraph) || !editableNode6.getOwner().equals(directedBigraph)) continue;
                            editableNode.getOutPort(n).setHandle(editableNode6.getInPort(n7));
                        }
                    }
                }
                if (DEBUG_CONSISTENCY_CHECK) {
                    if (!ctx.isConsistent()) {
                        throw new RuntimeException("Inconsistent bigraph (ctx)");
                    }
                    if (!rdx.isConsistent()) {
                        throw new RuntimeException("Inconsistent bigraph (rdx)");
                    }
                    if (!directedBigraph2.isConsistent()) {
                        throw new RuntimeException("Inconsistent bigraph (id)");
                    }
                    if (!directedBigraph.isConsistent()) {
                        throw new RuntimeException("Inconsistent bigraph (prm)");
                    }
                }
                this.nextMatch = new DirectedMatch(ctx, rdx, directedBigraph2, directedBigraph, nEmb);
            }
        }
    }
}

