/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.ldb;

import it.uniud.mads.jlibbig.core.exceptions.IncompatibleInterfaceException;
import it.uniud.mads.jlibbig.core.exceptions.IncompatibleSignatureException;
import it.uniud.mads.jlibbig.core.exceptions.InvalidInstantiationRuleException;
import it.uniud.mads.jlibbig.core.ldb.DirectedBigraph;
import it.uniud.mads.jlibbig.core.ldb.DirectedBigraphBuilder;
import it.uniud.mads.jlibbig.core.ldb.DirectedInstantiationMap;
import it.uniud.mads.jlibbig.core.ldb.DirectedMatch;
import it.uniud.mads.jlibbig.core.ldb.DirectedMatcher;
import it.uniud.mads.jlibbig.core.ldb.EditableChild;
import it.uniud.mads.jlibbig.core.ldb.EditableHandle;
import it.uniud.mads.jlibbig.core.ldb.EditableInnerName;
import it.uniud.mads.jlibbig.core.ldb.EditableNode;
import it.uniud.mads.jlibbig.core.ldb.EditableOuterName;
import it.uniud.mads.jlibbig.core.ldb.EditableParent;
import it.uniud.mads.jlibbig.core.ldb.EditablePoint;
import it.uniud.mads.jlibbig.core.ldb.EditableRoot;
import it.uniud.mads.jlibbig.core.ldb.EditableSite;
import it.uniud.mads.jlibbig.core.ldb.InnerName;
import it.uniud.mads.jlibbig.core.ldb.Node;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DirectedRewritingRule
implements it.uniud.mads.jlibbig.core.DirectedRewritingRule<DirectedBigraph, DirectedBigraph> {
    private static final boolean DEBUG;
    private static final boolean DEBUG_PRINT_MATCH;
    private static final boolean DEBUG_PRINT_RESULT;
    private static final boolean DEBUG_CONSISTENCY_CHECK;
    final DirectedBigraph redex;
    final DirectedBigraph reactum;
    final DirectedInstantiationMap eta;
    private DirectedMatcher matcher;

    public DirectedRewritingRule(DirectedBigraph redex, DirectedBigraph reactum, int ... eta) {
        this(DirectedMatcher.DEFAULT, redex, reactum, new DirectedInstantiationMap(redex.sites.size(), eta));
    }

    public DirectedRewritingRule(DirectedMatcher matcher, DirectedBigraph redex, DirectedBigraph reactum, int ... eta) {
        this(matcher, redex, reactum, new DirectedInstantiationMap(redex.sites.size(), eta));
    }

    public DirectedRewritingRule(DirectedBigraph redex, DirectedBigraph reactum, DirectedInstantiationMap eta) {
        this(DirectedMatcher.DEFAULT, redex, reactum, eta);
    }

    public DirectedRewritingRule(DirectedMatcher matcher, DirectedBigraph redex, DirectedBigraph reactum, DirectedInstantiationMap eta) {
        if (reactum.getSignature() != redex.getSignature()) {
            throw new IncompatibleSignatureException("Redex and reactum should have the same singature.", reactum.getSignature(), redex.getSignature());
        }
        if (redex.sites.size() < eta.getPlaceCodomain()) {
            throw new InvalidInstantiationRuleException("The instantiation rule does not match the redex inner interface.");
        }
        if (reactum.sites.size() != eta.getPlaceDomain()) {
            throw new InvalidInstantiationRuleException("The instantiation rule does not match the reactum inner interface.");
        }
        HashSet<String> xs = new HashSet<String>(reactum.outers.keySet());
        HashSet<String> ys = new HashSet<String>(redex.outers.keySet());
        HashSet<String> zs = new HashSet<String>(xs);
        xs.removeAll(ys);
        ys.removeAll(zs);
        if (redex.roots.size() != reactum.roots.size() || !xs.isEmpty() || !ys.isEmpty()) {
            throw new IncompatibleInterfaceException("Redex and reactum should have the same outer interface.");
        }
        xs = new HashSet<String>(reactum.inners.keySet());
        ys = new HashSet<String>(redex.inners.keySet());
        zs = new HashSet<String>(xs);
        xs.removeAll(ys);
        ys.removeAll(zs);
        if (!xs.isEmpty() || !ys.isEmpty()) {
            throw new IncompatibleInterfaceException("Redex and reactum should have the same set inner names.");
        }
        this.redex = redex;
        this.reactum = reactum;
        this.eta = eta;
        this.matcher = matcher == null ? DirectedMatcher.DEFAULT : matcher;
    }

    protected void instantiateReactumNode(Node original, Node instance, DirectedMatch match) {
    }

    protected final DirectedBigraph instantiateReactum(DirectedMatch match) {
        Object h2;
        EditableHandle h1;
        EditableInnerName i2;
        EditableOuterName o2;
        DirectedBigraph big;
        DirectedBigraph reactum = this.getReactum();
        DirectedBigraph owner = big = new DirectedBigraph(reactum.signature);
        HashMap<EditableHandle, Object> hnd_dic = new HashMap<EditableHandle, Object>();
        HashMap<EditableInnerName, EditableInnerName> pnt_dic = new HashMap<EditableInnerName, EditableInnerName>();
        for (EditableOuterName editableOuterName : reactum.outers.getAsc().values()) {
            o2 = editableOuterName.replicate();
            big.outers.addAsc(0, o2);
            o2.setOwner(owner);
            hnd_dic.put(editableOuterName, o2);
        }
        for (EditableInnerName editableInnerName : reactum.inners.getAsc().values()) {
            i2 = editableInnerName.replicate();
            pnt_dic.put(editableInnerName, i2);
            h1 = editableInnerName.getHandle();
            h2 = (EditableHandle)hnd_dic.get(h1);
            if (h2 == null) {
                h2 = h1.replicate();
                h2.setOwner(owner);
                hnd_dic.put(h1, h2);
            }
            i2.setHandle((EditableHandle)h2);
            big.inners.addAsc(0, i2);
        }
        for (EditableOuterName editableOuterName : reactum.inners.getDesc().values()) {
            o2 = editableOuterName.replicate();
            big.inners.addDesc(0, o2);
            o2.setOwner(owner);
            hnd_dic.put(editableOuterName, o2);
        }
        for (EditableInnerName editableInnerName : reactum.outers.getDesc().values()) {
            i2 = editableInnerName.replicate();
            pnt_dic.put(editableInnerName, i2);
            h1 = editableInnerName.getHandle();
            h2 = (EditableHandle)hnd_dic.get(h1);
            if (h2 == null) {
                h2 = h1.replicate();
                h2.setOwner(owner);
                hnd_dic.put(h1, h2);
            }
            i2.setHandle((EditableHandle)h2);
            big.outers.addDesc(0, i2);
        }
        class Pair {
            final EditableChild c;
            final EditableParent p;

            Pair(EditableParent p, EditableChild c) {
                this.c = c;
                this.p = p;
            }
        }
        ArrayDeque<Pair> q = new ArrayDeque<Pair>();
        for (EditableRoot r1 : reactum.roots) {
            EditableRoot r2 = r1.replicate();
            big.roots.add(r2);
            r2.setOwner(owner);
            for (EditableChild c : r1.getEditableChildren()) {
                q.add(new Pair(r2, c));
            }
        }
        EditableSite[] editableSiteArray = new EditableSite[reactum.sites.size()];
        while (!q.isEmpty()) {
            Pair t = (Pair)q.poll();
            if (t.c instanceof EditableNode) {
                int i;
                EditableNode n1 = (EditableNode)t.c;
                EditableNode n2 = n1.replicate();
                this.instantiateReactumNode(n1, n2, match);
                n2.setParent(t.p);
                for (i = n1.getControl().getArityOut() - 1; 0 <= i; --i) {
                    EditableNode.EditableOutPort p1 = n1.getOutPort(i);
                    EditableHandle h12 = p1.getHandle();
                    EditableHandle h22 = (EditableHandle)hnd_dic.get(h12);
                    if (h22 == null) {
                        h22 = h12.replicate();
                        h22.setOwner(owner);
                        hnd_dic.put(h12, h22);
                    }
                    n2.getOutPort(i).setHandle(h22);
                }
                for (i = n1.getControl().getArityIn() - 1; 0 <= i; --i) {
                    EditablePoint pnt;
                    EditableNode.EditableInPort ip1 = n1.getInPort(i);
                    EditableHandle h23 = (EditableHandle)hnd_dic.get(ip1);
                    EditableNode.EditableInPort ip2 = n2.getInPort(i);
                    ip2.setOwner(owner);
                    for (InnerName innerName : reactum.outers.getDesc().values()) {
                        pnt = (EditablePoint)pnt_dic.get(innerName);
                        if (pnt == null || !ip1.getEditablePoints().contains(innerName)) continue;
                        pnt.setHandle(ip2);
                    }
                    for (InnerName innerName : reactum.inners.getAsc().values()) {
                        pnt = (EditablePoint)pnt_dic.get(innerName);
                        if (pnt == null || !ip1.getEditablePoints().contains(innerName)) continue;
                        pnt.setHandle(ip2);
                    }
                    hnd_dic.put(ip1, ip2);
                }
                for (EditableChild c : n1.getEditableChildren()) {
                    q.add(new Pair(n2, c));
                }
                continue;
            }
            EditableSite s1 = (EditableSite)t.c;
            EditableSite s2 = s1.replicate();
            s2.setParent(t.p);
            editableSiteArray[reactum.sites.indexOf((Object)s1)] = s2;
        }
        big.sites.addAll(Arrays.asList(editableSiteArray));
        return big;
    }

    @Override
    public DirectedBigraph getRedex() {
        return this.redex;
    }

    @Override
    public DirectedBigraph getReactum() {
        return this.reactum;
    }

    public DirectedInstantiationMap getInstantiationRule() {
        return this.eta;
    }

    @Override
    public Iterable<DirectedBigraph> apply(DirectedBigraph to) {
        return this.apply(this.getMatcher(), to);
    }

    public Iterable<DirectedBigraph> apply(DirectedMatcher m, DirectedBigraph to) {
        return new RewriteIterable(m, to);
    }

    public DirectedMatcher getMatcher() {
        return this.matcher;
    }

    public void setMatcher(DirectedMatcher m) {
        this.matcher = m;
    }

    static {
        DEBUG_PRINT_MATCH = DEBUG = Boolean.getBoolean("it.uniud.mads.jlibbig.debug") || Boolean.getBoolean("it.uniud.mads.jlibbig.debug.reactions");
        DEBUG_PRINT_RESULT = DEBUG;
        DEBUG_CONSISTENCY_CHECK = Boolean.getBoolean("it.uniud.mads.jlibbig.consistency") || Boolean.getBoolean("it.uniud.mads.jlibbig.consistency.reactions");
    }

    private class RewriteIterable
    implements Iterable<DirectedBigraph> {
        private final DirectedMatcher matcher;
        private final DirectedBigraph target;
        private Iterable<? extends DirectedMatch> mAble;

        RewriteIterable(DirectedMatcher m, DirectedBigraph target) {
            this.target = target;
            this.matcher = m;
        }

        @Override
        public Iterator<DirectedBigraph> iterator() {
            if (this.mAble == null) {
                this.mAble = this.matcher.match(this.target, DirectedRewritingRule.this.redex);
            }
            return new RewriteIterator();
        }

        private class RewriteIterator
        implements Iterator<DirectedBigraph> {
            Iterator<? extends DirectedMatch> mTor = null;
            Iterator<DirectedBigraph> args = null;
            DirectedBigraph big = null;

            private RewriteIterator() {
            }

            @Override
            public boolean hasNext() {
                if (this.mTor == null) {
                    this.mTor = RewriteIterable.this.mAble.iterator();
                }
                return this.mTor.hasNext() || this.args != null && this.args.hasNext();
            }

            @Override
            public DirectedBigraph next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.args == null || !this.args.hasNext()) {
                    DirectedMatch match = this.mTor.next();
                    if (DEBUG_PRINT_MATCH) {
                        System.out.println(match);
                    }
                    DirectedBigraphBuilder bb = new DirectedBigraphBuilder(DirectedRewritingRule.this.instantiateReactum(match), true);
                    bb.leftJuxtapose(match.getRedexId(), true);
                    bb.outerCompose((DirectedBigraph)match.getContext(), true);
                    this.big = bb.makeBigraph(true);
                    this.args = DirectedRewritingRule.this.eta.instantiate((DirectedBigraph)match.getParam()).iterator();
                }
                if (this.args.hasNext()) {
                    DirectedBigraph params = this.args.next();
                    DirectedBigraph result = this.args.hasNext() ? DirectedBigraph.compose(this.big.clone(), params, true) : DirectedBigraph.compose(this.big, params, true);
                    if (DEBUG_PRINT_RESULT) {
                        System.out.println(result);
                    }
                    if (DEBUG_CONSISTENCY_CHECK && !result.isConsistent()) {
                        throw new RuntimeException("Inconsistent bigraph");
                    }
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("");
            }
        }
    }
}

