/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.ldb;

import it.uniud.mads.jlibbig.core.Owner;
import it.uniud.mads.jlibbig.core.attachedProperties.Replicable;
import it.uniud.mads.jlibbig.core.attachedProperties.ReplicationListener;
import it.uniud.mads.jlibbig.core.attachedProperties.ReplicationListenerContainer;
import it.uniud.mads.jlibbig.core.ldb.Edge;
import it.uniud.mads.jlibbig.core.ldb.EditableHandle;
import it.uniud.mads.jlibbig.core.ldb.EditablePoint;
import it.uniud.mads.jlibbig.core.ldb.Point;
import it.uniud.mads.jlibbig.core.util.NameGenerator;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;

class EditableEdge
implements Edge,
EditableHandle,
Replicable {
    private String name;
    private Collection<EditablePoint> points = Collections.newSetFromMap(new IdentityHashMap());
    private final Collection<? extends Point> ro_points = Collections.unmodifiableCollection(this.points);
    private Owner owner;
    private final ReplicationListenerContainer rep = new ReplicationListenerContainer(new ReplicationListener[0]);

    EditableEdge() {
        this.name = "E_" + NameGenerator.DEFAULT.generate();
    }

    EditableEdge(Owner owner) {
        this();
        this.setOwner(owner);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Collection<? extends Point> getPoints() {
        return this.ro_points;
    }

    @Override
    public Collection<EditablePoint> getEditablePoints() {
        return this.points;
    }

    @Override
    public void linkPoint(EditablePoint point) {
        if (point == null) {
            return;
        }
        this.points.add(point);
        if (this != point.getHandle()) {
            point.setHandle(this);
        }
    }

    @Override
    public void unlinkPoint(EditablePoint point) {
        if (point == null) {
            return;
        }
        this.points.remove(point);
        if (this == point.getHandle()) {
            point.setHandle(null);
        }
    }

    @Override
    public EditableEdge replicate() {
        EditableEdge copy = new EditableEdge();
        this.rep.tellReplicated(this, copy);
        return copy;
    }

    @Override
    public void registerListener(ReplicationListener listener) {
        this.rep.registerListener(listener);
    }

    @Override
    public boolean isListenerRegistered(ReplicationListener listener) {
        return this.rep.isListenerRegistered(listener);
    }

    @Override
    public boolean unregisterListener(ReplicationListener listener) {
        return this.rep.unregisterListener(listener);
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    String getName() {
        return this.name;
    }

    @Override
    public void setOwner(Owner value) {
        this.owner = value;
    }

    public int hashCode() {
        int prime = 83;
        return 83 * this.name.hashCode();
    }

    @Override
    public EditableEdge getEditable() {
        return this;
    }

    @Override
    public boolean isHandle() {
        return true;
    }

    @Override
    public boolean isPoint() {
        return false;
    }

    @Override
    public boolean isPort() {
        return false;
    }

    @Override
    public boolean isInnerName() {
        return false;
    }

    @Override
    public boolean isOuterName() {
        return false;
    }

    @Override
    public boolean isEdge() {
        return true;
    }
}

