/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.ldb;

import it.uniud.mads.jlibbig.core.Owner;
import it.uniud.mads.jlibbig.core.Port;
import it.uniud.mads.jlibbig.core.attachedProperties.DelegatedProperty;
import it.uniud.mads.jlibbig.core.attachedProperties.Property;
import it.uniud.mads.jlibbig.core.attachedProperties.PropertyContainer;
import it.uniud.mads.jlibbig.core.attachedProperties.PropertyListener;
import it.uniud.mads.jlibbig.core.attachedProperties.ReplicationListener;
import it.uniud.mads.jlibbig.core.attachedProperties.ReplicationListenerContainer;
import it.uniud.mads.jlibbig.core.ldb.Child;
import it.uniud.mads.jlibbig.core.ldb.DirectedControl;
import it.uniud.mads.jlibbig.core.ldb.EditableChild;
import it.uniud.mads.jlibbig.core.ldb.EditableHandle;
import it.uniud.mads.jlibbig.core.ldb.EditableParent;
import it.uniud.mads.jlibbig.core.ldb.EditablePoint;
import it.uniud.mads.jlibbig.core.ldb.EditableRoot;
import it.uniud.mads.jlibbig.core.ldb.Handle;
import it.uniud.mads.jlibbig.core.ldb.InPort;
import it.uniud.mads.jlibbig.core.ldb.LinkEntity;
import it.uniud.mads.jlibbig.core.ldb.Node;
import it.uniud.mads.jlibbig.core.ldb.OutPort;
import it.uniud.mads.jlibbig.core.ldb.Point;
import it.uniud.mads.jlibbig.core.util.NameGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;

class EditableNode
implements Node,
EditableParent,
EditableChild {
    public static final String PROPERTY_OWNER = "Owner";
    private final List<EditableOutPort> outPorts;
    private final List<EditableInPort> inPorts;
    private final List<? extends OutPort> ro_outPorts;
    private final List<? extends InPort> ro_inPorts;
    private final Collection<? extends Child> ro_chd;
    private final DelegatedProperty.PropertySetter<Owner> ownerSetter;
    private final DelegatedProperty<Owner> ownerProp;
    private final ReplicationListenerContainer rep = new ReplicationListenerContainer(new ReplicationListener[0]);
    private final PropertyContainer props = new PropertyContainer(this);
    private DirectedControl control;
    private EditableParent parent;
    private Collection<EditableChild> children;
    private String name = "N_" + NameGenerator.DEFAULT.generate();

    EditableNode(DirectedControl control) {
        int i;
        this.control = control;
        ArrayList<EditableOutPort> outPorts = new ArrayList<EditableOutPort>();
        ArrayList<EditableInPort> inPorts = new ArrayList<EditableInPort>();
        for (i = 0; i < control.getArityOut(); ++i) {
            outPorts.add(new EditableOutPort(i));
        }
        for (i = 0; i < control.getArityIn(); ++i) {
            inPorts.add(new EditableInPort(i));
        }
        this.outPorts = Collections.unmodifiableList(outPorts);
        this.inPorts = Collections.unmodifiableList(inPorts);
        this.children = new HashSet<EditableChild>();
        this.ro_outPorts = Collections.unmodifiableList(this.outPorts);
        this.ro_inPorts = Collections.unmodifiableList(this.inPorts);
        this.ro_chd = Collections.unmodifiableCollection(this.children);
        this.ownerSetter = new DelegatedProperty.PropertySetter();
        this.ownerProp = new DelegatedProperty<Owner>(PROPERTY_OWNER, true, this.ownerSetter, new PropertyListener[0]);
        this.props.attachProperty(this.ownerProp);
    }

    EditableNode(DirectedControl control, EditableParent parent) {
        this(control);
        this.setParent(parent);
    }

    EditableNode(DirectedControl control, EditableParent parent, List<? extends Handle> handles) {
        this(control, parent);
        for (int i = 0; i < Math.min(handles.size(), control.getArityOut()); ++i) {
            this.outPorts.get(i).setHandle((EditableHandle)handles.get(i));
        }
    }

    EditableNode(DirectedControl control, EditableParent parent, EditableHandle ... handles) {
        this(control, parent);
        for (int i = 0; i < Math.min(handles.length, control.getArityOut()); ++i) {
            this.outPorts.get(i).setHandle(handles[i]);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + ":" + this.control.getName();
    }

    @Override
    public EditableParent getParent() {
        return this.parent;
    }

    @Override
    public Collection<? extends Child> getChildren() {
        return this.ro_chd;
    }

    @Override
    public List<? extends Port<DirectedControl>> getPorts() {
        ArrayList<LinkEntity> ports = new ArrayList<LinkEntity>();
        ports.addAll(this.ro_outPorts);
        ports.addAll(this.ro_inPorts);
        return ports;
    }

    @Override
    public Port<DirectedControl> getPort(int index) {
        return null;
    }

    @Override
    public List<? extends OutPort> getOutPorts() {
        return this.ro_outPorts;
    }

    @Override
    public List<? extends InPort> getInPorts() {
        return this.ro_inPorts;
    }

    public List<EditableOutPort> getOutPortsForEdit() {
        return this.outPorts;
    }

    public List<EditableInPort> getInPortsForEdit() {
        return this.inPorts;
    }

    @Override
    public EditableOutPort getOutPort(int index) {
        return this.getOutPortsForEdit().get(index);
    }

    @Override
    public EditableInPort getInPort(int index) {
        return this.getInPortsForEdit().get(index);
    }

    @Override
    public DirectedControl getControl() {
        return this.control;
    }

    @Override
    public void addChild(EditableChild child) {
        if (child == null) {
            return;
        }
        this.children.add(child);
        if (this != child.getParent()) {
            child.setParent(this);
        }
    }

    @Override
    public void removeChild(EditableChild child) {
        if (child == null) {
            return;
        }
        this.children.remove(child);
        if (this == child.getParent()) {
            child.setParent(null);
        }
    }

    @Override
    public Collection<EditableChild> getEditableChildren() {
        return this.children;
    }

    @Override
    public EditableRoot getRoot() {
        return this.parent.getRoot();
    }

    @Override
    public EditableNode replicate() {
        EditableNode copy = new EditableNode(this.control);
        this.rep.tellReplicated(this, copy);
        return copy;
    }

    @Override
    public boolean isListenerRegistered(ReplicationListener listener) {
        return this.rep.isListenerRegistered(listener);
    }

    @Override
    public void registerListener(ReplicationListener listener) {
        this.rep.registerListener(listener);
    }

    @Override
    public boolean unregisterListener(ReplicationListener listener) {
        return this.rep.unregisterListener(listener);
    }

    @Override
    public Property<?> attachProperty(Property<?> prop) {
        if (prop == null) {
            throw new IllegalArgumentException("Argument can not be null.");
        }
        String name = prop.getName();
        if (PROPERTY_OWNER.equals(name)) {
            throw new IllegalArgumentException("Property '" + name + "' can not be substituted");
        }
        return this.props.attachProperty(prop);
    }

    @Override
    public <V> Property<V> detachProperty(Property<V> prop) {
        if (prop == null) {
            throw new IllegalArgumentException("Argument can not be null.");
        }
        return this.detachProperty(prop.getName());
    }

    @Override
    public <V> Property<V> detachProperty(String name) {
        if (PROPERTY_OWNER.equals(name)) {
            throw new IllegalArgumentException("Property '" + name + "' can not be detached");
        }
        return this.props.detachProperty(name);
    }

    @Override
    public <V> Property<V> getProperty(String name) {
        return this.props.getProperty(name);
    }

    @Override
    public Collection<Property<?>> getProperties() {
        return this.props.getProperties();
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.props.getPropertyNames();
    }

    @Override
    public Owner getOwner() {
        return this.ownerProp.get();
    }

    @Override
    public EditableNode getEditable() {
        return this;
    }

    @Override
    public boolean isParent() {
        return true;
    }

    @Override
    public void setParent(EditableParent parent) {
        if (this.parent != parent) {
            EditableParent old = this.parent;
            this.parent = parent;
            if (old != null) {
                old.removeChild(this);
            }
            if (parent != null) {
                parent.addChild(this);
                this.ownerSetter.set(parent.getProperty(PROPERTY_OWNER));
            }
        }
    }

    @Override
    public boolean isChild() {
        return true;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isSite() {
        return false;
    }

    @Override
    public boolean isNode() {
        return true;
    }

    public int hashCode() {
        int prime = 41;
        int result = 1;
        result = 41 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public class EditableOutPort
    implements OutPort,
    EditablePoint {
        private final int number;
        private EditableHandle handle;

        private EditableOutPort(int number) {
            this.number = number;
        }

        @Override
        public EditableNode getNode() {
            return EditableNode.this;
        }

        public String toString() {
            return this.number + "+@" + EditableNode.this;
        }

        @Override
        public int getNumber() {
            return this.number;
        }

        @Override
        public EditableHandle getHandle() {
            return this.handle;
        }

        @Override
        public Owner getOwner() {
            return this.handle != null ? this.handle.getOwner() : EditableNode.this.getOwner();
        }

        @Override
        public EditableOutPort getEditable() {
            return this;
        }

        @Override
        public boolean isHandle() {
            return false;
        }

        @Override
        public void setHandle(EditableHandle handle) {
            if (this.handle == handle) {
                return;
            }
            EditableHandle old = this.handle;
            this.handle = null;
            if (old != null) {
                old.unlinkPoint(this);
            }
            this.handle = handle;
            if (handle != null) {
                handle.linkPoint(this);
            }
        }

        @Override
        public boolean isPoint() {
            return true;
        }

        @Override
        public boolean isPort() {
            return true;
        }

        @Override
        public boolean isInnerName() {
            return false;
        }

        @Override
        public boolean isOuterName() {
            return false;
        }

        @Override
        public boolean isEdge() {
            return false;
        }
    }

    public class EditableInPort
    implements InPort,
    EditableHandle {
        private final int number;
        private Owner owner;
        private Collection<EditablePoint> points = Collections.newSetFromMap(new IdentityHashMap());
        private final Collection<? extends Point> ro_points = Collections.unmodifiableCollection(this.points);

        private EditableInPort(int number) {
            this.number = number;
        }

        @Override
        public EditableNode getNode() {
            return EditableNode.this;
        }

        public String toString() {
            return this.number + "-@" + EditableNode.this;
        }

        @Override
        public int getNumber() {
            return this.number;
        }

        @Override
        public EditableHandle getHandle() {
            return this;
        }

        @Override
        public EditableInPort getEditable() {
            return this;
        }

        @Override
        public boolean isHandle() {
            return true;
        }

        @Override
        public boolean isPoint() {
            return false;
        }

        @Override
        public boolean isPort() {
            return true;
        }

        @Override
        public boolean isInnerName() {
            return false;
        }

        @Override
        public boolean isOuterName() {
            return false;
        }

        @Override
        public boolean isEdge() {
            return false;
        }

        @Override
        public Owner getOwner() {
            return this.owner;
        }

        @Override
        public void setOwner(Owner value) {
            this.owner = value;
        }

        @Override
        public Collection<? extends Point> getPoints() {
            return this.ro_points;
        }

        @Override
        public Collection<EditablePoint> getEditablePoints() {
            return this.points;
        }

        @Override
        public void linkPoint(EditablePoint point) {
            if (point == null) {
                return;
            }
            this.points.add(point);
            if (this != point.getHandle()) {
                point.setHandle(this);
            }
        }

        @Override
        public void unlinkPoint(EditablePoint point) {
            if (point == null) {
                return;
            }
            if (this.points.remove(point) && this == point.getHandle()) {
                point.setHandle(null);
            }
        }

        @Override
        public EditableHandle replicate() {
            EditableInPort copy = new EditableInPort(this.getNumber());
            EditableNode.this.rep.tellReplicated(this, copy);
            return copy;
        }

        @Override
        public boolean isListenerRegistered(ReplicationListener listener) {
            return EditableNode.this.rep.isListenerRegistered(listener);
        }

        @Override
        public void registerListener(ReplicationListener listener) {
            EditableNode.this.rep.registerListener(listener);
        }

        @Override
        public boolean unregisterListener(ReplicationListener listener) {
            return EditableNode.this.rep.unregisterListener(listener);
        }
    }
}

