/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.ldb;

import it.uniud.mads.jlibbig.core.DirectedBigraphHandler;
import it.uniud.mads.jlibbig.core.Owner;
import it.uniud.mads.jlibbig.core.attachedProperties.Property;
import it.uniud.mads.jlibbig.core.attachedProperties.PropertyContainer;
import it.uniud.mads.jlibbig.core.attachedProperties.PropertyListener;
import it.uniud.mads.jlibbig.core.attachedProperties.ProtectedProperty;
import it.uniud.mads.jlibbig.core.attachedProperties.ReplicationListener;
import it.uniud.mads.jlibbig.core.attachedProperties.ReplicationListenerContainer;
import it.uniud.mads.jlibbig.core.ldb.Child;
import it.uniud.mads.jlibbig.core.ldb.EditableChild;
import it.uniud.mads.jlibbig.core.ldb.EditableOwned;
import it.uniud.mads.jlibbig.core.ldb.EditableParent;
import it.uniud.mads.jlibbig.core.ldb.Root;
import it.uniud.mads.jlibbig.core.util.NameGenerator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class EditableRoot
implements EditableParent,
Root,
EditableOwned {
    static final String PROPERTY_OWNER = "Owner";
    private final ProtectedProperty.ValueSetter<Owner> ownerSetter = new ProtectedProperty.ValueSetter();
    private final ProtectedProperty<Owner> owner = new ProtectedProperty<Owner>("Owner", null, this.ownerSetter, new PropertyListener[0]);
    private final ReplicationListenerContainer rep = new ReplicationListenerContainer(new ReplicationListener[0]);
    private final PropertyContainer props = new PropertyContainer(this);
    private final String name;
    private Set<EditableChild> children = new HashSet<EditableChild>();
    private final Set<? extends Child> ro_chd = Collections.unmodifiableSet(this.children);

    EditableRoot() {
        this(null);
    }

    EditableRoot(Owner owner) {
        this.name = "R_" + NameGenerator.DEFAULT.generate();
        this.props.attachProperty(this.owner);
        if (owner != null) {
            this.ownerSetter.set(owner);
        }
    }

    public String toString() {
        DirectedBigraphHandler h;
        int i;
        Owner o = this.getOwner();
        if (o != null && (i = (h = (DirectedBigraphHandler)o).getRoots().indexOf(this)) >= 0) {
            return i + ":r";
        }
        return this.name;
    }

    @Override
    public Collection<? extends Child> getChildren() {
        return this.ro_chd;
    }

    @Override
    public void addChild(EditableChild child) {
        if (child == null) {
            return;
        }
        this.children.add(child);
        if (this != child.getParent()) {
            child.setParent(this);
        }
    }

    @Override
    public void removeChild(EditableChild child) {
        if (child == null) {
            return;
        }
        this.children.remove(child);
        if (this == child.getParent()) {
            child.setParent(null);
        }
    }

    public Set<EditableChild> getEditableChildren() {
        return this.children;
    }

    @Override
    public EditableRoot getRoot() {
        return this;
    }

    @Override
    public EditableRoot replicate() {
        EditableRoot copy = new EditableRoot();
        this.rep.tellReplicated(this, copy);
        return copy;
    }

    @Override
    public void registerListener(ReplicationListener listener) {
        this.rep.registerListener(listener);
    }

    @Override
    public boolean isListenerRegistered(ReplicationListener listener) {
        return this.rep.isListenerRegistered(listener);
    }

    @Override
    public boolean unregisterListener(ReplicationListener listener) {
        return this.rep.unregisterListener(listener);
    }

    @Override
    public Property<?> attachProperty(Property<?> prop) {
        if (prop == null) {
            throw new IllegalArgumentException("Argument can not be null.");
        }
        String name = prop.getName();
        if (name.equals(PROPERTY_OWNER)) {
            throw new IllegalArgumentException("Property '" + name + "' can not be substituted");
        }
        return this.props.attachProperty(prop);
    }

    @Override
    public <V> Property<V> detachProperty(Property<V> prop) {
        if (prop == null) {
            throw new IllegalArgumentException("Argument can not be null.");
        }
        return this.detachProperty(prop.getName());
    }

    @Override
    public <V> Property<V> detachProperty(String name) {
        if (PROPERTY_OWNER.equals(name)) {
            throw new IllegalArgumentException("Property '" + name + "' can not be detached");
        }
        return this.props.detachProperty(name);
    }

    @Override
    public <V> Property<V> getProperty(String name) {
        return this.props.getProperty(name);
    }

    @Override
    public Collection<Property<?>> getProperties() {
        return this.props.getProperties();
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.props.getPropertyNames();
    }

    @Override
    public Owner getOwner() {
        return (Owner)this.owner.get();
    }

    @Override
    public void setOwner(Owner value) {
        this.ownerSetter.set(value);
    }

    @Override
    public EditableRoot getEditable() {
        return this;
    }

    @Override
    public boolean isParent() {
        return true;
    }

    @Override
    public boolean isChild() {
        return false;
    }

    @Override
    public boolean isRoot() {
        return true;
    }

    @Override
    public boolean isSite() {
        return false;
    }

    @Override
    public boolean isNode() {
        return false;
    }
}

