/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.std;

import it.uniud.mads.jlibbig.core.std.Bigraph;
import it.uniud.mads.jlibbig.core.std.BigraphBuilder;
import it.uniud.mads.jlibbig.core.std.EditableParent;
import it.uniud.mads.jlibbig.core.std.Match;
import it.uniud.mads.jlibbig.core.std.Node;
import it.uniud.mads.jlibbig.core.util.BidMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AgentMatch
extends Match {
    protected final List<Bigraph> params;
    protected final Bigraph lambda;

    AgentMatch(Bigraph context, Bigraph redexImage, Bigraph redexId, Bigraph paramWiring, Bigraph[] params, BidMap<Node, Node> nodeEmbedding, BidMap<EditableParent, EditableParent> ctxEmbMappping) {
        super(context, redexImage, redexId, null, nodeEmbedding, ctxEmbMappping);
        this.params = Collections.unmodifiableList(Arrays.asList(params));
        this.lambda = paramWiring;
    }

    @Override
    public Bigraph getParam() {
        if (this.param == null) {
            BigraphBuilder bb = new BigraphBuilder(((Bigraph)this.context).signature);
            for (Bigraph prm : this.params) {
                bb.rightParallelProduct(prm);
            }
            bb.outerCompose(this.lambda);
            this.param = bb.makeBigraph();
        }
        return (Bigraph)this.param;
    }

    public Bigraph getLambda() {
        return this.lambda;
    }

    public List<Bigraph> getParams() {
        return this.params;
    }

    public Bigraph getParamWiring() {
        return this.lambda;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AgentMatch:\ncontext = ").append(this.context).append("\nredexImage = ").append(this.rdxImage).append("\nredexId = ").append(this.rdxId).append("\nparamWiring = ").append(this.lambda);
        int i = 0;
        for (Bigraph prm : this.params) {
            builder.append("\nparam[").append(i++).append("] = ").append(prm);
        }
        return builder.toString();
    }
}

