/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.std;

import it.uniud.mads.jlibbig.core.Matcher;
import it.uniud.mads.jlibbig.core.std.AgentMatch;
import it.uniud.mads.jlibbig.core.std.Bigraph;
import it.uniud.mads.jlibbig.core.std.Child;
import it.uniud.mads.jlibbig.core.std.Edge;
import it.uniud.mads.jlibbig.core.std.EditableEdge;
import it.uniud.mads.jlibbig.core.std.EditableHandle;
import it.uniud.mads.jlibbig.core.std.EditableInnerName;
import it.uniud.mads.jlibbig.core.std.EditableNode;
import it.uniud.mads.jlibbig.core.std.EditableOuterName;
import it.uniud.mads.jlibbig.core.std.EditableParent;
import it.uniud.mads.jlibbig.core.std.EditableRoot;
import it.uniud.mads.jlibbig.core.std.EditableSite;
import it.uniud.mads.jlibbig.core.std.Handle;
import it.uniud.mads.jlibbig.core.std.InnerName;
import it.uniud.mads.jlibbig.core.std.LinkEntity;
import it.uniud.mads.jlibbig.core.std.Node;
import it.uniud.mads.jlibbig.core.std.Parent;
import it.uniud.mads.jlibbig.core.std.PlaceEntity;
import it.uniud.mads.jlibbig.core.std.Point;
import it.uniud.mads.jlibbig.core.std.Port;
import it.uniud.mads.jlibbig.core.std.Root;
import it.uniud.mads.jlibbig.core.std.Site;
import it.uniud.mads.jlibbig.core.util.BidMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.expression.discrete.arithmetic.ArExpression;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;

public class AgentMatcher
implements Matcher<Bigraph, Bigraph> {
    private static final boolean DEBUG;
    private static final boolean DEBUG_PRINT_CSP_SOLUTIONS;
    private static final boolean DEBUG_PRINT_SOLUTION_FETCH;
    private static final boolean DEBUG_CONSISTENCY_CHECK;
    public static final AgentMatcher DEFAULT;

    @Override
    public Iterable<? extends AgentMatch> match(Bigraph agent, Bigraph redex) {
        return this.match(agent, redex, null);
    }

    public Iterable<? extends AgentMatch> match(Bigraph agent, Bigraph redex, boolean ... neededParams) {
        return new MatchIterable(agent, redex, neededParams);
    }

    protected boolean areMatchable(Bigraph agent, Node fromAgent, Bigraph redex, Node fromRedex) {
        return fromAgent.getControl().equals(fromRedex.getControl());
    }

    static {
        DEBUG_PRINT_CSP_SOLUTIONS = DEBUG = Boolean.getBoolean("it.uniud.mads.jlibbig.debug") || Boolean.getBoolean("it.uniud.mads.jlibbig.debug.matchers");
        DEBUG_PRINT_SOLUTION_FETCH = DEBUG;
        DEBUG_CONSISTENCY_CHECK = Boolean.getBoolean("it.uniud.mads.jlibbig.consistency") || Boolean.getBoolean("it.uniud.mads.jlibbig.consistency.matchers");
        DEFAULT = new AgentMatcher();
    }

    private class MatchIterable
    implements Iterable<AgentMatch> {
        final Bigraph agent;
        final Bigraph redex;
        boolean agent_ancestors_is_empty = true;
        final Map<Node, Collection<Parent>> agent_ancestors;
        final List<? extends Root> agent_roots;
        final Collection<? extends Node> agent_nodes;
        final Collection<Port> agent_ports;
        final Collection<? extends Edge> agent_edges;
        final List<Handle> agent_handles;
        final List<? extends Root> redex_roots;
        final List<? extends Site> redex_sites;
        final Collection<? extends Node> redex_nodes;
        final Collection<Point> redex_points;
        final Collection<? extends Edge> redex_edges;
        final List<Handle> redex_handles;
        final boolean[] neededParam;
        final int ars;
        final int ans;
        final int ahs;
        final int rrs;
        final int rns;
        final int rss;
        final int rhs;
        final int rps;
        final int rprs;
        final int rins;

        private MatchIterable(Bigraph agent, Bigraph redex, boolean[] neededParams) {
            if (!agent.isGround()) {
                throw new UnsupportedOperationException("Agent should be a bigraph with empty inner interface i.e. ground.");
            }
            if (!agent.signature.equals(redex.signature)) {
                throw new UnsupportedOperationException("Agent and redex should have the same singature.");
            }
            this.agent = agent;
            this.redex = redex;
            this.agent_roots = agent.getRoots();
            this.agent_nodes = agent.getNodes();
            this.agent_edges = agent.getEdges();
            this.agent_handles = new LinkedList<Edge>(this.agent_edges);
            this.agent_handles.addAll(agent.getOuterNames());
            this.ars = this.agent_roots.size();
            this.ans = this.agent_nodes.size();
            this.ahs = this.agent_handles.size();
            this.agent_ports = new HashSet<Port>(this.ans);
            for (Node node : this.agent_nodes) {
                this.agent_ports.addAll(node.getPorts());
            }
            this.agent_ancestors = new HashMap<Node, Collection<Parent>>(this.ans);
            this.redex_roots = redex.getRoots();
            this.redex_sites = redex.getSites();
            this.redex_nodes = redex.getNodes();
            this.redex_edges = redex.getEdges();
            this.redex_handles = new LinkedList<Edge>(this.redex_edges);
            this.redex_handles.addAll(redex.getOuterNames());
            this.rrs = this.redex_roots.size();
            this.rns = this.redex_nodes.size();
            this.rss = this.redex_sites.size();
            this.rhs = this.redex_handles.size();
            this.redex_points = new HashSet<Point>(this.rns);
            for (Node node : this.redex_nodes) {
                List<? extends Port> ps = node.getPorts();
                this.redex_points.addAll(ps);
            }
            this.rprs = this.redex_points.size();
            Collection<? extends InnerName> ps = redex.getInnerNames();
            this.redex_points.addAll(ps);
            this.rps = this.redex_points.size();
            this.rins = this.rps - this.rprs;
            this.neededParam = new boolean[this.rss];
            for (int i = 0; i < this.neededParam.length; ++i) {
                this.neededParam[i] = neededParams == null || neededParams[i];
            }
        }

        @Override
        public Iterator<AgentMatch> iterator() {
            return new MatchIterator();
        }

        private class MatchIterator
        implements Iterator<AgentMatch> {
            private boolean mayHaveNext = true;
            private boolean firstRun = true;
            private AgentMatch nextMatch = null;
            private final Model model;
            private final Solver solver;
            final Map<PlaceEntity, Map<PlaceEntity, IntVar>> p_vars;
            final Map<LinkEntity, Map<LinkEntity, IntVar>> e_vars;
            final Map<Handle, Map<Handle, IntVar>> f_vars;
            public BidMap<Node, Node> nEmb;
            public BidMap<EditableParent, EditableParent> ctxEmbMapping;

            MatchIterator() {
                this.p_vars = new IdentityHashMap<PlaceEntity, Map<PlaceEntity, IntVar>>(MatchIterable.this.ars + MatchIterable.this.ans);
                this.e_vars = new IdentityHashMap<LinkEntity, Map<LinkEntity, IntVar>>(MatchIterable.this.ahs * MatchIterable.this.rhs + MatchIterable.this.agent_ports.size() * (1 + MatchIterable.this.redex_points.size()));
                this.f_vars = new IdentityHashMap<Handle, Map<Handle, IntVar>>(MatchIterable.this.rhs);
                this.model = new Model();
                this.solver = this.instantiateModel();
                if (DEBUG) {
                    System.out.println("- MODEL CREATED ---------------------");
                    System.out.println("- AGENT -----------------------------");
                    System.out.println(MatchIterable.this.agent);
                    System.out.println("- REDEX -----------------------------");
                    System.out.println(MatchIterable.this.redex);
                    System.out.println("-------------------------------------");
                }
            }

            private Variable findVariable(String name, Variable[] vars) {
                for (Variable v : vars) {
                    if (!name.equals(v.getName())) continue;
                    return v;
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            private Solver instantiateModel() {
                int ki = 0;
                for (Root root : MatchIterable.this.agent_roots) {
                    int n = 0;
                    HashMap<PlaceEntity, BoolVar> hashMap = new HashMap<PlaceEntity, BoolVar>(MatchIterable.this.rrs + MatchIterable.this.rns + MatchIterable.this.rss);
                    for (Root root2 : MatchIterable.this.redex_roots) {
                        BoolVar boolVar = this.model.boolVar(ki + "," + n++);
                        hashMap.put(root2, boolVar);
                    }
                    for (Node node : MatchIterable.this.redex_nodes) {
                        BoolVar boolVar = this.model.boolVar(ki + "," + n++);
                        this.model.arithm((IntVar)boolVar, "=", 0).post();
                        hashMap.put(node, boolVar);
                    }
                    for (Site site : MatchIterable.this.redex_sites) {
                        BoolVar boolVar = this.model.boolVar(ki + "," + n++);
                        this.model.arithm((IntVar)boolVar, "=", 0).post();
                        hashMap.put(site, boolVar);
                    }
                    this.p_vars.put(root, hashMap);
                    ++ki;
                }
                for (Node node : MatchIterable.this.agent_nodes) {
                    int n = 0;
                    HashMap<PlaceEntity, BoolVar> hashMap = new HashMap<PlaceEntity, BoolVar>(MatchIterable.this.rrs + MatchIterable.this.rns + MatchIterable.this.rss);
                    for (Root root : MatchIterable.this.redex_roots) {
                        BoolVar boolVar = this.model.boolVar(ki + "," + n++);
                        hashMap.put(root, boolVar);
                    }
                    for (Node node2 : MatchIterable.this.redex_nodes) {
                        BoolVar boolVar = this.model.boolVar(ki + "," + n++);
                        hashMap.put(node2, boolVar);
                    }
                    for (Site site : MatchIterable.this.redex_sites) {
                        BoolVar boolVar = this.model.boolVar(ki + "," + n++);
                        hashMap.put(site, boolVar);
                    }
                    this.p_vars.put(node, hashMap);
                    ++ki;
                }
                ki = 0;
                for (Handle handle : MatchIterable.this.redex_handles) {
                    int n = 0;
                    IdentityHashMap<Handle, BoolVar> identityHashMap = new IdentityHashMap<Handle, BoolVar>(MatchIterable.this.ahs);
                    for (Handle handle2 : MatchIterable.this.agent_handles) {
                        BoolVar boolVar = this.model.boolVar("F_" + ki + "_" + n++);
                        identityHashMap.put(handle2, boolVar);
                    }
                    this.f_vars.put(handle, identityHashMap);
                    ++ki;
                }
                ki = 0;
                for (Port port : MatchIterable.this.agent_ports) {
                    int n = 0;
                    IdentityHashMap<LinkEntity, BoolVar> identityHashMap = new IdentityHashMap<LinkEntity, BoolVar>(MatchIterable.this.redex_points.size() + 1);
                    EditableHandle editableHandle = port.getHandle();
                    BoolVar boolVar = this.model.boolVar("PH_" + ki);
                    identityHashMap.put(editableHandle, boolVar);
                    for (Point point : MatchIterable.this.redex_points) {
                        BoolVar boolVar2 = this.model.boolVar("PP_" + ki + "_" + n++);
                        identityHashMap.put(point, boolVar2);
                    }
                    this.e_vars.put(port, identityHashMap);
                    ++ki;
                }
                ki = 0;
                for (Handle handle : MatchIterable.this.redex_handles) {
                    int n = 0;
                    IdentityHashMap<Handle, IntVar> identityHashMap = new IdentityHashMap<Handle, IntVar>(MatchIterable.this.ahs);
                    for (Handle handle3 : MatchIterable.this.agent_handles) {
                        IntVar intVar = this.model.intVar("HH_" + ki + "_" + n++, 0, handle3.getPoints().size());
                        identityHashMap.put(handle3, intVar);
                    }
                    this.e_vars.put(handle, identityHashMap);
                    ++ki;
                }
                for (Node node : MatchIterable.this.agent_nodes) {
                    Map<PlaceEntity, IntVar> map = this.p_vars.get(node);
                    for (Node node3 : MatchIterable.this.redex_nodes) {
                        IntVar intVar = map.get(node3);
                        if (AgentMatcher.this.areMatchable(MatchIterable.this.agent, node, MatchIterable.this.redex, node3)) continue;
                        this.model.arithm(intVar, "=", 0).post();
                    }
                }
                for (Node node : MatchIterable.this.agent_nodes) {
                    Parent parent = node.getParent();
                    Map<PlaceEntity, IntVar> map = this.p_vars.get(node);
                    Map<PlaceEntity, IntVar> map2 = this.p_vars.get(parent);
                    for (Child child : MatchIterable.this.redex_nodes) {
                        Parent parent2 = child.getParent();
                        this.model.arithm(map.get(child), "<=", map2.get(parent2)).post();
                    }
                    for (Child child : MatchIterable.this.redex_sites) {
                        Parent parent3 = child.getParent();
                        this.model.arithm(map.get(child), "<=", map2.get(parent3)).post();
                    }
                }
                ArrayDeque<Node> qa = new ArrayDeque<Node>();
                ArrayDeque<Node> arrayDeque = new ArrayDeque<Node>();
                for (Root root : MatchIterable.this.agent_roots) {
                    for (Child child : root.getChildren()) {
                        if (!child.isNode()) continue;
                        qa.add((Node)child);
                    }
                }
                while (!qa.isEmpty()) {
                    Node node = (Node)qa.poll();
                    if (node.getControl().isActive()) {
                        for (Child child : node.getChildren()) {
                            if (!child.isNode()) continue;
                            qa.add((Node)child);
                        }
                        continue;
                    }
                    arrayDeque.add(node);
                }
                qa.clear();
                while (!arrayDeque.isEmpty()) {
                    Node node = (Node)arrayDeque.poll();
                    for (Child child : node.getChildren()) {
                        if (!child.isNode()) continue;
                        arrayDeque.add((Node)child);
                    }
                    Map<PlaceEntity, IntVar> map = this.p_vars.get(node);
                    for (Root root : MatchIterable.this.redex_roots) {
                        this.model.arithm(map.get(root), "=", 0).post();
                    }
                }
                Object vars = new IntVar[MatchIterable.this.ars + MatchIterable.this.ans];
                for (Root root : MatchIterable.this.redex_roots) {
                    int n = 0;
                    for (PlaceEntity placeEntity : this.p_vars.keySet()) {
                        vars[n++] = this.p_vars.get(placeEntity).get(root);
                    }
                    this.model.sum((IntVar[])vars, "=", 1).post();
                }
                for (Node node : MatchIterable.this.redex_nodes) {
                    int n = 0;
                    for (Parent parent : MatchIterable.this.agent_roots) {
                        vars[n++] = this.p_vars.get(parent).get(node);
                    }
                    for (Parent parent : MatchIterable.this.agent_nodes) {
                        vars[n++] = this.p_vars.get(parent).get(node);
                    }
                    this.model.sum((IntVar[])vars, "=", 1).post();
                }
                for (Node node : MatchIterable.this.agent_nodes) {
                    void var6_210;
                    void var7_269;
                    Map<PlaceEntity, IntVar> map = this.p_vars.get(node);
                    IntVar[] intVarArray = new IntVar[MatchIterable.this.rns + MatchIterable.this.rss];
                    boolean bl = false;
                    for (PlaceEntity placeEntity : MatchIterable.this.redex_nodes) {
                        intVarArray[++var5_159] = map.get(placeEntity);
                    }
                    for (PlaceEntity placeEntity : MatchIterable.this.redex_sites) {
                        intVarArray[bl2++] = map.get(placeEntity);
                    }
                    IntVar intVar = this.model.intVar(MatchIterable.this.rrs);
                    IntVar intVar2 = this.model.intVar(0);
                    for (IntVar intVar3 : intVarArray) {
                        IntVar intVar4 = var7_269.add((ArExpression)intVar3).intVar();
                    }
                    IntVar intVar5 = var7_269.mul((ArExpression)intVar).intVar();
                    IntVar[] intVarArray2 = new IntVar[MatchIterable.this.rrs];
                    boolean bl2 = false;
                    for (Root root : MatchIterable.this.redex_roots) {
                        intVarArray2[++var5_161] = map.get(root);
                    }
                    IntVar intVar6 = this.model.intVar(0);
                    for (IntVar intVar7 : intVarArray2) {
                        IntVar intVar8 = var6_210.add((ArExpression)intVar7).intVar();
                    }
                    IntVar intVar9 = var6_210.add((ArExpression)intVar5).intVar();
                    this.model.arithm(intVar9, "<=", MatchIterable.this.rrs).post();
                }
                for (Parent parent : MatchIterable.this.agent_nodes) {
                    Collection<? extends Child> collection = parent.getChildren();
                    for (Parent parent4 : MatchIterable.this.redex_nodes) {
                        Collection<? extends Child> collection2 = parent4.getChildren();
                        IntVar[] intVarArray = new IntVar[collection.size() * collection2.size()];
                        boolean bl = false;
                        for (PlaceEntity placeEntity : collection) {
                            for (PlaceEntity placeEntity2 : collection2) {
                                intVarArray[++var8_316] = this.p_vars.get(placeEntity).get(placeEntity2);
                            }
                        }
                        IntVar intVar = this.p_vars.get(parent).get(parent4);
                        this.model.sum(intVarArray, ">=", intVar.mul(collection.size()).intVar()).post();
                    }
                }
                Object cgs = new HashMap<Root, HashSet<? extends Child>>(MatchIterable.this.rrs);
                for (Root root : MatchIterable.this.redex_roots) {
                    HashSet<? extends Child> hashSet = new HashSet<Child>(root.getChildren());
                    hashSet.removeAll(MatchIterable.this.redex_sites);
                    cgs.put(root, hashSet);
                }
                for (PlaceEntity placeEntity : this.p_vars.keySet()) {
                    Collection<? extends Child> collection = ((Parent)placeEntity).getChildren();
                    for (Root root : MatchIterable.this.redex_roots) {
                        Collection collection3 = (Collection)cgs.get(root);
                        IntVar[] intVarArray = new IntVar[collection.size() * collection3.size()];
                        int n = 0;
                        for (Child child : collection) {
                            for (Child child2 : collection3) {
                                intVarArray[n++] = this.p_vars.get(child).get(child2);
                            }
                        }
                        IntVar intVar = this.p_vars.get(placeEntity).get(root);
                        this.model.sum(intVarArray, ">=", intVar.mul(collection3.size()).intVar()).post();
                    }
                }
                if (MatchIterable.this.agent_ancestors_is_empty) {
                    cgs = MatchIterable.this.agent_ancestors;
                    synchronized (cgs) {
                        if (MatchIterable.this.agent_ancestors_is_empty) {
                            Stack<Parent> stack = new Stack<Parent>();
                            Stack<Parent> stack2 = new Stack<Parent>();
                            for (Root root : MatchIterable.this.agent_roots) {
                                stack.clear();
                                stack2.add(root);
                                while (!stack2.isEmpty()) {
                                    boolean bl;
                                    Parent parent = (Parent)stack2.pop();
                                    if (parent.isNode()) {
                                        Node node = (Node)parent;
                                        while (!stack.isEmpty() && stack.peek() != node.getParent()) {
                                            stack.pop();
                                        }
                                        MatchIterable.this.agent_ancestors.put(node, new ArrayList(stack));
                                    }
                                    boolean bl3 = false;
                                    for (Child child : parent.getChildren()) {
                                        if (!child.isParent()) continue;
                                        stack2.add((Parent)((Object)child));
                                        bl = true;
                                    }
                                    if (!bl) continue;
                                    stack.push(parent);
                                }
                            }
                            MatchIterable.this.agent_ancestors_is_empty = false;
                        }
                    }
                }
                for (Root root : MatchIterable.this.redex_roots) {
                    for (PlaceEntity placeEntity : MatchIterable.this.agent_ancestors.keySet()) {
                        Collection<Parent> collection = MatchIterable.this.agent_ancestors.get(placeEntity);
                        IntVar[] intVarArray = new IntVar[1 + (collection.size() - 1) * MatchIterable.this.rss];
                        int n = 0;
                        for (Parent parent : collection) {
                            if (!parent.isNode()) continue;
                            Map<PlaceEntity, IntVar> map = this.p_vars.get(parent);
                            for (Site site : MatchIterable.this.redex_sites) {
                                intVarArray[n++] = map.get(site);
                            }
                        }
                        intVarArray[n] = this.p_vars.get(placeEntity).get(root);
                        this.model.sum(intVarArray, "<=", 1).post();
                    }
                }
                vars = new IntVar[MatchIterable.this.redex_points.size() + 1];
                for (Port port : MatchIterable.this.agent_ports) {
                    vars = (IntVar[])this.e_vars.get(port).values().toArray((T[])vars);
                    this.model.sum((IntVar[])vars, "=", 1).post();
                }
                for (Handle handle : MatchIterable.this.agent_handles) {
                    Collection<? extends Point> collection = handle.getPoints();
                    IntVar[] intVarArray = new IntVar[MatchIterable.this.rhs + collection.size()];
                    int n = 0;
                    for (Point point : collection) {
                        intVarArray[n++] = this.e_vars.get(point).get(handle);
                    }
                    for (Handle handle4 : MatchIterable.this.redex_handles) {
                        intVarArray[n++] = this.e_vars.get(handle4).get(handle);
                    }
                    this.model.sum(intVarArray, "=", collection.size()).post();
                }
                IntVar[] vars1 = new IntVar[MatchIterable.this.ahs];
                for (Handle handle : MatchIterable.this.redex_handles) {
                    void var7_284;
                    void var10_354;
                    Collection<? extends Point> collection = handle.getPoints();
                    int n = 0;
                    IntVar[] intVarArray = new IntVar[MatchIterable.this.agent_ports.size() * collection.size()];
                    for (Port port : MatchIterable.this.agent_ports) {
                        Map<LinkEntity, IntVar> map = this.e_vars.get(port);
                        for (Point point : collection) {
                            intVarArray[n++] = map.get(point);
                        }
                    }
                    vars1 = this.e_vars.get(handle).values().toArray(vars1);
                    IntVar intVar = this.model.intVar(0);
                    IntVar[] intVarArray3 = vars1;
                    int n2 = intVarArray3.length;
                    boolean bl = false;
                    while (var10_354 < n2) {
                        IntVar intVar10 = intVarArray3[var10_354];
                        IntVar intVar11 = var7_284.add((ArExpression)intVar10).intVar();
                        ++var10_354;
                    }
                    if (intVarArray.length == 0) continue;
                    this.model.sum(intVarArray, "=", (IntVar)var7_284).post();
                }
                vars = new IntVar[MatchIterable.this.agent_ports.size()];
                for (Point point : MatchIterable.this.redex_points) {
                    if (!point.isPort()) continue;
                    boolean bl = false;
                    for (Port port : MatchIterable.this.agent_ports) {
                        vars[++var4_122] = this.e_vars.get(port).get(point);
                    }
                    if (((Object)vars).length == 0) continue;
                    this.model.sum((IntVar[])vars, "=", 1).post();
                }
                for (Handle handle : MatchIterable.this.redex_handles) {
                    Map<Handle, IntVar> map = this.f_vars.get(handle);
                    Map<LinkEntity, IntVar> map3 = this.e_vars.get(handle);
                    if (handle.getPoints().isEmpty()) continue;
                    for (Handle handle5 : MatchIterable.this.agent_handles) {
                        if (handle5.getPoints().isEmpty()) continue;
                        IntVar intVar = map.get(handle5);
                        IntVar intVar12 = map3.get(handle5);
                        this.model.arithm(intVar12, "<=", intVar.mul(handle5.getPoints().size()).intVar()).post();
                        this.model.arithm(intVar, "<=", intVar12).post();
                    }
                }
                for (Handle handle : MatchIterable.this.redex_handles) {
                    Map<Handle, IntVar> map = this.f_vars.get(handle);
                    Collection<? extends Point> collection = handle.getPoints();
                    for (Handle handle6 : MatchIterable.this.agent_handles) {
                        IntVar intVar = map.get(handle6);
                        int n = 0;
                        IntVar[] intVarArray = new IntVar[collection.size() * handle6.getPoints().size()];
                        for (Point point : handle6.getPoints()) {
                            Map<LinkEntity, IntVar> map4 = this.e_vars.get(point);
                            for (Point point2 : collection) {
                                IntVar ve = map4.get(point2);
                                intVarArray[n++] = ve;
                                this.model.arithm(ve, "<=", intVar).post();
                            }
                            if (!handle.isEdge()) continue;
                            this.model.arithm(intVar.add((ArExpression)this.e_vars.get(point).get(handle6)).intVar(), "<=", 1).post();
                        }
                        if (collection.isEmpty() && handle6.getPoints().isEmpty()) continue;
                        this.model.sum(intVarArray, ">=", intVar).post();
                    }
                }
                vars = new IntVar[MatchIterable.this.ahs];
                for (Handle handle : MatchIterable.this.redex_handles) {
                    Map<Handle, IntVar> map = this.f_vars.get(handle);
                    if (((IntVar[])map.values().toArray((T[])vars)).length == 0) continue;
                    this.model.sum((IntVar[])map.values().toArray((T[])vars), "<=", 1).post();
                }
                ListIterator<Handle> ir1 = MatchIterable.this.redex_handles.listIterator(0);
                while (ir1.hasNext()) {
                    Handle handle = ir1.next();
                    Map<Handle, IntVar> map = this.f_vars.get(handle);
                    if (handle.isEdge()) {
                        for (Handle handle7 : MatchIterable.this.agent_handles) {
                            if (!handle7.isOuterName()) continue;
                            this.model.arithm(map.get(handle7), "=", 0).post();
                        }
                    }
                    ListIterator<Handle> listIterator = MatchIterable.this.redex_handles.listIterator(ir1.nextIndex());
                    while (listIterator.hasNext()) {
                        Handle handle8 = listIterator.next();
                        Map<Handle, IntVar> map5 = this.f_vars.get(handle8);
                        if (handle.isEdge() == handle8.isEdge()) continue;
                        for (Handle handle9 : MatchIterable.this.agent_handles) {
                            this.model.arithm(map.get(handle9).add((ArExpression)map5.get(handle9)).intVar(), "<=", 1).post();
                        }
                    }
                }
                vars = new IntVar[MatchIterable.this.redex_edges.size()];
                for (Handle handle : MatchIterable.this.agent_handles) {
                    boolean bl = false;
                    for (Handle handle10 : MatchIterable.this.redex_edges) {
                        vars[++var4_129] = this.f_vars.get(handle10).get(handle);
                    }
                    if (((Object)vars).length == 0) continue;
                    this.model.sum((IntVar[])vars, "<=", 1).post();
                }
                for (Node node : MatchIterable.this.agent_nodes) {
                    Map<PlaceEntity, IntVar> map = this.p_vars.get(node);
                    for (Node node4 : MatchIterable.this.redex_nodes) {
                        IntVar intVar = map.get(node4);
                        boolean bl = AgentMatcher.this.areMatchable(MatchIterable.this.agent, node, MatchIterable.this.redex, node4);
                        for (int i = node.getControl().getArity() - 1; 0 <= i; --i) {
                            Map<LinkEntity, IntVar> map6 = this.e_vars.get(node.getPort(i));
                            for (int j = node4.getControl().getArity() - 1; 0 <= j; --j) {
                                if (bl && i == j) {
                                    this.model.arithm(intVar, "=", map6.get(node4.getPort(j))).post();
                                    continue;
                                }
                                this.model.arithm(map6.get(node4.getPort(j)), "=", 0).post();
                            }
                        }
                    }
                }
                for (Node node : MatchIterable.this.agent_nodes) {
                    void var6_242;
                    void var9_344;
                    Collection<Parent> collection = MatchIterable.this.agent_ancestors.get(node);
                    IntVar[] intVarArray = new IntVar[(1 + collection.size()) * MatchIterable.this.rss];
                    boolean bl = false;
                    for (Parent parent : collection) {
                        Map<PlaceEntity, IntVar> map = this.p_vars.get(parent);
                        for (Site site : MatchIterable.this.redex_sites) {
                            intVarArray[++var5_176] = map.get(site);
                        }
                    }
                    Map<PlaceEntity, IntVar> map = this.p_vars.get(node);
                    for (Site site : MatchIterable.this.redex_sites) {
                        intVarArray[++var5_177] = map.get(site);
                    }
                    IntVar intVar = this.model.intVar(0);
                    IntVar[] intVarArray4 = intVarArray;
                    int n = intVarArray4.length;
                    boolean bl4 = false;
                    while (var9_344 < n) {
                        IntVar intVar13 = intVarArray4[var9_344];
                        IntVar intVar14 = var6_242.add((ArExpression)intVar13).intVar();
                        ++var9_344;
                    }
                    for (Port port : node.getPorts()) {
                        Map<LinkEntity, IntVar> map7 = this.e_vars.get(port);
                        IntVar[] intVarArray5 = new IntVar[MatchIterable.this.rins];
                        int n3 = 0;
                        for (Point point : MatchIterable.this.redex.getInnerNames()) {
                            IntVar intVar15 = map7.get(point);
                            intVarArray5[n3++] = intVar15;
                        }
                        this.model.sum(intVarArray5, "<=", (IntVar)var6_242).post();
                    }
                }
                Solver solver = this.model.getSolver();
                return solver;
            }

            @Override
            public boolean hasNext() {
                if (this.mayHaveNext && this.nextMatch == null) {
                    this.fetchSolution();
                }
                return this.mayHaveNext && this.nextMatch != null;
            }

            @Override
            public AgentMatch next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                AgentMatch res = this.nextMatch;
                this.nextMatch = null;
                return res;
            }

            @Override
            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException("");
            }

            private void noMoreSolutions() {
                this.mayHaveNext = false;
                this.solver.hardReset();
            }

            /*
             * WARNING - void declaration
             */
            private void fetchSolution() {
                String name;
                boolean first = this.firstRun;
                this.firstRun = false;
                if (DEBUG_PRINT_SOLUTION_FETCH) {
                    System.out.println("fetch solution has been invoked...");
                }
                if (first && !this.solver.solve() || !first && !this.solver.solve()) {
                    if (DEBUG_PRINT_SOLUTION_FETCH) {
                        System.out.println("...but no more solutions where found.");
                    }
                    this.noMoreSolutions();
                    return;
                }
                if (DEBUG_PRINT_CSP_SOLUTIONS) {
                    IntVar v;
                    Object v2;
                    void var4_13;
                    void var4_11;
                    void var4_8;
                    System.out.println("Solution: #" + this.solver.getSolutionCount());
                    System.out.print('\n');
                    int[] p_cell_width = new int[1 + MatchIterable.this.rrs + MatchIterable.this.rns + MatchIterable.this.rss];
                    p_cell_width[0] = 6;
                    for (Node node : MatchIterable.this.agent_nodes) {
                        p_cell_width[0] = Math.max(p_cell_width[0], node.toString().length());
                    }
                    System.out.printf("%-" + p_cell_width[0] + "s|", "P_VARS");
                    int c = 1;
                    boolean bl = false;
                    while (var4_8 < MatchIterable.this.redex_roots.size()) {
                        String string = "R_" + (int)var4_8;
                        p_cell_width[c] = string.length();
                        System.out.printf("%-" + p_cell_width[c] + "s|", string);
                        ++var4_8;
                        ++c;
                    }
                    for (Node node : MatchIterable.this.redex_nodes) {
                        String s3 = node.toString();
                        p_cell_width[c] = s3.length();
                        System.out.printf("%-" + p_cell_width[c++] + "s|", s3);
                    }
                    boolean bl2 = false;
                    while (var4_11 < MatchIterable.this.redex_sites.size()) {
                        String string = "S_" + (int)var4_11;
                        p_cell_width[c] = string.length();
                        System.out.printf("%-" + p_cell_width[c] + "s|", string);
                        ++var4_11;
                        ++c;
                    }
                    boolean bl3 = false;
                    while (var4_13 < MatchIterable.this.agent_roots.size()) {
                        void var7_29;
                        void var7_31;
                        System.out.printf("\nR_%-" + (p_cell_width[0] - 2) + "d|", (int)var4_13);
                        c = 1;
                        Root root = MatchIterable.this.agent_roots.get((int)var4_13);
                        Map<PlaceEntity, IntVar> row2 = this.p_vars.get(root);
                        boolean bl4 = false;
                        while (var7_31 < MatchIterable.this.redex_roots.size()) {
                            Root root2 = MatchIterable.this.redex_roots.get((int)var7_31);
                            IntVar v22 = this.findVariable(row2.get(root2).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v22.getValue());
                            ++var7_31;
                        }
                        for (Node node : MatchIterable.this.redex_nodes) {
                            v2 = this.findVariable(row2.get(node).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v2.getValue());
                        }
                        boolean bl5 = false;
                        while (var7_29 < MatchIterable.this.redex_sites.size()) {
                            Site site = MatchIterable.this.redex_sites.get((int)var7_29);
                            v2 = this.findVariable(row2.get(site).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v2.getValue());
                            ++var7_29;
                        }
                        ++var4_13;
                    }
                    for (Node node : MatchIterable.this.agent_nodes) {
                        void var7_39;
                        void var7_36;
                        System.out.printf("\n%-" + p_cell_width[0] + "s|", node);
                        c = 1;
                        Iterator<LinkEntity> row = this.p_vars.get(node);
                        boolean bl6 = false;
                        while (var7_36 < MatchIterable.this.redex_roots.size()) {
                            Root root = MatchIterable.this.redex_roots.get((int)var7_36);
                            v2 = this.findVariable(((IntVar)row.get(root)).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v2.getValue());
                            ++var7_36;
                        }
                        for (Node node2 : MatchIterable.this.redex_nodes) {
                            v2 = this.findVariable(((IntVar)row.get(node2)).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v2.getValue());
                        }
                        boolean bl7 = false;
                        while (var7_39 < MatchIterable.this.redex_sites.size()) {
                            Site site = MatchIterable.this.redex_sites.get((int)var7_39);
                            v2 = this.findVariable(((IntVar)row.get(site)).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v2.getValue());
                            ++var7_39;
                        }
                    }
                    System.out.println('\n');
                    int[] nArray = new int[1 + MatchIterable.this.ahs];
                    int[] nArray2 = new int[1 + MatchIterable.this.redex_points.size() + MatchIterable.this.ahs];
                    nArray[0] = 6;
                    for (Handle handle : MatchIterable.this.redex_handles) {
                        nArray[0] = Math.max(nArray[0], handle.toString().length());
                    }
                    nArray2[0] = nArray[0];
                    for (Point point : MatchIterable.this.agent_ports) {
                        nArray2[0] = Math.max(nArray2[0], point.toString().length());
                    }
                    System.out.printf("%-" + nArray2[0] + "s|", "E_VARS");
                    c = 1;
                    for (Point point : MatchIterable.this.redex_points) {
                        String string = point.toString();
                        nArray2[c] = string.length();
                        System.out.printf("%-" + nArray2[c++] + "s|", string);
                    }
                    for (Handle handle : MatchIterable.this.agent_handles) {
                        String string = handle.toString();
                        nArray2[c] = string.length();
                        System.out.printf("%-" + nArray2[c++] + "s|", string);
                    }
                    for (Point point : MatchIterable.this.agent_ports) {
                        System.out.printf("\n%-" + nArray2[0] + "s|", point);
                        c = 1;
                        Map<LinkEntity, IntVar> map = this.e_vars.get(point);
                        for (Point pj : MatchIterable.this.redex_points) {
                            v = this.findVariable(map.get(pj).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + nArray2[c++] + "d|", v.getValue());
                        }
                        for (Handle hj : MatchIterable.this.agent_handles) {
                            if (map.containsKey(hj)) {
                                v = this.findVariable(map.get(hj).getName(), this.model.getVars()).asIntVar();
                                System.out.printf("%" + nArray2[c++] + "d|", v.getValue());
                                continue;
                            }
                            System.out.printf("%" + nArray2[c++] + "c|", Character.valueOf(' '));
                        }
                    }
                    for (Handle handle : MatchIterable.this.redex_handles) {
                        System.out.printf("\n%-" + nArray2[0] + "s|", handle);
                        c = 1;
                        Map<LinkEntity, IntVar> map = this.e_vars.get(handle);
                        for (int j2 = MatchIterable.this.redex_points.size(); 0 < j2; --j2) {
                            System.out.printf("%" + nArray2[c++] + "c|", Character.valueOf(' '));
                        }
                        for (Handle hj : MatchIterable.this.agent_handles) {
                            v = this.findVariable(map.get(hj).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + nArray2[c++] + "d|", v.getValue());
                        }
                    }
                    System.out.println('\n');
                    System.out.printf("%" + nArray[0] + "s|", "F_VARS");
                    c = 1;
                    for (Handle handle : MatchIterable.this.agent_handles) {
                        String string = handle.toString();
                        nArray[c] = string.length();
                        System.out.printf("%-" + nArray[c++] + "s|", string);
                    }
                    for (Handle handle : MatchIterable.this.redex_handles) {
                        System.out.printf("\n%-" + nArray[0] + "s|", handle);
                        c = 1;
                        Map<Handle, IntVar> map = this.f_vars.get(handle);
                        for (Handle hj : MatchIterable.this.agent_handles) {
                            v = this.findVariable(map.get(hj).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + nArray[c++] + "d|", v.getValue());
                        }
                    }
                    System.out.println('\n');
                }
                Bigraph ctx = new Bigraph(MatchIterable.this.agent.signature);
                Bigraph rdx = new Bigraph(MatchIterable.this.agent.signature);
                Bigraph[] bigraphArray = new Bigraph[MatchIterable.this.rss];
                Bigraph bigraph = Bigraph.makeId(MatchIterable.this.redex.signature, MatchIterable.this.rss, new String[0]);
                Bigraph id = Bigraph.makeEmpty(MatchIterable.this.redex.signature);
                this.nEmb = new BidMap(MatchIterable.this.rns);
                this.ctxEmbMapping = new BidMap();
                EditableSite[] editableSiteArray = new EditableSite[MatchIterable.this.rrs];
                EditableSite[] editableSiteArray2 = new EditableSite[MatchIterable.this.rss];
                EditableRoot[] rdx_roots_dic = new EditableRoot[MatchIterable.this.rrs];
                IdentityHashMap<Object, EditableHandle> ctx_hnd_dic = new IdentityHashMap<Object, EditableHandle>();
                IdentityHashMap<EditableHandle, EditableHandle> rdx_hnd_dic = new IdentityHashMap<EditableHandle, EditableHandle>();
                IdentityHashMap<EditableHandle, EditableHandle> lmb_hnd_dic = new IdentityHashMap<EditableHandle, EditableHandle>();
                IdentityHashMap prms_hnd_dic = new IdentityHashMap();
                IdentityHashMap<EditableHandle, Object> handle_img = new IdentityHashMap<EditableHandle, Object>(MatchIterable.this.rhs);
                class VState {
                    final PlaceEntity c;
                    final PlaceEntity i;
                    final EditableParent p;
                    final Bigraph b;

                    VState(Bigraph b, EditableParent p, PlaceEntity c) {
                        this(b, p, c, null);
                    }

                    VState(Bigraph b, EditableParent p, PlaceEntity c, PlaceEntity i) {
                        this.i = i;
                        this.c = c;
                        this.p = p;
                        this.b = b;
                    }
                }
                ArrayDeque<VState> q = new ArrayDeque<VState>();
                for (EditableOuterName o1 : MatchIterable.this.agent.outers.values()) {
                    EditableOuterName o2 = o1.replicate();
                    ctx.outers.put(o2.getName(), o2);
                    o2.setOwner(ctx);
                    ctx_hnd_dic.put(o1, o2);
                }
                for (EditableOuterName o0 : MatchIterable.this.redex.outers.values()) {
                    EditableHandle h2;
                    void var21_90;
                    name = o0.getName();
                    EditableOuterName o2 = new EditableOuterName(name);
                    rdx.outers.put(name, o2);
                    o2.setOwner(rdx);
                    rdx_hnd_dic.put(o0, o2);
                    EditableInnerName i1 = new EditableInnerName(name);
                    ctx.inners.put(name, i1);
                    EditableHandle editableHandle = (EditableHandle)handle_img.get(o0);
                    if (editableHandle == null) {
                        void var21_93;
                        Map<Handle, IntVar> f_row = this.f_vars.get(o0);
                        for (Handle handle : MatchIterable.this.agent_handles) {
                            IntVar v = this.findVariable(f_row.get(handle).getName(), this.model.getVars()).asIntVar();
                            if (v.getValue() != 1) continue;
                            EditableHandle editableHandle2 = handle.getEditable();
                            break;
                        }
                        if (var21_93 == null) {
                            EditableEdge editableEdge = new EditableEdge();
                        }
                        handle_img.put(o0, var21_90);
                    }
                    if ((h2 = (EditableHandle)ctx_hnd_dic.get(var21_90)) == null) {
                        h2 = var21_90.replicate();
                        h2.setOwner(ctx);
                        ctx_hnd_dic.put(var21_90, h2);
                    }
                    i1.setHandle(h2);
                }
                for (EditableInnerName i0 : MatchIterable.this.redex.inners.values()) {
                    void var21_98;
                    name = i0.getName();
                    EditableInnerName i2 = new EditableInnerName(name);
                    EditableHandle h0 = i0.getHandle();
                    EditableHandle editableHandle = (EditableHandle)rdx_hnd_dic.get(h0);
                    if (editableHandle == null) {
                        EditableHandle h1 = (EditableHandle)handle_img.get(h0);
                        if (h1 == null) {
                            Map<Handle, IntVar> map = this.f_vars.get(h0);
                            for (Handle h : MatchIterable.this.agent_handles) {
                                IntVar v = this.findVariable(map.get(h).getName(), this.model.getVars()).asIntVar();
                                if (v.getValue() != 1) continue;
                                h1 = h.getEditable();
                                break;
                            }
                            if (h1 == null) {
                                h1 = new EditableEdge();
                            }
                            handle_img.put(h0, h1);
                        }
                        EditableHandle editableHandle3 = h1.replicate();
                        editableHandle3.setOwner(rdx);
                        rdx_hnd_dic.put(h0, editableHandle3);
                    }
                    i2.setHandle((EditableHandle)var21_98);
                    rdx.inners.put(name, i2);
                    EditableOuterName o2 = new EditableOuterName(name);
                    o2.setOwner(bigraph);
                    bigraph.outers.put(name, o2);
                }
                for (EditableRoot r0 : MatchIterable.this.agent.roots) {
                    q.add(new VState(ctx, null, r0));
                }
                LinkedList<? extends Root> unseen_rdx_roots = new LinkedList<Root>(MatchIterable.this.redex_roots);
                while (!q.isEmpty()) {
                    VState v = (VState)q.poll();
                    if (v.b == ctx) {
                        EditableParent p1 = (EditableParent)v.c;
                        EditableParent p2 = p1.replicate();
                        if (p1.isRoot()) {
                            EditableRoot r2 = (EditableRoot)p2;
                            ctx.roots.add(r2);
                            r2.setOwner(ctx);
                        } else {
                            EditableNode n1 = (EditableNode)p1;
                            EditableNode editableNode = (EditableNode)p2;
                            editableNode.setParent(v.p);
                            this.ctxEmbMapping.put(editableNode, n1);
                            for (int i = n1.getControl().getArity() - 1; -1 < i; --i) {
                                EditableNode.EditablePort editablePort = n1.getPort(i);
                                EditableHandle editableHandle = editablePort.getHandle();
                                EditableHandle h2 = (EditableHandle)ctx_hnd_dic.get(editableHandle);
                                if (h2 == null) {
                                    h2 = editableHandle.replicate();
                                    h2.setOwner(ctx);
                                    ctx_hnd_dic.put(editableHandle, h2);
                                }
                                editableNode.getPort(i).setHandle(h2);
                            }
                        }
                        HashSet<? extends Child> rcs = new HashSet<Child>(p1.getChildren());
                        Map<PlaceEntity, IntVar> map = this.p_vars.get(p1);
                        Iterator ir = unseen_rdx_roots.iterator();
                        while (ir.hasNext()) {
                            Root root = (Root)ir.next();
                            IntVar intVar = this.findVariable(map.get(root).getName(), this.model.getVars()).asIntVar();
                            if (intVar.getValue() != 1) continue;
                            ir.remove();
                            int k = MatchIterable.this.redex_roots.indexOf(root);
                            EditableSite s = new EditableSite();
                            s.setParent(p2);
                            editableSiteArray[k] = s;
                            EditableRoot r2 = new EditableRoot();
                            r2.setOwner(rdx);
                            rdx_roots_dic[k] = r2;
                            for (Child child : root.getChildren()) {
                                Iterator ic = rcs.iterator();
                                boolean notMatched = true;
                                while (ic.hasNext()) {
                                    Child c1 = (Child)ic.next();
                                    IntVar intVar2 = this.findVariable(this.p_vars.get(c1).get(child).getName(), this.model.getVars()).asIntVar();
                                    if (intVar2.getValue() != 1) continue;
                                    notMatched = false;
                                    q.add(new VState(rdx, r2, c1, child));
                                    ic.remove();
                                }
                                if (!notMatched || !child.isSite()) continue;
                                q.add(new VState(rdx, r2, null, child));
                            }
                        }
                        for (Child child : rcs) {
                            q.add(new VState(ctx, p2, child));
                        }
                        continue;
                    }
                    if (v.b == rdx) {
                        if (v.i.isNode()) {
                            void var21_104;
                            EditableNode n0 = (EditableNode)v.i;
                            EditableNode n1 = (EditableNode)v.c;
                            EditableNode n2 = n1.replicate();
                            this.nEmb.put(n0, n1);
                            n2.setParent(v.p);
                            int n = n0.getControl().getArity() - 1;
                            while (-1 < var21_104) {
                                void var24_139;
                                EditableNode.EditablePort o0 = n0.getPort((int)var21_104);
                                EditableHandle editableHandle = o0.getHandle();
                                EditableHandle editableHandle4 = (EditableHandle)rdx_hnd_dic.get(editableHandle);
                                if (editableHandle4 == null) {
                                    EditableHandle editableHandle5 = n1.getPort((int)var21_104).getHandle().replicate();
                                    editableHandle5.setOwner(rdx);
                                    rdx_hnd_dic.put(editableHandle, editableHandle5);
                                }
                                n2.getPort((int)var21_104).setHandle((EditableHandle)var24_139);
                                --var21_104;
                            }
                            HashSet<? extends Child> hashSet = new HashSet<Child>(n1.getChildren());
                            for (Child child : n0.getChildren()) {
                                Iterator iterator = hashSet.iterator();
                                boolean notMatched = true;
                                while (iterator.hasNext()) {
                                    Child c1 = (Child)iterator.next();
                                    IntVar var = this.findVariable(this.p_vars.get(c1).get(child).getName(), this.model.getVars()).asIntVar();
                                    if (var.getValue() != 1) continue;
                                    notMatched = false;
                                    q.add(new VState(rdx, n2, c1, child));
                                    iterator.remove();
                                }
                                if (!notMatched || !child.isSite()) continue;
                                q.add(new VState(rdx, n2, null, child));
                            }
                            continue;
                        }
                        EditableSite s0 = (EditableSite)v.i;
                        int k = MatchIterable.this.redex_sites.indexOf(s0);
                        if (editableSiteArray2[k] == null) {
                            EditableSite s2 = new EditableSite();
                            s2.setParent(v.p);
                            editableSiteArray2[k] = s2;
                        }
                        if (!MatchIterable.this.neededParam[k]) continue;
                        Bigraph prm = bigraphArray[k];
                        if (prm == null) {
                            prm = new Bigraph(MatchIterable.this.agent.getSignature());
                            prm.roots.add(new EditableRoot(prm));
                            bigraphArray[k] = prm;
                            prms_hnd_dic.put(prm, new IdentityHashMap());
                        }
                        if (v.c == null) continue;
                        q.add(new VState(prm, prm.roots.get(0), v.c));
                        continue;
                    }
                    EditableNode n1 = (EditableNode)v.c;
                    EditableNode n2 = n1.replicate();
                    n2.setParent(v.p);
                    this.ctxEmbMapping.put(n2, n1);
                    for (int i = n1.getControl().getArity() - 1; -1 < i; --i) {
                        void var23_127;
                        EditableNode.EditablePort p2;
                        block73: {
                            Map<LinkEntity, IntVar> row;
                            Map map;
                            block72: {
                                EditableHandle h1;
                                EditableNode.EditablePort editablePort = n1.getPort(i);
                                p2 = n2.getPort(i);
                                Object var23_122 = null;
                                map = (Map)prms_hnd_dic.get(v.b);
                                row = this.e_vars.get(editablePort);
                                IntVar var_tmp = this.findVariable(row.get(h1 = editablePort.getHandle()).getName(), this.model.getVars()).asIntVar();
                                if (var_tmp.getValue() != 1) break block72;
                                EditableHandle editableHandle = (EditableHandle)map.get(h1);
                                if (editableHandle != null) break block73;
                                EditableHandle h3 = (EditableHandle)lmb_hnd_dic.get(h1);
                                if (h3 == null) {
                                    EditableHandle editableHandle6 = (EditableHandle)ctx_hnd_dic.get(h1);
                                    if (editableHandle6 != null) {
                                        EditableInnerName i4 = new EditableInnerName();
                                        i4.setHandle(editableHandle6);
                                        String name2 = i4.getName();
                                        ctx.inners.put(name2, i4);
                                        EditableOuterName o5 = new EditableOuterName(name2);
                                        o5.setOwner(id);
                                        id.outers.put(name2, o5);
                                        EditableInnerName i5 = new EditableInnerName(name2);
                                        i5.setHandle(o5);
                                        id.inners.put(name2, i5);
                                        EditableOuterName o3 = new EditableOuterName(name2);
                                        bigraph.outers.put(name2, o3);
                                        h3 = o3;
                                    } else {
                                        h3 = new EditableEdge();
                                    }
                                    h3.setOwner(bigraph);
                                    lmb_hnd_dic.put(h1, h3);
                                }
                                EditableInnerName editableInnerName = new EditableInnerName(h3);
                                String name3 = editableInnerName.getName();
                                bigraph.inners.put(name3, editableInnerName);
                                EditableOuterName o2 = new EditableOuterName(name3);
                                o2.setOwner(v.b);
                                v.b.outers.put(name3, o2);
                                EditableOuterName editableOuterName = o2;
                                map.put(h1, editableOuterName);
                                break block73;
                            }
                            for (InnerName innerName : MatchIterable.this.redex.inners.values()) {
                                IntVar var = this.findVariable(row.get(innerName).getName(), this.model.getVars()).asIntVar();
                                if (var.getValue() != 1) continue;
                                EditableHandle h3 = bigraph.outers.get(innerName.getName());
                                EditableHandle editableHandle = (EditableHandle)map.get(h3);
                                if (editableHandle != null) break;
                                EditableInnerName i3 = new EditableInnerName();
                                String name4 = i3.getName();
                                i3.setHandle(h3);
                                bigraph.inners.put(name4, i3);
                                EditableOuterName o2 = new EditableOuterName(name4);
                                o2.setOwner(v.b);
                                v.b.outers.put(name4, o2);
                                EditableOuterName editableOuterName = o2;
                                map.put(h3, o2);
                                break;
                            }
                        }
                        p2.setHandle((EditableHandle)var23_127);
                    }
                    for (Child child : n1.getChildren()) {
                        q.add(new VState(v.b, n2, child));
                    }
                }
                ctx.sites.addAll(Arrays.asList(editableSiteArray));
                rdx.sites.addAll(Arrays.asList(editableSiteArray2));
                rdx.roots.addAll(Arrays.asList(rdx_roots_dic));
                if (DEBUG_CONSISTENCY_CHECK) {
                    if (!ctx.isConsistent()) {
                        throw new RuntimeException("Inconsistent bigraph (ctx)");
                    }
                    if (!rdx.isConsistent()) {
                        throw new RuntimeException("Inconsistent bigraph (rdx)");
                    }
                    if (!bigraph.isConsistent()) {
                        throw new RuntimeException("Inconsistent bigraph (lmb)");
                    }
                    if (!id.isConsistent()) {
                        throw new RuntimeException("Inconsistent bigraph (id)");
                    }
                    for (int i = 0; i < MatchIterable.this.rss; ++i) {
                        if (!MatchIterable.this.neededParam[i] || bigraphArray[i].isConsistent()) continue;
                        throw new RuntimeException("Inconsistent bigraph (prm " + i + ")");
                    }
                }
                this.nextMatch = new AgentMatch(ctx, rdx, id, bigraph, bigraphArray, this.nEmb, this.ctxEmbMapping);
            }
        }
    }
}

