/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.std;

import it.uniud.mads.jlibbig.core.exceptions.IncompatibleSignatureException;
import it.uniud.mads.jlibbig.core.std.AgentMatch;
import it.uniud.mads.jlibbig.core.std.AgentMatcher;
import it.uniud.mads.jlibbig.core.std.Bigraph;
import it.uniud.mads.jlibbig.core.std.BigraphBuilder;
import it.uniud.mads.jlibbig.core.std.EditableInnerName;
import it.uniud.mads.jlibbig.core.std.EditableRoot;
import it.uniud.mads.jlibbig.core.std.EditableSite;
import it.uniud.mads.jlibbig.core.std.InstantiationMap;
import it.uniud.mads.jlibbig.core.std.RewritingRule;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class AgentRewritingRule
extends RewritingRule {
    private static final boolean DEBUG;
    private static final boolean DEBUG_PRINT_MATCH;
    private static final boolean DEBUG_PRINT_RESULT;
    private static final boolean DEBUG_CONSISTENCY_CHECK;
    private final boolean[] neededParam;
    private final boolean[] cloneParam;
    private AgentMatcher matcher;

    public AgentRewritingRule(Bigraph redex, Bigraph reactum, int ... eta) {
        this(AgentMatcher.DEFAULT, redex, reactum, new InstantiationMap(redex.sites.size(), eta));
    }

    public AgentRewritingRule(AgentMatcher matcher, Bigraph redex, Bigraph reactum, int ... eta) {
        this(matcher, redex, reactum, new InstantiationMap(redex.sites.size(), eta));
    }

    public AgentRewritingRule(Bigraph redex, Bigraph reactum, InstantiationMap eta) {
        this(AgentMatcher.DEFAULT, redex, reactum, eta);
    }

    public AgentRewritingRule(AgentMatcher matcher, Bigraph redex, Bigraph reactum, InstantiationMap eta) {
        super(redex, reactum, eta);
        int j;
        int i;
        this.matcher = matcher == null ? AgentMatcher.DEFAULT : matcher;
        this.neededParam = new boolean[redex.sites.size()];
        this.cloneParam = new boolean[this.eta.getPlaceDomain()];
        int[] prms = new int[this.eta.getPlaceDomain()];
        for (i = 0; i < this.eta.getPlaceDomain(); ++i) {
            j = this.eta.getPlaceInstance(i);
            this.neededParam[j] = true;
            prms[i] = j;
        }
        for (i = 0; i < prms.length; ++i) {
            if (this.cloneParam[i]) continue;
            for (j = i + 1; j < prms.length; ++j) {
                this.cloneParam[j] = this.cloneParam[j] || prms[i] == prms[j];
            }
        }
    }

    @Override
    public Bigraph getRedex() {
        return this.redex;
    }

    @Override
    public Bigraph getReactum() {
        return this.reactum;
    }

    @Override
    public InstantiationMap getInstantiationRule() {
        return this.eta;
    }

    @Override
    public Iterable<Bigraph> apply(Bigraph agent) {
        if (!agent.isGround()) {
            throw new UnsupportedOperationException("Agent should be a bigraph with empty inner interface i.e. ground.");
        }
        if (!agent.signature.equals(this.redex.signature)) {
            throw new IncompatibleSignatureException("Agent and redex should have the same singature.", agent.getSignature(), this.redex.getSignature());
        }
        return new RewriteIterable(agent);
    }

    static {
        DEBUG_PRINT_MATCH = DEBUG = Boolean.getBoolean("it.uniud.mads.jlibbig.debug") || Boolean.getBoolean("it.uniud.mads.jlibbig.debug.reactions");
        DEBUG_PRINT_RESULT = DEBUG;
        DEBUG_CONSISTENCY_CHECK = Boolean.getBoolean("it.uniud.mads.jlibbig.consistency") || Boolean.getBoolean("it.uniud.mads.jlibbig.consistency.reactions");
    }

    private class RewriteIterable
    implements Iterable<Bigraph> {
        private final Bigraph target;
        private Iterable<? extends AgentMatch> mAble;

        RewriteIterable(Bigraph target) {
            this.target = target;
        }

        @Override
        public Iterator<Bigraph> iterator() {
            if (this.mAble == null) {
                this.mAble = AgentRewritingRule.this.matcher.match(this.target, AgentRewritingRule.this.redex, AgentRewritingRule.this.neededParam);
            }
            return new RewriteIterator();
        }

        private class RewriteIterator
        implements Iterator<Bigraph> {
            Iterator<? extends AgentMatch> mTor;

            private RewriteIterator() {
            }

            @Override
            public boolean hasNext() {
                if (this.mTor == null) {
                    this.mTor = RewriteIterable.this.mAble.iterator();
                }
                return this.mTor.hasNext();
            }

            @Override
            public Bigraph next() {
                int i;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                AgentMatch match = this.mTor.next();
                if (DEBUG_PRINT_MATCH) {
                    System.out.println(match);
                }
                BigraphBuilder bb = new BigraphBuilder(AgentRewritingRule.this.redex.getSignature());
                for (int i2 = AgentRewritingRule.this.eta.getPlaceDomain() - 1; 0 <= i2; --i2) {
                    bb.leftJuxtapose(match.params.get(AgentRewritingRule.this.eta.getPlaceInstance(i2)), !AgentRewritingRule.this.cloneParam[i2]);
                }
                Bigraph lambda = match.getParamWiring();
                for (EditableInnerName n : lambda.inners.values()) {
                    if (bb.containsOuterName(n.getName())) continue;
                    lambda.inners.remove(n.getName());
                    n.setHandle(null);
                }
                for (i = AgentRewritingRule.this.eta.getPlaceCodomain() - AgentRewritingRule.this.eta.getPlaceDomain(); i > 0; --i) {
                    lambda.roots.remove(0);
                    lambda.sites.remove(0);
                }
                for (i = AgentRewritingRule.this.eta.getPlaceDomain() - AgentRewritingRule.this.eta.getPlaceCodomain(); i > 0; --i) {
                    EditableRoot r = new EditableRoot();
                    r.setOwner(lambda);
                    EditableSite s = new EditableSite(r);
                    lambda.roots.add(r);
                    lambda.sites.add(s);
                }
                bb.outerCompose(lambda, true);
                Bigraph inreact = AgentRewritingRule.this.instantiateReactum(match);
                inreact = Bigraph.juxtapose(inreact, match.getRedexId());
                bb.outerCompose(inreact, true);
                bb.outerCompose((Bigraph)match.getContext(), true);
                Bigraph result = bb.makeBigraph(true);
                if (DEBUG_PRINT_RESULT) {
                    System.out.println(result);
                }
                if (DEBUG_CONSISTENCY_CHECK && !result.isConsistent()) {
                    throw new RuntimeException("Inconsistent bigraph");
                }
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("");
            }
        }
    }
}

