/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.std;

import it.uniud.mads.jlibbig.core.Owner;
import it.uniud.mads.jlibbig.core.exceptions.IncompatibleInterfaceException;
import it.uniud.mads.jlibbig.core.exceptions.IncompatibleSignatureException;
import it.uniud.mads.jlibbig.core.exceptions.NameClashException;
import it.uniud.mads.jlibbig.core.std.BigraphBuilder;
import it.uniud.mads.jlibbig.core.std.Child;
import it.uniud.mads.jlibbig.core.std.Control;
import it.uniud.mads.jlibbig.core.std.Edge;
import it.uniud.mads.jlibbig.core.std.EditableChild;
import it.uniud.mads.jlibbig.core.std.EditableEdge;
import it.uniud.mads.jlibbig.core.std.EditableHandle;
import it.uniud.mads.jlibbig.core.std.EditableInnerName;
import it.uniud.mads.jlibbig.core.std.EditableNode;
import it.uniud.mads.jlibbig.core.std.EditableOuterName;
import it.uniud.mads.jlibbig.core.std.EditableOwned;
import it.uniud.mads.jlibbig.core.std.EditableParent;
import it.uniud.mads.jlibbig.core.std.EditablePoint;
import it.uniud.mads.jlibbig.core.std.EditableRoot;
import it.uniud.mads.jlibbig.core.std.EditableSite;
import it.uniud.mads.jlibbig.core.std.Handle;
import it.uniud.mads.jlibbig.core.std.InnerName;
import it.uniud.mads.jlibbig.core.std.LinkFacet;
import it.uniud.mads.jlibbig.core.std.Node;
import it.uniud.mads.jlibbig.core.std.OuterName;
import it.uniud.mads.jlibbig.core.std.Parent;
import it.uniud.mads.jlibbig.core.std.Point;
import it.uniud.mads.jlibbig.core.std.Port;
import it.uniud.mads.jlibbig.core.std.Root;
import it.uniud.mads.jlibbig.core.std.Signature;
import it.uniud.mads.jlibbig.core.std.Site;
import it.uniud.mads.jlibbig.core.util.CachingProxy;
import it.uniud.mads.jlibbig.core.util.Provider;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class Bigraph
implements it.uniud.mads.jlibbig.core.Bigraph<Control>,
Cloneable {
    private static final boolean DEBUG_CONSISTENCY_CHECK = Boolean.getBoolean("it.uniud.mads.jlibbig.consistency") || Boolean.getBoolean("it.uniud.mads.jlibbig.consistency.bigraphops");
    final Signature signature;
    public final List<EditableRoot> roots = new ArrayList<EditableRoot>();
    public final List<EditableSite> sites = new ArrayList<EditableSite>();
    public final Map<String, EditableOuterName> outers = new IdentityHashMap<String, EditableOuterName>();
    public final Map<String, EditableInnerName> inners = new IdentityHashMap<String, EditableInnerName>();
    private final List<? extends Root> ro_roots = Collections.unmodifiableList(this.roots);
    private final List<? extends Site> ro_sites = Collections.unmodifiableList(this.sites);
    CachingProxy<Collection<EditableNode>> nodesProxy = new CachingProxy<Collection<EditableNode>>(new Provider<Collection<EditableNode>>(){

        @Override
        public Collection<EditableNode> get() {
            return Bigraph.this.provideNodes();
        }
    });
    CachingProxy<Collection<EditableEdge>> edgesProxy = new CachingProxy<Collection<EditableEdge>>(new Provider<Collection<EditableEdge>>(){

        @Override
        public Collection<EditableEdge> get() {
            return Bigraph.this.provideEdges();
        }
    });
    private Map<Child, Collection<Parent>> ancestors = new WeakHashMap<Child, Collection<Parent>>();
    static final Collection<Parent> EMPTY_ANCS_LST = Collections.unmodifiableList(Collections.emptyList());
    private static final Comparator<Control> controlComparator = new Comparator<Control>(){

        @Override
        public int compare(Control o1, Control o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final Comparator<Node> nodeComparator = new Comparator<Node>(){

        @Override
        public int compare(Node o1, Node o2) {
            int c = controlComparator.compare(o1.getControl(), o2.getControl());
            if (c == 0) {
                return o1.getEditable().getName().compareTo(o2.getEditable().getName());
            }
            return c;
        }
    };
    private final Comparator<Child> childComparator = new Comparator<Child>(){

        @Override
        public int compare(Child o1, Child o2) {
            if (o1.isSite()) {
                if (o2.isSite()) {
                    return Bigraph.this.sites.indexOf(o1) < Bigraph.this.sites.indexOf(o2) ? -1 : 1;
                }
                return 1;
            }
            if (o2.isSite()) {
                return -1;
            }
            return nodeComparator.compare((Node)o1, (Node)o2);
        }
    };
    private static final Comparator<Port> portComparator = new Comparator<Port>(){

        @Override
        public int compare(Port o1, Port o2) {
            if (o1 == o2) {
                return 0;
            }
            int c = nodeComparator.compare(o1.getNode(), o2.getNode());
            if (c == 0) {
                return o1.getNumber() < o2.getNumber() ? -1 : 1;
            }
            return c;
        }
    };
    private static final Comparator<InnerName> innerComparator = new Comparator<InnerName>(){

        @Override
        public int compare(InnerName o1, InnerName o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final Comparator<Point> pointComparator = new Comparator<Point>(){

        @Override
        public int compare(Point o1, Point o2) {
            if (o1.isPort()) {
                if (o2.isPort()) {
                    return portComparator.compare((Port)o1, (Port)o2);
                }
                return -1;
            }
            if (o2.isPort()) {
                return 1;
            }
            return innerComparator.compare((InnerName)o1, (InnerName)o2);
        }
    };
    private static final Comparator<OuterName> outerComparator = new Comparator<OuterName>(){

        @Override
        public int compare(OuterName o1, OuterName o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final Comparator<Edge> edgeComparator = new Comparator<Edge>(){

        @Override
        public int compare(Edge o1, Edge o2) {
            return o1.getEditable().getName().compareTo(o2.getEditable().getName());
        }
    };

    public Bigraph(Signature sig) {
        if (sig == null) {
            throw new IllegalArgumentException("Signature can not be null.");
        }
        this.signature = sig;
    }

    public boolean isConsistent() {
        return this.isConsistent(this);
    }

    boolean isConsistent(Owner owner) {
        HashSet<Point> seen_points = new HashSet<Point>();
        HashSet<EditableHandle> seen_handles = new HashSet<EditableHandle>();
        HashSet<EditableSite> unseen_sites = new HashSet<EditableSite>();
        unseen_sites.addAll(this.sites);
        HashSet<Child> seen_children = new HashSet<Child>();
        ArrayDeque<EditableParent> q = new ArrayDeque<EditableParent>();
        for (EditableRoot editableRoot : this.roots) {
            if (editableRoot.getOwner() != owner) {
                System.err.println("INCOSISTENCY: foreign root");
                return false;
            }
            q.add(editableRoot);
        }
        while (!q.isEmpty()) {
            Parent p = (Parent)q.poll();
            for (Child child : p.getChildren()) {
                if (!p.equals(child.getParent())) {
                    System.err.println("INCOSISTENCY: parent/child mismatch");
                    return false;
                }
                if (!seen_children.add(child)) {
                    System.err.println("INCOSISTENCY: cyclic place");
                    return false;
                }
                if (child.isNode()) {
                    EditableNode editableNode = (EditableNode)child;
                    if (editableNode.getControl().getArity() != editableNode.getPorts().size() || !this.signature.contains(editableNode.getControl())) {
                        System.err.println("INCOSISTENCY: control/arity");
                        return false;
                    }
                    q.add(editableNode);
                    for (Point point : editableNode.getPorts()) {
                        EditableHandle h = ((EditablePoint)point).getHandle();
                        if (h == null || h.getOwner() != owner) {
                            System.out.println(this);
                            System.err.println("INCOSISTENCY: broken or foreign handle");
                            return false;
                        }
                        if (!h.getPoints().contains(point)) {
                            System.err.println("INCOSISTENCY: handle/point mismatch");
                            return false;
                        }
                        seen_points.add(point);
                        seen_handles.add(h);
                    }
                    continue;
                }
                if (child.isSite()) {
                    Site site = (Site)child;
                    unseen_sites.remove(site);
                    if (this.sites.contains(site)) continue;
                    System.err.println("INCOSISTENCY: foreign site");
                    return false;
                }
                System.err.println("INCOSISTENCY: neither a node nor a site");
                return false;
            }
        }
        for (EditableOuterName editableOuterName : this.outers.values()) {
            if (editableOuterName.getOwner() != owner) {
                System.err.println("INCOSISTENCY: foreign outer name");
                return false;
            }
            seen_handles.add(editableOuterName);
        }
        for (EditableInnerName editableInnerName : this.inners.values()) {
            if (editableInnerName.getOwner() != owner) {
                System.err.println("INCOSISTENCY: foreign inner name");
                return false;
            }
            seen_handles.add(editableInnerName.getHandle());
            seen_points.add(editableInnerName);
        }
        for (Handle handle : seen_handles) {
            for (Point point : handle.getPoints()) {
                if (seen_points.remove(point)) continue;
                System.err.println("INCOSISTENCY: foreign point");
                return false;
            }
        }
        if (seen_points.size() > 0) {
            System.err.println("INCOSISTENCY: handle chain broken");
            return false;
        }
        if (unseen_sites.size() > 0) {
            System.err.println("INCOSISTENCY: unreachable site");
            return false;
        }
        return true;
    }

    Bigraph setOwner(Owner owner) {
        if (owner == null) {
            owner = this;
        }
        for (EditableOwned editableOwned : this.roots) {
            editableOwned.setOwner(owner);
        }
        for (EditableOwned editableOwned : this.outers.values()) {
            editableOwned.setOwner(owner);
        }
        for (Edge edge : this.getEdges()) {
            ((EditableOwned)((Object)edge)).setOwner(owner);
        }
        return this;
    }

    public Bigraph clone() {
        return this.clone(null);
    }

    Bigraph clone(Owner owner) {
        Bigraph big = new Bigraph(this.signature);
        if (owner == null) {
            owner = big;
        }
        HashMap<EditableHandle, EditableHandle> hnd_dic = new HashMap<EditableHandle, EditableHandle>();
        for (EditableOuterName editableOuterName : this.outers.values()) {
            EditableOuterName o2 = editableOuterName.replicate();
            big.outers.put(o2.getName(), o2);
            o2.setOwner(owner);
            hnd_dic.put(editableOuterName, o2);
        }
        for (EditableInnerName editableInnerName : this.inners.values()) {
            EditableInnerName i2 = editableInnerName.replicate();
            EditableHandle h1 = editableInnerName.getHandle();
            Object h2 = (EditableHandle)hnd_dic.get(h1);
            if (h2 == null) {
                h2 = h1.replicate();
                h2.setOwner(owner);
                hnd_dic.put(h1, (EditableHandle)h2);
            }
            i2.setHandle((EditableHandle)h2);
            big.inners.put(i2.getName(), i2);
        }
        class Pair {
            final EditableChild c;
            final EditableParent p;

            Pair(EditableParent p, EditableChild c) {
                this.c = c;
                this.p = p;
            }
        }
        LinkedList<Pair> q = new LinkedList<Pair>();
        for (EditableRoot r1 : this.roots) {
            EditableRoot r2 = r1.replicate();
            big.roots.add(r2);
            r2.setOwner(owner);
            for (EditableChild c : r1.getEditableChildren()) {
                q.add(new Pair(r2, c));
            }
        }
        EditableSite[] editableSiteArray = new EditableSite[this.sites.size()];
        while (!q.isEmpty()) {
            Pair t = (Pair)q.poll();
            if (t.c.isNode()) {
                EditableNode n1 = (EditableNode)t.c;
                EditableNode n2 = n1.replicate();
                n2.setParent(t.p);
                for (int i = n1.getControl().getArity() - 1; 0 <= i; --i) {
                    EditableNode.EditablePort p1 = n1.getPort(i);
                    EditableHandle h1 = p1.getHandle();
                    EditableHandle h2 = (EditableHandle)hnd_dic.get(h1);
                    if (h2 == null) {
                        h2 = h1.replicate();
                        h2.setOwner(owner);
                        hnd_dic.put(h1, h2);
                    }
                    n2.getPort(i).setHandle(h2);
                }
                for (EditableChild c : n1.getEditableChildren()) {
                    q.add(new Pair(n2, c));
                }
                continue;
            }
            EditableSite s1 = (EditableSite)t.c;
            EditableSite s2 = s1.replicate();
            s2.setParent(t.p);
            editableSiteArray[this.sites.indexOf((Object)s1)] = s2;
        }
        big.sites.addAll(Arrays.asList(editableSiteArray));
        return big;
    }

    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public boolean isEmpty() {
        return this.outers.isEmpty() && this.inners.isEmpty() && this.roots.isEmpty() && this.sites.isEmpty();
    }

    @Override
    public boolean isGround() {
        return this.inners.isEmpty() && this.sites.isEmpty();
    }

    @Override
    public List<? extends Root> getRoots() {
        return this.ro_roots;
    }

    @Override
    public List<? extends Site> getSites() {
        return this.ro_sites;
    }

    @Override
    public Collection<? extends OuterName> getOuterNames() {
        return this.outers.values();
    }

    @Override
    public Collection<? extends InnerName> getInnerNames() {
        return this.inners.values();
    }

    void onNodeAdded(EditableNode node) {
        Collection<EditableNode> ns = this.nodesProxy.softGet();
        if (ns != null) {
            ns.add(node);
        }
    }

    void onNodeAdded(Collection<EditableNode> nodes) {
        Collection<EditableNode> ns = this.nodesProxy.softGet();
        if (ns != null) {
            ns.addAll(nodes);
        }
    }

    void onNodeRemoved(EditableNode node) {
        this.ancestors.clear();
        Collection<EditableNode> ns = this.nodesProxy.softGet();
        if (ns != null) {
            ns.remove(node);
        }
    }

    void onNodeRemoved(Collection<EditableNode> nodes) {
        this.ancestors.clear();
        Collection<EditableNode> ns = this.nodesProxy.softGet();
        if (ns != null) {
            ns.removeAll(nodes);
        }
    }

    void onNodeSetChanged() {
        this.nodesProxy.invalidate();
        this.ancestors.clear();
    }

    private Collection<EditableNode> provideNodes() {
        HashSet<EditableNode> s = new HashSet<EditableNode>();
        LinkedList<EditableNode> q = new LinkedList<EditableNode>();
        for (Root root : this.roots) {
            for (Child child : root.getChildren()) {
                if (!child.isNode()) continue;
                EditableNode n = (EditableNode)child;
                q.add(n);
            }
        }
        while (!q.isEmpty()) {
            EditableNode p = (EditableNode)q.poll();
            s.add(p);
            for (Child child : p.getChildren()) {
                if (!child.isNode()) continue;
                EditableNode editableNode = (EditableNode)child;
                q.add(editableNode);
            }
        }
        return s;
    }

    @Override
    public Collection<? extends Node> getNodes() {
        return this.nodesProxy.get();
    }

    void onEdgeAdded(EditableEdge edge) {
        Collection<EditableEdge> ns = this.edgesProxy.softGet();
        if (ns != null) {
            ns.add(edge);
        }
    }

    void onEdgeAdded(Collection<EditableEdge> edges) {
        Collection<EditableEdge> ns = this.edgesProxy.softGet();
        if (ns != null) {
            ns.addAll(edges);
        }
    }

    void onEdgeRemoved(EditableEdge edge) {
        Collection<EditableEdge> ns = this.edgesProxy.softGet();
        if (ns != null) {
            ns.remove(edge);
        }
    }

    void onEdgeRemoved(Collection<EditableEdge> edges) {
        Collection<EditableEdge> ns = this.edgesProxy.softGet();
        if (ns != null) {
            ns.removeAll(edges);
        }
    }

    void onEdgeSetChanged() {
        this.nodesProxy.invalidate();
    }

    public Collection<EditableEdge> provideEdges() {
        Collection<? extends Node> nodes = this.getNodes();
        HashSet<EditableEdge> s = new HashSet<EditableEdge>();
        for (Node node : nodes) {
            for (Port port : node.getPorts()) {
                EditableHandle h = port.getHandle();
                if (!h.isEdge()) continue;
                s.add((EditableEdge)h);
            }
        }
        for (InnerName innerName : this.inners.values()) {
            EditableHandle h = innerName.getHandle();
            if (!h.isEdge()) continue;
            s.add((EditableEdge)h);
        }
        return s;
    }

    @Override
    public Collection<? extends Edge> getEdges() {
        return this.edgesProxy.get();
    }

    Collection<Parent> getAncestors(Child child) {
        if (child == null) {
            throw new IllegalArgumentException("The argument can not be null.");
        }
        Collection<Parent> s = this.ancestors.get(child);
        if (s == null) {
            Parent parent = child.getParent();
            if (parent.isRoot()) {
                s = EMPTY_ANCS_LST;
            } else {
                s = new LinkedList<Parent>(this.getAncestors((Child)((Object)parent)));
                s.add(parent);
            }
            this.ancestors.put(child, s);
        }
        return s;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder b = new StringBuilder();
        b.append(this.signature.getUSID());
        b.append(" {");
        Iterator is = this.signature.iterator();
        while (is.hasNext()) {
            b.append(((Control)is.next()).toString());
            if (!is.hasNext()) continue;
            b.append(", ");
        }
        b.append("} :: <").append(this.sites.size()).append(",{");
        ArrayList<EditableInnerName> ins = new ArrayList<EditableInnerName>(this.inners.values());
        Collections.sort(ins, innerComparator);
        Iterator ii = ins.iterator();
        while (ii.hasNext()) {
            b.append(((EditableInnerName)ii.next()).toString());
            if (!ii.hasNext()) continue;
            b.append(", ");
        }
        b.append("}> -> <").append(this.roots.size()).append(",{");
        ArrayList<EditableOuterName> ons = new ArrayList<EditableOuterName>(this.outers.values());
        Collections.sort(ons, outerComparator);
        Iterator io = ons.iterator();
        while (io.hasNext()) {
            b.append(((EditableOuterName)io.next()).toString());
            if (!io.hasNext()) continue;
            b.append(", ");
        }
        b.append("}>");
        for (Handle handle : this.outers.values()) {
            b.append(nl).append(handle);
            b.append(":o <- {");
            ArrayList<? extends Point> arrayList = new ArrayList<Point>(handle.getPoints());
            Collections.sort(arrayList, pointComparator);
            Iterator ip = arrayList.iterator();
            while (ip.hasNext()) {
                Point p = (Point)ip.next();
                b.append(p);
                if (p.isInnerName()) {
                    b.append(":i");
                }
                if (!ip.hasNext()) continue;
                b.append(", ");
            }
            b.append('}');
        }
        ArrayList<? extends Edge> es = new ArrayList<Edge>(this.getEdges());
        Collections.sort(es, edgeComparator);
        for (Handle handle : es) {
            b.append(nl).append(handle);
            b.append(":e <- {");
            ArrayList<? extends Point> ps = new ArrayList<Point>(handle.getPoints());
            Collections.sort(ps, pointComparator);
            Iterator ip = ps.iterator();
            while (ip.hasNext()) {
                Point p = (Point)ip.next();
                b.append(p);
                if (p.isInnerName()) {
                    b.append(":i");
                }
                if (!ip.hasNext()) continue;
                b.append(", ");
            }
            b.append('}');
        }
        LinkedList<Parent> linkedList = new LinkedList<Parent>();
        linkedList.addAll(this.roots);
        while (!linkedList.isEmpty()) {
            Parent parent = (Parent)linkedList.poll();
            b.append(nl);
            if (parent.isRoot()) {
                b.append(this.roots.indexOf(parent));
            } else {
                b.append(parent);
            }
            b.append(" <- {");
            ArrayList<? extends Child> cs = new ArrayList<Child>(parent.getChildren());
            Collections.sort(cs, this.childComparator);
            Iterator ic = cs.iterator();
            while (ic.hasNext()) {
                Child c = (Child)ic.next();
                if (c.isSite()) {
                    b.append(this.sites.indexOf(c));
                } else {
                    b.append(c);
                    linkedList.add((Parent)((Object)c));
                }
                if (!ic.hasNext()) continue;
                b.append(", ");
            }
            b.append('}');
        }
        return b.toString();
    }

    public static Bigraph juxtapose(Bigraph left, Bigraph right) {
        return Bigraph.juxtapose(left, right, false);
    }

    public static Bigraph juxtapose(Bigraph left, Bigraph right, boolean reuse) {
        if (left == right) {
            throw new IllegalArgumentException("Operand shuld be distinct; a bigraph can not be juxtaposed with itself.");
        }
        if (!left.signature.equals(right.signature)) {
            throw new IncompatibleSignatureException(left.getSignature(), right.getSignature());
        }
        if (!Collections.disjoint(left.inners.keySet(), right.inners.keySet()) || !Collections.disjoint(left.outers.keySet(), right.outers.keySet())) {
            throw new IncompatibleInterfaceException(new NameClashException(Bigraph.intersectNames(left.inners.values(), right.inners.values(), Bigraph.intersectNames(left.outers.values(), right.outers.values()))));
        }
        Bigraph l = reuse ? left : left.clone();
        Bigraph r = reuse ? right : right.clone();
        for (EditableOwned editableOwned : r.roots) {
            editableOwned.setOwner(l);
        }
        for (EditableOwned editableOwned : r.outers.values()) {
            editableOwned.setOwner(l);
        }
        Collection<EditableEdge> es = r.edgesProxy.get();
        for (EditableEdge e : es) {
            e.setOwner(l);
        }
        l.onEdgeAdded(es);
        l.onNodeAdded(r.nodesProxy.get());
        r.onEdgeSetChanged();
        r.onNodeSetChanged();
        l.roots.addAll(r.roots);
        l.sites.addAll(r.sites);
        l.outers.putAll(r.outers);
        l.inners.putAll(r.inners);
        if (DEBUG_CONSISTENCY_CHECK && !l.isConsistent()) {
            throw new RuntimeException("Inconsistent bigraph");
        }
        return l;
    }

    public static Bigraph compose(Bigraph out, Bigraph in) {
        return Bigraph.compose(out, in, false);
    }

    public static Bigraph compose(Bigraph out, Bigraph in, boolean reuse) {
        if (out == in) {
            throw new IllegalArgumentException("Operand shuld be distinct; a bigraph can not be composed with itself.");
        }
        if (!out.signature.equals(in.signature)) {
            throw new IncompatibleSignatureException(out.getSignature(), in.getSignature());
        }
        HashSet<String> xs = new HashSet<String>(out.inners.keySet());
        HashSet<String> ys = new HashSet<String>(in.outers.keySet());
        HashSet<String> zs = new HashSet<String>(xs);
        xs.removeAll(ys);
        ys.removeAll(zs);
        if (!xs.isEmpty() || !ys.isEmpty() || out.sites.size() != in.roots.size()) {
            throw new IncompatibleInterfaceException("The outer face of the first graph must be equal to inner face of the second");
        }
        Bigraph a = reuse ? out : out.clone();
        Bigraph b = reuse ? in : in.clone();
        Collection<EditableEdge> es = b.edgesProxy.get();
        Collection<EditableNode> ns = b.nodesProxy.get();
        Iterator<EditableRoot> ir = b.roots.iterator();
        Iterator<EditableSite> is = a.sites.iterator();
        while (ir.hasNext()) {
            EditableSite s = is.next();
            EditableParent p = s.getParent();
            p.removeChild(s);
            for (EditableChild c : new ArrayList(ir.next().getEditableChildren())) {
                c.setParent(p);
            }
        }
        HashMap<String, EditableHandle> a_inners = new HashMap<String, EditableHandle>();
        for (EditableInnerName i : a.inners.values()) {
            a_inners.put(i.getName(), i.getHandle());
            i.setHandle(null);
        }
        for (EditableOuterName o : b.outers.values()) {
            EditableHandle h = (EditableHandle)a_inners.get(o.getName());
            for (EditablePoint p : new HashSet<EditablePoint>(o.getEditablePoints())) {
                p.setHandle(h);
            }
        }
        a.inners.clear();
        a.sites.clear();
        a.inners.putAll(b.inners);
        a.sites.addAll(b.sites);
        a.onNodeAdded(ns);
        b.onNodeSetChanged();
        for (EditableEdge e : es) {
            e.setOwner(a);
        }
        a.onEdgeAdded(es);
        b.onEdgeSetChanged();
        if (DEBUG_CONSISTENCY_CHECK && !a.isConsistent()) {
            throw new RuntimeException("Inconsistent bigraph");
        }
        return a;
    }

    public static Bigraph makeEmpty(Signature signature) {
        return new Bigraph(signature);
    }

    public static Bigraph makeId(Signature signature, int width, String ... names) {
        BigraphBuilder bb = new BigraphBuilder(signature);
        for (int i = 0; i < width; ++i) {
            bb.addSite(bb.addRoot());
        }
        for (String name : names) {
            bb.addInnerName(name, bb.addOuterName(name));
        }
        return bb.makeBigraph();
    }

    public static Bigraph makeId(Signature signature, int width, Iterable<? extends LinkFacet> names) {
        BigraphBuilder bb = new BigraphBuilder(signature);
        for (int i = 0; i < width; ++i) {
            bb.addSite(bb.addRoot());
        }
        for (LinkFacet linkFacet : names) {
            String name = linkFacet.getName();
            bb.addInnerName(name, bb.addOuterName(name));
        }
        return bb.makeBigraph();
    }

    private static Collection<String> intersectNames(Collection<? extends LinkFacet> arg0, Collection<? extends LinkFacet> arg1) {
        return Bigraph.intersectNames(arg0, arg1, new HashSet<String>());
    }

    private static Collection<String> intersectNames(Collection<? extends LinkFacet> arg0, Collection<? extends LinkFacet> arg1, Collection<String> ns0) {
        HashSet<String> ns1 = new HashSet<String>();
        for (LinkFacet linkFacet : arg0) {
            ns1.add(linkFacet.getName());
        }
        for (LinkFacet linkFacet : arg1) {
            String s = linkFacet.getName();
            if (!ns1.contains(s)) continue;
            ns0.add(s);
            ns1.remove(s);
        }
        return ns0;
    }
}

