/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.std;

import it.uniud.mads.jlibbig.core.Owned;
import it.uniud.mads.jlibbig.core.Owner;
import it.uniud.mads.jlibbig.core.exceptions.IncompatibleInterfaceException;
import it.uniud.mads.jlibbig.core.exceptions.IncompatibleSignatureException;
import it.uniud.mads.jlibbig.core.exceptions.NameClashException;
import it.uniud.mads.jlibbig.core.exceptions.UnexpectedOwnerException;
import it.uniud.mads.jlibbig.core.std.Bigraph;
import it.uniud.mads.jlibbig.core.std.Control;
import it.uniud.mads.jlibbig.core.std.Edge;
import it.uniud.mads.jlibbig.core.std.EditableChild;
import it.uniud.mads.jlibbig.core.std.EditableEdge;
import it.uniud.mads.jlibbig.core.std.EditableHandle;
import it.uniud.mads.jlibbig.core.std.EditableInnerName;
import it.uniud.mads.jlibbig.core.std.EditableNode;
import it.uniud.mads.jlibbig.core.std.EditableOuterName;
import it.uniud.mads.jlibbig.core.std.EditableOwned;
import it.uniud.mads.jlibbig.core.std.EditableParent;
import it.uniud.mads.jlibbig.core.std.EditablePoint;
import it.uniud.mads.jlibbig.core.std.EditableRoot;
import it.uniud.mads.jlibbig.core.std.EditableSite;
import it.uniud.mads.jlibbig.core.std.Handle;
import it.uniud.mads.jlibbig.core.std.InnerName;
import it.uniud.mads.jlibbig.core.std.LinkFacet;
import it.uniud.mads.jlibbig.core.std.Node;
import it.uniud.mads.jlibbig.core.std.OuterName;
import it.uniud.mads.jlibbig.core.std.Parent;
import it.uniud.mads.jlibbig.core.std.Point;
import it.uniud.mads.jlibbig.core.std.Root;
import it.uniud.mads.jlibbig.core.std.Signature;
import it.uniud.mads.jlibbig.core.std.Site;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BigraphBuilder
implements it.uniud.mads.jlibbig.core.BigraphBuilder<Control>,
Cloneable {
    private static final boolean DEBUG_CONSISTENCY_CHECK = Boolean.getBoolean("it.uniud.mads.jlibbig.consistency") || Boolean.getBoolean("it.uniud.mads.jlibbig.consistency.bigraphops");
    private Bigraph big;
    private boolean closed = false;

    public BigraphBuilder(Signature sig) {
        this.big = Bigraph.makeEmpty(sig);
    }

    public BigraphBuilder(Bigraph big) {
        this(big, false);
    }

    public BigraphBuilder(Bigraph big, boolean reuse) {
        if (big == null) {
            throw new IllegalArgumentException("Argument can not be null.");
        }
        if (!big.isConsistent()) {
            throw new IllegalArgumentException("Inconsistent bigraph.");
        }
        this.big = reuse ? big.setOwner(this) : big.clone(this);
    }

    public String toString() {
        this.assertOpen();
        return this.big.toString();
    }

    public Bigraph makeBigraph() {
        return this.makeBigraph(false);
    }

    public Bigraph makeBigraph(boolean close) {
        Bigraph b;
        this.assertOpen();
        this.assertConsistency();
        if (close) {
            b = this.big.setOwner(this.big);
            this.closed = true;
        } else {
            b = this.big.clone();
            if (DEBUG_CONSISTENCY_CHECK && !b.isConsistent()) {
                throw new RuntimeException("Inconsistent bigraph.");
            }
        }
        return b;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void assertOpen() throws UnsupportedOperationException {
        if (this.closed) {
            throw new UnsupportedOperationException("The operation is not supported by a closed BigraphBuilder");
        }
    }

    public BigraphBuilder clone() {
        this.assertOpen();
        BigraphBuilder bb = new BigraphBuilder(this.big.getSignature());
        bb.big = this.big.clone(bb);
        return bb;
    }

    public Signature getSignature() {
        this.assertOpen();
        return this.big.getSignature();
    }

    @Override
    public boolean isEmpty() {
        this.assertOpen();
        return this.big.isEmpty();
    }

    @Override
    public boolean isGround() {
        this.assertOpen();
        return this.big.isGround();
    }

    @Override
    public List<? extends Root> getRoots() {
        this.assertOpen();
        return this.big.getRoots();
    }

    @Override
    public List<? extends Site> getSites() {
        this.assertOpen();
        return this.big.getSites();
    }

    @Override
    public Collection<? extends OuterName> getOuterNames() {
        this.assertOpen();
        return this.big.getOuterNames();
    }

    public boolean containsOuterName(String name) {
        this.assertOpen();
        return this.big.outers.containsKey(name);
    }

    @Override
    public Collection<? extends InnerName> getInnerNames() {
        this.assertOpen();
        return this.big.getInnerNames();
    }

    public boolean containsInnerName(String name) {
        this.assertOpen();
        return this.big.inners.containsKey(name);
    }

    @Override
    public Collection<? extends Node> getNodes() {
        this.assertOpen();
        return this.big.getNodes();
    }

    @Override
    public Collection<? extends Edge> getEdges() {
        this.assertOpen();
        return this.big.getEdges();
    }

    public Root addRoot() {
        this.assertOpen();
        EditableRoot r = new EditableRoot();
        r.setOwner(this);
        this.big.roots.add(r);
        this.assertConsistency();
        return r;
    }

    public Root addRoot(int index) {
        this.assertOpen();
        EditableRoot r = new EditableRoot();
        r.setOwner(this);
        this.big.roots.add(index, r);
        this.assertConsistency();
        return r;
    }

    public Site addSite(Parent parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument can not be null.");
        }
        this.assertOpen();
        this.assertOwner(parent, "Parent");
        EditableSite s = new EditableSite((EditableParent)parent);
        this.big.sites.add(s);
        this.assertConsistency();
        return s;
    }

    public Node addNode(String controlName, Parent parent) {
        return this.addNode(controlName, parent, new LinkedList<Handle>());
    }

    public Node addNode(String controlName, Parent parent, Handle ... handles) {
        if (controlName == null) {
            throw new IllegalArgumentException("Control name can not be null.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Parent can not be null.");
        }
        this.assertOpen();
        Control c = (Control)this.big.getSignature().getByName(controlName);
        if (c == null) {
            throw new IllegalArgumentException("Control should be in the signature.");
        }
        this.assertOwner(parent, "Parent");
        EditableHandle[] hs = new EditableHandle[c.getArity()];
        for (int i = 0; i < hs.length; ++i) {
            EditableHandle h = null;
            if (i < handles.length) {
                h = (EditableHandle)handles[i];
            }
            if (h != null) {
                this.assertOwner(h, "Handle");
            } else {
                EditableEdge e = new EditableEdge(this);
                this.big.onEdgeAdded(e);
                h = e;
            }
            hs[i] = h;
        }
        EditableNode n = new EditableNode(c, (EditableParent)parent, hs);
        this.big.onNodeAdded(n);
        this.assertConsistency();
        return n;
    }

    public Node addNode(String controlName, Parent parent, List<Handle> handles) {
        if (controlName == null) {
            throw new IllegalArgumentException("Control name can not be null.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Parent can not be null.");
        }
        this.assertOpen();
        Control c = (Control)this.big.getSignature().getByName(controlName);
        if (c == null) {
            throw new IllegalArgumentException("Control should be in the signature.");
        }
        this.assertOwner(parent, "Parent");
        int ar = c.getArity();
        ArrayList<EditableHandle> hs = new ArrayList<EditableHandle>(ar);
        Iterator<Handle> hi = handles == null ? null : handles.iterator();
        for (int i = 0; i < ar; ++i) {
            EditableHandle h = null;
            if (hi != null && hi.hasNext()) {
                h = (EditableHandle)hi.next();
            }
            if (h != null) {
                this.assertOwner(h, "Handle");
            } else {
                EditableEdge e = new EditableEdge(this);
                this.big.onEdgeAdded(e);
                h = e;
            }
            hs.add(h);
        }
        EditableNode n = new EditableNode(c, (EditableParent)parent, hs);
        this.big.onNodeAdded(n);
        this.assertConsistency();
        return n;
    }

    public OuterName addOuterName() {
        return this.addOuterName(new EditableOuterName());
    }

    public OuterName addOuterName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Argument can not be null.");
        }
        return this.addOuterName(new EditableOuterName(name));
    }

    private OuterName addOuterName(EditableOuterName name) {
        this.assertOpen();
        if (this.big.outers.containsKey(name.getName())) {
            throw new IllegalArgumentException("Name '" + name.getName() + "' already present.");
        }
        name.setOwner(this);
        this.big.outers.put(name.getName(), name);
        this.assertConsistency();
        return name;
    }

    public InnerName addInnerName() {
        EditableEdge e = new EditableEdge(this);
        this.big.onEdgeAdded(e);
        return this.addInnerName(new EditableInnerName(), e);
    }

    public InnerName addInnerName(Handle handle) {
        Owner o = handle.getOwner();
        this.assertOrSetOwner(handle, "Handle");
        if (handle.isEdge() && o != null) {
            this.big.onEdgeAdded((EditableEdge)handle);
        }
        return this.addInnerName(new EditableInnerName(), (EditableHandle)handle);
    }

    public InnerName addInnerName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name can not be null.");
        }
        EditableEdge e = new EditableEdge(this);
        this.big.onEdgeAdded(e);
        return this.addInnerName(name, (Handle)e);
    }

    public InnerName addInnerName(String name, Handle handle) {
        if (name == null) {
            throw new IllegalArgumentException("Name can not be null.");
        }
        Owner o = handle.getOwner();
        this.assertOrSetOwner(handle, "Handle");
        if (handle.isEdge() && o != null) {
            this.big.onEdgeAdded((EditableEdge)handle);
        }
        return this.addInnerName(new EditableInnerName(name), (EditableHandle)handle);
    }

    private InnerName addInnerName(EditableInnerName n, EditableHandle h) {
        this.assertOpen();
        if (this.big.inners.containsKey(n.getName())) {
            throw new IllegalArgumentException("Name already present.");
        }
        n.setHandle(h);
        this.big.inners.put(n.getName(), n);
        this.assertConsistency();
        return n;
    }

    public Edge relink(Point ... points) {
        return (Edge)this.relink((Handle)new EditableEdge(), points);
    }

    public Edge relink(Collection<? extends Point> points) {
        if (points == null) {
            throw new IllegalArgumentException("Argument can not be null.");
        }
        return this.relink(points.toArray(new EditablePoint[points.size()]));
    }

    public Handle relink(Handle handle, Point ... points) {
        int i;
        this.assertOpen();
        this.assertOrSetOwner(handle, "Handle");
        EditablePoint[] ps = new EditablePoint[points.length];
        EditableHandle h = (EditableHandle)handle;
        for (i = 0; i < points.length; ++i) {
            ps[i] = (EditablePoint)points[i];
            this.assertOwner(ps[i], "Point");
        }
        for (i = 0; i < points.length; ++i) {
            EditableHandle old = ps[i].getHandle();
            ps[i].setHandle(h);
            if (!old.isEdge() || !old.getPoints().isEmpty()) continue;
            this.big.onEdgeRemoved((EditableEdge)old);
        }
        if (handle.isEdge()) {
            this.big.onEdgeAdded((EditableEdge)handle);
        }
        this.assertConsistency();
        return h;
    }

    public Handle relink(Handle handle, Collection<? extends Point> points) {
        if (points == null) {
            throw new IllegalArgumentException("Argument can not be null.");
        }
        return this.relink(handle, (Point[])points.toArray(new EditablePoint[points.size()]));
    }

    public Edge unlink(Point point) {
        return this.relink(point);
    }

    public Edge closeOuterName(String name) {
        return this.closeOuterName(this.big.outers.get(name));
    }

    public Edge closeOuterName(OuterName name) {
        this.assertOwner(name, "OuterName ");
        if (!this.big.outers.containsKey(name.getName())) {
            throw new IllegalArgumentException("Name '" + name.getName() + "' not present.");
        }
        EditableOuterName n1 = (EditableOuterName)name;
        Edge e = this.relink(n1.getEditablePoints());
        this.big.outers.remove(n1.getName());
        n1.setOwner(null);
        return e;
    }

    public void closeInnerName(String name) {
        this.closeInnerName(this.big.inners.get(name));
    }

    public void closeInnerName(InnerName name) {
        this.assertOwner(name, "InnerName ");
        if (!this.big.inners.containsKey(name.getName())) {
            throw new IllegalArgumentException("Name '" + name.getName() + "' not present.");
        }
        EditableInnerName n1 = (EditableInnerName)name;
        EditableHandle h = n1.getHandle();
        n1.setHandle(null);
        this.big.inners.remove(n1.getName());
        if (h.isEdge() && h.getPoints().isEmpty()) {
            this.big.onEdgeRemoved((EditableEdge)h);
        }
    }

    public void renameOuterName(String oldName, String newName) {
        if (newName == null || oldName == null) {
            throw new IllegalArgumentException("Arguments can not be null");
        }
        EditableOuterName n1 = this.big.outers.get(oldName);
        if (n1 == null) {
            throw new IllegalArgumentException("Name '" + oldName + "' is not present.");
        }
        this.renameOuterName(n1, newName);
    }

    public void renameOuterName(OuterName oldName, String newName) {
        if (newName == null || oldName == null) {
            throw new IllegalArgumentException("Arguments can not be null");
        }
        this.assertOwner(oldName, "OuterName ");
        if (newName.equals(oldName.getName())) {
            return;
        }
        EditableOuterName n2 = this.big.outers.get(newName);
        if (n2 != null) {
            throw new IllegalArgumentException("Name '" + newName + "' already in use");
        }
        ((EditableOuterName)oldName).setName(newName);
    }

    public void renameInnerName(String oldName, String newName) {
        if (newName == null || oldName == null) {
            throw new IllegalArgumentException("Arguments can not be null");
        }
        EditableInnerName n1 = this.big.inners.get(oldName);
        if (n1 == null) {
            throw new IllegalArgumentException("Name '" + oldName + "' is not present.");
        }
        this.renameInnerName(n1, newName);
    }

    public void renameInnerName(InnerName oldName, String newName) {
        if (newName == null || oldName == null) {
            throw new IllegalArgumentException("Arguments can not be null");
        }
        this.assertOwner(oldName, "InnerName ");
        if (newName.equals(oldName.getName())) {
            return;
        }
        EditableInnerName n2 = this.big.inners.get(newName);
        if (n2 != null) {
            throw new IllegalArgumentException("Name '" + newName + "' is present already.");
        }
        ((EditableInnerName)oldName).setName(newName);
    }

    public Root merge() {
        this.assertOpen();
        EditableRoot r = new EditableRoot();
        r.setOwner(this);
        for (EditableParent editableParent : this.big.roots) {
            for (EditableChild c : new HashSet<EditableChild>(editableParent.getEditableChildren())) {
                c.setParent(r);
            }
        }
        BigraphBuilder.clearOwnedCollection(this.big.roots);
        this.big.roots.add(r);
        this.assertConsistency();
        return r;
    }

    public Root merge(int index, int ... roots) {
        this.assertOpen();
        EditableRoot r = new EditableRoot();
        r.setOwner(this);
        EditableRoot[] rs = new EditableRoot[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            rs[i] = this.big.roots.get(roots[i]);
            Iterator ir = rs[i].getEditableChildren().iterator();
            while (ir.hasNext()) {
                ((EditableChild)ir.next()).setParent(r);
            }
        }
        for (EditableRoot r1 : rs) {
            this.big.roots.remove(r1);
            r1.setOwner(null);
        }
        this.big.roots.add(index, r);
        this.assertConsistency();
        return r;
    }

    public void removeRoot(Root root) {
        this.assertOwner(root, "Root ");
        if (!root.getChildren().isEmpty()) {
            throw new IllegalArgumentException("Unempty region.");
        }
        EditableRoot editableRoot = (EditableRoot)root;
        editableRoot.setOwner(null);
        this.big.roots.remove(editableRoot);
        if (!root.getChildren().isEmpty()) {
            this.big.onNodeSetChanged();
        }
        this.assertConsistency();
    }

    public void removeRoot(int index) {
        if (index < 0 || index >= this.big.roots.size()) {
            throw new IndexOutOfBoundsException("The argument does not refer to a root.");
        }
        this.removeRoot(this.big.roots.get(index));
    }

    public void closeSite(Site site) {
        this.assertOwner(site, "Site ");
        EditableSite editableSite = (EditableSite)site;
        editableSite.setParent(null);
        this.big.sites.remove(editableSite);
        this.assertConsistency();
    }

    public void closeSite(int index) {
        if (index < 0 || index >= this.big.sites.size()) {
            throw new IndexOutOfBoundsException("The argument does not refer to a site.");
        }
        this.closeSite(this.big.sites.get(index));
    }

    public void ground() {
        this.assertOpen();
        BigraphBuilder.clearChildCollection(this.big.sites);
        BigraphBuilder.clearInnerMap(this.big.inners);
        this.assertConsistency();
    }

    public void leftJuxtapose(Bigraph graph) {
        this.leftJuxtapose(graph, false);
    }

    public void leftJuxtapose(Bigraph graph, boolean reuse) {
        this.assertOpen();
        Bigraph left = graph;
        Bigraph right = this.big;
        if (left == right) {
            throw new IllegalArgumentException("Operand shuld be distinct; a bigraph can not be juxtaposed with itself.");
        }
        if (!left.signature.equals(right.signature)) {
            throw new IncompatibleSignatureException(left.getSignature(), right.getSignature());
        }
        if (!Collections.disjoint(left.inners.keySet(), right.inners.keySet()) || !Collections.disjoint(left.outers.keySet(), right.outers.keySet())) {
            throw new IncompatibleInterfaceException(new NameClashException(BigraphBuilder.intersectNames(left.inners.values(), right.inners.values(), BigraphBuilder.intersectNames(left.outers.values(), right.outers.values()))));
        }
        Bigraph l = reuse ? left : left.clone();
        Bigraph r = right;
        for (EditableOwned editableOwned : l.roots) {
            editableOwned.setOwner(this);
        }
        for (EditableOwned editableOwned : l.outers.values()) {
            editableOwned.setOwner(this);
        }
        Collection<EditableEdge> es = l.edgesProxy.get();
        for (EditableEdge e : es) {
            e.setOwner(this);
        }
        r.onEdgeAdded(es);
        r.onNodeAdded(l.nodesProxy.get());
        l.onEdgeSetChanged();
        l.onNodeSetChanged();
        r.roots.addAll(0, l.roots);
        r.sites.addAll(0, l.sites);
        r.outers.putAll(l.outers);
        r.inners.putAll(l.inners);
        this.assertConsistency();
    }

    public void rightJuxtapose(Bigraph graph) {
        this.rightJuxtapose(graph, false);
    }

    public void rightJuxtapose(Bigraph graph, boolean reuse) {
        this.assertOpen();
        Bigraph left = this.big;
        Bigraph right = graph;
        if (left == right) {
            throw new IllegalArgumentException("Operand shuld be distinct; a bigraph can not be juxtaposed with itself.");
        }
        if (!left.signature.equals(right.signature)) {
            throw new IncompatibleSignatureException(left.signature, right.signature);
        }
        if (!Collections.disjoint(left.inners.keySet(), right.inners.keySet()) || !Collections.disjoint(left.outers.keySet(), right.outers.keySet())) {
            throw new IncompatibleInterfaceException(new NameClashException(BigraphBuilder.intersectNames(left.inners.values(), right.inners.values(), BigraphBuilder.intersectNames(left.outers.values(), right.outers.values()))));
        }
        Bigraph l = left;
        Bigraph r = reuse ? right : right.clone();
        for (EditableOwned editableOwned : r.roots) {
            editableOwned.setOwner(this);
        }
        for (EditableOwned editableOwned : r.outers.values()) {
            editableOwned.setOwner(this);
        }
        Collection<EditableEdge> es = r.edgesProxy.get();
        for (EditableEdge e : es) {
            e.setOwner(this);
        }
        l.onEdgeAdded(es);
        l.onNodeAdded(r.nodesProxy.get());
        r.onEdgeSetChanged();
        r.onNodeSetChanged();
        l.roots.addAll(r.roots);
        l.sites.addAll(r.sites);
        l.outers.putAll(r.outers);
        l.inners.putAll(r.inners);
        this.assertConsistency();
    }

    public void innerCompose(Bigraph graph) {
        this.innerCompose(graph, false);
    }

    public void innerCompose(Bigraph graph, boolean reuse) {
        this.assertOpen();
        Bigraph in = graph;
        Bigraph out = this.big;
        if (out == in) {
            throw new IllegalArgumentException("Operand shuld be distinct; a bigraph can not be composed with itself.");
        }
        if (!out.signature.equals(in.signature)) {
            throw new IncompatibleSignatureException(out.signature, in.signature);
        }
        HashSet<String> xs = new HashSet<String>(out.inners.keySet());
        HashSet<String> ys = new HashSet<String>(in.outers.keySet());
        HashSet<String> zs = new HashSet<String>(xs);
        xs.removeAll(ys);
        ys.removeAll(zs);
        if (!xs.isEmpty() || !ys.isEmpty() || out.sites.size() != in.roots.size()) {
            throw new IncompatibleInterfaceException("The outer face of the first graph must be equal to inner face of the second");
        }
        Bigraph a = out;
        Bigraph b = reuse ? in : in.clone();
        Collection<EditableEdge> es = b.edgesProxy.get();
        Collection<EditableNode> ns = b.nodesProxy.get();
        Iterator<EditableRoot> ir = b.roots.iterator();
        Iterator<EditableSite> is = a.sites.iterator();
        while (ir.hasNext()) {
            EditableSite s = is.next();
            EditableParent p = s.getParent();
            p.removeChild(s);
            for (EditableChild c : new HashSet(ir.next().getEditableChildren())) {
                c.setParent(p);
            }
        }
        HashMap<String, EditableHandle> a_inners = new HashMap<String, EditableHandle>();
        for (EditableInnerName i : a.inners.values()) {
            a_inners.put(i.getName(), i.getHandle());
            i.setHandle(null);
        }
        for (EditableOuterName o : b.outers.values()) {
            EditableHandle h = (EditableHandle)a_inners.get(o.getName());
            for (EditablePoint p : new HashSet<EditablePoint>(o.getEditablePoints())) {
                p.setHandle(h);
            }
        }
        BigraphBuilder.clearInnerMap(a.inners);
        BigraphBuilder.clearChildCollection(a.sites);
        a.inners.putAll(b.inners);
        a.sites.addAll(b.sites);
        a.onNodeAdded(ns);
        b.onNodeSetChanged();
        for (EditableEdge e : es) {
            e.setOwner(this);
        }
        a.onEdgeAdded(es);
        b.onEdgeSetChanged();
        this.assertConsistency();
    }

    public void outerCompose(Bigraph graph) {
        this.outerCompose(graph, false);
    }

    public void outerCompose(Bigraph graph, boolean reuse) {
        EditableHandle h;
        this.assertOpen();
        Bigraph in = this.big;
        Bigraph out = graph;
        if (out == in) {
            throw new IllegalArgumentException("Operand shuld be distinct; a bigraph can not be composed with itself.");
        }
        if (!out.signature.equals(in.signature)) {
            throw new IncompatibleSignatureException(out.signature, in.signature);
        }
        HashSet<String> xs = new HashSet<String>(out.inners.keySet());
        HashSet<String> ys = new HashSet<String>(in.outers.keySet());
        HashSet<String> zs = new HashSet<String>(xs);
        xs.removeAll(ys);
        ys.removeAll(zs);
        if (!xs.isEmpty() || !ys.isEmpty() || out.sites.size() != in.roots.size()) {
            throw new IncompatibleInterfaceException("The outer face of the first graph must be equal to inner face of the second");
        }
        Bigraph a = reuse ? out : out.clone();
        Bigraph b = in;
        Collection<EditableEdge> es = a.edgesProxy.get();
        Collection<EditableNode> ns = a.nodesProxy.get();
        Iterator<EditableRoot> ir = b.roots.iterator();
        Iterator<EditableSite> is = a.sites.iterator();
        while (ir.hasNext()) {
            EditableSite s = is.next();
            EditableParent p = s.getParent();
            p.removeChild(s);
            for (EditableChild c : new HashSet(ir.next().getEditableChildren())) {
                c.setParent(p);
            }
        }
        HashMap<String, EditableHandle> a_inners = new HashMap<String, EditableHandle>(a.inners.size());
        for (EditableInnerName editableInnerName : a.inners.values()) {
            h = editableInnerName.getHandle();
            a_inners.put(editableInnerName.getName(), h);
            editableInnerName.setHandle(null);
        }
        for (EditableOuterName editableOuterName : b.outers.values()) {
            h = (EditableHandle)a_inners.get(editableOuterName.getName());
            for (EditablePoint p : new HashSet<EditablePoint>(editableOuterName.getEditablePoints())) {
                p.setHandle(h);
            }
        }
        BigraphBuilder.clearOuterMap(b.outers);
        BigraphBuilder.clearOwnedCollection(b.roots);
        b.outers.putAll(a.outers);
        b.roots.addAll(a.roots);
        for (EditableOwned editableOwned : b.roots) {
            editableOwned.setOwner(this);
        }
        for (EditableOwned editableOwned : b.outers.values()) {
            editableOwned.setOwner(this);
        }
        b.onNodeAdded(ns);
        a.onNodeSetChanged();
        for (EditableEdge editableEdge : es) {
            editableEdge.setOwner(this);
        }
        b.onEdgeAdded(es);
        a.onEdgeSetChanged();
        this.assertConsistency();
    }

    public void innerNest(Bigraph graph) {
        this.innerNest(graph, false);
    }

    public void innerNest(Bigraph graph, boolean reuse) {
        this.assertOpen();
        Bigraph in = graph;
        Bigraph out = this.big;
        if (out == in) {
            throw new IllegalArgumentException("Operand shuld be distinct; a bigraph can not be composed with itself.");
        }
        if (!out.signature.equals(in.signature)) {
            throw new IncompatibleSignatureException(out.signature, in.signature);
        }
        if (!out.inners.isEmpty() || out.sites.size() != in.roots.size()) {
            throw new IncompatibleInterfaceException();
        }
        HashMap<String, EditableOuterName> nmap = new HashMap<String, EditableOuterName>();
        for (EditableOuterName o : out.outers.values()) {
            nmap.put(o.getName(), o);
        }
        for (EditableOuterName o : in.outers.values()) {
            EditableOuterName p = (EditableOuterName)nmap.get(o.getName());
            if (p == null) {
                p = (EditableOuterName)this.addOuterName(o.getName());
            }
            this.addInnerName(o.getName(), (Handle)p);
        }
        this.innerCompose(in, reuse);
    }

    public void outerNest(Bigraph graph) {
        this.outerNest(graph, false);
    }

    public void outerNest(Bigraph graph, boolean reuse) {
        this.assertOpen();
        Bigraph in = this.big;
        Bigraph out = graph;
        if (out == in) {
            throw new IllegalArgumentException("Operand shuld be distinct; a bigraph can not be composed with itself.");
        }
        if (!out.signature.equals(in.signature)) {
            throw new IncompatibleSignatureException(out.signature, in.signature);
        }
        if (!out.inners.isEmpty() || out.sites.size() != in.roots.size()) {
            throw new IncompatibleInterfaceException();
        }
        if (reuse) {
            out = out.clone();
        }
        HashMap<String, EditableOuterName> nmap = new HashMap<String, EditableOuterName>();
        for (EditableOuterName o : out.outers.values()) {
            nmap.put(o.getName(), o);
        }
        for (EditableOuterName o : in.outers.values()) {
            EditableOuterName p = (EditableOuterName)nmap.get(o.getName());
            if (p == null) {
                p = new EditableOuterName(o.getName());
                p.setOwner(out);
                out.outers.put(p.getName(), p);
            }
            EditableInnerName i = new EditableInnerName(p.getName());
            i.setHandle(p);
            out.inners.put(i.getName(), i);
        }
        this.outerCompose(out, false);
    }

    public void leftParallelProduct(Bigraph graph) {
        this.leftParallelProduct(graph, false);
    }

    public void leftParallelProduct(Bigraph graph, boolean reuse) {
        this.assertOpen();
        Bigraph left = graph;
        Bigraph right = this.big;
        if (!left.signature.equals(right.signature)) {
            throw new IncompatibleSignatureException(left.signature, right.signature);
        }
        if (!Collections.disjoint(left.inners.keySet(), right.inners.keySet())) {
            throw new IncompatibleInterfaceException(new NameClashException(BigraphBuilder.intersectNames(left.inners.values(), right.inners.values())));
        }
        Bigraph l = reuse ? left : left.clone();
        Bigraph r = right;
        for (EditableOwned editableOwned : l.roots) {
            editableOwned.setOwner(this);
        }
        HashMap<String, EditableOuterName> os = new HashMap<String, EditableOuterName>();
        for (EditableOuterName o : l.outers.values()) {
            EditableOuterName q = null;
            for (EditableOuterName editableOuterName : r.outers.values()) {
                if (!editableOuterName.getName().equals(o.getName())) continue;
                q = editableOuterName;
                break;
            }
            if (q == null) {
                os.put(o.getName(), o);
                o.setOwner(this);
                continue;
            }
            for (EditablePoint editablePoint : new HashSet<EditablePoint>(o.getEditablePoints())) {
                q.linkPoint(editablePoint);
            }
        }
        Collection<EditableEdge> collection = l.edgesProxy.get();
        for (EditableEdge e : collection) {
            e.setOwner(this);
        }
        r.onEdgeAdded(collection);
        r.onNodeAdded(l.nodesProxy.get());
        l.onEdgeSetChanged();
        l.onNodeSetChanged();
        r.roots.addAll(l.roots);
        r.sites.addAll(l.sites);
        r.outers.putAll(os);
        r.inners.putAll(l.inners);
        this.assertConsistency();
    }

    public void rightParallelProduct(Bigraph graph) {
        this.rightParallelProduct(graph, false);
    }

    public void rightParallelProduct(Bigraph graph, boolean reuse) {
        this.assertOpen();
        Bigraph left = this.big;
        Bigraph right = graph;
        if (left == right) {
            throw new IllegalArgumentException("Operand shuld be distinct; a bigraph can not be juxtaposed with itself.");
        }
        if (!left.signature.equals(right.signature)) {
            throw new IncompatibleSignatureException(left.signature, right.signature);
        }
        if (!Collections.disjoint(left.inners.keySet(), right.inners.keySet())) {
            throw new IncompatibleInterfaceException(new NameClashException(BigraphBuilder.intersectNames(left.inners.values(), right.inners.values())));
        }
        Bigraph l = left;
        Bigraph r = reuse ? right : right.clone();
        for (EditableOwned editableOwned : r.roots) {
            editableOwned.setOwner(this);
        }
        HashMap<String, EditableOuterName> os = new HashMap<String, EditableOuterName>();
        for (EditableOuterName o : r.outers.values()) {
            EditableOuterName q = null;
            for (EditableOuterName editableOuterName : l.outers.values()) {
                if (!editableOuterName.getName().equals(o.getName())) continue;
                q = editableOuterName;
                break;
            }
            if (q == null) {
                os.put(o.getName(), o);
                o.setOwner(this);
                continue;
            }
            for (EditablePoint editablePoint : new HashSet<EditablePoint>(o.getEditablePoints())) {
                q.linkPoint(editablePoint);
            }
        }
        Collection<EditableEdge> collection = r.edgesProxy.get();
        for (EditableEdge e : collection) {
            e.setOwner(this);
        }
        l.onEdgeAdded(collection);
        l.onNodeAdded(r.nodesProxy.get());
        r.onEdgeSetChanged();
        r.onNodeSetChanged();
        l.roots.addAll(r.roots);
        l.sites.addAll(r.sites);
        l.outers.putAll(os);
        l.inners.putAll(r.inners);
        this.assertConsistency();
    }

    public void leftMergeProduct(Bigraph graph) {
        this.leftMergeProduct(graph, false);
    }

    public void leftMergeProduct(Bigraph graph, boolean reuse) {
        this.leftJuxtapose(graph, reuse);
        this.merge();
    }

    public void rightMergeProduct(Bigraph graph) {
        this.rightMergeProduct(graph, false);
    }

    public void rightMergeProduct(Bigraph graph, boolean reuse) {
        this.rightJuxtapose(graph, reuse);
        this.merge();
    }

    private void assertConsistency() {
        if (DEBUG_CONSISTENCY_CHECK && !this.big.isConsistent(this)) {
            throw new RuntimeException("Inconsistent bigraph.");
        }
    }

    private void assertOwner(Owned owned, String obj) {
        if (owned == null) {
            throw new IllegalArgumentException(obj + " can not be null.");
        }
        Owner o = owned.getOwner();
        if (o != this) {
            throw new UnexpectedOwnerException(obj + " should be owned by this structure.");
        }
    }

    private void assertOrSetOwner(Owned owned, String obj) {
        if (owned == null) {
            throw new IllegalArgumentException(obj + " can not be null.");
        }
        Owner o = owned.getOwner();
        if (o == null) {
            ((EditableOwned)owned).setOwner(this);
        } else if (o != this) {
            throw new UnexpectedOwnerException(obj + " already owned by an other structure.");
        }
    }

    private static Collection<String> intersectNames(Collection<? extends LinkFacet> arg0, Collection<? extends LinkFacet> arg1) {
        return BigraphBuilder.intersectNames(arg0, arg1, new HashSet<String>());
    }

    private static Collection<String> intersectNames(Collection<? extends LinkFacet> arg0, Collection<? extends LinkFacet> arg1, Collection<String> ns0) {
        HashSet<String> ns1 = new HashSet<String>();
        for (LinkFacet linkFacet : arg0) {
            ns1.add(linkFacet.getName());
        }
        for (LinkFacet linkFacet : arg1) {
            String s = linkFacet.getName();
            if (!ns1.contains(s)) continue;
            ns0.add(s);
            ns1.remove(s);
        }
        return ns0;
    }

    private static void clearOwnedCollection(Collection<? extends EditableOwned> col) {
        for (EditableOwned editableOwned : col) {
            editableOwned.setOwner(null);
        }
        col.clear();
    }

    private static void clearChildCollection(Collection<? extends EditableChild> col) {
        for (EditableChild editableChild : col) {
            editableChild.setParent(null);
        }
        col.clear();
    }

    private static void clearOuterMap(Map<String, EditableOuterName> map) {
        Iterator<EditableOuterName> ir = map.values().iterator();
        while (ir.hasNext()) {
            ir.next().setOwner(null);
        }
        map.clear();
    }

    private static void clearInnerMap(Map<String, EditableInnerName> map) {
        Iterator<EditableInnerName> ir = map.values().iterator();
        while (ir.hasNext()) {
            ir.next().setHandle(null);
        }
        map.clear();
    }
}

