/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.std;

import it.uniud.mads.jlibbig.core.attachedProperties.Property;
import it.uniud.mads.jlibbig.core.attachedProperties.PropertyContainer;
import it.uniud.mads.jlibbig.core.attachedProperties.PropertyTarget;
import it.uniud.mads.jlibbig.core.util.NameGenerator;
import java.util.Collection;
import java.util.Iterator;

public final class Control
extends it.uniud.mads.jlibbig.core.Control
implements PropertyTarget {
    private final boolean active;
    private final PropertyContainer props;
    String _tostring;

    public Control(boolean active, int arity) {
        this("C_" + NameGenerator.DEFAULT.generate(), active, arity);
    }

    public Control(String name, boolean active, int arity) {
        super(name, arity);
        this.active = active;
        this.props = new PropertyContainer(this);
    }

    public final boolean isActive() {
        return this.active;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.getArity();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Control other = (Control)obj;
        return this.getArity() == other.getArity() && super.getName().equals(other.getName());
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean includeProperties) {
        StringBuilder builder = null;
        if (this._tostring == null) {
            builder = new StringBuilder();
            builder.append(this.getName()).append(":(").append(this.getArity()).append(this.active ? ",a)" : ",p)");
            this._tostring = builder.toString();
        }
        if (includeProperties) {
            Collection<Property<?>> ps = this.props.getProperties();
            if (ps.isEmpty()) {
                return this._tostring;
            }
            if (builder == null) {
                builder = new StringBuilder(this._tostring);
            }
            builder.append(" [");
            Iterator<Property<?>> ip = ps.iterator();
            while (ip.hasNext()) {
                Property<?> p = ip.next();
                builder.append(p.getName()).append('=').append(p.get());
                if (ip.hasNext()) {
                    builder.append("; ");
                    continue;
                }
                builder.append(']');
            }
            return builder.toString();
        }
        return this._tostring;
    }

    @Override
    public Property<?> attachProperty(Property<?> prop) {
        return this.props.attachProperty(prop);
    }

    @Override
    public <V> Property<V> detachProperty(Property<V> prop) {
        return this.props.detachProperty(prop);
    }

    @Override
    public <V> Property<V> detachProperty(String name) {
        return this.props.detachProperty(name);
    }

    @Override
    public <V> Property<V> getProperty(String name) {
        return this.props.getProperty(name);
    }

    @Override
    public Collection<Property<?>> getProperties() {
        return this.props.getProperties();
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.props.getPropertyNames();
    }
}

