/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.std;

import it.uniud.mads.jlibbig.core.Owner;
import it.uniud.mads.jlibbig.core.attachedProperties.DelegatedProperty;
import it.uniud.mads.jlibbig.core.attachedProperties.Property;
import it.uniud.mads.jlibbig.core.attachedProperties.PropertyContainer;
import it.uniud.mads.jlibbig.core.attachedProperties.PropertyListener;
import it.uniud.mads.jlibbig.core.attachedProperties.ReplicationListener;
import it.uniud.mads.jlibbig.core.attachedProperties.ReplicationListenerContainer;
import it.uniud.mads.jlibbig.core.std.Child;
import it.uniud.mads.jlibbig.core.std.Control;
import it.uniud.mads.jlibbig.core.std.EditableChild;
import it.uniud.mads.jlibbig.core.std.EditableHandle;
import it.uniud.mads.jlibbig.core.std.EditableParent;
import it.uniud.mads.jlibbig.core.std.EditablePoint;
import it.uniud.mads.jlibbig.core.std.EditableRoot;
import it.uniud.mads.jlibbig.core.std.Handle;
import it.uniud.mads.jlibbig.core.std.Node;
import it.uniud.mads.jlibbig.core.std.Port;
import it.uniud.mads.jlibbig.core.util.NameGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class EditableNode
implements Node,
EditableParent,
EditableChild {
    public static final String PROPERTY_OWNER = "Owner";
    private Control control;
    private final List<EditablePort> ports;
    private EditableParent parent;
    private Collection<EditableChild> children;
    private final List<? extends Port> ro_ports;
    private final Collection<? extends Child> ro_chd;
    private String name;
    private final DelegatedProperty.PropertySetter<Owner> ownerSetter;
    private final DelegatedProperty<Owner> ownerProp;
    private final ReplicationListenerContainer rep = new ReplicationListenerContainer(new ReplicationListener[0]);
    private final PropertyContainer props = new PropertyContainer(this);

    public EditableNode(Control control) {
        this.name = "N_" + NameGenerator.DEFAULT.generate();
        this.control = control;
        ArrayList<EditablePort> ports = new ArrayList<EditablePort>();
        for (int i = 0; i < control.getArity(); ++i) {
            ports.add(new EditablePort(i));
        }
        this.ports = Collections.unmodifiableList(ports);
        this.children = new HashSet<EditableChild>();
        this.ro_ports = Collections.unmodifiableList(this.ports);
        this.ro_chd = Collections.unmodifiableCollection(this.children);
        this.ownerSetter = new DelegatedProperty.PropertySetter();
        this.ownerProp = new DelegatedProperty<Owner>(PROPERTY_OWNER, true, this.ownerSetter, new PropertyListener[0]);
        this.props.attachProperty(this.ownerProp);
    }

    public EditableNode(Control control, EditableParent parent) {
        this(control);
        this.setParent(parent);
    }

    public EditableNode(Control control, EditableParent parent, List<? extends Handle> handles) {
        this(control, parent);
        for (int i = 0; i < Math.min(handles.size(), control.getArity()); ++i) {
            this.ports.get(i).setHandle((EditableHandle)handles.get(i));
        }
    }

    public EditableNode(Control control, EditableParent parent, EditableHandle ... handles) {
        this(control, parent);
        for (int i = 0; i < Math.min(handles.length, control.getArity()); ++i) {
            this.ports.get(i).setHandle(handles[i]);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name).append(':').append(this.control.getName());
        return builder.toString();
    }

    @Override
    public EditableParent getParent() {
        return this.parent;
    }

    @Override
    public Collection<? extends Child> getChildren() {
        return this.ro_chd;
    }

    @Override
    public List<? extends Port> getPorts() {
        return this.ro_ports;
    }

    public List<EditablePort> getPortsForEdit() {
        return this.ports;
    }

    @Override
    public EditablePort getPort(int index) {
        return this.ports.get(index);
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    @Override
    public void setParent(EditableParent parent) {
        if (this.parent != parent) {
            EditableParent old = this.parent;
            this.parent = parent;
            if (old != null) {
                old.removeChild(this);
            }
            if (parent != null) {
                parent.addChild(this);
                this.ownerSetter.set(parent.getProperty(PROPERTY_OWNER));
            }
        }
    }

    @Override
    public void addChild(EditableChild child) {
        if (child == null) {
            return;
        }
        this.children.add(child);
        if (this != child.getParent()) {
            child.setParent(this);
        }
    }

    @Override
    public void removeChild(EditableChild child) {
        if (child == null) {
            return;
        }
        this.children.remove(child);
        if (this == child.getParent()) {
            child.setParent(null);
        }
    }

    @Override
    public Collection<EditableChild> getEditableChildren() {
        return this.children;
    }

    @Override
    public EditableRoot getRoot() {
        return this.parent.getRoot();
    }

    @Override
    public EditableNode replicate() {
        EditableNode copy = new EditableNode(this.control);
        this.rep.tellReplicated(this, copy);
        return copy;
    }

    @Override
    public boolean isListenerRegistered(ReplicationListener listener) {
        return this.rep.isListenerRegistered(listener);
    }

    @Override
    public void registerListener(ReplicationListener listener) {
        this.rep.registerListener(listener);
    }

    @Override
    public boolean unregisterListener(ReplicationListener listener) {
        return this.rep.unregisterListener(listener);
    }

    @Override
    public Property<?> attachProperty(Property<?> prop) {
        if (prop == null) {
            throw new IllegalArgumentException("Argument can not be null.");
        }
        String name = prop.getName();
        if (PROPERTY_OWNER.equals(name)) {
            throw new IllegalArgumentException("Property '" + name + "' can not be substituted");
        }
        return this.props.attachProperty(prop);
    }

    @Override
    public <V> Property<V> detachProperty(Property<V> prop) {
        if (prop == null) {
            throw new IllegalArgumentException("Argument can not be null.");
        }
        return this.detachProperty(prop.getName());
    }

    @Override
    public <V> Property<V> detachProperty(String name) {
        if (PROPERTY_OWNER.equals(name)) {
            throw new IllegalArgumentException("Property '" + name + "' can not be detached");
        }
        return this.props.detachProperty(name);
    }

    @Override
    public <V> Property<V> getProperty(String name) {
        return this.props.getProperty(name);
    }

    @Override
    public Collection<Property<?>> getProperties() {
        return this.props.getProperties();
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.props.getPropertyNames();
    }

    @Override
    public Owner getOwner() {
        return this.ownerProp.get();
    }

    @Override
    public EditableNode getEditable() {
        return this;
    }

    @Override
    public boolean isParent() {
        return true;
    }

    @Override
    public boolean isChild() {
        return true;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isSite() {
        return false;
    }

    @Override
    public boolean isNode() {
        return true;
    }

    public int hashCode() {
        int prime = 41;
        int result = 1;
        result = 41 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public class EditablePort
    implements Port,
    EditablePoint {
        private final int number;
        private EditableHandle handle;

        private EditablePort(int number) {
            this.number = number;
        }

        @Override
        public EditableNode getNode() {
            return EditableNode.this;
        }

        public String toString() {
            return this.number + "@" + EditableNode.this;
        }

        @Override
        public int getNumber() {
            return this.number;
        }

        @Override
        public EditableHandle getHandle() {
            return this.handle;
        }

        @Override
        public void setHandle(EditableHandle handle) {
            if (this.handle == handle) {
                return;
            }
            EditableHandle old = this.handle;
            this.handle = null;
            if (old != null) {
                old.unlinkPoint(this);
            }
            this.handle = handle;
            if (handle != null) {
                handle.linkPoint(this);
            }
        }

        @Override
        public Owner getOwner() {
            return this.handle != null ? this.handle.getOwner() : EditableNode.this.getOwner();
        }

        @Override
        public EditablePort getEditable() {
            return this;
        }

        @Override
        public boolean isHandle() {
            return false;
        }

        @Override
        public boolean isPoint() {
            return true;
        }

        @Override
        public boolean isPort() {
            return true;
        }

        @Override
        public boolean isInnerName() {
            return false;
        }

        @Override
        public boolean isOuterName() {
            return false;
        }

        @Override
        public boolean isEdge() {
            return false;
        }
    }
}

