/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.std;

import it.uniud.mads.jlibbig.core.InstantiationRule;
import it.uniud.mads.jlibbig.core.exceptions.IncompatibleInterfaceException;
import it.uniud.mads.jlibbig.core.std.Bigraph;
import it.uniud.mads.jlibbig.core.std.EditableChild;
import it.uniud.mads.jlibbig.core.std.EditableHandle;
import it.uniud.mads.jlibbig.core.std.EditableInnerName;
import it.uniud.mads.jlibbig.core.std.EditableNode;
import it.uniud.mads.jlibbig.core.std.EditableOuterName;
import it.uniud.mads.jlibbig.core.std.EditableParent;
import it.uniud.mads.jlibbig.core.std.EditableRoot;
import it.uniud.mads.jlibbig.core.std.EditableSite;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;

public class InstantiationMap
implements InstantiationRule<Bigraph> {
    private static final boolean DEBUG_CONSISTENCY_CHECK = Boolean.getBoolean("it.uniud.mads.jlibbig.consistency") || Boolean.getBoolean("it.uniud.mads.jlibbig.consistency.reactions");
    private final int[] map;
    private final int dom;
    private final int cod;
    private final int[] multiplicity;

    public InstantiationMap(int codomain, int ... map) {
        this.dom = map.length;
        this.cod = codomain--;
        this.map = new int[this.dom];
        this.multiplicity = new int[this.cod];
        for (int i = 0; i < map.length; ++i) {
            int j;
            if (map[i] < 0 || map[i] > codomain) {
                throw new IllegalArgumentException("Invalid image");
            }
            this.map[i] = j = map[i];
            int n = j;
            this.multiplicity[n] = this.multiplicity[n] + 1;
        }
    }

    public int getPlaceDomain() {
        return this.dom;
    }

    public int getPlaceCodomain() {
        return this.cod;
    }

    public int getPlaceInstance(int arg) {
        if (-1 < arg && arg < this.dom) {
            return this.map[arg];
        }
        return -1;
    }

    public boolean isNeeded(int prm) {
        return -1 < prm && prm < this.cod && this.multiplicity[prm] > 0;
    }

    @Override
    public Iterable<Bigraph> instantiate(Bigraph parameters) {
        return this.instantiate(parameters, false);
    }

    /*
     * WARNING - void declaration
     */
    Iterable<Bigraph> instantiate(Bigraph parameters, boolean reuse) {
        if (parameters.roots.size() < this.cod) {
            throw new IncompatibleInterfaceException();
        }
        LinkedList<Bigraph> l = new LinkedList<Bigraph>();
        Bigraph prm = new Bigraph(parameters.signature);
        EditableRoot[] rs = new EditableRoot[this.dom];
        EditableSite[][] ss = new EditableSite[parameters.sites.size()][];
        HashMap<EditableHandle, EditableHandle> hnd_dic = new HashMap<EditableHandle, EditableHandle>();
        for (EditableOuterName o1 : parameters.outers.values()) {
            EditableOuterName o2 = reuse ? o1 : o1.replicate();
            prm.outers.put(o2.getName(), o2);
            o2.setOwner(prm);
            hnd_dic.put(o1, o2);
        }
        for (EditableInnerName i1 : parameters.inners.values()) {
            void var12_19;
            EditableInnerName i2 = reuse ? i1 : i1.replicate();
            EditableHandle h1 = i1.getHandle();
            EditableHandle editableHandle = (EditableHandle)hnd_dic.get(h1);
            if (editableHandle == null) {
                EditableHandle editableHandle2 = reuse ? h1 : h1.replicate();
                editableHandle2.setOwner(prm);
                hnd_dic.put(h1, editableHandle2);
            }
            i2.setHandle((EditableHandle)var12_19);
            prm.inners.put(i2.getName(), i2);
        }
        class VState {
            final EditableChild c;
            final EditableParent[] ps;

            VState(EditableParent[] ps, EditableChild c) {
                this.c = c;
                this.ps = ps;
            }
        }
        ArrayDeque<VState> q = new ArrayDeque<VState>();
        for (int j = 0; j < this.cod; ++j) {
            int m = this.multiplicity[j];
            if (m <= 0) continue;
            EditableRoot r1 = parameters.roots.get(j);
            EditableParent[] editableParentArray = new EditableRoot[m];
            int k = 0;
            for (int i = 0; i < this.dom; ++i) {
                if (this.map[i] != j) continue;
                rs[i] = reuse && k > 0 ? r1 : r1.replicate();
                editableParentArray[k] = rs[i];
                ++k;
            }
            for (EditableChild c : r1.getEditableChildren()) {
                q.add(new VState(editableParentArray, c));
            }
        }
        while (!q.isEmpty()) {
            void var12_30;
            VState s = (VState)q.poll();
            if (s.c.isNode()) {
                void var12_27;
                void var12_25;
                EditableNode n1 = (EditableNode)s.c;
                EditableParent[] n2s = new EditableNode[s.ps.length];
                boolean bl = false;
                while (var12_25 < n2s.length) {
                    n2s[var12_25] = reuse && var12_25 > 0 ? n1 : n1.replicate();
                    n2s[var12_25].setParent(s.ps[var12_25]);
                    ++var12_25;
                }
                int n = n1.getControl().getArity() - 1;
                while (false <= var12_27) {
                    EditableNode.EditablePort p1 = n1.getPort((int)var12_27);
                    EditableHandle h1 = p1.getHandle();
                    EditableHandle h2 = (EditableHandle)hnd_dic.get(h1);
                    if (h2 == null) {
                        h2 = reuse ? h1 : h1.replicate();
                        h2.setOwner(prm);
                        hnd_dic.put(h1, h2);
                    }
                    for (EditableParent n2 : n2s) {
                        ((EditableNode)n2).getPort((int)var12_27).setHandle(h2);
                    }
                    --var12_27;
                }
                for (EditableChild c : n1.getEditableChildren()) {
                    q.add(new VState(n2s, c));
                }
                continue;
            }
            EditableSite s1 = (EditableSite)s.c;
            EditableSite[] s2s = new EditableSite[s.ps.length];
            ss[parameters.sites.indexOf((Object)s1)] = s2s;
            boolean bl = false;
            while (var12_30 < s2s.length) {
                s2s[var12_30] = reuse && var12_30 > 0 ? s1 : s1.replicate();
                ++var12_30;
            }
        }
        for (EditableRoot editableRoot : rs) {
            prm.roots.add(editableRoot);
            editableRoot.setOwner(prm);
        }
        for (EditableRoot editableRoot : ss) {
            if (editableRoot == null) continue;
            prm.sites.addAll(Arrays.asList(editableRoot));
        }
        if (reuse) {
            parameters.sites.clear();
            parameters.roots.clear();
            parameters.inners.clear();
            parameters.outers.clear();
        }
        if (DEBUG_CONSISTENCY_CHECK && !prm.isConsistent()) {
            throw new RuntimeException("Inconsistent bigraph");
        }
        l.add(prm);
        return l;
    }
}

