/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.std;

import it.uniud.mads.jlibbig.core.AbstractMatch;
import it.uniud.mads.jlibbig.core.std.Bigraph;
import it.uniud.mads.jlibbig.core.std.EditableParent;
import it.uniud.mads.jlibbig.core.std.Node;
import it.uniud.mads.jlibbig.core.std.Signature;
import it.uniud.mads.jlibbig.core.util.BidMap;

public class Match
extends AbstractMatch<Bigraph> {
    protected Bigraph rdxImage;
    protected Bigraph rdxId;
    public BidMap<Node, Node> emb_nodes;
    public BidMap<EditableParent, EditableParent> ctxEmbMappping;

    protected Match(Bigraph context, Bigraph redexImage, Bigraph redexId, Bigraph param, BidMap<Node, Node> nodeEmbedding, BidMap<EditableParent, EditableParent> ctxEmbMappping) {
        super(context, null, param);
        Signature sig = context.signature;
        this.rdxImage = redexImage;
        this.rdxId = redexId != null ? redexId : Bigraph.makeEmpty(sig);
        this.emb_nodes = nodeEmbedding;
        this.ctxEmbMappping = ctxEmbMappping;
    }

    public Node getImage(Node node) {
        return this.emb_nodes.get(node);
    }

    public Node getPreImage(Node node) {
        return this.emb_nodes.getKey(node);
    }

    @Override
    public Bigraph getRedex() {
        if (this.redex == null) {
            this.redex = Bigraph.juxtapose(this.rdxImage, this.rdxId);
        }
        return (Bigraph)this.redex;
    }

    public Bigraph getRedexImage() {
        return this.rdxImage;
    }

    public Bigraph getRedexId() {
        return this.rdxId;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Match:\ncontext = ").append(this.context).append("\nredexImage = ").append(this.rdxImage).append("\nredexId = ").append(this.rdxId).append("\nparam = ").append(this.param);
        return builder.toString();
    }
}

