/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.std;

import it.uniud.mads.jlibbig.core.std.Bigraph;
import it.uniud.mads.jlibbig.core.std.Child;
import it.uniud.mads.jlibbig.core.std.Edge;
import it.uniud.mads.jlibbig.core.std.EditableEdge;
import it.uniud.mads.jlibbig.core.std.EditableHandle;
import it.uniud.mads.jlibbig.core.std.EditableInnerName;
import it.uniud.mads.jlibbig.core.std.EditableNode;
import it.uniud.mads.jlibbig.core.std.EditableOuterName;
import it.uniud.mads.jlibbig.core.std.EditableParent;
import it.uniud.mads.jlibbig.core.std.EditableRoot;
import it.uniud.mads.jlibbig.core.std.EditableSite;
import it.uniud.mads.jlibbig.core.std.Handle;
import it.uniud.mads.jlibbig.core.std.InnerName;
import it.uniud.mads.jlibbig.core.std.LinkEntity;
import it.uniud.mads.jlibbig.core.std.Match;
import it.uniud.mads.jlibbig.core.std.Node;
import it.uniud.mads.jlibbig.core.std.Parent;
import it.uniud.mads.jlibbig.core.std.PlaceEntity;
import it.uniud.mads.jlibbig.core.std.Point;
import it.uniud.mads.jlibbig.core.std.Port;
import it.uniud.mads.jlibbig.core.std.Root;
import it.uniud.mads.jlibbig.core.std.Site;
import it.uniud.mads.jlibbig.core.util.BidMap;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.expression.discrete.arithmetic.ArExpression;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;

public class Matcher
implements it.uniud.mads.jlibbig.core.Matcher<Bigraph, Bigraph> {
    private static final boolean DEBUG;
    private static final boolean DEBUG_PRINT_CSP_SOLUTIONS;
    private static final boolean DEBUG_PRINT_SOLUTION_FETCH;
    private static final boolean DEBUG_CONSISTENCY_CHECK;
    public static final Matcher DEFAULT;

    @Override
    public Iterable<? extends Match> match(Bigraph agent, Bigraph redex) {
        return new MatchIterable(agent, redex);
    }

    protected boolean areMatchable(Bigraph agent, Node fromAgent, Bigraph redex, Node fromRedex) {
        return fromAgent.getControl().equals(fromRedex.getControl());
    }

    static {
        DEBUG_PRINT_CSP_SOLUTIONS = DEBUG = Boolean.getBoolean("it.uniud.mads.jlibbig.debug") || Boolean.getBoolean("it.uniud.mads.jlibbig.debug.matchers");
        DEBUG_PRINT_SOLUTION_FETCH = DEBUG;
        DEBUG_CONSISTENCY_CHECK = Boolean.getBoolean("it.uniud.mads.jlibbig.consistency") || Boolean.getBoolean("it.uniud.mads.jlibbig.consistency.matchers");
        DEFAULT = new Matcher();
    }

    private class MatchIterable
    implements Iterable<Match> {
        final Bigraph agent;
        final Bigraph redex;
        final List<? extends Root> agent_roots;
        final List<? extends Site> agent_sites;
        final Collection<? extends Node> agent_nodes;
        final Collection<Port> agent_ports;
        final Collection<Point> agent_points;
        final Collection<? extends Edge> agent_edges;
        final List<Handle> agent_handles;
        final List<? extends Root> redex_roots;
        final List<? extends Site> redex_sites;
        final Collection<? extends Node> redex_nodes;
        final Collection<Point> redex_points;
        final Collection<? extends Edge> redex_edges;
        final List<Handle> redex_handles;
        final int ars;
        final int ans;
        final int ass;
        final int ahs;
        final int aps;
        final int aprs;
        final int rrs;
        final int rns;
        final int rss;
        final int rhs;
        final int rps;
        final int rprs;
        final int rins;

        private MatchIterable(Bigraph agent, Bigraph redex) {
            if (!agent.signature.equals(redex.signature)) {
                throw new UnsupportedOperationException("Agent and redex should have the same singature.");
            }
            this.agent = agent;
            this.redex = redex;
            this.agent_roots = agent.getRoots();
            this.agent_nodes = agent.getNodes();
            this.agent_sites = agent.getSites();
            this.agent_edges = agent.getEdges();
            this.agent_handles = new LinkedList<Edge>(this.agent_edges);
            this.agent_handles.addAll(agent.getOuterNames());
            this.ars = this.agent_roots.size();
            this.ans = this.agent_nodes.size();
            this.ass = this.agent_sites.size();
            this.ahs = this.agent_handles.size();
            this.agent_ports = new HashSet<Port>(2 * this.ans);
            this.agent_points = new HashSet<Point>(2 * this.ans);
            for (Node node : this.agent_nodes) {
                this.agent_ports.addAll(node.getPorts());
            }
            this.aprs = this.agent_ports.size();
            this.agent_points.addAll(this.agent_ports);
            this.agent_points.addAll(agent.getInnerNames());
            this.aps = this.agent_points.size();
            this.redex_roots = redex.getRoots();
            this.redex_sites = redex.getSites();
            this.redex_nodes = redex.getNodes();
            this.redex_edges = redex.getEdges();
            this.redex_handles = new LinkedList<Edge>(this.redex_edges);
            this.redex_handles.addAll(redex.getOuterNames());
            this.rrs = this.redex_roots.size();
            this.rns = this.redex_nodes.size();
            this.rss = this.redex_sites.size();
            this.rhs = this.redex_handles.size();
            this.redex_points = new HashSet<Point>(this.rns);
            for (Node node : this.redex_nodes) {
                this.redex_points.addAll(node.getPorts());
            }
            this.rprs = this.redex_points.size();
            this.redex_points.addAll(redex.getInnerNames());
            this.rps = this.redex_points.size();
            this.rins = this.rps - this.rprs;
        }

        @Override
        public Iterator<Match> iterator() {
            return new MatchIterator();
        }

        private class MatchIterator
        implements Iterator<Match> {
            private boolean mayHaveNext = true;
            private boolean firstRun = true;
            private Match nextMatch = null;
            private final Model model;
            private final Solver solver;
            final Map<PlaceEntity, Map<PlaceEntity, IntVar>> p_vars;
            final Map<LinkEntity, Map<LinkEntity, IntVar>> e_vars;
            final Map<Handle, Map<Handle, IntVar>> f_vars;

            MatchIterator() {
                this.p_vars = new IdentityHashMap<PlaceEntity, Map<PlaceEntity, IntVar>>(MatchIterable.this.ars + MatchIterable.this.ans + MatchIterable.this.ass);
                this.e_vars = new IdentityHashMap<LinkEntity, Map<LinkEntity, IntVar>>(MatchIterable.this.ahs * MatchIterable.this.rhs + MatchIterable.this.aps * (1 + MatchIterable.this.rps));
                this.f_vars = new IdentityHashMap<Handle, Map<Handle, IntVar>>(MatchIterable.this.rhs);
                this.model = new Model();
                this.solver = this.instantiateModel();
                if (DEBUG) {
                    System.out.println("- MODEL CREATED ---------------------");
                    System.out.println("- AGENT -----------------------------");
                    System.out.println(MatchIterable.this.agent);
                    System.out.println("- REDEX -----------------------------");
                    System.out.println(MatchIterable.this.redex);
                    System.out.println("-------------------------------------");
                }
            }

            private Variable findVariable(String name, Variable[] vars) {
                for (Variable v : vars) {
                    if (!name.equals(v.getName())) continue;
                    return v;
                }
                return null;
            }

            /*
             * WARNING - void declaration
             */
            private Solver instantiateModel() {
                int ki = 0;
                for (Root root : MatchIterable.this.agent_roots) {
                    int n = 0;
                    HashMap<PlaceEntity, BoolVar> hashMap = new HashMap<PlaceEntity, BoolVar>(MatchIterable.this.rrs + MatchIterable.this.rns + MatchIterable.this.rss);
                    for (Root root2 : MatchIterable.this.redex_roots) {
                        BoolVar boolVar = this.model.boolVar(ki + "_" + n++);
                        hashMap.put(root2, boolVar);
                    }
                    for (Node node : MatchIterable.this.redex_nodes) {
                        BoolVar boolVar = this.model.boolVar(ki + "_" + n++);
                        this.model.arithm((IntVar)boolVar, "=", 0).post();
                        hashMap.put(node, boolVar);
                    }
                    for (Site site : MatchIterable.this.redex_sites) {
                        BoolVar boolVar = this.model.boolVar(ki + "_" + n++);
                        this.model.arithm((IntVar)boolVar, "=", 0).post();
                        hashMap.put(site, boolVar);
                    }
                    this.p_vars.put(root, hashMap);
                    ++ki;
                }
                for (Node node : MatchIterable.this.agent_nodes) {
                    int n = 0;
                    HashMap<PlaceEntity, BoolVar> hashMap = new HashMap<PlaceEntity, BoolVar>(MatchIterable.this.rrs + MatchIterable.this.rns + MatchIterable.this.rss);
                    for (Root root : MatchIterable.this.redex_roots) {
                        BoolVar boolVar = this.model.boolVar(ki + "_" + n++);
                        hashMap.put(root, boolVar);
                    }
                    for (Node node2 : MatchIterable.this.redex_nodes) {
                        BoolVar boolVar = this.model.boolVar(ki + "_" + n++);
                        hashMap.put(node2, boolVar);
                    }
                    for (Site site : MatchIterable.this.redex_sites) {
                        BoolVar boolVar = this.model.boolVar(ki + "_" + n++);
                        hashMap.put(site, boolVar);
                    }
                    this.p_vars.put(node, hashMap);
                    ++ki;
                }
                for (Site site : MatchIterable.this.agent_sites) {
                    int n = 0;
                    HashMap<Site, BoolVar> hashMap = new HashMap<Site, BoolVar>(MatchIterable.this.rss);
                    for (Site site2 : MatchIterable.this.redex_sites) {
                        BoolVar boolVar = this.model.boolVar(ki + "_" + n++);
                        hashMap.put(site2, boolVar);
                    }
                    this.p_vars.put(site, hashMap);
                    ++ki;
                }
                ki = 0;
                for (Handle handle : MatchIterable.this.redex_handles) {
                    int n = 0;
                    IdentityHashMap<Handle, BoolVar> identityHashMap = new IdentityHashMap<Handle, BoolVar>(MatchIterable.this.ahs);
                    for (Handle handle2 : MatchIterable.this.agent_handles) {
                        BoolVar boolVar = this.model.boolVar("F_" + ki + "_" + n++);
                        identityHashMap.put(handle2, boolVar);
                    }
                    this.f_vars.put(handle, identityHashMap);
                    ++ki;
                }
                ki = 0;
                for (Point point : MatchIterable.this.agent_points) {
                    int n = 0;
                    IdentityHashMap<LinkEntity, BoolVar> identityHashMap = new IdentityHashMap<LinkEntity, BoolVar>(MatchIterable.this.rps + 1);
                    EditableHandle editableHandle = point.getHandle();
                    BoolVar boolVar = this.model.boolVar("PH_" + ki);
                    identityHashMap.put(editableHandle, boolVar);
                    for (Point point2 : MatchIterable.this.redex_points) {
                        BoolVar boolVar2 = this.model.boolVar("PP_" + ki + "_" + n++);
                        identityHashMap.put(point2, boolVar2);
                    }
                    this.e_vars.put(point, identityHashMap);
                    ++ki;
                }
                ki = 0;
                for (Handle handle : MatchIterable.this.redex_handles) {
                    int n = 0;
                    IdentityHashMap<Handle, IntVar> identityHashMap = new IdentityHashMap<Handle, IntVar>(MatchIterable.this.ahs);
                    for (Handle handle3 : MatchIterable.this.agent_handles) {
                        IntVar intVar = this.model.intVar("HH_" + ki + "_" + n++, 0, handle3.getPoints().size());
                        identityHashMap.put(handle3, intVar);
                    }
                    this.e_vars.put(handle, identityHashMap);
                    ++ki;
                }
                for (Node node : MatchIterable.this.agent_nodes) {
                    Parent parent = node.getParent();
                    Map<PlaceEntity, IntVar> map = this.p_vars.get(node);
                    Map<PlaceEntity, IntVar> map2 = this.p_vars.get(parent);
                    for (Child child : MatchIterable.this.redex_nodes) {
                        Parent parent2 = child.getParent();
                        this.model.arithm(map.get(child), "<=", map2.get(parent2)).post();
                    }
                    for (Child child : MatchIterable.this.redex_sites) {
                        Parent parent3 = child.getParent();
                        this.model.arithm(map.get(child), "<=", map2.get(parent3)).post();
                    }
                }
                for (Site site : MatchIterable.this.agent_sites) {
                    Parent parent = site.getParent();
                    Map<PlaceEntity, IntVar> map = this.p_vars.get(site);
                    Map<PlaceEntity, IntVar> map3 = this.p_vars.get(parent);
                    for (Child child : MatchIterable.this.redex_sites) {
                        Parent parent4 = child.getParent();
                        this.model.arithm(map.get(child), "<=", map3.get(parent4)).post();
                    }
                }
                ArrayDeque<Node> qa = new ArrayDeque<Node>();
                ArrayDeque<Node> arrayDeque = new ArrayDeque<Node>();
                for (Root root : MatchIterable.this.agent_roots) {
                    for (Child child : root.getChildren()) {
                        if (!child.isNode()) continue;
                        qa.add((Node)child);
                    }
                }
                while (!qa.isEmpty()) {
                    Node node = (Node)qa.poll();
                    if (node.getControl().isActive()) {
                        for (Child child : node.getChildren()) {
                            if (!child.isNode()) continue;
                            qa.add((Node)child);
                        }
                        continue;
                    }
                    arrayDeque.add(node);
                }
                qa.clear();
                while (!arrayDeque.isEmpty()) {
                    Child child = (Child)arrayDeque.poll();
                    Map<PlaceEntity, IntVar> map = this.p_vars.get(child);
                    for (Root root : MatchIterable.this.redex_roots) {
                        this.model.arithm(map.get(root), "=", 0).post();
                    }
                    if (!child.isNode()) continue;
                    for (Child child2 : ((Node)child).getChildren()) {
                        if (!child2.isNode()) continue;
                        arrayDeque.add((Node)child2);
                    }
                }
                Object vars = new IntVar[MatchIterable.this.ars + MatchIterable.this.ans];
                for (Root root : MatchIterable.this.redex_roots) {
                    int n = 0;
                    for (PlaceEntity placeEntity : this.p_vars.keySet()) {
                        if (placeEntity.isSite()) continue;
                        vars[n++] = this.p_vars.get(placeEntity).get(root);
                    }
                    this.model.sum((IntVar[])vars, "=", 1).post();
                }
                vars = new IntVar[MatchIterable.this.ans + MatchIterable.this.ass];
                for (Node node : MatchIterable.this.redex_nodes) {
                    int n = 0;
                    for (PlaceEntity placeEntity : this.p_vars.keySet()) {
                        if (placeEntity.isRoot()) continue;
                        vars[n++] = this.p_vars.get(placeEntity).get(node);
                    }
                    this.model.sum((IntVar[])vars, "=", 1).post();
                }
                for (Node node : MatchIterable.this.agent_nodes) {
                    void var6_217;
                    void var7_283;
                    Map<PlaceEntity, IntVar> map = this.p_vars.get(node);
                    IntVar[] intVarArray = new IntVar[MatchIterable.this.rns + MatchIterable.this.rss];
                    boolean bl = false;
                    for (PlaceEntity placeEntity : MatchIterable.this.redex_nodes) {
                        intVarArray[++var5_163] = map.get(placeEntity);
                    }
                    for (PlaceEntity placeEntity : MatchIterable.this.redex_sites) {
                        intVarArray[bl2++] = map.get(placeEntity);
                    }
                    IntVar intVar = this.model.intVar(MatchIterable.this.rrs);
                    IntVar intVar2 = this.model.intVar(0);
                    for (IntVar intVar3 : intVarArray) {
                        IntVar intVar4 = var7_283.add((ArExpression)intVar3).intVar();
                    }
                    IntVar intVar5 = var7_283.mul((ArExpression)intVar).intVar();
                    IntVar[] intVarArray2 = new IntVar[MatchIterable.this.rrs];
                    boolean bl2 = false;
                    for (Root root : MatchIterable.this.redex_roots) {
                        intVarArray2[++var5_165] = map.get(root);
                    }
                    IntVar intVar6 = this.model.intVar(0);
                    for (IntVar intVar7 : intVarArray2) {
                        IntVar intVar8 = var6_217.add((ArExpression)intVar7).intVar();
                    }
                    IntVar intVar9 = var6_217.add((ArExpression)intVar5).intVar();
                    this.model.arithm(intVar9, "<=", MatchIterable.this.rrs).post();
                }
                for (Parent parent : MatchIterable.this.agent_nodes) {
                    Collection<? extends Child> collection = parent.getChildren();
                    for (Parent parent5 : MatchIterable.this.redex_nodes) {
                        Collection<? extends Child> collection2 = parent5.getChildren();
                        IntVar[] intVarArray = new IntVar[collection.size() * collection2.size()];
                        boolean bl = false;
                        for (PlaceEntity placeEntity : collection) {
                            for (Object j : collection2) {
                                intVarArray[++var8_340] = this.p_vars.get(placeEntity).get(j);
                            }
                        }
                        IntVar intVar = this.p_vars.get(parent).get(parent5);
                        this.model.sum(intVarArray, ">=", intVar.mul(collection.size()).intVar()).post();
                    }
                }
                HashMap cgs = new HashMap(MatchIterable.this.rrs);
                for (Root root : MatchIterable.this.redex_roots) {
                    HashSet<? extends Child> hashSet = new HashSet<Child>(root.getChildren());
                    hashSet.removeAll(MatchIterable.this.redex_sites);
                    cgs.put(root, hashSet);
                }
                for (PlaceEntity placeEntity : this.p_vars.keySet()) {
                    if (placeEntity.isSite()) continue;
                    Collection<? extends Child> collection = ((Parent)placeEntity).getChildren();
                    for (Root root : MatchIterable.this.redex_roots) {
                        Collection collection3 = (Collection)cgs.get(root);
                        IntVar[] intVarArray = new IntVar[collection.size() * collection3.size()];
                        int n = 0;
                        for (Child child : collection) {
                            for (Child child3 : collection3) {
                                intVarArray[n++] = this.p_vars.get(child).get(child3);
                            }
                        }
                        IntVar intVar = this.p_vars.get(placeEntity).get(root);
                        this.model.sum(intVarArray, ">=", intVar.mul(collection3.size()).intVar()).post();
                    }
                }
                for (Node node : MatchIterable.this.agent_nodes) {
                    void var6_227;
                    void var9_363;
                    Collection<Parent> collection = MatchIterable.this.agent.getAncestors(node);
                    IntVar[] intVarArray = new IntVar[collection.size() * MatchIterable.this.rss];
                    boolean bl = false;
                    for (Parent parent : collection) {
                        if (!parent.isNode()) continue;
                        Map<PlaceEntity, IntVar> map = this.p_vars.get(parent);
                        for (Site site : MatchIterable.this.redex_sites) {
                            intVarArray[++var5_169] = map.get(site);
                        }
                    }
                    IntVar intVar = this.model.intVar(0);
                    IntVar[] intVarArray3 = intVarArray;
                    int n = intVarArray3.length;
                    boolean bl3 = false;
                    while (var9_363 < n) {
                        IntVar intVar10 = intVarArray3[var9_363];
                        IntVar intVar11 = var6_227.add((ArExpression)intVar10).intVar();
                        ++var9_363;
                    }
                    Map<PlaceEntity, IntVar> map = this.p_vars.get(node);
                    for (Root root : MatchIterable.this.redex_roots) {
                        this.model.arithm(var6_227.add((ArExpression)map.get(root)).intVar(), "<=", 1).post();
                    }
                }
                vars = new IntVar[MatchIterable.this.rrs + MatchIterable.this.rns + MatchIterable.this.rss];
                for (Site site : MatchIterable.this.agent_sites) {
                    vars = (IntVar[])this.p_vars.get(site).values().toArray((T[])vars);
                    this.model.sum((IntVar[])vars, "<=", 1).post();
                }
                vars = new IntVar[MatchIterable.this.rps + 1];
                for (Point point : MatchIterable.this.agent_points) {
                    vars = (IntVar[])this.e_vars.get(point).values().toArray((T[])vars);
                    this.model.sum((IntVar[])vars, "=", 1).post();
                }
                for (Handle handle : MatchIterable.this.agent_handles) {
                    Collection<? extends Point> collection = handle.getPoints();
                    IntVar[] intVarArray = new IntVar[MatchIterable.this.rhs + collection.size()];
                    int n = 0;
                    for (Point point : collection) {
                        intVarArray[n++] = this.e_vars.get(point).get(handle);
                    }
                    for (Handle handle4 : MatchIterable.this.redex_handles) {
                        intVarArray[n++] = this.e_vars.get(handle4).get(handle);
                    }
                    this.model.sum(intVarArray, "=", collection.size()).post();
                }
                IntVar[] vars1 = new IntVar[MatchIterable.this.ahs];
                for (Handle handle : MatchIterable.this.redex_handles) {
                    void var7_301;
                    void var10_382;
                    Collection<? extends Point> collection = handle.getPoints();
                    int n = 0;
                    IntVar[] intVarArray = new IntVar[MatchIterable.this.aps * collection.size()];
                    for (Point point : MatchIterable.this.agent_points) {
                        Map<LinkEntity, IntVar> map = this.e_vars.get(point);
                        for (Point point3 : collection) {
                            intVarArray[n++] = map.get(point3);
                        }
                    }
                    vars1 = this.e_vars.get(handle).values().toArray(vars1);
                    IntVar intVar = this.model.intVar(0);
                    IntVar[] intVarArray4 = vars1;
                    int n2 = intVarArray4.length;
                    boolean bl = false;
                    while (var10_382 < n2) {
                        IntVar intVar12 = intVarArray4[var10_382];
                        IntVar intVar13 = var7_301.add((ArExpression)intVar12).intVar();
                        ++var10_382;
                    }
                    this.model.sum(intVarArray, "=", (IntVar)var7_301).post();
                }
                vars = new IntVar[MatchIterable.this.aps];
                for (Point point : MatchIterable.this.redex_points) {
                    if (!point.isPort()) continue;
                    int n = 0;
                    for (Point point4 : MatchIterable.this.agent_points) {
                        vars[n++] = this.e_vars.get(point4).get(point);
                    }
                    this.model.sum((IntVar[])vars, "=", 1).post();
                }
                vars = new IntVar[MatchIterable.this.aprs];
                for (Point point : MatchIterable.this.redex_points) {
                    if (!point.isInnerName()) continue;
                    int n = 0;
                    for (Point point5 : MatchIterable.this.agent_ports) {
                        vars[n++] = this.e_vars.get(point5).get(point);
                    }
                    this.model.sum((IntVar[])vars, "=", 1).post();
                }
                for (Handle handle : MatchIterable.this.redex_handles) {
                    Map<Handle, IntVar> map = this.f_vars.get(handle);
                    Map<LinkEntity, IntVar> map4 = this.e_vars.get(handle);
                    if (handle.getPoints().isEmpty()) continue;
                    for (Handle handle5 : MatchIterable.this.agent_handles) {
                        if (handle5.getPoints().isEmpty()) continue;
                        IntVar intVar = map.get(handle5);
                        IntVar intVar14 = map4.get(handle5);
                        this.model.arithm(intVar14, "<=", intVar.mul(handle5.getPoints().size()).intVar()).post();
                        this.model.arithm(intVar, "<=", intVar14).post();
                    }
                }
                for (Handle handle : MatchIterable.this.redex_handles) {
                    Map<Handle, IntVar> map = this.f_vars.get(handle);
                    Collection<? extends Point> collection = handle.getPoints();
                    for (Handle handle6 : MatchIterable.this.agent_handles) {
                        IntVar intVar = map.get(handle6);
                        int n = 0;
                        IntVar[] intVarArray = new IntVar[collection.size() * handle6.getPoints().size()];
                        for (Point point : handle6.getPoints()) {
                            Map<LinkEntity, IntVar> e_row = this.e_vars.get(point);
                            for (Point point6 : collection) {
                                IntVar ve = e_row.get(point6);
                                intVarArray[n++] = ve;
                                this.model.arithm(ve, "<=", intVar).post();
                            }
                            if (!handle.isEdge()) continue;
                            this.model.arithm(intVar.add((ArExpression)this.e_vars.get(point).get(handle6)).intVar(), "<=", 1).post();
                        }
                        if (collection.isEmpty() && handle6.getPoints().isEmpty()) continue;
                        this.model.sum(intVarArray, ">=", intVar).post();
                    }
                }
                vars = new IntVar[MatchIterable.this.ahs];
                for (Handle handle : MatchIterable.this.redex_handles) {
                    Map<Handle, IntVar> map = this.f_vars.get(handle);
                    this.model.sum((IntVar[])map.values().toArray((T[])vars), "<=", 1).post();
                }
                ListIterator<Handle> ir1 = MatchIterable.this.redex_handles.listIterator(0);
                while (ir1.hasNext()) {
                    Handle handle = ir1.next();
                    Map<Handle, IntVar> map = this.f_vars.get(handle);
                    if (handle.isEdge()) {
                        for (Handle handle7 : MatchIterable.this.agent_handles) {
                            if (!handle7.isOuterName()) continue;
                            this.model.arithm(map.get(handle7), "=", 0).post();
                        }
                    }
                    ListIterator<Handle> listIterator = MatchIterable.this.redex_handles.listIterator(ir1.nextIndex());
                    while (listIterator.hasNext()) {
                        Handle handle8 = listIterator.next();
                        Map<Handle, IntVar> map5 = this.f_vars.get(handle8);
                        if (handle.isEdge() == handle8.isEdge()) continue;
                        for (Handle handle9 : MatchIterable.this.agent_handles) {
                            this.model.arithm(map.get(handle9).add((ArExpression)map5.get(handle9)).intVar(), "<=", 1).post();
                        }
                    }
                }
                vars = new IntVar[MatchIterable.this.redex_edges.size()];
                for (Handle handle : MatchIterable.this.agent_handles) {
                    int n = 0;
                    for (Handle handle10 : MatchIterable.this.redex_edges) {
                        vars[n++] = this.f_vars.get(handle10).get(handle);
                    }
                    this.model.sum((IntVar[])vars, "<=", 1).post();
                }
                for (Node node : MatchIterable.this.agent_nodes) {
                    Map<PlaceEntity, IntVar> map = this.p_vars.get(node);
                    for (Node node3 : MatchIterable.this.redex_nodes) {
                        IntVar intVar = map.get(node3);
                        boolean bl = Matcher.this.areMatchable(MatchIterable.this.agent, node, MatchIterable.this.redex, node3);
                        if (!bl) {
                            this.model.arithm(intVar, "=", 0).post();
                        }
                        for (int i = node.getControl().getArity() - 1; 0 <= i; --i) {
                            Map<LinkEntity, IntVar> map6 = this.e_vars.get(node.getPort(i));
                            for (int j = node3.getControl().getArity() - 1; 0 <= j; --j) {
                                if (bl && i == j) {
                                    this.model.arithm(map6.get(node3.getPort(j)), "=", intVar).post();
                                    continue;
                                }
                                this.model.arithm(map6.get(node3.getPort(j)), "=", 0).post();
                            }
                        }
                    }
                }
                for (Node node : MatchIterable.this.agent_nodes) {
                    void var6_252;
                    void var9_371;
                    Collection<Parent> collection = MatchIterable.this.agent.getAncestors(node);
                    IntVar[] intVarArray = new IntVar[(1 + collection.size()) * MatchIterable.this.rss];
                    boolean bl = false;
                    for (Parent parent : collection) {
                        Map<PlaceEntity, IntVar> map = this.p_vars.get(parent);
                        for (Site site : MatchIterable.this.redex_sites) {
                            intVarArray[++var5_181] = map.get(site);
                        }
                    }
                    Map<PlaceEntity, IntVar> map = this.p_vars.get(node);
                    for (Site site : MatchIterable.this.redex_sites) {
                        intVarArray[++var5_182] = map.get(site);
                    }
                    IntVar intVar = this.model.intVar(0);
                    IntVar[] intVarArray5 = intVarArray;
                    int n = intVarArray5.length;
                    boolean bl4 = false;
                    while (var9_371 < n) {
                        IntVar intVar15 = intVarArray5[var9_371];
                        IntVar intVar16 = var6_252.add((ArExpression)intVar15).intVar();
                        ++var9_371;
                    }
                    for (Port port : node.getPorts()) {
                        Map<LinkEntity, IntVar> map7 = this.e_vars.get(port);
                        IntVar[] intVarArray6 = new IntVar[MatchIterable.this.rins];
                        int n3 = 0;
                        for (Point point : MatchIterable.this.redex.getInnerNames()) {
                            IntVar intVar17 = map7.get(point);
                            intVarArray6[n3++] = intVar17;
                        }
                        this.model.sum(intVarArray6, "<=", (IntVar)var6_252).post();
                    }
                }
                return this.model.getSolver();
            }

            @Override
            public boolean hasNext() {
                if (this.mayHaveNext && this.nextMatch == null) {
                    this.fetchSolution();
                }
                return this.mayHaveNext && this.nextMatch != null;
            }

            @Override
            public Match next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Match res = this.nextMatch;
                this.nextMatch = null;
                return res;
            }

            @Override
            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException("");
            }

            private void noMoreSolutions() {
                this.mayHaveNext = false;
                this.solver.hardReset();
            }

            /*
             * WARNING - void declaration
             */
            private void fetchSolution() {
                IntVar var;
                EditableHandle h1;
                EditableInnerName i2;
                String name;
                boolean first = this.firstRun;
                this.firstRun = false;
                if (DEBUG_PRINT_SOLUTION_FETCH) {
                    System.out.println("fetch solution has been invoked...");
                }
                if (first && !this.solver.solve() || !first && !this.solver.solve()) {
                    if (DEBUG_PRINT_SOLUTION_FETCH) {
                        System.out.println("...but no more solutions where found.");
                    }
                    this.noMoreSolutions();
                    return;
                }
                if (DEBUG_PRINT_CSP_SOLUTIONS) {
                    IntVar v;
                    void var4_16;
                    Iterator<LinkEntity> row;
                    Object v2;
                    int j;
                    void var4_13;
                    void var4_11;
                    void var4_8;
                    System.out.println("Solution: #" + this.solver.getSolutionCount());
                    System.out.print('\n');
                    int[] p_cell_width = new int[1 + MatchIterable.this.rrs + MatchIterable.this.rns + MatchIterable.this.rss];
                    p_cell_width[0] = 6;
                    for (Node node : MatchIterable.this.agent_nodes) {
                        p_cell_width[0] = Math.max(p_cell_width[0], node.toString().length());
                    }
                    System.out.printf("%-" + p_cell_width[0] + "s|", "P_VARS");
                    int c = 1;
                    boolean bl = false;
                    while (var4_8 < MatchIterable.this.rrs) {
                        String string = "R_" + (int)var4_8;
                        p_cell_width[c] = string.length();
                        System.out.printf("%-" + p_cell_width[c] + "s|", string);
                        ++var4_8;
                        ++c;
                    }
                    for (Node node : MatchIterable.this.redex_nodes) {
                        String s3 = node.toString();
                        p_cell_width[c] = s3.length();
                        System.out.printf("%-" + p_cell_width[c++] + "s|", s3);
                    }
                    boolean bl2 = false;
                    while (var4_11 < MatchIterable.this.rss) {
                        String string = "S_" + (int)var4_11;
                        p_cell_width[c] = string.length();
                        System.out.printf("%-" + p_cell_width[c] + "s|", string);
                        ++var4_11;
                        ++c;
                    }
                    boolean bl3 = false;
                    while (var4_13 < MatchIterable.this.ars) {
                        System.out.printf("\nR_%-" + (p_cell_width[0] - 2) + "d|", (int)var4_13);
                        c = 1;
                        Root root = MatchIterable.this.agent_roots.get((int)var4_13);
                        Map<PlaceEntity, IntVar> row2 = this.p_vars.get(root);
                        for (j = 0; j < MatchIterable.this.rrs; ++j) {
                            Root root2 = MatchIterable.this.redex_roots.get(j);
                            IntVar v22 = this.findVariable(row2.get(root2).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v22.getValue());
                        }
                        for (Node node : MatchIterable.this.redex_nodes) {
                            v2 = this.findVariable(row2.get(node).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v2.getValue());
                        }
                        for (j = 0; j < MatchIterable.this.rss; ++j) {
                            Site site = MatchIterable.this.redex_sites.get(j);
                            v2 = this.findVariable(row2.get(site).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v2.getValue());
                        }
                        ++var4_13;
                    }
                    for (Node node : MatchIterable.this.agent_nodes) {
                        System.out.printf("\n%-" + p_cell_width[0] + "s|", node);
                        c = 1;
                        row = this.p_vars.get(node);
                        for (j = 0; j < MatchIterable.this.rrs; ++j) {
                            Root root = MatchIterable.this.redex_roots.get(j);
                            v2 = this.findVariable(row.get(root).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v2.getValue());
                        }
                        for (Node node2 : MatchIterable.this.redex_nodes) {
                            v2 = this.findVariable(row.get(node2).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v2.getValue());
                        }
                        for (j = 0; j < MatchIterable.this.rss; ++j) {
                            Site site = MatchIterable.this.redex_sites.get(j);
                            v2 = this.findVariable(((IntVar)row.get(site)).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v2.getValue());
                        }
                    }
                    boolean bl4 = false;
                    while (var4_16 < MatchIterable.this.ass) {
                        System.out.printf("\nS_%-" + (p_cell_width[0] - 2) + "d|", (int)var4_16);
                        c = 1;
                        Root root = MatchIterable.this.agent_roots.get((int)var4_16);
                        row = this.p_vars.get(root);
                        for (j = 0; j < MatchIterable.this.rrs; ++j) {
                            System.out.printf("%" + p_cell_width[c++] + "d|", Character.valueOf(' '));
                        }
                        for (j = 0; j < MatchIterable.this.rns; ++j) {
                            System.out.printf("%" + p_cell_width[c++] + "d|", Character.valueOf(' '));
                        }
                        for (j = 0; j < MatchIterable.this.rss; ++j) {
                            Site site = MatchIterable.this.redex_sites.get(j);
                            v2 = this.findVariable(((IntVar)row.get(site)).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v2.getValue());
                        }
                        ++var4_16;
                    }
                    System.out.println('\n');
                    int[] nArray = new int[1 + MatchIterable.this.ahs];
                    int[] nArray2 = new int[1 + MatchIterable.this.rps + MatchIterable.this.ahs];
                    nArray[0] = 6;
                    for (Handle n : MatchIterable.this.redex_handles) {
                        nArray[0] = Math.max(nArray[0], n.toString().length());
                    }
                    nArray2[0] = nArray[0];
                    for (Point n : MatchIterable.this.agent_points) {
                        nArray2[0] = Math.max(nArray2[0], n.toString().length());
                    }
                    System.out.printf("%-" + nArray2[0] + "s|", "E_VARS");
                    c = 1;
                    for (Point p : MatchIterable.this.redex_points) {
                        String string = p.toString();
                        nArray2[c] = string.length();
                        System.out.printf("%-" + nArray2[c++] + "s|", string);
                    }
                    for (Handle h : MatchIterable.this.agent_handles) {
                        String string = h.toString();
                        nArray2[c] = string.length();
                        System.out.printf("%-" + nArray2[c++] + "s|", string);
                    }
                    for (Point pi : MatchIterable.this.agent_points) {
                        System.out.printf("\n%-" + nArray2[0] + "s|", pi);
                        c = 1;
                        Map<LinkEntity, IntVar> map = this.e_vars.get(pi);
                        for (Point pj : MatchIterable.this.redex_points) {
                            v = this.findVariable(map.get(pj).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + nArray2[c++] + "d|", v.getValue());
                        }
                        for (Handle hj : MatchIterable.this.agent_handles) {
                            if (map.containsKey(hj)) {
                                v = this.findVariable(map.get(hj).getName(), this.model.getVars()).asIntVar();
                                System.out.printf("%" + nArray2[c++] + "d|", v.getValue());
                                continue;
                            }
                            System.out.printf("%" + nArray2[c++] + "c|", Character.valueOf(' '));
                        }
                    }
                    for (Handle hi : MatchIterable.this.redex_handles) {
                        System.out.printf("\n%-" + nArray2[0] + "s|", hi);
                        c = 1;
                        Map<LinkEntity, IntVar> map = this.e_vars.get(hi);
                        for (int j2 = MatchIterable.this.rps; 0 < j2; --j2) {
                            System.out.printf("%" + nArray2[c++] + "c|", Character.valueOf(' '));
                        }
                        for (Handle hj : MatchIterable.this.agent_handles) {
                            v = this.findVariable(map.get(hj).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + nArray2[c++] + "d|", v.getValue());
                        }
                    }
                    System.out.println('\n');
                    System.out.printf("%" + nArray[0] + "s|", "F_VARS");
                    c = 1;
                    for (Handle h : MatchIterable.this.agent_handles) {
                        String string = h.toString();
                        nArray[c] = string.length();
                        System.out.printf("%-" + nArray[c++] + "s|", string);
                    }
                    for (Handle hi : MatchIterable.this.redex_handles) {
                        System.out.printf("\n%-" + nArray[0] + "s|", hi);
                        c = 1;
                        Map<Handle, IntVar> map = this.f_vars.get(hi);
                        for (Handle hj : MatchIterable.this.agent_handles) {
                            v = this.findVariable(map.get(hj).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + nArray[c++] + "d|", v.getValue());
                        }
                    }
                    System.out.println('\n');
                }
                Bigraph ctx = new Bigraph(MatchIterable.this.agent.signature);
                Bigraph rdx = new Bigraph(MatchIterable.this.agent.signature);
                Bigraph bigraph = new Bigraph(MatchIterable.this.agent.signature);
                Bigraph bigraph2 = new Bigraph(MatchIterable.this.agent.signature);
                BidMap<Node, Node> nEmb = new BidMap<Node, Node>(MatchIterable.this.rns);
                BidMap<EditableParent, EditableParent> ctxEmb = new BidMap<EditableParent, EditableParent>();
                EditableSite[] editableSiteArray = new EditableSite[MatchIterable.this.rrs];
                EditableSite[] rdx_sites_dic = new EditableSite[MatchIterable.this.rss];
                EditableRoot[] rdx_roots_dic = new EditableRoot[MatchIterable.this.rrs];
                EditableRoot[] prm_roots_dic = new EditableRoot[MatchIterable.this.rss];
                EditableSite[] prm_sites_dic = new EditableSite[MatchIterable.this.ass];
                IdentityHashMap<Object, EditableHandle> ctx_hnd_dic = new IdentityHashMap<Object, EditableHandle>();
                IdentityHashMap<EditableHandle, EditableHandle> rdx_hnd_dic = new IdentityHashMap<EditableHandle, EditableHandle>();
                IdentityHashMap<EditableHandle, Object> prm_hnd_dic = new IdentityHashMap<EditableHandle, Object>();
                IdentityHashMap<EditableHandle, Object> handle_img = new IdentityHashMap<EditableHandle, Object>(MatchIterable.this.rhs);
                class VState {
                    final PlaceEntity c;
                    final PlaceEntity i;
                    final EditableParent p;
                    final Bigraph b;

                    VState(Bigraph b, EditableParent p, PlaceEntity c) {
                        this(b, p, c, null);
                    }

                    VState(Bigraph b, EditableParent p, PlaceEntity c, PlaceEntity i) {
                        this.i = i;
                        this.c = c;
                        this.p = p;
                        this.b = b;
                    }
                }
                ArrayDeque<VState> q = new ArrayDeque<VState>();
                for (EditableOuterName o1 : MatchIterable.this.agent.outers.values()) {
                    EditableOuterName o2 = o1.replicate();
                    ctx.outers.put(o2.getName(), o2);
                    o2.setOwner(ctx);
                    ctx_hnd_dic.put(o1, o2);
                }
                for (EditableOuterName o0 : MatchIterable.this.redex.outers.values()) {
                    EditableHandle h2;
                    void var23_90;
                    name = o0.getName();
                    EditableOuterName o2 = new EditableOuterName(name);
                    rdx.outers.put(name, o2);
                    o2.setOwner(rdx);
                    rdx_hnd_dic.put(o0, o2);
                    EditableInnerName i1 = new EditableInnerName(name);
                    ctx.inners.put(name, i1);
                    EditableHandle editableHandle = (EditableHandle)handle_img.get(o0);
                    if (editableHandle == null) {
                        void var23_93;
                        Map<Handle, IntVar> f_row = this.f_vars.get(o0);
                        for (Handle handle : MatchIterable.this.agent_handles) {
                            IntVar intVar = this.findVariable(f_row.get(handle).getName(), this.model.getVars()).asIntVar();
                            if (intVar.getValue() != 1) continue;
                            EditableHandle editableHandle2 = handle.getEditable();
                            break;
                        }
                        if (var23_93 == null) {
                            EditableEdge editableEdge = new EditableEdge();
                        }
                        handle_img.put(o0, var23_90);
                    }
                    if ((h2 = (EditableHandle)ctx_hnd_dic.get(var23_90)) == null) {
                        h2 = var23_90.replicate();
                        h2.setOwner(ctx);
                        ctx_hnd_dic.put(var23_90, h2);
                    }
                    i1.setHandle(h2);
                }
                for (EditableInnerName i0 : MatchIterable.this.redex.inners.values()) {
                    void var23_98;
                    name = i0.getName();
                    i2 = new EditableInnerName(name);
                    EditableHandle h0 = i0.getHandle();
                    EditableHandle editableHandle = (EditableHandle)rdx_hnd_dic.get(h0);
                    if (editableHandle == null) {
                        h1 = (EditableHandle)handle_img.get(h0);
                        if (h1 == null) {
                            Map<Handle, IntVar> map = this.f_vars.get(h0);
                            for (Handle handle : MatchIterable.this.agent_handles) {
                                var = this.findVariable(map.get(handle).getName(), this.model.getVars()).asIntVar();
                                if (var.getValue() != 1) continue;
                                h1 = handle.getEditable();
                                break;
                            }
                            if (h1 == null) {
                                h1 = new EditableEdge();
                            }
                            handle_img.put(h0, h1);
                        }
                        EditableHandle editableHandle3 = h1.replicate();
                        editableHandle3.setOwner(rdx);
                        rdx_hnd_dic.put(h0, editableHandle3);
                    }
                    i2.setHandle((EditableHandle)var23_98);
                    rdx.inners.put(name, i2);
                    EditableOuterName o2 = new EditableOuterName(name);
                    o2.setOwner(bigraph);
                    bigraph.outers.put(name, o2);
                }
                for (EditableInnerName i1 : MatchIterable.this.agent.inners.values()) {
                    EditableHandle h2;
                    String name1;
                    block79: {
                        Map<LinkEntity, IntVar> map;
                        block78: {
                            name1 = i1.getName();
                            i2 = new EditableInnerName(name1);
                            h2 = null;
                            map = this.e_vars.get(i1);
                            IntVar intVar = this.findVariable(map.get(h1 = i1.getHandle()).getName(), this.model.getVars()).asIntVar();
                            if (intVar.getValue() != 1) break block78;
                            h2 = (EditableHandle)prm_hnd_dic.get(h1);
                            if (h2 != null) break block79;
                            EditableHandle editableHandle = (EditableHandle)ctx_hnd_dic.get(h1);
                            if (editableHandle != null) {
                                EditableInnerName editableInnerName = new EditableInnerName();
                                editableInnerName.setHandle(editableHandle);
                                String name2 = editableInnerName.getName();
                                ctx.inners.put(name2, editableInnerName);
                                EditableOuterName o4 = new EditableOuterName(name2);
                                o4.setOwner(bigraph2);
                                bigraph2.outers.put(name2, o4);
                                EditableInnerName editableInnerName2 = new EditableInnerName(name2);
                                editableInnerName2.setHandle(o4);
                                bigraph2.inners.put(name2, editableInnerName2);
                                EditableOuterName editableOuterName = new EditableOuterName(name2);
                                editableOuterName.setOwner(bigraph);
                                bigraph.outers.put(name2, editableOuterName);
                                h2 = editableOuterName;
                            } else {
                                h2 = new EditableEdge(bigraph);
                            }
                            prm_hnd_dic.put(h1, h2);
                            break block79;
                        }
                        for (InnerName innerName : MatchIterable.this.redex.inners.values()) {
                            IntVar v = this.findVariable(map.get(innerName).getName(), this.model.getVars()).asIntVar();
                            if (v.getValue() != 1) continue;
                            String name2 = innerName.getName();
                            h2 = bigraph.outers.get(name2);
                            if (h2 != null) break;
                            EditableOuterName editableOuterName = new EditableOuterName(name2);
                            editableOuterName.setOwner(bigraph);
                            bigraph.outers.put(name2, editableOuterName);
                            h2 = editableOuterName;
                            break;
                        }
                    }
                    i2.setHandle(h2);
                    bigraph.inners.put(name1, i2);
                }
                for (EditableRoot r0 : MatchIterable.this.agent.roots) {
                    q.add(new VState(ctx, null, r0));
                }
                LinkedList<? extends Root> unseen_rdx_roots = new LinkedList<Root>(MatchIterable.this.redex_roots);
                while (!q.isEmpty()) {
                    VState v;
                    block80: {
                        EditableRoot r2;
                        v = (VState)q.poll();
                        if (v.b == ctx) {
                            EditableParent p1 = (EditableParent)v.c;
                            EditableParent p2 = p1.replicate();
                            if (p1.isRoot()) {
                                r2 = (EditableRoot)p2;
                                ctx.roots.add(r2);
                                r2.setOwner(ctx);
                            } else {
                                EditableNode n1 = (EditableNode)p1;
                                EditableNode editableNode = (EditableNode)p2;
                                editableNode.setParent(v.p);
                                for (int i = n1.getControl().getArity() - 1; -1 < i; --i) {
                                    void var27_157;
                                    EditableNode.EditablePort editablePort = n1.getPort(i);
                                    EditableHandle editableHandle = editablePort.getHandle();
                                    EditableHandle editableHandle4 = (EditableHandle)ctx_hnd_dic.get(editableHandle);
                                    if (editableHandle4 == null) {
                                        EditableHandle editableHandle5 = editableHandle.replicate();
                                        editableHandle5.setOwner(ctx);
                                        ctx_hnd_dic.put(editableHandle, editableHandle5);
                                    }
                                    editableNode.getPort(i).setHandle((EditableHandle)var27_157);
                                }
                            }
                            HashSet<? extends Child> rcs = new HashSet<Child>(p1.getChildren());
                            Map<PlaceEntity, IntVar> map = this.p_vars.get(p1);
                            Iterator ir = unseen_rdx_roots.iterator();
                            while (ir.hasNext()) {
                                Root root = (Root)ir.next();
                                IntVar intVar = this.findVariable(map.get(root).getName(), this.model.getVars()).asIntVar();
                                if (intVar.getValue() != 1) continue;
                                ir.remove();
                                int n = MatchIterable.this.redex_roots.indexOf(root);
                                EditableSite s = new EditableSite();
                                s.setParent(p2);
                                editableSiteArray[n] = s;
                                EditableRoot r22 = new EditableRoot();
                                r22.setOwner(rdx);
                                rdx_roots_dic[n] = r22;
                                for (Child child : root.getChildren()) {
                                    Iterator ic = rcs.iterator();
                                    boolean notMatched = true;
                                    while (ic.hasNext()) {
                                        Child c1 = (Child)ic.next();
                                        IntVar var4 = this.findVariable(this.p_vars.get(c1).get(child).getName(), this.model.getVars()).asIntVar();
                                        if (var4.getValue() != 1) continue;
                                        notMatched = false;
                                        q.add(new VState(rdx, r22, c1, child));
                                        ic.remove();
                                    }
                                    if (!notMatched || !child.isSite()) continue;
                                    q.add(new VState(rdx, r22, null, child));
                                }
                            }
                            for (Child child : rcs) {
                                q.add(new VState(ctx, p2, child));
                            }
                            continue;
                        }
                        if (v.b == rdx) {
                            if (v.i.isNode()) {
                                void var23_106;
                                EditableNode n0 = (EditableNode)v.i;
                                EditableNode n1 = (EditableNode)v.c;
                                EditableNode n2 = n1.replicate();
                                nEmb.put(n0, n1);
                                n2.setParent(v.p);
                                int n = n0.getControl().getArity() - 1;
                                while (-1 < var23_106) {
                                    void var26_146;
                                    EditableNode.EditablePort o0 = n0.getPort((int)var23_106);
                                    EditableHandle editableHandle = o0.getHandle();
                                    EditableHandle editableHandle6 = (EditableHandle)rdx_hnd_dic.get(editableHandle);
                                    if (editableHandle6 == null) {
                                        EditableHandle editableHandle7 = n1.getPort((int)var23_106).getHandle().replicate();
                                        editableHandle7.setOwner(rdx);
                                        rdx_hnd_dic.put(editableHandle, editableHandle7);
                                    }
                                    n2.getPort((int)var23_106).setHandle((EditableHandle)var26_146);
                                    --var23_106;
                                }
                                HashSet<? extends Child> hashSet = new HashSet<Child>(n1.getChildren());
                                for (Child child : n0.getChildren()) {
                                    Iterator iterator = hashSet.iterator();
                                    boolean bl = true;
                                    while (iterator.hasNext()) {
                                        Child c1 = (Child)iterator.next();
                                        IntVar var5 = this.findVariable(this.p_vars.get(c1).get(child).getName(), this.model.getVars()).asIntVar();
                                        if (var5.getValue() != 1) continue;
                                        bl = false;
                                        q.add(new VState(rdx, n2, c1, child));
                                        iterator.remove();
                                    }
                                    if (!bl || !child.isSite()) continue;
                                    q.add(new VState(rdx, n2, null, child));
                                }
                                continue;
                            }
                            EditableSite s0 = (EditableSite)v.i;
                            int k = MatchIterable.this.redex_sites.indexOf(s0);
                            if (rdx_sites_dic[k] == null) {
                                EditableSite s2 = new EditableSite();
                                s2.setParent(v.p);
                                rdx_sites_dic[k] = s2;
                            }
                            if (prm_roots_dic[k] == null) {
                                prm_roots_dic[k] = new EditableRoot(bigraph);
                            }
                            r2 = prm_roots_dic[k];
                            if (v.c == null) continue;
                            q.add(new VState(bigraph, r2, v.c));
                            continue;
                        }
                        if (!v.c.isNode()) break block80;
                        EditableNode n1 = (EditableNode)v.c;
                        EditableNode n2 = n1.replicate();
                        n2.setParent(v.p);
                        for (int i = n1.getControl().getArity() - 1; -1 < i; --i) {
                            void var25_133;
                            EditableNode.EditablePort p2;
                            block82: {
                                Map<LinkEntity, IntVar> map;
                                block81: {
                                    void var25_130;
                                    EditableHandle editableHandle;
                                    EditableNode.EditablePort editablePort = n1.getPort(i);
                                    p2 = n2.getPort(i);
                                    Object var25_126 = null;
                                    map = this.e_vars.get(editablePort);
                                    var = this.findVariable(map.get(editableHandle = editablePort.getHandle()).getName(), this.model.getVars()).asIntVar();
                                    if (var.getValue() != 1) break block81;
                                    EditableHandle editableHandle8 = (EditableHandle)prm_hnd_dic.get(editableHandle);
                                    if (editableHandle8 != null) break block82;
                                    EditableHandle h3 = (EditableHandle)ctx_hnd_dic.get(editableHandle);
                                    if (h3 != null) {
                                        EditableInnerName editableInnerName = new EditableInnerName();
                                        editableInnerName.setHandle(h3);
                                        String string = editableInnerName.getName();
                                        ctx.inners.put(string, editableInnerName);
                                        EditableOuterName o4 = new EditableOuterName(string);
                                        o4.setOwner(bigraph2);
                                        bigraph2.outers.put(string, o4);
                                        EditableInnerName i4 = new EditableInnerName(string);
                                        i4.setHandle(o4);
                                        bigraph2.inners.put(string, i4);
                                        EditableOuterName o2 = new EditableOuterName(string);
                                        o2.setOwner(v.b);
                                        v.b.outers.put(string, o2);
                                        EditableOuterName editableOuterName = o2;
                                    } else {
                                        EditableEdge editableEdge = new EditableEdge(bigraph);
                                    }
                                    prm_hnd_dic.put(editableHandle, var25_130);
                                    break block82;
                                }
                                for (InnerName innerName : MatchIterable.this.redex.inners.values()) {
                                    IntVar intVar = this.findVariable(map.get(innerName).getName(), this.model.getVars()).asIntVar();
                                    if (intVar.getValue() != 1) continue;
                                    String name4 = innerName.getName();
                                    EditableHandle editableHandle = bigraph.outers.get(name4);
                                    if (editableHandle != null) break;
                                    EditableOuterName o2 = new EditableOuterName(name4);
                                    o2.setOwner(v.b);
                                    v.b.outers.put(name4, o2);
                                    EditableOuterName editableOuterName = o2;
                                    break;
                                }
                            }
                            p2.setHandle((EditableHandle)var25_133);
                        }
                        for (Child child : n1.getChildren()) {
                            q.add(new VState(v.b, n2, child));
                        }
                        continue;
                    }
                    EditableSite s1 = (EditableSite)v.c;
                    EditableSite s2 = s1.replicate();
                    s2.setParent(v.p);
                    prm_sites_dic[MatchIterable.this.agent_sites.indexOf((Object)s1)] = s2;
                }
                ctx.sites.addAll(Arrays.asList(editableSiteArray));
                rdx.sites.addAll(Arrays.asList(rdx_sites_dic));
                rdx.roots.addAll(Arrays.asList(rdx_roots_dic));
                bigraph.roots.addAll(Arrays.asList(prm_roots_dic));
                bigraph.sites.addAll(Arrays.asList(prm_sites_dic));
                if (DEBUG_CONSISTENCY_CHECK) {
                    if (!ctx.isConsistent()) {
                        throw new RuntimeException("Inconsistent bigraph (ctx)");
                    }
                    if (!rdx.isConsistent()) {
                        throw new RuntimeException("Inconsistent bigraph (rdx)");
                    }
                    if (!bigraph2.isConsistent()) {
                        throw new RuntimeException("Inconsistent bigraph (id)");
                    }
                    if (!bigraph.isConsistent()) {
                        throw new RuntimeException("Inconsistent bigraph (prm)");
                    }
                }
                this.nextMatch = new Match(ctx, rdx, bigraph2, bigraph, nEmb, ctxEmb);
            }
        }
    }
}

