/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.std;

import it.uniud.mads.jlibbig.core.Owner;
import it.uniud.mads.jlibbig.core.attachedProperties.Property;
import it.uniud.mads.jlibbig.core.attachedProperties.PropertyListener;
import it.uniud.mads.jlibbig.core.attachedProperties.Replicating;
import it.uniud.mads.jlibbig.core.attachedProperties.ReplicationListener;
import it.uniud.mads.jlibbig.core.std.EditableNode;
import it.uniud.mads.jlibbig.core.std.Node;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class NodeChaser {
    private static final Owner FAKE_OWNER = new Owner(){};
    private final Map<Owner, Set<Node>> index = new WeakHashMap<Owner, Set<Node>>();
    private final Map<Node, PropertyListener<Owner>> ownerLsts = new WeakHashMap<Node, PropertyListener<Owner>>();
    private final Map<Node, ReplicationListener> repLsts = new WeakHashMap<Node, ReplicationListener>();

    private Set<Node> newWeakHashSet() {
        return Collections.newSetFromMap(new WeakHashMap());
    }

    private Owner getOwnerKey(Node node) {
        return this.getOwnerKey(node.getOwner());
    }

    private Owner getOwnerKey(Owner owner) {
        if (owner == null) {
            owner = FAKE_OWNER;
        }
        return owner;
    }

    public Collection<Node> getAll() {
        ArrayList<Node> col = new ArrayList<Node>(this.ownerLsts.keySet().size());
        for (Owner o : this.index.keySet()) {
            col.addAll(this.getAll(o));
        }
        return col;
    }

    public Collection<Node> getAll(Owner owner) {
        Set<Node> s = this.index.get(this.getOwnerKey(owner));
        if (s == null) {
            return new HashSet<Node>();
        }
        return s;
    }

    public void releaseAll() {
        Iterator<Owner> oi = this.index.keySet().iterator();
        while (oi.hasNext()) {
            Owner o = oi.next();
            this.releaseAll(o);
            oi.remove();
        }
    }

    public void releaseAll(Owner owner) {
        Set<Node> set = this.index.get(owner);
        if (set == null) {
            return;
        }
        Iterator<Node> ir = set.iterator();
        while (ir.hasNext()) {
            Node node = ir.next();
            if (node == null) continue;
            node.getProperty("Owner").unregisterListener(this.ownerLsts.get(node));
            ((EditableNode)node).unregisterListener(this.repLsts.remove(node));
            ir.remove();
        }
    }

    public void release(Node node) {
        if (this.isChased(node)) {
            node.getProperty("Owner").unregisterListener(this.ownerLsts.remove(node));
            ((EditableNode)node).unregisterListener(this.repLsts.remove(node));
        }
    }

    public boolean isChased(Node node) {
        return this.ownerLsts.containsKey(node);
    }

    public void chase(Node node) {
        this.chase((EditableNode)node);
    }

    void chase(EditableNode node) {
        Set<Node> ns = this.index.get(this.getOwnerKey(node));
        if (ns == null) {
            ns = this.newWeakHashSet();
            this.index.put(this.getOwnerKey(node), ns);
        }
        ns.add(node);
        final WeakReference<EditableNode> ref = new WeakReference<EditableNode>(node);
        PropertyListener<Owner> ol = new PropertyListener<Owner>(){

            @Override
            public void onChanged(Property<? extends Owner> property, Owner oldValue, Owner newValue) {
                Set<Node> ns = NodeChaser.this.index.get(NodeChaser.this.getOwnerKey(oldValue));
                if (ns != null) {
                    ns.remove(ref.get());
                }
                if ((ns = NodeChaser.this.index.get(NodeChaser.this.getOwnerKey(newValue))) == null) {
                    ns = NodeChaser.this.newWeakHashSet();
                    NodeChaser.this.index.put(NodeChaser.this.getOwnerKey(newValue), ns);
                }
                ns.add((Node)ref.get());
                NodeChaser.this.onOwnerChanged((Node)ref.get(), oldValue, newValue);
            }
        };
        node.getProperty("Owner").registerListener(ol);
        this.ownerLsts.put(node, ol);
        ReplicationListener rl = new ReplicationListener(){

            @Override
            public void onReplicated(Replicating original, Replicating copy) {
                NodeChaser.this.chase((EditableNode)copy);
                NodeChaser.this.onReplicated((Node)((Object)original), (Node)((Object)copy));
            }
        };
        this.repLsts.put(node, rl);
        node.registerListener(rl);
        this.onNodeAdded(node);
    }

    protected void onNodeAdded(Node node) {
    }

    protected void onOwnerChanged(Node node, Owner oldValue, Owner newValue) {
    }

    protected void onReplicated(Node original, Node copy) {
    }
}

