/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.std;

import it.uniud.mads.jlibbig.core.exceptions.IncompatibleInterfaceException;
import it.uniud.mads.jlibbig.core.exceptions.IncompatibleSignatureException;
import it.uniud.mads.jlibbig.core.exceptions.InvalidInstantiationRuleException;
import it.uniud.mads.jlibbig.core.std.Bigraph;
import it.uniud.mads.jlibbig.core.std.BigraphBuilder;
import it.uniud.mads.jlibbig.core.std.EditableChild;
import it.uniud.mads.jlibbig.core.std.EditableHandle;
import it.uniud.mads.jlibbig.core.std.EditableInnerName;
import it.uniud.mads.jlibbig.core.std.EditableNode;
import it.uniud.mads.jlibbig.core.std.EditableOuterName;
import it.uniud.mads.jlibbig.core.std.EditableParent;
import it.uniud.mads.jlibbig.core.std.EditableRoot;
import it.uniud.mads.jlibbig.core.std.EditableSite;
import it.uniud.mads.jlibbig.core.std.InstantiationMap;
import it.uniud.mads.jlibbig.core.std.Match;
import it.uniud.mads.jlibbig.core.std.Matcher;
import it.uniud.mads.jlibbig.core.std.Node;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RewritingRule
implements it.uniud.mads.jlibbig.core.RewritingRule<Bigraph, Bigraph> {
    private static final boolean DEBUG;
    private static final boolean DEBUG_PRINT_MATCH;
    private static final boolean DEBUG_PRINT_RESULT;
    private static final boolean DEBUG_CONSISTENCY_CHECK;
    final Bigraph redex;
    final Bigraph reactum;
    final InstantiationMap eta;
    private Matcher matcher;

    public RewritingRule(Bigraph redex, Bigraph reactum, int ... eta) {
        this(Matcher.DEFAULT, redex, reactum, new InstantiationMap(redex.sites.size(), eta));
    }

    public RewritingRule(Matcher matcher, Bigraph redex, Bigraph reactum, int ... eta) {
        this(matcher, redex, reactum, new InstantiationMap(redex.sites.size(), eta));
    }

    public RewritingRule(Bigraph redex, Bigraph reactum, InstantiationMap eta) {
        this(Matcher.DEFAULT, redex, reactum, eta);
    }

    public RewritingRule(Matcher matcher, Bigraph redex, Bigraph reactum, InstantiationMap eta) {
        if (reactum.getSignature() != redex.getSignature()) {
            throw new IncompatibleSignatureException("Redex and reactum should have the same singature.", reactum.getSignature(), redex.getSignature());
        }
        if (redex.sites.size() < eta.getPlaceCodomain()) {
            throw new InvalidInstantiationRuleException("The instantiation rule does not match the redex inner interface.");
        }
        if (reactum.sites.size() != eta.getPlaceDomain()) {
            throw new InvalidInstantiationRuleException("The instantiation rule does not match the reactum inner interface.");
        }
        if (reactum.sites.size() != eta.getPlaceDomain()) {
            throw new InvalidInstantiationRuleException("The instantiation rule does not match the reactum inner interface.");
        }
        HashSet<String> xs = new HashSet<String>(reactum.outers.keySet());
        HashSet<String> ys = new HashSet<String>(redex.outers.keySet());
        HashSet<String> zs = new HashSet<String>(xs);
        xs.removeAll(ys);
        ys.removeAll(zs);
        if (redex.roots.size() != reactum.roots.size() || !xs.isEmpty() || !ys.isEmpty()) {
            throw new IncompatibleInterfaceException("Redex and reactum should have the same outer interface.");
        }
        xs = new HashSet<String>(reactum.inners.keySet());
        ys = new HashSet<String>(redex.inners.keySet());
        zs = new HashSet<String>(xs);
        xs.removeAll(ys);
        ys.removeAll(zs);
        if (!xs.isEmpty() || !ys.isEmpty()) {
            throw new IncompatibleInterfaceException("Redex and reactum should have the same set inner names.");
        }
        this.redex = redex;
        this.reactum = reactum;
        this.eta = eta;
        this.matcher = matcher == null ? Matcher.DEFAULT : matcher;
    }

    protected void instantiateReactumNode(Node original, Node instance, Match match) {
    }

    protected final Bigraph instantiateReactum(Match match) {
        Bigraph big;
        Bigraph reactum = this.getReactum();
        Bigraph owner = big = new Bigraph(reactum.signature);
        HashMap<EditableHandle, EditableHandle> hnd_dic = new HashMap<EditableHandle, EditableHandle>();
        for (EditableOuterName editableOuterName : reactum.outers.values()) {
            EditableOuterName o2 = editableOuterName.replicate();
            big.outers.put(o2.getName(), o2);
            o2.setOwner(owner);
            hnd_dic.put(editableOuterName, o2);
        }
        for (EditableInnerName editableInnerName : reactum.inners.values()) {
            EditableInnerName i2 = editableInnerName.replicate();
            EditableHandle h1 = editableInnerName.getHandle();
            Object h2 = (EditableHandle)hnd_dic.get(h1);
            if (h2 == null) {
                h2 = h1.replicate();
                h2.setOwner(owner);
                hnd_dic.put(h1, (EditableHandle)h2);
            }
            i2.setHandle((EditableHandle)h2);
            big.inners.put(i2.getName(), i2);
        }
        class Pair {
            final EditableChild c;
            final EditableParent p;

            Pair(EditableParent p, EditableChild c) {
                this.c = c;
                this.p = p;
            }
        }
        ArrayDeque<Pair> q = new ArrayDeque<Pair>();
        for (EditableRoot r1 : reactum.roots) {
            EditableRoot r2 = r1.replicate();
            big.roots.add(r2);
            r2.setOwner(owner);
            for (EditableChild c : r1.getEditableChildren()) {
                q.add(new Pair(r2, c));
            }
        }
        EditableSite[] editableSiteArray = new EditableSite[reactum.sites.size()];
        while (!q.isEmpty()) {
            Pair t = (Pair)q.poll();
            if (t.c instanceof EditableNode) {
                EditableNode n1 = (EditableNode)t.c;
                EditableNode n2 = n1.replicate();
                this.instantiateReactumNode(n1, n2, match);
                n2.setParent(t.p);
                for (int i = n1.getControl().getArity() - 1; 0 <= i; --i) {
                    EditableNode.EditablePort p1 = n1.getPort(i);
                    EditableHandle h1 = p1.getHandle();
                    EditableHandle h2 = (EditableHandle)hnd_dic.get(h1);
                    if (h2 == null) {
                        h2 = h1.replicate();
                        h2.setOwner(owner);
                        hnd_dic.put(h1, h2);
                    }
                    n2.getPort(i).setHandle(h2);
                }
                for (EditableChild c : n1.getEditableChildren()) {
                    q.add(new Pair(n2, c));
                }
                continue;
            }
            EditableSite s1 = (EditableSite)t.c;
            EditableSite s2 = s1.replicate();
            s2.setParent(t.p);
            editableSiteArray[reactum.sites.indexOf((Object)s1)] = s2;
        }
        big.sites.addAll(Arrays.asList(editableSiteArray));
        return big;
    }

    @Override
    public Bigraph getRedex() {
        return this.redex;
    }

    @Override
    public Bigraph getReactum() {
        return this.reactum;
    }

    public InstantiationMap getInstantiationRule() {
        return this.eta;
    }

    @Override
    public Iterable<Bigraph> apply(Bigraph to) {
        return this.apply(this.getMatcher(), to);
    }

    public Iterable<Bigraph> apply(Matcher m, Bigraph to) {
        return new RewriteIterable(m, to);
    }

    public Matcher getMatcher() {
        return this.matcher;
    }

    public void setMatcher(Matcher m) {
        this.matcher = m;
    }

    static {
        DEBUG_PRINT_MATCH = DEBUG = Boolean.getBoolean("it.uniud.mads.jlibbig.debug") || Boolean.getBoolean("it.uniud.mads.jlibbig.debug.reactions");
        DEBUG_PRINT_RESULT = DEBUG;
        DEBUG_CONSISTENCY_CHECK = Boolean.getBoolean("it.uniud.mads.jlibbig.consistency") || Boolean.getBoolean("it.uniud.mads.jlibbig.consistency.reactions");
    }

    private class RewriteIterable
    implements Iterable<Bigraph> {
        private final Matcher matcher;
        private final Bigraph target;
        private Iterable<? extends Match> mAble;

        RewriteIterable(Matcher m, Bigraph target) {
            this.target = target;
            this.matcher = m;
        }

        @Override
        public Iterator<Bigraph> iterator() {
            if (this.mAble == null) {
                this.mAble = this.matcher.match(this.target, RewritingRule.this.redex);
            }
            return new RewriteIterator();
        }

        private class RewriteIterator
        implements Iterator<Bigraph> {
            Iterator<? extends Match> mTor = null;
            Iterator<Bigraph> args = null;
            Bigraph big = null;

            private RewriteIterator() {
            }

            @Override
            public boolean hasNext() {
                if (this.mTor == null) {
                    this.mTor = RewriteIterable.this.mAble.iterator();
                }
                return this.mTor.hasNext() || this.args != null && this.args.hasNext();
            }

            @Override
            public Bigraph next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.args == null || !this.args.hasNext()) {
                    Match match = this.mTor.next();
                    if (DEBUG_PRINT_MATCH) {
                        System.out.println(match);
                    }
                    BigraphBuilder bb = new BigraphBuilder(RewritingRule.this.instantiateReactum(match), true);
                    bb.leftJuxtapose(match.getRedexId(), true);
                    bb.outerCompose((Bigraph)match.getContext(), true);
                    this.big = bb.makeBigraph(true);
                    this.args = RewritingRule.this.eta.instantiate((Bigraph)match.getParam()).iterator();
                }
                if (this.args.hasNext()) {
                    Bigraph params = this.args.next();
                    Bigraph result = this.args.hasNext() ? Bigraph.compose(this.big.clone(), params, true) : Bigraph.compose(this.big, params, true);
                    if (DEBUG_PRINT_RESULT) {
                        System.out.println(result);
                    }
                    if (DEBUG_CONSISTENCY_CHECK && !result.isConsistent()) {
                        throw new RuntimeException("Inconsistent bigraph");
                    }
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("");
            }
        }
    }
}

