/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.std;

import it.uniud.mads.jlibbig.core.std.Bigraph;
import it.uniud.mads.jlibbig.core.std.Child;
import it.uniud.mads.jlibbig.core.std.Edge;
import it.uniud.mads.jlibbig.core.std.EditableEdge;
import it.uniud.mads.jlibbig.core.std.EditableHandle;
import it.uniud.mads.jlibbig.core.std.EditableInnerName;
import it.uniud.mads.jlibbig.core.std.EditableNode;
import it.uniud.mads.jlibbig.core.std.EditableOuterName;
import it.uniud.mads.jlibbig.core.std.EditableParent;
import it.uniud.mads.jlibbig.core.std.EditableRoot;
import it.uniud.mads.jlibbig.core.std.EditableSite;
import it.uniud.mads.jlibbig.core.std.Handle;
import it.uniud.mads.jlibbig.core.std.InnerName;
import it.uniud.mads.jlibbig.core.std.LinkEntity;
import it.uniud.mads.jlibbig.core.std.Matcher;
import it.uniud.mads.jlibbig.core.std.Node;
import it.uniud.mads.jlibbig.core.std.Parent;
import it.uniud.mads.jlibbig.core.std.PlaceEntity;
import it.uniud.mads.jlibbig.core.std.Point;
import it.uniud.mads.jlibbig.core.std.Port;
import it.uniud.mads.jlibbig.core.std.Root;
import it.uniud.mads.jlibbig.core.std.Site;
import it.uniud.mads.jlibbig.core.std.WeightedMatch;
import it.uniud.mads.jlibbig.core.util.BidMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.expression.discrete.arithmetic.ArExpression;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;

public class WeightedMatcher
extends Matcher {
    private static final boolean DEBUG;
    private static final boolean DEBUG_PRINT_CSP_SOLUTIONS;
    private static final boolean DEBUG_PRINT_SOLUTION_FETCH;
    private static final boolean DEBUG_CONSISTENCY_CHECK;
    public static final WeightedMatcher DEFAULT;
    private final boolean maximizing;

    public WeightedMatcher() {
        this(true);
    }

    public WeightedMatcher(boolean maximizing) {
        this.maximizing = maximizing;
    }

    @Override
    public Iterable<? extends WeightedMatch> match(Bigraph agent, Bigraph redex) {
        return new MatchIterable(agent, redex);
    }

    protected int matchingWeight(Bigraph agent, Node agentNode, Bigraph redex, Node redexNode) {
        return 0;
    }

    static {
        DEBUG_PRINT_CSP_SOLUTIONS = DEBUG = Boolean.getBoolean("it.uniud.mads.jlibbig.debug") || Boolean.getBoolean("it.uniud.mads.jlibbig.debug.matchers");
        DEBUG_PRINT_SOLUTION_FETCH = DEBUG;
        DEBUG_CONSISTENCY_CHECK = Boolean.getBoolean("it.uniud.mads.jlibbig.consistency") || Boolean.getBoolean("it.uniud.mads.jlibbig.consistency.matchers");
        DEFAULT = new WeightedMatcher();
    }

    private class MatchIterable
    implements Iterable<WeightedMatch> {
        final Bigraph agent;
        final Bigraph redex;
        boolean agent_ancestors_is_empty = true;
        final Map<Child, Collection<Parent>> agent_ancestors;
        final List<? extends Root> agent_roots;
        final List<? extends Site> agent_sites;
        final Collection<? extends Node> agent_nodes;
        final Collection<Point> agent_points;
        final Collection<? extends Edge> agent_edges;
        final List<Handle> agent_handles;
        final List<? extends Root> redex_roots;
        final List<? extends Site> redex_sites;
        final Collection<? extends Node> redex_nodes;
        final Collection<Point> redex_points;
        final Collection<? extends Edge> redex_edges;
        final List<Handle> redex_handles;
        final int ars;
        final int ans;
        final int ass;
        final int ahs;
        final int aps;
        final int rrs;
        final int rns;
        final int rss;
        final int rhs;
        final int rps;
        final int rprs;
        final int rins;

        private MatchIterable(Bigraph agent, Bigraph redex) {
            if (!agent.isGround()) {
                throw new UnsupportedOperationException("Agent should be a bigraph with empty inner interface i.e. ground.");
            }
            if (!agent.signature.equals(redex.signature)) {
                throw new UnsupportedOperationException("Agent and redex should have the same singature.");
            }
            this.agent = agent;
            this.redex = redex;
            this.agent_roots = agent.getRoots();
            this.agent_nodes = agent.getNodes();
            this.agent_sites = agent.getSites();
            this.agent_edges = agent.getEdges();
            this.agent_handles = new LinkedList<Edge>(this.agent_edges);
            this.agent_handles.addAll(agent.getOuterNames());
            this.ars = this.agent_roots.size();
            this.ans = this.agent_nodes.size();
            this.ass = this.agent_sites.size();
            this.ahs = this.agent_handles.size();
            this.agent_points = new HashSet<Point>(this.ans);
            for (Node node : this.agent_nodes) {
                this.agent_points.addAll(node.getPorts());
            }
            this.agent_points.addAll(agent.getInnerNames());
            this.aps = this.agent_points.size();
            this.agent_ancestors = new HashMap<Child, Collection<Parent>>(this.ans);
            this.redex_roots = redex.getRoots();
            this.redex_sites = redex.getSites();
            this.redex_nodes = redex.getNodes();
            this.redex_edges = redex.getEdges();
            this.redex_handles = new LinkedList<Edge>(this.redex_edges);
            this.redex_handles.addAll(redex.getOuterNames());
            this.rrs = this.redex_roots.size();
            this.rns = this.redex_nodes.size();
            this.rss = this.redex_sites.size();
            this.rhs = this.redex_handles.size();
            this.redex_points = new HashSet<Point>(this.rns);
            for (Node node : this.redex_nodes) {
                this.redex_points.addAll(node.getPorts());
            }
            this.rprs = this.redex_points.size();
            this.redex_points.addAll(redex.getInnerNames());
            this.rps = this.redex_points.size();
            this.rins = this.rps - this.rprs;
        }

        @Override
        public Iterator<WeightedMatch> iterator() {
            return new MatchIterator();
        }

        private class MatchIterator
        implements Iterator<WeightedMatch> {
            private boolean mayHaveNext = true;
            private boolean firstRun = true;
            private WeightedMatch nextMatch = null;
            private final Model model;
            private final Solver solver;
            final Map<PlaceEntity, Map<PlaceEntity, IntVar>> p_vars;
            final Map<LinkEntity, Map<LinkEntity, IntVar>> e_vars;
            final Map<Handle, Map<Handle, IntVar>> f_vars;
            private IntVar weight;

            MatchIterator() {
                this.p_vars = new IdentityHashMap<PlaceEntity, Map<PlaceEntity, IntVar>>(MatchIterable.this.ars + MatchIterable.this.ans + MatchIterable.this.ass);
                this.e_vars = new IdentityHashMap<LinkEntity, Map<LinkEntity, IntVar>>(MatchIterable.this.ahs * MatchIterable.this.rhs + MatchIterable.this.aps * (1 + MatchIterable.this.rps));
                this.f_vars = new IdentityHashMap<Handle, Map<Handle, IntVar>>(MatchIterable.this.rhs);
                this.model = new Model();
                this.solver = this.instantiateModel();
                if (DEBUG) {
                    System.out.println("- MODEL CREATED ---------------------");
                    System.out.println("- AGENT -----------------------------");
                    System.out.println(MatchIterable.this.agent);
                    System.out.println("- REDEX -----------------------------");
                    System.out.println(MatchIterable.this.redex);
                    System.out.println("-------------------------------------");
                }
            }

            private Variable findVariable(String name, Variable[] vars) {
                for (Variable v : vars) {
                    if (!name.equals(v.getName())) continue;
                    return v;
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Could not resolve type clashes
             */
            private Solver instantiateModel() {
                Object vf;
                Map<Handle, IntVar> f_row;
                Collection<Parent> ancs;
                Object g;
                Object f_row2;
                Map<PlaceEntity, IntVar> i_row;
                Object var;
                Map<Object, Object> row;
                int kj;
                int ki = 0;
                for (Iterator<Point> i : MatchIterable.this.agent_roots) {
                    kj = 0;
                    row = new HashMap(MatchIterable.this.rrs + MatchIterable.this.rns + MatchIterable.this.rss);
                    for (PlaceEntity j : MatchIterable.this.redex_roots) {
                        var = this.model.boolVar(ki + "_" + kj++);
                        row.put(j, var);
                    }
                    for (PlaceEntity j : MatchIterable.this.redex_nodes) {
                        var = this.model.boolVar(ki + "_" + kj++);
                        this.model.arithm((IntVar)var, "=", 0).post();
                        row.put(j, var);
                    }
                    for (PlaceEntity j : MatchIterable.this.redex_sites) {
                        var = this.model.boolVar(ki + "_" + kj++);
                        this.model.arithm((IntVar)var, "=", 0).post();
                        row.put(j, var);
                    }
                    this.p_vars.put((PlaceEntity)((Object)i), (Map<PlaceEntity, IntVar>)row);
                    ++ki;
                }
                for (Iterator<Point> i : MatchIterable.this.agent_nodes) {
                    kj = 0;
                    row = new HashMap(MatchIterable.this.rrs + MatchIterable.this.rns + MatchIterable.this.rss);
                    for (PlaceEntity j : MatchIterable.this.redex_roots) {
                        var = this.model.boolVar(ki + "_" + kj++);
                        row.put(j, var);
                    }
                    for (PlaceEntity j : MatchIterable.this.redex_nodes) {
                        var = this.model.boolVar(ki + "_" + kj++);
                        row.put(j, var);
                    }
                    for (PlaceEntity j : MatchIterable.this.redex_sites) {
                        var = this.model.boolVar(ki + "_" + kj++);
                        row.put(j, var);
                    }
                    this.p_vars.put((PlaceEntity)((Object)i), (Map<PlaceEntity, IntVar>)row);
                    ++ki;
                }
                for (Iterator<Point> i : MatchIterable.this.agent_sites) {
                    kj = 0;
                    row = new HashMap(MatchIterable.this.rss);
                    for (PlaceEntity j : MatchIterable.this.redex_sites) {
                        var = this.model.boolVar(ki + "_" + kj++);
                        row.put(j, var);
                    }
                    this.p_vars.put((PlaceEntity)((Object)i), row);
                    ++ki;
                }
                ki = 0;
                for (Object hr : MatchIterable.this.redex_handles) {
                    kj = 0;
                    row = new IdentityHashMap(MatchIterable.this.ahs);
                    for (Handle ha : MatchIterable.this.agent_handles) {
                        var = this.model.boolVar("F_" + ki + "_" + kj++);
                        row.put(ha, var);
                    }
                    this.f_vars.put((Handle)hr, (Map<Handle, IntVar>)row);
                    ++ki;
                }
                ki = 0;
                for (Point pi : MatchIterable.this.agent_points) {
                    kj = 0;
                    row = new IdentityHashMap(MatchIterable.this.rps + 1);
                    EditableHandle hi = pi.getHandle();
                    BoolVar var2 = this.model.boolVar("PH_" + ki);
                    row.put(hi, var2);
                    for (Point pj : MatchIterable.this.redex_points) {
                        var2 = this.model.boolVar("PP_" + ki + "_" + kj++);
                        row.put(pj, var2);
                    }
                    this.e_vars.put(pi, (Map<LinkEntity, IntVar>)row);
                    ++ki;
                }
                ki = 0;
                for (Handle hj : MatchIterable.this.redex_handles) {
                    kj = 0;
                    row = new IdentityHashMap(MatchIterable.this.ahs);
                    for (Iterator<? extends Site> hi : MatchIterable.this.agent_handles) {
                        var = this.model.intVar("HH_" + ki + "_" + kj++, 0, hi.getPoints().size());
                        row.put(hi, var);
                    }
                    this.e_vars.put(hj, (Map<LinkEntity, IntVar>)row);
                    ++ki;
                }
                this.weight = this.model.intVar("OPT", Short.MIN_VALUE, Short.MAX_VALUE, true);
                LinkedList<IntVar> weights = new LinkedList<IntVar>();
                for (Iterator<Point> i : MatchIterable.this.agent_nodes) {
                    Parent f = i.getParent();
                    i_row = this.p_vars.get(i);
                    f_row2 = this.p_vars.get(f);
                    for (PlaceEntity j : MatchIterable.this.redex_nodes) {
                        g = j.getParent();
                        this.model.arithm(i_row.get(j), "<=", (IntVar)f_row2.get(g)).post();
                    }
                    for (PlaceEntity j : MatchIterable.this.redex_sites) {
                        g = j.getParent();
                        this.model.arithm(i_row.get(j), "<=", (IntVar)f_row2.get(g)).post();
                    }
                }
                for (Iterator<Point> i : MatchIterable.this.agent_sites) {
                    Parent f = i.getParent();
                    i_row = this.p_vars.get(i);
                    f_row2 = this.p_vars.get(f);
                    for (PlaceEntity j : MatchIterable.this.redex_sites) {
                        g = j.getParent();
                        this.model.arithm(i_row.get(j), "<=", (IntVar)f_row2.get(g)).post();
                    }
                }
                ArrayDeque<Node> qa = new ArrayDeque<Node>();
                Iterator<? extends Node> qp = new ArrayDeque<Node>();
                for (Object r : MatchIterable.this.agent_roots) {
                    for (Child c : r.getChildren()) {
                        if (!c.isNode()) continue;
                        qa.add((Node)c);
                    }
                }
                while (!qa.isEmpty()) {
                    Node n = (Node)qa.poll();
                    if (n.getControl().isActive()) {
                        for (Object c : n.getChildren()) {
                            if (!c.isNode()) continue;
                            qa.add((Node)c);
                        }
                        continue;
                    }
                    qp.add(n);
                }
                qa.clear();
                while (!qp.isEmpty()) {
                    Child i = (Child)qp.poll();
                    row = this.p_vars.get(i);
                    for (PlaceEntity j : MatchIterable.this.redex_roots) {
                        this.model.arithm((IntVar)row.get(j), "=", 0).post();
                    }
                    if (!i.isNode()) continue;
                    for (Child c : ((Node)i).getChildren()) {
                        if (!c.isNode()) continue;
                        qp.add((Node)c);
                    }
                }
                Object vars = new IntVar[MatchIterable.this.ars + MatchIterable.this.ans];
                for (Parent j : MatchIterable.this.redex_roots) {
                    int k = 0;
                    for (Object i : this.p_vars.keySet()) {
                        if (i.isSite()) continue;
                        vars[k++] = this.p_vars.get(i).get(j);
                    }
                    this.model.sum((IntVar[])vars, "=", 1).post();
                }
                vars = new IntVar[MatchIterable.this.ans + MatchIterable.this.ass];
                for (Parent j : MatchIterable.this.redex_nodes) {
                    int k = 0;
                    for (Object i : this.p_vars.keySet()) {
                        if (i.isRoot()) continue;
                        vars[k++] = this.p_vars.get(i).get(j);
                    }
                    this.model.sum((IntVar[])vars, "=", 1).post();
                }
                for (Iterator<Point> i : MatchIterable.this.agent_nodes) {
                    Map<PlaceEntity, IntVar> row2 = this.p_vars.get(i);
                    IntVar[] vars2 = new IntVar[MatchIterable.this.rns + MatchIterable.this.rss];
                    int k = 0;
                    for (PlaceEntity j : MatchIterable.this.redex_nodes) {
                        vars2[k++] = row2.get(j);
                    }
                    for (PlaceEntity j : MatchIterable.this.redex_sites) {
                        vars2[k++] = row2.get(j);
                    }
                    IntVar t1 = this.model.intVar(MatchIterable.this.rrs);
                    IntVar c = this.model.intVar(0);
                    for (Object v : vars2) {
                        c = c.add((ArExpression)v).intVar();
                    }
                    c = c.mul((ArExpression)t1).intVar();
                    vars2 = new IntVar[MatchIterable.this.rrs];
                    k = 0;
                    for (Root j : MatchIterable.this.redex_roots) {
                        vars2[k++] = row2.get(j);
                    }
                    t1 = this.model.intVar(0);
                    for (Object v : vars2) {
                        t1 = t1.add((ArExpression)v).intVar();
                    }
                    t1 = t1.add((ArExpression)c).intVar();
                    this.model.arithm(t1, "<=", MatchIterable.this.rrs).post();
                }
                for (Iterator<PlaceEntity> f : MatchIterable.this.agent_nodes) {
                    Collection<? extends Child> cf = f.getChildren();
                    for (Parent g2 : MatchIterable.this.redex_nodes) {
                        Collection<? extends Child> cg = g2.getChildren();
                        IntVar[] vars3 = new IntVar[cf.size() * cg.size()];
                        int k = 0;
                        for (PlaceEntity i : cf) {
                            Object v;
                            v = cg.iterator();
                            while (v.hasNext()) {
                                PlaceEntity j = v.next();
                                vars3[k++] = this.p_vars.get(i).get(j);
                            }
                        }
                        IntVar chld = this.p_vars.get(f).get(g2);
                        this.model.sum(vars3, ">=", chld.mul(cf.size()).intVar()).post();
                    }
                }
                Object cgs = new HashMap<Root, HashSet<? extends Child>>(MatchIterable.this.rrs);
                for (Root g3 : MatchIterable.this.redex_roots) {
                    HashSet<? extends Child> cg = new HashSet<Child>(g3.getChildren());
                    cg.removeAll(MatchIterable.this.redex_sites);
                    cgs.put(g3, cg);
                }
                for (Object f : this.p_vars.keySet()) {
                    if (f.isSite()) continue;
                    Collection<? extends Child> cf = ((Parent)f).getChildren();
                    for (Root g4 : MatchIterable.this.redex_roots) {
                        Collection cg = (Collection)cgs.get(g4);
                        IntVar[] vars4 = new IntVar[cf.size() * cg.size()];
                        int k = 0;
                        for (Child i : cf) {
                            for (Object j : cg) {
                                vars4[k++] = this.p_vars.get(i).get(j);
                            }
                        }
                        IntVar chld = this.p_vars.get(f).get(g4);
                        this.model.sum(vars4, ">=", chld.mul(cg.size()).intVar()).post();
                    }
                }
                if (MatchIterable.this.agent_ancestors_is_empty) {
                    cgs = MatchIterable.this.agent_ancestors;
                    synchronized (cgs) {
                        if (MatchIterable.this.agent_ancestors_is_empty) {
                            Stack<Object> ancs2 = new Stack<Object>();
                            Stack<Parent> visit = new Stack<Parent>();
                            for (Root r : MatchIterable.this.agent_roots) {
                                ancs2.clear();
                                visit.add(r);
                                while (!visit.isEmpty()) {
                                    Parent p = (Parent)visit.pop();
                                    if (p.isNode()) {
                                        Node n = (Node)p;
                                        while (!ancs2.isEmpty() && ancs2.peek() != n.getParent()) {
                                            ancs2.pop();
                                        }
                                    }
                                    ancs2.push(p);
                                    for (Child c : p.getChildren()) {
                                        if (c.isParent()) {
                                            visit.add((Parent)((Object)c));
                                        }
                                        MatchIterable.this.agent_ancestors.put(c, new ArrayList(ancs2));
                                    }
                                }
                            }
                            MatchIterable.this.agent_ancestors_is_empty = false;
                        }
                    }
                }
                for (Iterator<Point> i : MatchIterable.this.agent_nodes) {
                    ancs = MatchIterable.this.agent_ancestors.get(i);
                    IntVar[] vars5 = new IntVar[(ancs.size() - 1) * MatchIterable.this.rss];
                    int k = 0;
                    for (IntVar[] f : ancs) {
                        if (!f.isNode()) continue;
                        Map<PlaceEntity, IntVar> f_row3 = this.p_vars.get(f);
                        for (Site g5 : MatchIterable.this.redex_sites) {
                            vars5[k++] = f_row3.get(g5);
                        }
                    }
                    Object sum = this.model.intVar(0);
                    for (IntVar v : vars5) {
                        sum = sum.add((ArExpression)v).intVar();
                    }
                    Map<PlaceEntity, IntVar> i_row2 = this.p_vars.get(i);
                    for (Root j : MatchIterable.this.redex_roots) {
                        this.model.arithm(sum.add((ArExpression)i_row2.get(j)).intVar(), "<=", 1).post();
                    }
                }
                vars = new IntVar[MatchIterable.this.rrs + MatchIterable.this.rns + MatchIterable.this.rss];
                for (Child i : MatchIterable.this.agent_sites) {
                    vars = (IntVar[])this.p_vars.get(i).values().toArray((T[])vars);
                    this.model.sum((IntVar[])vars, "<=", 1).post();
                }
                vars = new IntVar[MatchIterable.this.rps + 1];
                for (Point p : MatchIterable.this.agent_points) {
                    vars = (IntVar[])this.e_vars.get(p).values().toArray((T[])vars);
                    this.model.sum((IntVar[])vars, "=", 1).post();
                }
                for (Iterator<Point> ha : MatchIterable.this.agent_handles) {
                    Collection<? extends Point> ps = ha.getPoints();
                    IntVar[] vars1 = new IntVar[MatchIterable.this.rhs + ps.size()];
                    int k = 0;
                    for (Point p : ps) {
                        vars1[k++] = this.e_vars.get(p).get(ha);
                    }
                    for (Object hr : MatchIterable.this.redex_handles) {
                        vars1[k++] = this.e_vars.get(hr).get(ha);
                    }
                    this.model.sum(vars1, "=", ps.size()).post();
                }
                IntVar[] vars1 = new IntVar[MatchIterable.this.ahs];
                for (Handle hr : MatchIterable.this.redex_handles) {
                    Collection<? extends Point> ps = hr.getPoints();
                    int k = 0;
                    IntVar[] vars2 = new IntVar[MatchIterable.this.aps * ps.size()];
                    for (IntVar[] pa : MatchIterable.this.agent_points) {
                        Map<LinkEntity, IntVar> row3 = this.e_vars.get(pa);
                        for (Point pr : ps) {
                            vars2[k++] = row3.get(pr);
                        }
                    }
                    vars1 = this.e_vars.get(hr).values().toArray(vars1);
                    IntVar sum1 = this.model.intVar(0);
                    for (Object v : vars1) {
                        sum1 = sum1.add((ArExpression)v).intVar();
                    }
                    this.model.sum(vars2, "=", sum1).post();
                }
                vars = new IntVar[MatchIterable.this.aps];
                for (Point pr : MatchIterable.this.redex_points) {
                    if (!pr.isPort()) continue;
                    int k = 0;
                    for (Point pa : MatchIterable.this.agent_points) {
                        vars[k++] = this.e_vars.get(pa).get(pr);
                    }
                    this.model.sum((IntVar[])vars, "=", 1).post();
                }
                for (Object hr : MatchIterable.this.redex_handles) {
                    f_row = this.f_vars.get(hr);
                    Map<LinkEntity, IntVar> e_row = this.e_vars.get(hr);
                    if (hr.getPoints().isEmpty()) continue;
                    for (Handle ha : MatchIterable.this.agent_handles) {
                        if (ha.getPoints().isEmpty()) continue;
                        vf = f_row.get(ha);
                        IntVar ve = e_row.get(ha);
                        this.model.arithm(ve, "<=", vf.mul(ha.getPoints().size()).intVar()).post();
                        this.model.arithm((IntVar)vf, "<=", ve).post();
                    }
                }
                for (Object hr : MatchIterable.this.redex_handles) {
                    f_row = this.f_vars.get(hr);
                    Collection<? extends Point> ps = hr.getPoints();
                    for (Handle ha : MatchIterable.this.agent_handles) {
                        vf = f_row.get(ha);
                        int k = 0;
                        IntVar[] vars6 = new IntVar[ps.size() * ha.getPoints().size()];
                        for (Point pa : ha.getPoints()) {
                            Map<LinkEntity, IntVar> e_row = this.e_vars.get(pa);
                            for (Point pr : ps) {
                                IntVar ve = e_row.get(pr);
                                vars6[k++] = ve;
                                this.model.arithm(ve, "<=", (IntVar)vf).post();
                            }
                            if (!hr.isEdge()) continue;
                            this.model.arithm(vf.add((ArExpression)this.e_vars.get(pa).get(ha)).intVar(), "<=", 1).post();
                        }
                        if (ps.isEmpty() && ha.getPoints().isEmpty()) continue;
                        this.model.sum(vars6, ">=", (IntVar)vf).post();
                    }
                }
                vars = new IntVar[MatchIterable.this.ahs];
                for (Handle hr : MatchIterable.this.redex_handles) {
                    Map<Handle, IntVar> f_row4 = this.f_vars.get(hr);
                    this.model.sum((IntVar[])f_row4.values().toArray((T[])vars), "<=", 1).post();
                }
                ListIterator<Handle> ir1 = MatchIterable.this.redex_handles.listIterator(0);
                while (ir1.hasNext()) {
                    Handle hr1 = ir1.next();
                    Map<Handle, IntVar> f_row1 = this.f_vars.get(hr1);
                    if (hr1.isEdge()) {
                        for (Handle ha : MatchIterable.this.agent_handles) {
                            if (!ha.isOuterName()) continue;
                            this.model.arithm(f_row1.get(ha), "=", 0).post();
                        }
                    }
                    ListIterator<Handle> ir2 = MatchIterable.this.redex_handles.listIterator(ir1.nextIndex());
                    while (ir2.hasNext()) {
                        Handle hr2 = ir2.next();
                        Map<Handle, IntVar> f_row22 = this.f_vars.get(hr2);
                        if (hr1.isEdge() == hr2.isEdge()) continue;
                        for (Handle ha : MatchIterable.this.agent_handles) {
                            this.model.arithm(f_row1.get(ha).add((ArExpression)f_row22.get(ha)).intVar(), "<=", 1).post();
                        }
                    }
                }
                vars = new IntVar[MatchIterable.this.redex_edges.size()];
                for (Handle ha : MatchIterable.this.agent_handles) {
                    int k = 0;
                    for (Handle hr : MatchIterable.this.redex_edges) {
                        vars[k++] = this.f_vars.get(hr).get(ha);
                    }
                    this.model.sum((IntVar[])vars, "<=", 1).post();
                }
                for (Node ni : MatchIterable.this.agent_nodes) {
                    Map<PlaceEntity, IntVar> p_row = this.p_vars.get(ni);
                    for (Node nj : MatchIterable.this.redex_nodes) {
                        IntVar m = p_row.get(nj);
                        boolean comp = WeightedMatcher.this.areMatchable(MatchIterable.this.agent, ni, MatchIterable.this.redex, nj);
                        if (comp) {
                            Integer w = WeightedMatcher.this.matchingWeight(MatchIterable.this.agent, ni, MatchIterable.this.redex, nj);
                            if (w != 0) {
                                weights.add(m.mul(w.intValue()).intVar());
                            }
                        } else {
                            this.model.arithm(m, "=", 0).post();
                        }
                        for (int i = ni.getControl().getArity() - 1; 0 <= i; --i) {
                            Map<LinkEntity, IntVar> e_row = this.e_vars.get(ni.getPort(i));
                            for (int j = nj.getControl().getArity() - 1; 0 <= j; --j) {
                                if (comp && i == j) {
                                    this.model.arithm(m, "=", e_row.get(nj.getPort(j))).post();
                                    continue;
                                }
                                this.model.arithm(e_row.get(nj.getPort(j)), "=", 0).post();
                            }
                        }
                    }
                }
                for (Node ni : MatchIterable.this.agent_nodes) {
                    ancs = MatchIterable.this.agent_ancestors.get(ni);
                    IntVar[] vars2 = new IntVar[(1 + ancs.size()) * MatchIterable.this.rss];
                    int k2 = 0;
                    for (Parent f : ancs) {
                        Map<PlaceEntity, IntVar> row4 = this.p_vars.get(f);
                        for (Site g6 : MatchIterable.this.redex_sites) {
                            vars2[k2++] = row4.get(g6);
                        }
                    }
                    Map<PlaceEntity, IntVar> row5 = this.p_vars.get(ni);
                    for (Site g7 : MatchIterable.this.redex_sites) {
                        vars2[k2++] = row5.get(g7);
                    }
                    IntVar sum2 = this.model.intVar(0);
                    for (IntVar v : vars2) {
                        sum2 = sum2.add((ArExpression)v).intVar();
                    }
                    for (Port pi : ni.getPorts()) {
                        Map<LinkEntity, IntVar> row6 = this.e_vars.get(pi);
                        IntVar[] vars4 = new IntVar[MatchIterable.this.rins];
                        int k4 = 0;
                        for (Point in : MatchIterable.this.redex.getInnerNames()) {
                            IntVar var3 = row6.get(in);
                            vars4[k4++] = var3;
                        }
                        this.model.sum(vars4, "<=", sum2).post();
                    }
                }
                vars = new IntVar[weights.size()];
                vars = (IntVar[])weights.toArray((T[])vars);
                this.model.sum((IntVar[])vars, "=", this.weight).post();
                this.model.setObjective(WeightedMatcher.this.maximizing, (Variable)this.weight);
                Solver solver = this.model.getSolver();
                return solver;
            }

            @Override
            public boolean hasNext() {
                if (this.mayHaveNext && this.nextMatch == null) {
                    this.fetchSolution();
                }
                return this.mayHaveNext && this.nextMatch != null;
            }

            @Override
            public WeightedMatch next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                WeightedMatch res = this.nextMatch;
                this.nextMatch = null;
                return res;
            }

            @Override
            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException("");
            }

            private void noMoreSolutions() {
                this.mayHaveNext = false;
                this.solver.hardReset();
            }

            /*
             * WARNING - void declaration
             */
            private void fetchSolution() {
                EditableHandle h1;
                EditableInnerName i2;
                String name;
                boolean first = this.firstRun;
                this.firstRun = false;
                if (DEBUG_PRINT_SOLUTION_FETCH) {
                    System.out.println("fetch solution has been invoked...");
                }
                if (!this.solver.solve()) {
                    if (DEBUG_PRINT_SOLUTION_FETCH) {
                        System.out.println("...but no more solutions where found.");
                    }
                    this.noMoreSolutions();
                    return;
                }
                int mWeight = 0;
                if (DEBUG_PRINT_CSP_SOLUTIONS) {
                    IntVar v;
                    void var5_17;
                    Iterator<LinkEntity> row;
                    Object v2;
                    int j;
                    void var5_14;
                    void var5_12;
                    void var5_9;
                    System.out.println("Solution: #" + this.solver.getSolutionCount());
                    System.out.print('\n');
                    int[] p_cell_width = new int[1 + MatchIterable.this.rrs + MatchIterable.this.rns + MatchIterable.this.rss];
                    p_cell_width[0] = 6;
                    for (Node node : MatchIterable.this.agent_nodes) {
                        p_cell_width[0] = Math.max(p_cell_width[0], node.toString().length());
                    }
                    System.out.printf("%-" + p_cell_width[0] + "s|", "P_VARS");
                    int c = 1;
                    boolean bl = false;
                    while (var5_9 < MatchIterable.this.rrs) {
                        String string = "R_" + (int)var5_9;
                        p_cell_width[c] = string.length();
                        System.out.printf("%-" + p_cell_width[c] + "s|", string);
                        ++var5_9;
                        ++c;
                    }
                    for (Node node : MatchIterable.this.redex_nodes) {
                        String s3 = node.toString();
                        p_cell_width[c] = s3.length();
                        System.out.printf("%-" + p_cell_width[c++] + "s|", s3);
                    }
                    boolean bl2 = false;
                    while (var5_12 < MatchIterable.this.rss) {
                        String string = "S_" + (int)var5_12;
                        p_cell_width[c] = string.length();
                        System.out.printf("%-" + p_cell_width[c] + "s|", string);
                        ++var5_12;
                        ++c;
                    }
                    boolean bl3 = false;
                    while (var5_14 < MatchIterable.this.ars) {
                        System.out.printf("\nR_%-" + (p_cell_width[0] - 2) + "d|", (int)var5_14);
                        c = 1;
                        Root root = MatchIterable.this.agent_roots.get((int)var5_14);
                        Map<PlaceEntity, IntVar> row2 = this.p_vars.get(root);
                        for (j = 0; j < MatchIterable.this.rrs; ++j) {
                            Root root2 = MatchIterable.this.redex_roots.get(j);
                            IntVar v22 = this.findVariable(row2.get(root2).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v22.getValue());
                        }
                        for (Node node : MatchIterable.this.redex_nodes) {
                            v2 = this.findVariable(row2.get(node).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v2.getValue());
                        }
                        for (j = 0; j < MatchIterable.this.rss; ++j) {
                            Site site = MatchIterable.this.redex_sites.get(j);
                            v2 = this.findVariable(row2.get(site).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v2.getValue());
                        }
                        ++var5_14;
                    }
                    for (Node node : MatchIterable.this.agent_nodes) {
                        System.out.printf("\n%-" + p_cell_width[0] + "s|", node);
                        c = 1;
                        row = this.p_vars.get(node);
                        for (j = 0; j < MatchIterable.this.rrs; ++j) {
                            Root root = MatchIterable.this.redex_roots.get(j);
                            v2 = this.findVariable(row.get(root).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v2.getValue());
                        }
                        for (Node node2 : MatchIterable.this.redex_nodes) {
                            v2 = this.findVariable(row.get(node2).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v2.getValue());
                        }
                        for (j = 0; j < MatchIterable.this.rss; ++j) {
                            Site site = MatchIterable.this.redex_sites.get(j);
                            v2 = this.findVariable(((IntVar)row.get(site)).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v2.getValue());
                        }
                    }
                    boolean bl4 = false;
                    while (var5_17 < MatchIterable.this.ass) {
                        System.out.printf("\nS_%-" + (p_cell_width[0] - 2) + "d|", (int)var5_17);
                        c = 1;
                        Root root = MatchIterable.this.agent_roots.get((int)var5_17);
                        row = this.p_vars.get(root);
                        for (j = 0; j < MatchIterable.this.rrs; ++j) {
                            System.out.printf("%" + p_cell_width[c++] + "d|", Character.valueOf(' '));
                        }
                        for (j = 0; j < MatchIterable.this.rns; ++j) {
                            System.out.printf("%" + p_cell_width[c++] + "d|", Character.valueOf(' '));
                        }
                        for (j = 0; j < MatchIterable.this.rss; ++j) {
                            Site site = MatchIterable.this.redex_sites.get(j);
                            v2 = this.findVariable(((IntVar)row.get(site)).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + p_cell_width[c++] + "d|", v2.getValue());
                        }
                        ++var5_17;
                    }
                    System.out.println('\n');
                    int[] nArray = new int[1 + MatchIterable.this.ahs];
                    int[] nArray2 = new int[1 + MatchIterable.this.rps + MatchIterable.this.ahs];
                    nArray[0] = 6;
                    for (Handle n : MatchIterable.this.redex_handles) {
                        nArray[0] = Math.max(nArray[0], n.toString().length());
                    }
                    nArray2[0] = nArray[0];
                    for (Point n : MatchIterable.this.agent_points) {
                        nArray2[0] = Math.max(nArray2[0], n.toString().length());
                    }
                    System.out.printf("%-" + nArray2[0] + "s|", "E_VARS");
                    c = 1;
                    for (Point p : MatchIterable.this.redex_points) {
                        String string = p.toString();
                        nArray2[c] = string.length();
                        System.out.printf("%-" + nArray2[c++] + "s|", string);
                    }
                    for (Handle h : MatchIterable.this.agent_handles) {
                        String string = h.toString();
                        nArray2[c] = string.length();
                        System.out.printf("%-" + nArray2[c++] + "s|", string);
                    }
                    for (Point pi : MatchIterable.this.agent_points) {
                        System.out.printf("\n%-" + nArray2[0] + "s|", pi);
                        c = 1;
                        Map<LinkEntity, IntVar> map = this.e_vars.get(pi);
                        for (Point pj : MatchIterable.this.redex_points) {
                            v = this.findVariable(map.get(pj).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + nArray2[c++] + "d|", v.getValue());
                        }
                        for (Handle hj : MatchIterable.this.agent_handles) {
                            if (map.containsKey(hj)) {
                                v = this.findVariable(map.get(hj).getName(), this.model.getVars()).asIntVar();
                                System.out.printf("%" + nArray2[c++] + "d|", v.getValue());
                                continue;
                            }
                            System.out.printf("%" + nArray2[c++] + "c|", Character.valueOf(' '));
                        }
                    }
                    for (Handle hi : MatchIterable.this.redex_handles) {
                        System.out.printf("\n%-" + nArray2[0] + "s|", hi);
                        c = 1;
                        Map<LinkEntity, IntVar> map = this.e_vars.get(hi);
                        for (int j2 = MatchIterable.this.rps; 0 < j2; --j2) {
                            System.out.printf("%" + nArray2[c++] + "c|", Character.valueOf(' '));
                        }
                        for (Handle hj : MatchIterable.this.agent_handles) {
                            v = this.findVariable(map.get(hj).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + nArray2[c++] + "d|", v.getValue());
                        }
                    }
                    System.out.println('\n');
                    System.out.printf("%" + nArray[0] + "s|", "F_VARS");
                    c = 1;
                    for (Handle h : MatchIterable.this.agent_handles) {
                        String string = h.toString();
                        nArray[c] = string.length();
                        System.out.printf("%-" + nArray[c++] + "s|", string);
                    }
                    for (Handle hi : MatchIterable.this.redex_handles) {
                        System.out.printf("\n%-" + nArray[0] + "s|", hi);
                        c = 1;
                        Map<Handle, IntVar> map = this.f_vars.get(hi);
                        for (Handle hj : MatchIterable.this.agent_handles) {
                            v = this.findVariable(map.get(hj).getName(), this.model.getVars()).asIntVar();
                            System.out.printf("%" + nArray[c++] + "d|", v.getValue());
                        }
                    }
                    IntVar v3 = this.findVariable(this.weight.getName(), this.model.getVars()).asIntVar();
                    mWeight = v3.getValue();
                    System.out.printf("\n\nOPT = %d\n\n", mWeight);
                }
                Bigraph ctx = new Bigraph(MatchIterable.this.agent.signature);
                Bigraph rdx = new Bigraph(MatchIterable.this.agent.signature);
                Bigraph bigraph = new Bigraph(MatchIterable.this.agent.signature);
                Bigraph bigraph2 = new Bigraph(MatchIterable.this.agent.signature);
                BidMap<Node, Node> nEmb = new BidMap<Node, Node>(MatchIterable.this.rns);
                EditableSite[] ctx_sites_dic = new EditableSite[MatchIterable.this.rrs];
                EditableSite[] editableSiteArray = new EditableSite[MatchIterable.this.rss];
                EditableRoot[] rdx_roots_dic = new EditableRoot[MatchIterable.this.rrs];
                EditableRoot[] prm_roots_dic = new EditableRoot[MatchIterable.this.rss];
                EditableSite[] prm_sites_dic = new EditableSite[MatchIterable.this.ass];
                IdentityHashMap<Object, EditableHandle> ctx_hnd_dic = new IdentityHashMap<Object, EditableHandle>();
                IdentityHashMap<EditableHandle, EditableHandle> rdx_hnd_dic = new IdentityHashMap<EditableHandle, EditableHandle>();
                IdentityHashMap<EditableHandle, Object> prm_hnd_dic = new IdentityHashMap<EditableHandle, Object>();
                IdentityHashMap<EditableHandle, Object> handle_img = new IdentityHashMap<EditableHandle, Object>(MatchIterable.this.rhs);
                class VState {
                    final PlaceEntity c;
                    final PlaceEntity i;
                    final EditableParent p;
                    final Bigraph b;

                    VState(Bigraph b, EditableParent p, PlaceEntity c) {
                        this(b, p, c, null);
                    }

                    VState(Bigraph b, EditableParent p, PlaceEntity c, PlaceEntity i) {
                        this.i = i;
                        this.c = c;
                        this.p = p;
                        this.b = b;
                    }
                }
                ArrayDeque<VState> q = new ArrayDeque<VState>();
                for (EditableOuterName o1 : MatchIterable.this.agent.outers.values()) {
                    EditableOuterName o2 = o1.replicate();
                    ctx.outers.put(o2.getName(), o2);
                    o2.setOwner(ctx);
                    ctx_hnd_dic.put(o1, o2);
                }
                for (EditableOuterName o0 : MatchIterable.this.redex.outers.values()) {
                    EditableHandle h2;
                    void var23_90;
                    name = o0.getName();
                    EditableOuterName o2 = new EditableOuterName(name);
                    rdx.outers.put(name, o2);
                    o2.setOwner(rdx);
                    rdx_hnd_dic.put(o0, o2);
                    EditableInnerName i1 = new EditableInnerName(name);
                    ctx.inners.put(name, i1);
                    EditableHandle editableHandle = (EditableHandle)handle_img.get(o0);
                    if (editableHandle == null) {
                        void var23_93;
                        Map<Handle, IntVar> f_row = this.f_vars.get(o0);
                        for (Handle handle : MatchIterable.this.agent_handles) {
                            IntVar intVar = this.findVariable(f_row.get(handle).getName(), this.model.getVars()).asIntVar();
                            if (intVar.getValue() != 1) continue;
                            EditableHandle editableHandle2 = handle.getEditable();
                            break;
                        }
                        if (var23_93 == null) {
                            EditableEdge editableEdge = new EditableEdge();
                        }
                        handle_img.put(o0, var23_90);
                    }
                    if ((h2 = (EditableHandle)ctx_hnd_dic.get(var23_90)) == null) {
                        h2 = var23_90.replicate();
                        h2.setOwner(ctx);
                        ctx_hnd_dic.put(var23_90, h2);
                    }
                    i1.setHandle(h2);
                }
                for (EditableInnerName i0 : MatchIterable.this.redex.inners.values()) {
                    void var23_98;
                    name = i0.getName();
                    i2 = new EditableInnerName(name);
                    EditableHandle h0 = i0.getHandle();
                    EditableHandle editableHandle = (EditableHandle)rdx_hnd_dic.get(h0);
                    if (editableHandle == null) {
                        h1 = (EditableHandle)handle_img.get(h0);
                        if (h1 == null) {
                            Map<Handle, IntVar> map = this.f_vars.get(h0);
                            for (Handle handle : MatchIterable.this.agent_handles) {
                                IntVar var = this.findVariable(map.get(handle).getName(), this.model.getVars()).asIntVar();
                                if (var.getValue() != 1) continue;
                                h1 = handle.getEditable();
                                break;
                            }
                            if (h1 == null) {
                                h1 = new EditableEdge();
                            }
                            handle_img.put(h0, h1);
                        }
                        EditableHandle editableHandle3 = h1.replicate();
                        editableHandle3.setOwner(rdx);
                        rdx_hnd_dic.put(h0, editableHandle3);
                    }
                    i2.setHandle((EditableHandle)var23_98);
                    rdx.inners.put(name, i2);
                    EditableOuterName o2 = new EditableOuterName(name);
                    o2.setOwner(bigraph);
                    bigraph.outers.put(name, o2);
                }
                for (EditableInnerName i1 : MatchIterable.this.agent.inners.values()) {
                    EditableHandle h2;
                    String name1;
                    block79: {
                        Map<LinkEntity, IntVar> map;
                        block78: {
                            name1 = i1.getName();
                            i2 = new EditableInnerName(name1);
                            h2 = null;
                            map = this.e_vars.get(i1);
                            IntVar intVar = this.findVariable(map.get(h1 = i1.getHandle()).getName(), this.model.getVars()).asIntVar();
                            if (intVar.getValue() != 1) break block78;
                            h2 = (EditableHandle)prm_hnd_dic.get(h1);
                            if (h2 != null) break block79;
                            EditableHandle editableHandle = (EditableHandle)ctx_hnd_dic.get(h1);
                            if (editableHandle != null) {
                                EditableInnerName editableInnerName = new EditableInnerName();
                                editableInnerName.setHandle(editableHandle);
                                String name2 = editableInnerName.getName();
                                ctx.inners.put(name2, editableInnerName);
                                EditableOuterName o4 = new EditableOuterName(name2);
                                o4.setOwner(bigraph2);
                                bigraph2.outers.put(name2, o4);
                                EditableInnerName editableInnerName2 = new EditableInnerName(name2);
                                editableInnerName2.setHandle(o4);
                                bigraph2.inners.put(name2, editableInnerName2);
                                EditableOuterName editableOuterName = new EditableOuterName(name2);
                                editableOuterName.setOwner(bigraph);
                                bigraph.outers.put(name2, editableOuterName);
                                h2 = editableOuterName;
                            } else {
                                h2 = new EditableEdge(bigraph);
                            }
                            prm_hnd_dic.put(h1, h2);
                            break block79;
                        }
                        for (InnerName innerName : MatchIterable.this.redex.inners.values()) {
                            IntVar v = this.findVariable(map.get(innerName).getName(), this.model.getVars()).asIntVar();
                            if (v.getValue() != 1) continue;
                            String name2 = innerName.getName();
                            h2 = bigraph.outers.get(name2);
                            if (h2 != null) break;
                            EditableOuterName editableOuterName = new EditableOuterName(name2);
                            editableOuterName.setOwner(bigraph);
                            bigraph.outers.put(name2, editableOuterName);
                            h2 = editableOuterName;
                            break;
                        }
                    }
                    i2.setHandle(h2);
                    bigraph.inners.put(name1, i2);
                }
                for (EditableRoot r0 : MatchIterable.this.agent.roots) {
                    q.add(new VState(ctx, null, r0));
                }
                LinkedList<? extends Root> unseen_rdx_roots = new LinkedList<Root>(MatchIterable.this.redex_roots);
                while (!q.isEmpty()) {
                    VState v;
                    block80: {
                        EditableRoot r2;
                        v = (VState)q.poll();
                        if (v.b == ctx) {
                            EditableParent p1 = (EditableParent)v.c;
                            EditableParent p2 = p1.replicate();
                            if (p1.isRoot()) {
                                r2 = (EditableRoot)p2;
                                ctx.roots.add(r2);
                                r2.setOwner(ctx);
                            } else {
                                EditableNode n1 = (EditableNode)p1;
                                EditableNode editableNode = (EditableNode)p2;
                                editableNode.setParent(v.p);
                                for (int i = n1.getControl().getArity() - 1; -1 < i; --i) {
                                    void var27_157;
                                    EditableNode.EditablePort editablePort = n1.getPort(i);
                                    EditableHandle editableHandle = editablePort.getHandle();
                                    EditableHandle editableHandle4 = (EditableHandle)ctx_hnd_dic.get(editableHandle);
                                    if (editableHandle4 == null) {
                                        EditableHandle editableHandle5 = editableHandle.replicate();
                                        editableHandle5.setOwner(ctx);
                                        ctx_hnd_dic.put(editableHandle, editableHandle5);
                                    }
                                    editableNode.getPort(i).setHandle((EditableHandle)var27_157);
                                }
                            }
                            HashSet<? extends Child> rcs = new HashSet<Child>(p1.getChildren());
                            Map<PlaceEntity, IntVar> map = this.p_vars.get(p1);
                            Iterator ir = unseen_rdx_roots.iterator();
                            while (ir.hasNext()) {
                                Root root = (Root)ir.next();
                                IntVar intVar = this.findVariable(map.get(root).getName(), this.model.getVars()).asIntVar();
                                if (intVar.getValue() != 1) continue;
                                ir.remove();
                                int n = MatchIterable.this.redex_roots.indexOf(root);
                                EditableSite s = new EditableSite();
                                s.setParent(p2);
                                ctx_sites_dic[n] = s;
                                EditableRoot r22 = new EditableRoot();
                                r22.setOwner(rdx);
                                rdx_roots_dic[n] = r22;
                                for (Child child : root.getChildren()) {
                                    Iterator ic = rcs.iterator();
                                    boolean notMatched = true;
                                    while (ic.hasNext()) {
                                        Child c1 = (Child)ic.next();
                                        IntVar var_tmp = this.findVariable(this.p_vars.get(c1).get(child).getName(), this.model.getVars()).asIntVar();
                                        if (var_tmp.getValue() != 1) continue;
                                        notMatched = false;
                                        q.add(new VState(rdx, r22, c1, child));
                                        ic.remove();
                                    }
                                    if (!notMatched || !child.isSite()) continue;
                                    q.add(new VState(rdx, r22, null, child));
                                }
                            }
                            for (Child child : rcs) {
                                q.add(new VState(ctx, p2, child));
                            }
                            continue;
                        }
                        if (v.b == rdx) {
                            if (v.i.isNode()) {
                                void var23_106;
                                EditableNode n0 = (EditableNode)v.i;
                                EditableNode n1 = (EditableNode)v.c;
                                EditableNode n2 = n1.replicate();
                                nEmb.put(n0, n1);
                                n2.setParent(v.p);
                                int n = n0.getControl().getArity() - 1;
                                while (-1 < var23_106) {
                                    void var26_146;
                                    EditableNode.EditablePort o0 = n0.getPort((int)var23_106);
                                    EditableHandle editableHandle = o0.getHandle();
                                    EditableHandle editableHandle6 = (EditableHandle)rdx_hnd_dic.get(editableHandle);
                                    if (editableHandle6 == null) {
                                        EditableHandle editableHandle7 = n1.getPort((int)var23_106).getHandle().replicate();
                                        editableHandle7.setOwner(rdx);
                                        rdx_hnd_dic.put(editableHandle, editableHandle7);
                                    }
                                    n2.getPort((int)var23_106).setHandle((EditableHandle)var26_146);
                                    --var23_106;
                                }
                                HashSet<? extends Child> hashSet = new HashSet<Child>(n1.getChildren());
                                for (Child child : n0.getChildren()) {
                                    Iterator iterator = hashSet.iterator();
                                    boolean bl = true;
                                    while (iterator.hasNext()) {
                                        Child c1 = (Child)iterator.next();
                                        IntVar var_tmp = this.findVariable(this.p_vars.get(c1).get(child).getName(), this.model.getVars()).asIntVar();
                                        if (var_tmp.getValue() != 1) continue;
                                        bl = false;
                                        q.add(new VState(rdx, n2, c1, child));
                                        iterator.remove();
                                    }
                                    if (!bl || !child.isSite()) continue;
                                    q.add(new VState(rdx, n2, null, child));
                                }
                                continue;
                            }
                            EditableSite s0 = (EditableSite)v.i;
                            int k = MatchIterable.this.redex_sites.indexOf(s0);
                            if (editableSiteArray[k] == null) {
                                EditableSite s2 = new EditableSite();
                                s2.setParent(v.p);
                                editableSiteArray[k] = s2;
                            }
                            if (prm_roots_dic[k] == null) {
                                prm_roots_dic[k] = new EditableRoot(bigraph);
                            }
                            r2 = prm_roots_dic[k];
                            if (v.c == null) continue;
                            q.add(new VState(bigraph, r2, v.c));
                            continue;
                        }
                        if (!v.c.isNode()) break block80;
                        EditableNode n1 = (EditableNode)v.c;
                        EditableNode n2 = n1.replicate();
                        n2.setParent(v.p);
                        for (int i = n1.getControl().getArity() - 1; -1 < i; --i) {
                            void var25_133;
                            EditableNode.EditablePort p2;
                            block82: {
                                Map<LinkEntity, IntVar> map;
                                block81: {
                                    void var25_130;
                                    EditableHandle editableHandle;
                                    EditableNode.EditablePort editablePort = n1.getPort(i);
                                    p2 = n2.getPort(i);
                                    Object var25_126 = null;
                                    map = this.e_vars.get(editablePort);
                                    IntVar var_tmp = this.findVariable(map.get(editableHandle = editablePort.getHandle()).getName(), this.model.getVars()).asIntVar();
                                    if (var_tmp.getValue() != 1) break block81;
                                    EditableHandle editableHandle8 = (EditableHandle)prm_hnd_dic.get(editableHandle);
                                    if (editableHandle8 != null) break block82;
                                    EditableHandle h3 = (EditableHandle)ctx_hnd_dic.get(editableHandle);
                                    if (h3 != null) {
                                        EditableInnerName editableInnerName = new EditableInnerName();
                                        editableInnerName.setHandle(h3);
                                        String string = editableInnerName.getName();
                                        ctx.inners.put(string, editableInnerName);
                                        EditableOuterName o4 = new EditableOuterName(string);
                                        o4.setOwner(bigraph2);
                                        bigraph2.outers.put(string, o4);
                                        EditableInnerName i4 = new EditableInnerName(string);
                                        i4.setHandle(o4);
                                        bigraph2.inners.put(string, i4);
                                        EditableOuterName o2 = new EditableOuterName(string);
                                        o2.setOwner(v.b);
                                        v.b.outers.put(string, o2);
                                        EditableOuterName editableOuterName = o2;
                                    } else {
                                        EditableEdge editableEdge = new EditableEdge(bigraph);
                                    }
                                    prm_hnd_dic.put(editableHandle, var25_130);
                                    break block82;
                                }
                                for (InnerName innerName : MatchIterable.this.redex.inners.values()) {
                                    IntVar intVar = this.findVariable(map.get(innerName).getName(), this.model.getVars()).asIntVar();
                                    if (intVar.getValue() != 1) continue;
                                    String name4 = innerName.getName();
                                    EditableHandle editableHandle = bigraph.outers.get(name4);
                                    if (editableHandle != null) break;
                                    EditableOuterName o2 = new EditableOuterName(name4);
                                    o2.setOwner(v.b);
                                    v.b.outers.put(name4, o2);
                                    EditableOuterName editableOuterName = o2;
                                    break;
                                }
                            }
                            p2.setHandle((EditableHandle)var25_133);
                        }
                        for (Child child : n1.getChildren()) {
                            q.add(new VState(v.b, n2, child));
                        }
                        continue;
                    }
                    EditableSite s1 = (EditableSite)v.c;
                    EditableSite s2 = s1.replicate();
                    s2.setParent(v.p);
                    prm_sites_dic[MatchIterable.this.agent_sites.indexOf((Object)s1)] = s2;
                }
                ctx.sites.addAll(Arrays.asList(ctx_sites_dic));
                rdx.sites.addAll(Arrays.asList(editableSiteArray));
                rdx.roots.addAll(Arrays.asList(rdx_roots_dic));
                bigraph.roots.addAll(Arrays.asList(prm_roots_dic));
                bigraph.sites.addAll(Arrays.asList(prm_sites_dic));
                if (DEBUG_CONSISTENCY_CHECK) {
                    if (!ctx.isConsistent()) {
                        throw new RuntimeException("Inconsistent bigraph (ctx)");
                    }
                    if (!rdx.isConsistent()) {
                        throw new RuntimeException("Inconsistent bigraph (rdx)");
                    }
                    if (!bigraph2.isConsistent()) {
                        throw new RuntimeException("Inconsistent bigraph (id)");
                    }
                    if (!bigraph.isConsistent()) {
                        throw new RuntimeException("Inconsistent bigraph (prm)");
                    }
                }
                this.nextMatch = new WeightedMatch(ctx, rdx, bigraph2, bigraph, nEmb, mWeight);
            }
        }
    }
}

