/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BidMap<A, B>
implements Map<A, B> {
    private Map<A, B> _mapA;
    private Map<B, A> _mapB;

    public BidMap() {
        this._mapA = new HashMap<A, B>();
        this._mapB = new HashMap<B, A>();
    }

    public BidMap(int size) {
        this._mapA = new HashMap<A, B>(size);
        this._mapB = new HashMap<B, A>(size);
    }

    public BidMap(Map<? extends A, ? extends B> map) {
        this(map.size());
        this._mapA.putAll(map);
        for (A a : map.keySet()) {
            B b = map.get(a);
            if (this._mapB.containsKey(b)) {
                throw new IllegalArgumentException("The given map is not bidirectional");
            }
            this._mapB.put(b, a);
        }
    }

    private BidMap(Map<A, B> mapA, Map<B, A> mapB) {
        this._mapA = mapA;
        this._mapB = mapB;
    }

    public BidMap<B, A> getInverse() {
        return new BidMap<B, A>(this._mapB, this._mapA);
    }

    @Override
    public void clear() {
        this._mapA.clear();
        this._mapB.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._mapA.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._mapB.containsKey(value);
    }

    @Override
    public Set<Map.Entry<A, B>> entrySet() {
        return this._mapA.entrySet();
    }

    @Override
    public B get(Object key) {
        return this._mapA.get(key);
    }

    public A getKey(Object value) {
        return this._mapB.get(value);
    }

    @Override
    public boolean isEmpty() {
        return this._mapA.isEmpty();
    }

    @Override
    public Set<A> keySet() {
        return this._mapA.keySet();
    }

    @Override
    public B put(A key, B value) {
        B b = this._mapA.get(key);
        A a = this._mapB.get(value);
        if (a != null && a != key) {
            throw new IllegalArgumentException("This insertion violates bidirectionality");
        }
        this._mapA.put(key, value);
        this._mapB.put(value, key);
        return b;
    }

    @Override
    public void putAll(Map<? extends A, ? extends B> map) {
        HashMap<A, B> mapA = new HashMap<A, B>();
        HashMap<B, A> mapB = new HashMap<B, A>();
        mapA.putAll(map);
        for (A a : map.keySet()) {
            B b = map.get(a);
            if (mapB.containsKey(b)) {
                throw new IllegalArgumentException("The given map is not bidirectional");
            }
            mapB.put(b, a);
        }
        this._mapA.putAll(mapA);
        this._mapB.putAll(mapB);
    }

    @Override
    public B remove(Object key) {
        B b = this._mapA.remove(key);
        this._mapB.remove(b);
        return b;
    }

    @Override
    public int size() {
        return this._mapA.size();
    }

    @Override
    public Collection<B> values() {
        return this._mapB.keySet();
    }
}

