/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.util;

import it.uniud.mads.jlibbig.core.util.Provider;
import java.lang.ref.SoftReference;

public class CachingProxy<T> {
    private SoftReference<T> ref;
    private Provider<T> provider;

    public CachingProxy(Provider<T> provider) {
        this.setProvider(provider);
    }

    public Provider<T> getProvider() {
        return this.provider;
    }

    public void setProvider(Provider<T> p) {
        if (p == null) {
            throw new IllegalArgumentException("The value cannot be null.");
        }
        this.provider = p;
        this.invalidate();
    }

    public void invalidate() {
        SoftReference<T> old = this.ref;
        this.ref = null;
        if (old != null) {
            old.clear();
        }
    }

    public T get() {
        T value = this.softGet();
        if (value == null) {
            value = this.populateCache();
        }
        return value;
    }

    public T softGet() {
        T value = null;
        if (this.ref != null) {
            value = this.ref.get();
        }
        return value;
    }

    private T populateCache() {
        T value = this.provider.get();
        this.ref = new SoftReference<T>(value);
        return value;
    }
}

