/*
 * Decompiled with CFR 0.152.
 */
package it.uniud.mads.jlibbig.core.util;

import java.lang.ref.SoftReference;
import java.math.BigInteger;

public class NameGenerator {
    private static final boolean DEBUG = Boolean.getBoolean("it.uniud.mads.jlibbig.namegeneration");
    public static final NameGenerator DEFAULT = new NameGenerator();
    private BigInteger _sharedCounter = BigInteger.ZERO;
    private final ThreadLocal<SoftReference<BlockProxy>> _localBlock = new ThreadLocal<SoftReference<BlockProxy>>(){

        @Override
        protected SoftReference<BlockProxy> initialValue() {
            return null;
        }
    };

    public String generate() {
        SoftReference<BlockProxy> ref = this._localBlock.get();
        if (ref == null) {
            if (DEBUG) {
                System.out.println("New local block for thread " + Thread.currentThread().getId() + "-" + Thread.currentThread().getName());
            }
            ref = new SoftReference<BlockProxy>(this.createLocalBlock());
            this._localBlock.set(ref);
        }
        return ref.get().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigInteger getNewBlock(BigInteger size) {
        BigInteger block;
        NameGenerator nameGenerator = this;
        synchronized (nameGenerator) {
            if (DEBUG) {
                System.out.println("Allocating a new block of size " + size.toString() + " for thread " + Thread.currentThread().getId() + "-" + Thread.currentThread().getName());
            }
            block = this._sharedCounter;
            this._sharedCounter = block.add(size);
        }
        return block;
    }

    protected BlockProxy createLocalBlock() {
        return new BlockProxy();
    }

    protected class BlockProxy {
        private static final long MIN_BLOCK_SIZE = 1000L;
        private static final long MAX_BLOCK_SIZE = 100000L;
        private static final long SHRINK_FACTOR = 2L;
        private static final long GROW_FACTOR = 2L;
        private static final long TIME_THRESHOLD = 1000L;
        private static final long FREQ_THRESHOLD = 5L;
        private long _rem = 0L;
        private long _currentSize = 2000L;
        private BigInteger _blockSize = BigInteger.valueOf(this._currentSize);
        private long _lastGenT = 0L;
        private int _genSinceLastSizeCng = -1;
        private BigInteger _next = null;

        BlockProxy() {
        }

        public long getSize() {
            return this._currentSize;
        }

        protected long onRefilling(long oldBlockSize) {
            long now = System.currentTimeMillis();
            long newBlockSize = oldBlockSize;
            if (now - this._lastGenT < 1000L && newBlockSize * 2L <= 100000L) {
                newBlockSize *= 2L;
            } else if ((long)this._genSinceLastSizeCng > 5L && newBlockSize / 2L >= 1000L) {
                newBlockSize /= 2L;
            }
            return newBlockSize;
        }

        private void refill() {
            long newBlockSize = this.onRefilling(this._currentSize);
            if (newBlockSize != this._currentSize && newBlockSize >= 1000L) {
                this._currentSize = newBlockSize;
                this._genSinceLastSizeCng = 0;
                this._blockSize = BigInteger.valueOf(this._currentSize);
            } else {
                this._lastGenT = System.currentTimeMillis();
                ++this._genSinceLastSizeCng;
            }
            this._next = NameGenerator.this.getNewBlock(this._blockSize);
            this._rem = this._currentSize;
        }

        public String next() {
            if (this._rem < 1L) {
                this.refill();
            }
            --this._rem;
            String name = this._next.toString(16).toUpperCase();
            this._next = this._next.add(BigInteger.ONE);
            return name;
        }
    }
}

