/*
 * Decompiled with CFR 0.152.
 */
package org.bigraphs.framework.simulation.encoding;

import java.util.function.Function;
import org.bigraphs.framework.core.Bigraph;
import org.bigraphs.framework.core.ElementaryBigraph;
import org.bigraphs.framework.core.exceptions.BigraphIsNotGroundException;
import org.bigraphs.framework.core.exceptions.BigraphIsNotPrimeException;
import org.bigraphs.framework.core.impl.elementary.DiscreteIon;
import org.bigraphs.framework.core.impl.elementary.Linkings;
import org.bigraphs.framework.core.impl.elementary.Placings;
import org.bigraphs.framework.core.impl.pure.PureBigraph;
import org.bigraphs.framework.simulation.encoding.BigraphCanonicalFormStrategy;
import org.bigraphs.framework.simulation.encoding.BigraphCanonicalFormSupport;
import org.bigraphs.framework.simulation.encoding.PureCanonicalForm;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.factory.Maps;

public class BigraphCanonicalForm
implements BigraphCanonicalFormSupport {
    private final MutableMap<Class<? extends Bigraph<?>>, BigraphCanonicalFormStrategy<? extends Bigraph<?>>> strategyMap = Maps.mutable.of(PureBigraph.class, (Object)new PureCanonicalForm(this));
    boolean withNodeIdentifiers = false;
    static final char PREFIX_BARREN = 'r';
    boolean rewriteOpenLinks = false;

    public static BigraphCanonicalForm createInstance() {
        return BigraphCanonicalForm.createInstance(false);
    }

    public static BigraphCanonicalForm createInstance(boolean withNodeIdentifiers) {
        return new BigraphCanonicalForm(withNodeIdentifiers);
    }

    private BigraphCanonicalForm() {
    }

    private BigraphCanonicalForm(boolean withNodeIdentifiers) {
        this.withNodeIdentifiers = withNodeIdentifiers;
    }

    public synchronized <B extends Bigraph<?>> String bfcs(B bigraph) {
        if (bigraph instanceof PureBigraph) {
            BigraphCanonicalFormStrategy<B> canonicalFormStrategy = ((BigraphCanonicalFormStrategy)this.strategyMap.getOrDefault(bigraph.getClass(), (Object)new PureCanonicalForm(this))).setPrintNodeIdentifiers(this.withNodeIdentifiers).setRewriteOpenLinks(this.rewriteOpenLinks);
            return canonicalFormStrategy.compute(bigraph);
        }
        if (bigraph instanceof ElementaryBigraph) {
            return this.bfcs((ElementaryBigraph)bigraph);
        }
        throw new RuntimeException("Not implemented yet");
    }

    protected String bfcs(ElementaryBigraph<?> elementaryBigraph) {
        if (elementaryBigraph.isPlacing()) {
            if (elementaryBigraph instanceof Placings.Barren || elementaryBigraph instanceof Placings.Join) {
                return (String)((Function)ELEMENTARY_ENCODINGS.get(elementaryBigraph.getClass())).apply(null);
            }
            return (String)((Function)ELEMENTARY_ENCODINGS.get(elementaryBigraph.getClass())).apply(elementaryBigraph.getSites().size());
        }
        if (elementaryBigraph.isLinking()) {
            if (elementaryBigraph instanceof Linkings.Closure || elementaryBigraph instanceof Linkings.Identity) {
                return (String)((Function)ELEMENTARY_ENCODINGS.get(elementaryBigraph.getClass())).apply(elementaryBigraph.getInnerNames());
            }
            if (elementaryBigraph instanceof Linkings.Substitution) {
                return (String)((Function)ELEMENTARY_ENCODINGS.get(elementaryBigraph.getClass())).apply(new Object[]{elementaryBigraph.getOuterNames().iterator().next(), elementaryBigraph.getInnerNames()});
            }
            throw new RuntimeException("Not implemented yet");
        }
        assert (elementaryBigraph instanceof DiscreteIon);
        throw new RuntimeException("Not implemented yet");
    }

    public boolean isWithNodeIdentifiers() {
        return this.withNodeIdentifiers;
    }

    public BigraphCanonicalForm setWithNodeIdentifiers(boolean withNodeIdentifiers) {
        this.withNodeIdentifiers = withNodeIdentifiers;
        return this;
    }

    public boolean isRewriteOpenLinks() {
        return this.rewriteOpenLinks;
    }

    public BigraphCanonicalForm setRewriteOpenLinks(boolean rewriteOpenLinks) {
        this.rewriteOpenLinks = rewriteOpenLinks;
        return this;
    }

    <B extends Bigraph<?>> void assertBigraphIsGroundAndPrime(B bigraph) {
        if (!bigraph.isGround() || !bigraph.isPrime()) {
            throw new BigraphIsNotGroundException();
        }
    }

    <B extends Bigraph<?>> void assertControlsAreAtomic(B bigraph) {
    }

    <B extends Bigraph<?>> void assertBigraphIsPrime(B bigraph) {
        if (!bigraph.isPrime()) {
            throw new BigraphIsNotPrimeException();
        }
    }

    public void assertBigraphHasRoots(PureBigraph bigraph) {
        if (bigraph.getRoots().size() == 0) {
            throw new RuntimeException("Bigraph has no roots. Cannot compute the canonical form");
        }
    }
}

