/*
 * Decompiled with CFR 0.152.
 */
package org.bigraphs.framework.simulation.encoding;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.bigraphs.framework.core.impl.BigraphEntity;
import org.bigraphs.framework.core.impl.elementary.Linkings;
import org.bigraphs.framework.core.impl.elementary.Placings;

public interface BigraphCanonicalFormSupport {
    public static final char PREFIX_BARREN = 'r';
    public static final Map<Class<?>, Function<Object, String>> ELEMENTARY_ENCODINGS;

    public static Supplier<String> createNameSupplier(final String prefix) {
        return new Supplier<String>(){
            private int id = 0;

            @Override
            public String get() {
                return prefix + this.id++;
            }
        };
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
        ELEMENTARY_ENCODINGS = Map.of(Placings.Barren.class, Void2 -> BigraphCanonicalFormSupport.createNameSupplier(String.valueOf('r')).get() + "#", Placings.Join.class, Void2 -> BigraphCanonicalFormSupport.createNameSupplier(String.valueOf('r')).get() + "$01#", Placings.Identity1.class, n -> BigraphCanonicalFormSupport.createNameSupplier(String.valueOf('r')).get() + "$0#", Placings.Merge.class, n -> {
            StringBuilder sb = new StringBuilder(String.valueOf('r')).append(0);
            if (Integer.parseInt(String.valueOf(n)) > 0) {
                sb.append('$');
            }
            for (int i = 0; i < Integer.parseInt(String.valueOf(n)); ++i) {
                sb.append(i);
            }
            return sb.append('#').toString();
        }, Placings.Permutation.class, n -> {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < Integer.parseInt(String.valueOf(n)); ++i) {
                sb.append('r').append(i).append('$').append(i).append('#');
            }
            return sb.toString();
        }, Placings.Symmetry.class, n -> {
            int N = Integer.parseInt(String.valueOf(n));
            StringBuilder sb = new StringBuilder();
            int i = 0;
            int j = N - 1;
            while (i < N) {
                sb.append('r').append(i).append('$').append(j).append('#');
                ++i;
                --j;
            }
            return sb.toString();
        }, Linkings.Closure.class, n -> {
            if (!2.$assertionsDisabled && !(n instanceof Iterable)) {
                throw new AssertionError();
            }
            Iterable names = (Iterable)n;
            StringBuilder sb = new StringBuilder();
            for (BigraphEntity.InnerName eachName : names) {
                sb.append(eachName.getName()).append('$');
            }
            sb.replace(sb.length() - 1, sb.length(), "");
            return sb.append('#').toString();
        }, Linkings.Substitution.class, outerInner -> {
            if (!2.$assertionsDisabled && !(outerInner instanceof Object[])) {
                throw new AssertionError();
            }
            if (!2.$assertionsDisabled && ((Object[])outerInner).length != 2) {
                throw new AssertionError();
            }
            BigraphEntity.OuterName outerName = (BigraphEntity.OuterName)((Object[])outerInner)[0];
            Iterable innerNames = (Iterable)((Object[])outerInner)[1];
            StringBuilder sb = new StringBuilder();
            for (BigraphEntity.InnerName eachName : innerNames) {
                sb.append(eachName.getName()).append(outerName.getName()).append('$');
            }
            sb.replace(sb.length() - 1, sb.length(), "");
            return sb.append('#').toString();
        }, Linkings.Identity.class, outerInner -> {
            Iterable innerNames = (Iterable)outerInner;
            StringBuilder sb = new StringBuilder("");
            for (BigraphEntity.InnerName eachName : innerNames) {
                sb.append(eachName.getName()).append(eachName.getName()).append('$');
            }
            sb.replace(sb.length() - 1, sb.length(), "");
            return sb.append('#').toString();
        });
    }
}

