/*
 * Decompiled with CFR 0.152.
 */
package org.bigraphs.framework.simulation.encoding;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bigraphs.framework.core.BigraphEntityType;
import org.bigraphs.framework.core.Control;
import org.bigraphs.framework.core.ControlStatus;
import org.bigraphs.framework.core.datatypes.FiniteOrdinal;
import org.bigraphs.framework.core.datatypes.StringTypedName;
import org.bigraphs.framework.core.impl.BigraphEntity;
import org.bigraphs.framework.core.impl.pure.PureBigraph;
import org.bigraphs.framework.core.impl.signature.DefaultDynamicControl;
import org.bigraphs.framework.core.utils.BigraphUtil;
import org.bigraphs.framework.simulation.encoding.BigraphCanonicalForm;
import org.bigraphs.framework.simulation.encoding.BigraphCanonicalFormStrategy;
import org.bigraphs.framework.simulation.encoding.BigraphCanonicalFormSupport;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Maps;
import org.eclipse.collections.impl.map.sorted.mutable.TreeSortedMap;
import org.eclipse.emf.ecore.EObject;

public class PureCanonicalForm
extends BigraphCanonicalFormStrategy<PureBigraph> {
    RewriteFunction rewriteFunction = new RewriteFunction();
    TreeSortedMap<String, BigraphEntity.Edge> E2 = new TreeSortedMap();
    TreeSortedMap<String, BigraphEntity.InnerName> I2 = new TreeSortedMap();
    TreeSortedMap<String, BigraphEntity.OuterName> O2 = new TreeSortedMap();
    MutableMap<BigraphEntity<?>, BigraphEntity<?>> parentMap = Maps.mutable.with();
    MutableMap<BigraphEntity<?>, Integer> parentChildMap = Maps.mutable.with();
    MutableList<BigraphEntity.OuterName> idleOuterNames = Lists.mutable.empty();
    MutableList<BigraphEntity<?>> frontier = Lists.mutable.empty();
    MutableList<BigraphEntity<?>> next = Lists.mutable.empty();
    PureBigraph bigraph;
    Supplier<String> rewriteEdgeNameSupplier;
    Supplier<String> rewriteInnerNameSupplier;
    Supplier<String> rewriteOuterNameSupplier;
    LinkedList<BigraphEntity<?>> totalOrdering = new LinkedList();
    Comparator<BigraphEntity<?>> compareByLinkGraphOrdering = Comparator.comparing(entry -> {
        if (BigraphEntityType.isNode((BigraphEntity)entry) && this.bigraph.getPortCount((BigraphEntity.NodeEntity)entry) > 0) {
            List collect = this.bigraph.getPorts(entry).stream().sorted().map(arg_0 -> ((PureBigraph)this.bigraph).getLinkOfPoint(arg_0)).filter(Objects::nonNull).flatMap(x -> this.bigraph.getPointsFromLink(x).stream()).filter(BigraphEntityType::isPort).map(x -> this.bigraph.getNodeOfPort((BigraphEntity.Port)x)).map(x -> this.totalOrdering.indexOf(x)).filter(x -> x != -1).sorted().collect(Collectors.toList());
            Integer reduce = collect.stream().reduce(0, Integer::sum);
            return reduce;
        }
        return Integer.MIN_VALUE;
    });
    Comparator<BigraphEntity<?>> compareControlByKey3 = Comparator.comparing(entry -> {
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        queue.add(entry);
        StringBuilder s1 = new StringBuilder();
        while (!queue.isEmpty()) {
            BigraphEntity currentNode = (BigraphEntity)queue.remove();
            List sorted = this.bigraph.getChildrenOf(currentNode).stream().sorted(Comparator.comparing(lhs -> BigraphEntityType.isSite((BigraphEntity)lhs) ? String.valueOf(((BigraphEntity.SiteEntity)lhs).getIndex()) : this.label((BigraphEntity<?>)lhs) + this.getLinkName(this.bigraph, (BigraphEntity<?>)lhs))).collect(Collectors.toList());
            queue.addAll(sorted);
            s1.append(this.label(currentNode)).append(this.getLinkName(this.bigraph, currentNode)).append(sorted.stream().map(x -> BigraphEntityType.isSite((BigraphEntity)x) ? String.valueOf(((BigraphEntity.SiteEntity)x).getIndex()) : this.label((BigraphEntity<?>)x) + this.getLinkName(this.bigraph, (BigraphEntity<?>)x)).collect(Collectors.joining("")));
        }
        return s1.toString();
    });
    Comparator<Map.Entry<BigraphEntity<?>, LinkedList<BigraphEntity<?>>>> compareControlOfParentAndChildren = Comparator.comparing(entry -> {
        String s1 = ((LinkedList)entry.getValue()).stream().sorted(Comparator.comparing(lhs -> BigraphEntityType.isSite((BigraphEntity)lhs) ? String.valueOf(((BigraphEntity.SiteEntity)lhs).getIndex()) : this.label((BigraphEntity<?>)lhs) + this.getLinkName(this.bigraph, (BigraphEntity<?>)lhs))).map(x -> BigraphEntityType.isSite((BigraphEntity)x) ? String.valueOf(((BigraphEntity.SiteEntity)x).getIndex()) : this.label((BigraphEntity<?>)x) + this.getLinkName(this.bigraph, (BigraphEntity<?>)x)).collect(Collectors.joining(""));
        String o = this.label((BigraphEntity)entry.getKey()) + this.getLinkName(this.bigraph, (BigraphEntity)entry.getKey()) + s1;
        return o;
    });
    static final Comparator<Map.Entry<BigraphEntity<?>, LinkedList<BigraphEntity<?>>>> compareChildrenSizeByValue = Comparator.comparing(entry -> ((LinkedList)entry.getValue()).size());
    final Comparator<Map.Entry<BigraphEntity<?>, LinkedList<BigraphEntity<?>>>> compareChildrenPortSum = Comparator.comparing(entry -> {
        int sum = 0;
        for (int i = 0; i < ((LinkedList)entry.getValue()).size(); ++i) {
            BigraphEntity bigraphEntity = (BigraphEntity)((LinkedList)entry.getValue()).get(i);
            sum += this.bigraph.getPortCount((BigraphEntity.NodeEntity)bigraphEntity);
        }
        return sum;
    });
    final Comparator<BigraphEntity<?>> compareChildrenSize = Comparator.comparing(entry -> this.bigraph.getChildrenOf(entry).size());
    final Comparator<BigraphEntity<?>> comparePortCount = Comparator.comparing(entry -> this.bigraph.getPortCount((BigraphEntity.NodeEntity)entry));
    final Comparator<BigraphEntity<?>> compareLinkNames = Comparator.comparing(entry -> {
        if (this.rewriteOpenLinks && !this.printNodeIdentifiers) {
            return "";
        }
        String collect = this.bigraph.getPorts(entry).stream().sorted().map(x -> this.bigraph.getLinkOfPoint((BigraphEntity)x)).map(x -> x.getName()).sorted().collect(Collectors.joining(""));
        return collect;
    });
    final Comparator<Map.Entry<BigraphEntity<?>, LinkedList<BigraphEntity<?>>>> compareChildrenLinkNames = Comparator.comparing(entry -> {
        String s1 = ((LinkedList)entry.getValue()).stream().sorted(this.compareLinkNames).filter(BigraphEntityType::isNode).map(x -> this.bigraph.getLinkOfPoint(x)).filter(Objects::nonNull).map(BigraphEntity.Link::getName).sorted().collect(Collectors.joining(""));
        String o = this.label((BigraphEntity)entry.getKey()) + s1;
        return o;
    });

    public PureCanonicalForm(BigraphCanonicalForm bigraphCanonicalForm) {
        super(bigraphCanonicalForm);
    }

    private void reset() {
        this.rewriteFunction = new RewriteFunction();
        this.E2.clear();
        this.I2.clear();
        this.O2.clear();
        this.parentMap.clear();
        this.parentChildMap.clear();
        this.idleOuterNames.clear();
        this.frontier.clear();
        this.next.clear();
        this.bigraph = null;
        this.rewriteEdgeNameSupplier = BigraphCanonicalFormSupport.createNameSupplier("e");
        this.rewriteInnerNameSupplier = BigraphCanonicalFormSupport.createNameSupplier("x");
        this.rewriteOuterNameSupplier = BigraphCanonicalFormSupport.createNameSupplier("y");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized String compute(PureBigraph bigraph) {
        this.reset();
        this.bigraph = bigraph;
        this.getBigraphCanonicalForm().assertBigraphHasRoots(bigraph);
        this.getBigraphCanonicalForm().assertControlsAreAtomic(bigraph);
        StringBuilder sb = new StringBuilder();
        Comparator<BigraphEntity<?>> levelComp2 = this.compareControlByKey3.thenComparing(this.compareChildrenSize.reversed().thenComparing(this.comparePortCount.reversed().thenComparing(this.compareLinkNames.reversed())));
        Comparator<Map.Entry<BigraphEntity<?>, LinkedList<BigraphEntity<?>>>> levelComparator = this.compareControlOfParentAndChildren.thenComparing(compareChildrenSizeByValue.reversed().thenComparing(this.compareChildrenPortSum.reversed().thenComparing(this.compareChildrenLinkNames.reversed())));
        for (BigraphEntity.RootEntity theParent : bigraph.getRoots()) {
            this.totalOrdering.clear();
            sb.append('r').append(theParent.getIndex()).append('$');
            this.parentMap.put((Object)theParent, (Object)theParent);
            this.frontier.clear();
            this.frontier.add((Object)theParent);
            for (BigraphEntity.OuterName each : bigraph.getOuterNames()) {
                if (bigraph.getPointsFromLink((BigraphEntity.Link)each).size() != 0 || !this.O2.flip().get((Object)each).getFirstOptional().isEmpty()) continue;
                if (this.rewriteOpenLinks) {
                    this.O2.put((Object)this.rewriteOuterNameSupplier.get(), (Object)each);
                } else {
                    this.O2.put((Object)each.getName(), (Object)each);
                }
                this.idleOuterNames.add((Object)each);
            }
            for (BigraphEntity.OuterName each : bigraph.getInnerNames()) {
                if (bigraph.getLinkOfPoint((BigraphEntity)each) != null || !this.I2.flip().get((Object)each).getFirstOptional().isEmpty()) continue;
                if (this.rewriteOpenLinks) {
                    this.I2.put((Object)this.rewriteInnerNameSupplier.get(), (Object)each);
                    continue;
                }
                this.I2.put((Object)each.getName(), (Object)each);
            }
            AtomicBoolean checkNextRound = new AtomicBoolean(false);
            LinkedList<BigraphEntity.SiteEntity> places0 = new LinkedList<BigraphEntity.SiteEntity>();
            places0.addAll(bigraph.getNodes());
            for (BigraphEntity.SiteEntity s : bigraph.getSites()) {
                places0.add(s);
            }
            int maxDegree = bigraph.getOpenNeighborhoodOfVertex((BigraphEntity)theParent).size();
            LinkedList lastOrdering = new LinkedList();
            while (!this.frontier.isEmpty()) {
                Iterator openNeighborhoodOfVertex;
                block9: for (BigraphEntity bigraphEntity : places0) {
                    void var12_16;
                    DefaultDynamicControl defaultDynamicControl;
                    if (this.parentMap.get((Object)bigraphEntity) != null) continue;
                    if (bigraphEntity.getType() == BigraphEntityType.SITE) {
                        String newLabel = String.valueOf(((BigraphEntity.SiteEntity)bigraphEntity).getIndex());
                        defaultDynamicControl = DefaultDynamicControl.createDefaultDynamicControl((StringTypedName)StringTypedName.of((String)newLabel), (FiniteOrdinal)FiniteOrdinal.ofInteger((int)0), (ControlStatus)ControlStatus.ATOMIC);
                        BigraphEntity parent = bigraph.getParent(bigraphEntity);
                        BigraphEntity.NodeEntity nodeEntity = BigraphEntity.createNode((EObject)bigraphEntity.getInstance(), (Control)defaultDynamicControl);
                        BigraphUtil.setParentOfNode((BigraphEntity)nodeEntity, (BigraphEntity)parent);
                    }
                    if (maxDegree < (openNeighborhoodOfVertex = bigraph.getOpenNeighborhoodOfVertex((BigraphEntity)var12_16)).size()) {
                        maxDegree = openNeighborhoodOfVertex.size();
                    }
                    defaultDynamicControl = openNeighborhoodOfVertex.iterator();
                    while (defaultDynamicControl.hasNext()) {
                        BigraphEntity v = (BigraphEntity)defaultDynamicControl.next();
                        if (!this.frontier.contains((Object)v)) continue;
                        this.next.add((Object)var12_16);
                        this.parentMap.put((Object)var12_16, (Object)v);
                        continue block9;
                    }
                }
                if (this.next.size() > 0) {
                    void var12_20;
                    AtomicInteger atLevelCnt;
                    LinkedList next0 = this.next.stream().sorted(levelComp2).collect(Collectors.toCollection(LinkedList::new));
                    LinkedHashMap<BigraphEntity, LinkedList> linkedHashMap = new LinkedHashMap<BigraphEntity, LinkedList>();
                    for (Object each : next0) {
                        BigraphEntity p = bigraph.getParent((BigraphEntity)each);
                        linkedHashMap.putIfAbsent(p, new LinkedList());
                        ((LinkedList)linkedHashMap.get(p)).add(each);
                    }
                    openNeighborhoodOfVertex = linkedHashMap.entrySet().iterator();
                    while (openNeighborhoodOfVertex.hasNext()) {
                        Object each;
                        each = openNeighborhoodOfVertex.next();
                        linkedHashMap.put((BigraphEntity)each.getKey(), ((LinkedList)each.getValue()).stream().sorted(levelComp2).collect(Collectors.toCollection(LinkedList::new)));
                    }
                    if (lastOrdering.size() != 0) {
                        atLevelCnt = new AtomicInteger(lastOrdering.size() - linkedHashMap.size());
                        LinkedHashMap<BigraphEntity, LinkedList> collectTmp = new LinkedHashMap<BigraphEntity, LinkedList>();
                        ArrayList<BigraphEntity> skip = new ArrayList<BigraphEntity>();
                        for (BigraphEntity eachOrder : lastOrdering) {
                            LinkedList bigraphEntities;
                            List collect2;
                            List collect1;
                            if (this.parentChildMap.get((Object)eachOrder) != null) {
                                collectTmp.put(eachOrder, new LinkedList());
                            }
                            if (linkedHashMap.get(eachOrder) == null) continue;
                            boolean processed = false;
                            long distinctLabels = ((LinkedList)linkedHashMap.get(eachOrder)).stream().filter(x -> BigraphEntityType.isNode((BigraphEntity)x)).map(x -> x.getControl().getNamedType().stringValue()).distinct().count();
                            if (((LinkedList)linkedHashMap.get(eachOrder)).size() > 1 && distinctLabels == 1L && (collect1 = (collect2 = (bigraphEntities = (LinkedList)linkedHashMap.get((BigraphEntity.NodeEntity)eachOrder)).stream().sorted(levelComp2).collect(Collectors.toList())).stream().map(x -> bigraph.getParent(x)).distinct().collect(Collectors.toList())).size() > 0) {
                                BigraphEntity eO = null;
                                for (BigraphEntity t : collect1) {
                                    if (skip.contains(t)) continue;
                                    eO = t;
                                    break;
                                }
                                skip.add(eO);
                                collectTmp.put(eO, ((LinkedList)linkedHashMap.get(eO)).stream().sorted(levelComp2).collect(Collectors.toCollection(LinkedList::new)));
                                processed = true;
                            }
                            if (processed) continue;
                            collectTmp.put(eachOrder, ((LinkedList)linkedHashMap.get(eachOrder)).stream().sorted(levelComp2).collect(Collectors.toCollection(LinkedList::new)));
                        }
                        LinkedHashMap<BigraphEntity, LinkedList> linkedHashMap2 = collectTmp;
                        this.totalOrdering.addAll(lastOrdering);
                        lastOrdering.clear();
                    } else {
                        atLevelCnt = new AtomicInteger(0);
                        Map map = linkedHashMap.entrySet().stream().sorted(levelComparator).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
                    }
                    AtomicInteger ixCnt = new AtomicInteger(0);
                    MutableList levelList = Lists.mutable.empty();
                    void blu = var12_20;
                    blu.forEach((key, value) -> levelList.addAll((Collection)value));
                    boolean allNodesAreLeaves = levelList.summarizeInt((IntFunction & Serializable)x -> bigraph.getChildrenOf(x).size()).getSum() == 0L;
                    blu.entrySet().stream().forEachOrdered(e -> {
                        if (((LinkedList)e.getValue()).size() == 0 && this.parentChildMap.get(e.getKey()) != null) {
                            sb.append("$");
                            this.parentChildMap.remove(e.getKey());
                            return;
                        }
                        List childrenOrdered = ((LinkedList)e.getValue()).stream().sorted(this.compareByLinkGraphOrdering).peek(x -> {
                            lastOrdering.add(x);
                            this.totalOrdering.add((BigraphEntity<?>)x);
                        }).collect(Collectors.toList());
                        childrenOrdered.stream().forEachOrdered(val -> {
                            sb.append(this.label((BigraphEntity<?>)val));
                            if (!allNodesAreLeaves && bigraph.getChildrenOf(val).size() == 0) {
                                this.parentChildMap.put(val, (Object)atLevelCnt.get());
                            }
                            atLevelCnt.incrementAndGet();
                            if (bigraph.getPortCount((BigraphEntity.NodeEntity)val) > 0) {
                                sb.append("{");
                                bigraph.getPorts(val).stream().sorted().map(arg_0 -> ((PureBigraph)bigraph).getLinkOfPoint(arg_0)).filter(Objects::nonNull).map(l -> {
                                    if (this.rewriteOpenLinks) {
                                        return this.rewriteFunction.rewrite((MutableSortedMap<String, BigraphEntity.Edge>)this.E2, (MutableSortedMap<String, BigraphEntity.OuterName>)this.O2, (BigraphEntity.Link)l, this.rewriteEdgeNameSupplier, this.rewriteOuterNameSupplier, this.printNodeIdentifiers);
                                    }
                                    return this.rewriteFunction.rewrite((MutableSortedMap<String, BigraphEntity.Edge>)this.E2, (MutableSortedMap<String, BigraphEntity.OuterName>)this.O2, (BigraphEntity.Link)l, this.rewriteEdgeNameSupplier, null, this.printNodeIdentifiers);
                                }).sorted().forEachOrdered(n -> sb.append((String)n));
                                sb.append("}");
                            }
                        });
                        sb.append("$");
                        ixCnt.incrementAndGet();
                    });
                    if (this.parentChildMap.size() != 0) {
                        checkNextRound.set(true);
                    }
                }
                this.frontier.clear();
                this.frontier.addAll(this.next);
                this.next.clear();
            }
            this.cleanUpEndOfEncoding(sb);
        }
        this.E2.values().forEach((Procedure & Serializable)edge -> bigraph.getPointsFromLink((BigraphEntity.Link)edge).stream().filter(BigraphEntityType::isInnerName).forEachOrdered(x -> {
            if (this.I2.flip().get((Object)((BigraphEntity.InnerName)x)).getFirstOptional().isEmpty()) {
                if (this.rewriteOpenLinks) {
                    this.I2.put((Object)this.rewriteInnerNameSupplier.get(), (Object)((BigraphEntity.InnerName)x));
                } else {
                    this.I2.put((Object)((BigraphEntity.InnerName)x).getName(), (Object)((BigraphEntity.InnerName)x));
                }
            }
        }));
        this.O2.values().forEach((Procedure & Serializable)edge -> bigraph.getPointsFromLink((BigraphEntity.Link)edge).stream().filter(BigraphEntityType::isInnerName).forEachOrdered(x -> {
            if (this.I2.flip().get((Object)((BigraphEntity.InnerName)x)).getFirstOptional().isEmpty()) {
                if (this.rewriteOpenLinks) {
                    this.I2.put((Object)this.rewriteInnerNameSupplier.get(), (Object)((BigraphEntity.InnerName)x));
                } else {
                    this.I2.put((Object)((BigraphEntity.InnerName)x).getName(), (Object)((BigraphEntity.InnerName)x));
                }
            }
        }));
        for (BigraphEntity.InnerName each : this.I2.values()) {
            BigraphEntity.Link linkOfPoint = bigraph.getLinkOfPoint((BigraphEntity)each);
            if (linkOfPoint != null) {
                String name = null;
                switch (linkOfPoint.getType()) {
                    case EDGE: {
                        name = this.rewriteFunction.labelE((MutableSortedMap<String, BigraphEntity.Edge>)this.E2, (BigraphEntity.Edge)linkOfPoint);
                        break;
                    }
                    case OUTER_NAME: {
                        name = this.rewriteFunction.labelO((MutableSortedMap<String, BigraphEntity.OuterName>)this.O2, (BigraphEntity.OuterName)linkOfPoint);
                    }
                }
                sb.append((String)this.I2.flip().get((Object)each).getOnly()).append(name).append("$");
                continue;
            }
            sb.append((String)this.I2.flip().get((Object)each).getOnly()).append("$");
        }
        for (BigraphEntity.InnerName each : this.idleOuterNames) {
            sb.append(this.rewriteFunction.labelO((MutableSortedMap<String, BigraphEntity.OuterName>)this.O2, (BigraphEntity.OuterName)each)).append("$");
        }
        if (bigraph.getOuterNames().size() > 0 || bigraph.getInnerNames().size() > 0) {
            if (sb.charAt(sb.length() - 1) == '$') {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.insert(sb.length(), "#");
        }
        return sb.toString().replaceAll("\\$#", "#").replaceAll("##", "#");
    }

    private void cleanUpEndOfEncoding(StringBuilder sb) {
        if (sb.charAt(sb.length() - 1) == '$') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.insert(sb.length(), "#");
        int i = sb.lastIndexOf("$#");
        if (i != -1) {
            sb.replace(i, sb.length(), "#");
        }
    }

    String getLinkName(PureBigraph bigraph, BigraphEntity<?> node) {
        if (!this.printNodeIdentifiers) {
            return "";
        }
        List ports = bigraph.getPorts(node);
        if (ports.size() == 0) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        for (BigraphEntity.Port p : ports) {
            if (bigraph.getLinkOfPoint((BigraphEntity)p) == null) continue;
            s.append(bigraph.getLinkOfPoint((BigraphEntity)p).getName());
        }
        return s.toString();
    }

    String label(BigraphEntity<?> val) {
        if (BigraphEntityType.isRoot(val)) {
            return "";
        }
        if (BigraphEntityType.isSite(val)) {
            return String.valueOf(((BigraphEntity.SiteEntity)val).getIndex());
        }
        return val.getControl().getNamedType().stringValue();
    }

    public static class RewriteFunction {
        boolean printNodeIdentifiers;

        public String rewrite(MutableSortedMap<String, BigraphEntity.Edge> E2, MutableSortedMap<String, BigraphEntity.OuterName> O2, BigraphEntity.Link l, Supplier<String> rewriteEdgeNameSupplier, Supplier<String> rewriteOuterNameSupplier, boolean printNodeIdentifiers) {
            this.printNodeIdentifiers = printNodeIdentifiers;
            if (BigraphEntityType.isEdge((BigraphEntity)l)) {
                if (E2.flip().get((Object)((BigraphEntity.Edge)l)).getFirstOptional().isEmpty()) {
                    E2.put((Object)rewriteEdgeNameSupplier.get(), (Object)((BigraphEntity.Edge)l));
                }
                return this.labelE(E2, (BigraphEntity.Edge)l);
            }
            if (O2.flip().get((Object)((BigraphEntity.OuterName)l)).getFirstOptional().isEmpty()) {
                if (rewriteOuterNameSupplier != null) {
                    O2.put((Object)rewriteOuterNameSupplier.get(), (Object)((BigraphEntity.OuterName)l));
                } else {
                    O2.put((Object)l.getName(), (Object)((BigraphEntity.OuterName)l));
                }
            }
            return this.labelO(O2, (BigraphEntity.OuterName)l);
        }

        String labelE(MutableSortedMap<String, BigraphEntity.Edge> map, BigraphEntity.Edge val) {
            if (this.printNodeIdentifiers) {
                return val.getName();
            }
            return (String)map.flip().get((Object)val).getOnly();
        }

        String labelO(MutableSortedMap<String, BigraphEntity.OuterName> map, BigraphEntity.OuterName val) {
            if (this.printNodeIdentifiers) {
                return val.getName();
            }
            return (String)map.flip().get((Object)val).getOnly();
        }
    }
}

