/*
 * Decompiled with CFR 0.152.
 */
package org.bigraphs.framework.simulation.equivalence.adapter;

import bighuggies.bisimulation.se705.bisimulation.lts.Process;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.bigraphs.framework.core.Bigraph;
import org.bigraphs.framework.core.Signature;
import org.bigraphs.framework.core.reactivesystem.ReactionGraph;
import org.jgrapht.Graph;

public class BighuggiesBisimulationProcessAdapter<B extends Bigraph<? extends Signature<?>>, AST extends ReactionGraph<B>>
extends Process {
    AST transitionSystem;
    String prefix;

    public BighuggiesBisimulationProcessAdapter(String processName, String prefix, AST transitionSystem) {
        super(processName);
        this.prefix = prefix;
        this.transitionSystem = transitionSystem;
        this.initProcessFromAST();
    }

    protected void initProcessFromAST() {
        Graph g = this.transitionSystem.getGraph();
        AtomicInteger cnt = new AtomicInteger(0);
        HashMap simpleIntMap = new HashMap();
        g.vertexSet().forEach(l -> simpleIntMap.put(l.getLabel(), cnt.getAndIncrement()));
        g.vertexSet().forEach(vertex -> {
            String s1_lbl = this.prefix + simpleIntMap.get(vertex.getLabel());
            g.outgoingEdgesOf(vertex).forEach(edge -> {
                String action_lbl = edge.getLabel();
                String s2_lbl = this.prefix + simpleIntMap.get(((ReactionGraph.LabeledNode)g.getEdgeTarget(edge)).getLabel());
                this.addState(s1_lbl);
                this.addState(s2_lbl);
                this.addAction(action_lbl);
                this.addTransition(s1_lbl, action_lbl, s2_lbl);
            });
        });
    }
}

