/*
 * Decompiled with CFR 0.152.
 */
package org.bigraphs.framework.simulation.matching;

import com.google.common.collect.Streams;
import com.google.common.graph.Traverser;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bigraphs.framework.core.AbstractEcoreSignature;
import org.bigraphs.framework.core.Bigraph;
import org.bigraphs.framework.core.BigraphDelegator;
import org.bigraphs.framework.core.BigraphEntityType;
import org.bigraphs.framework.core.Control;
import org.bigraphs.framework.core.EcoreBigraph;
import org.bigraphs.framework.core.EcoreBigraphExt;
import org.bigraphs.framework.core.impl.BigraphEntity;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class AbstractDynamicMatchAdapter<S extends AbstractEcoreSignature<? extends Control<?, ?>>, B extends Bigraph<S> & EcoreBigraph<S>>
extends BigraphDelegator<S>
implements EcoreBigraph<S> {
    protected Supplier<Throwable> throwableSupplier = new Supplier<Throwable>(){

        @Override
        public Throwable get() {
            return new RuntimeException("Node couldn't be found in the node set of the bigraph.");
        }
    };

    public AbstractDynamicMatchAdapter(B bigraph) {
        super(bigraph);
    }

    public B getBigraphDelegate() {
        return (B)super.getBigraphDelegate();
    }

    public List<BigraphEntity.RootEntity> getRoots() {
        return Lists.mutable.ofAll((Iterable)super.getRoots());
    }

    public EPackage getMetaModel() {
        return ((EcoreBigraphExt)this.getBigraphDelegate()).getMetaModel();
    }

    public EObject getInstanceModel() {
        return ((EcoreBigraphExt)this.getBigraphDelegate()).getInstanceModel();
    }

    public void clearCache() {
    }

    public abstract AbstractSequentialList<ControlLinkPair> getLinksOfNode(BigraphEntity<?> var1);

    public List<BigraphEntity<?>> getSubtreeOfNode(BigraphEntity<?> node) {
        Traverser stringTraverser = Traverser.forTree(this::getChildren);
        MutableList bigraphEntities = Lists.mutable.ofAll(stringTraverser.depthFirstPostOrder(node));
        bigraphEntities.remove(node);
        return bigraphEntities;
    }

    public List<BigraphEntity<?>> getNodesOfLink(BigraphEntity.Link outerName) {
        EObject instance = outerName.getInstance();
        MutableList linkedNodes = Lists.mutable.empty();
        EStructuralFeature pointsRef = instance.eClass().getEStructuralFeature("bPoints");
        if (pointsRef == null) {
            return linkedNodes;
        }
        EList pointsList = (EList)instance.eGet(pointsRef);
        for (EObject eachPoint : pointsList) {
            if (!this.isBPort(eachPoint)) continue;
            EStructuralFeature nodeRef = eachPoint.eClass().getEStructuralFeature("bNode");
            EObject node = (EObject)eachPoint.eGet(nodeRef);
            this.addPlaceToList((List<BigraphEntity<?>>)linkedNodes, node, false);
        }
        return linkedNodes;
    }

    public int degreeOf(BigraphEntity<?> nodeEntity) {
        EStructuralFeature prntRef;
        EObject instance = nodeEntity.getInstance();
        int cnt = 0;
        EStructuralFeature chldRef = instance.eClass().getEStructuralFeature("bChild");
        if (Objects.nonNull(chldRef)) {
            EList childs = (EList)instance.eGet(chldRef);
            cnt += childs.size();
        }
        if (Objects.nonNull(prntRef = instance.eClass().getEStructuralFeature("bPrnt")) && Objects.nonNull(instance.eGet(prntRef))) {
            ++cnt;
        }
        return cnt;
    }

    protected List<BigraphEntity<?>> neighborhoodHook(List<BigraphEntity<?>> neighbors, BigraphEntity<?> node) {
        EStructuralFeature prntRef;
        EObject instance = node.getInstance();
        EStructuralFeature chldRef = instance.eClass().getEStructuralFeature("bChild");
        if (Objects.nonNull(chldRef)) {
            EList childs = (EList)instance.eGet(chldRef);
            for (EObject each : childs) {
                this.addPlaceToList(neighbors, each, false);
            }
        }
        if (Objects.nonNull(prntRef = instance.eClass().getEStructuralFeature("bPrnt")) && Objects.nonNull(instance.eGet(prntRef))) {
            EObject each = (EObject)instance.eGet(prntRef);
            this.addPlaceToList(neighbors, each, false);
        }
        return neighbors;
    }

    protected void addPlaceToList(List<BigraphEntity<?>> list, EObject each, boolean withSites) {
        try {
            if (this.isBNode(each)) {
                list.add((BigraphEntity)this.getNodes().stream().filter(x -> x.getInstance().equals(each)).findFirst().orElseThrow(this.throwableSupplier));
            } else if (this.isBRoot(each)) {
                list.add((BigraphEntity)this.getRoots().stream().filter(x -> x.getInstance().equals(each)).findFirst().orElseThrow(this.throwableSupplier));
            }
            if (withSites && this.isBSite(each)) {
                list.add((BigraphEntity)this.getSites().stream().filter(x -> x.getInstance().equals(each)).findFirst().orElseThrow(this.throwableSupplier));
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public MutableList<BigraphEntity<?>> getOpenNeighborhoodOfVertex(BigraphEntity<?> node) {
        MutableList neighbors = Lists.mutable.empty();
        this.neighborhoodHook((List<BigraphEntity<?>>)neighbors, node);
        return neighbors;
    }

    public ImmutableList<BigraphEntity<?>> getAllVertices() {
        return Lists.immutable.fromStream(Streams.concat((Stream[])new Stream[]{this.getNodes().stream().map(x -> x), this.getRoots().stream().map(x -> x)}));
    }

    public ImmutableList<BigraphEntity<?>> getAllInternalVerticesPostOrder() {
        return Lists.immutable.ofAll(this.getAllVerticesPostOrder()).select((Predicate & Serializable)x -> this.getChildren((BigraphEntity<?>)x).size() > 0);
    }

    public Stream<BigraphEntity<?>> getAllInternalVerticesPostOrderAsStream() {
        Iterable<BigraphEntity<?>> allVerticesPostOrder = this.getAllVerticesPostOrder();
        return StreamSupport.stream(allVerticesPostOrder.spliterator(), false).filter(x -> this.getChildren((BigraphEntity<?>)x).size() > 0);
    }

    public Iterable<BigraphEntity<?>> getAllVerticesPostOrder() {
        MutableList allVerticesPostOrder = Lists.mutable.empty();
        this.getRoots().forEach(eachRoot -> {
            Traverser stringTraverser = Traverser.forTree(this::getChildren);
            allVerticesPostOrder.addAllIterable(stringTraverser.depthFirstPostOrder(eachRoot));
        });
        return allVerticesPostOrder;
    }

    public Iterable<BigraphEntity<?>> getAllVerticesBfsOrder() {
        MutableList allVerticesBfsOrder = Lists.mutable.empty();
        this.getBigraphDelegate().getRoots().stream().sorted(Comparator.comparingInt(BigraphEntity.RootEntity::getIndex)).forEachOrdered(eachRoot -> allVerticesBfsOrder.addAll(this.getAllVerticesBfsOrderFrom((BigraphEntity<?>)eachRoot)));
        return allVerticesBfsOrder;
    }

    public Stream<BigraphEntity<?>> getAllVerticesBfsOrderStream() {
        Traverser stringTraverser = Traverser.forTree(this::getChildren);
        return StreamSupport.stream(stringTraverser.breadthFirst((Object)((BigraphEntity)this.getRoots().get(0))).spliterator(), false);
    }

    public List<BigraphEntity<?>> getAllVerticesBfsOrderFrom(BigraphEntity<?> eachRoot) {
        Traverser stringTraverser = Traverser.forTree(this::getChildren);
        return Lists.fixedSize.ofAll(stringTraverser.breadthFirst(eachRoot));
    }

    public List<BigraphEntity<?>> getChildren(BigraphEntity<?> node) {
        MutableList childrenWithoutSites = Lists.mutable.empty();
        for (BigraphEntity x : this.getBigraphDelegate().getChildrenOf(node)) {
            if (BigraphEntityType.isSite((BigraphEntity)x)) continue;
            childrenWithoutSites.add((Object)x);
        }
        return childrenWithoutSites;
    }

    public List<BigraphEntity<?>> getAllLeaves() {
        MutableList leaves = Lists.mutable.empty();
        this.getAllVertices().forEach((Procedure & Serializable)each -> {
            if (this.degreeOf((BigraphEntity<?>)each) <= 1 && !this.isBRoot(each.getInstance())) {
                leaves.add(each);
            }
        });
        return leaves;
    }

    public static class ControlLinkPair {
        Control<?, ?> control;
        BigraphEntity.Link link;

        public ControlLinkPair(Control<?, ?> control, BigraphEntity.Link link) {
            this.control = control;
            this.link = link;
        }

        public Control<?, ?> getControl() {
            return this.control;
        }

        public BigraphEntity.Link getLink() {
            return this.link;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ControlLinkPair)) {
                return false;
            }
            ControlLinkPair that = (ControlLinkPair)o;
            return this.control.equals(that.control) && this.link.equals((Object)that.link);
        }

        public int hashCode() {
            return Objects.hash(this.control, this.link);
        }
    }
}

