/*
 * Decompiled with CFR 0.152.
 */
package org.bigraphs.framework.simulation.matching;

import com.google.common.collect.Lists;
import com.google.common.graph.Traverser;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.bigraphs.framework.core.impl.BigraphEntity;
import org.bigraphs.framework.simulation.matching.AbstractDynamicMatchAdapter;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;
import org.jgrapht.graph.builder.GraphTypeBuilder;

public abstract class BigraphMatchingSupport {
    protected static final ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());

    public List<BigraphEntity<?>> getSubBigraphFrom(BigraphEntity<?> node, AbstractDynamicMatchAdapter adapter) {
        Traverser childTraverser = Traverser.forTree(xx -> adapter.getChildren((BigraphEntity<?>)xx));
        return Lists.newArrayList((Iterable)childTraverser.breadthFirst(node));
    }

    public boolean isSameControl(BigraphEntity<?> node1, BigraphEntity<?> node2) {
        return node1.getControl().equals(node2.getControl());
    }

    public static Graph<BigraphEntity<?>, DefaultEdge> createBipartiteGraph(List<BigraphEntity<?>> x, List<BigraphEntity<?>> y) {
        SimpleGraph bg = (SimpleGraph)BigraphMatchingSupport.buildEmptySimpleDirectedGraph();
        for (BigraphEntity<?> eachX : x) {
            bg.addVertex(eachX);
        }
        for (BigraphEntity<?> eachY : y) {
            bg.addVertex(eachY);
        }
        return bg;
    }

    public static Graph<BigraphEntity<?>, DefaultEdge> buildEmptySimpleDirectedGraph() {
        return GraphTypeBuilder.undirected().allowingMultipleEdges(false).allowingSelfLoops(false).edgeClass(DefaultEdge.class).weighted(false).buildGraph();
    }
}

