/*
 * Decompiled with CFR 0.152.
 */
package org.bigraphs.framework.simulation.matching.pure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bigraphs.framework.core.Bigraph;
import org.bigraphs.framework.core.BigraphEntityType;
import org.bigraphs.framework.core.impl.BigraphEntity;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.impl.factory.Sets;

public class IHSFilter {
    private final Bigraph<?> redex;
    private final Bigraph<?> agent;

    public IHSFilter(Bigraph<?> redexAdapter, Bigraph<?> agentAdapter) {
        this.redex = redexAdapter;
        this.agent = agentAdapter;
    }

    public boolean condition1(BigraphEntity.NodeEntity<?> nodeRedex, BigraphEntity.NodeEntity<?> nodeAgent) {
        boolean labelsAreEqual = this.getLabel(nodeRedex).equals(this.getLabel(nodeAgent));
        boolean degreeIsLessOrEqual = this.degree(nodeRedex, this.redex) <= this.degree(nodeAgent, this.agent);
        return labelsAreEqual && degreeIsLessOrEqual;
    }

    public boolean condition2(BigraphEntity.NodeEntity<?> nodeRedex, BigraphEntity.NodeEntity<?> nodeAgent) {
        return this.numOfadj(nodeRedex, this.redex) <= this.numOfadj(nodeAgent, this.agent);
    }

    public boolean condition3(BigraphEntity.NodeEntity<?> nodeRedex, BigraphEntity.NodeEntity<?> nodeAgent) {
        Map<Integer, List<BigraphEntity.Link>> incidentHyperedgesR = this.getIncidentHyperedges(nodeRedex, this.redex);
        Map<Integer, List<BigraphEntity.Link>> incidentHyperedgesA = this.getIncidentHyperedges(nodeAgent, this.agent);
        Stream concat = Stream.concat(incidentHyperedgesR.keySet().stream(), incidentHyperedgesA.keySet().stream()).distinct();
        Set arityValues = concat.collect(Collectors.toSet());
        for (Integer eachArity : arityValues) {
            int arityA;
            boolean hasEdge;
            boolean redexHasAritiy = incidentHyperedgesR.get(eachArity) != null;
            boolean agentHasAritiy = incidentHyperedgesA.get(eachArity) != null;
            boolean bl = hasEdge = redexHasAritiy && incidentHyperedgesR.get(eachArity).stream().anyMatch(BigraphEntityType::isEdge);
            if (hasEdge) {
                List edgesR = incidentHyperedgesR.get(eachArity).stream().filter(BigraphEntityType::isEdge).collect(Collectors.toList());
                List edgesA = incidentHyperedgesA.values().stream().flatMap(Collection::stream).filter(BigraphEntityType::isEdge).collect(Collectors.toList());
                if (edgesR.size() > edgesA.size()) {
                    this.clearMap(incidentHyperedgesA, incidentHyperedgesR);
                    return false;
                }
                for (int i = 0; i < edgesR.size(); ++i) {
                    long count = this.redex.getPointsFromLink((BigraphEntity.Link)edgesR.get(i)).stream().filter(BigraphEntityType::isPort).map(x -> this.redex.getNodeOfPort((BigraphEntity.Port)x)).count();
                    boolean cmp = edgesA.stream().allMatch(x -> this.agent.getPointsFromLink(x).stream().filter(BigraphEntityType::isPort).map(p -> this.agent.getNodeOfPort((BigraphEntity.Port)p)).count() != count);
                    if (!cmp) continue;
                    this.clearMap(incidentHyperedgesA, incidentHyperedgesR);
                    return false;
                }
                continue;
            }
            int arityR = redexHasAritiy ? incidentHyperedgesR.get(eachArity).size() : 0;
            if (arityR <= (arityA = agentHasAritiy ? incidentHyperedgesA.get(eachArity).size() : arityR)) continue;
            this.clearMap(incidentHyperedgesA, incidentHyperedgesR);
            return false;
        }
        this.clearMap(incidentHyperedgesA, incidentHyperedgesR);
        return true;
    }

    private void clearMap(Map ... maps) {
        for (Map each : maps) {
            each.clear();
        }
    }

    public boolean condition4(BigraphEntity.NodeEntity<?> nodeRedex, BigraphEntity.NodeEntity<?> nodeAgent) {
        Map<Integer, List<BigraphEntity.Link>> incidentHyperedgesR = this.getIncidentHyperedges(nodeRedex, this.redex);
        Map<Integer, List<BigraphEntity.Link>> incidentHyperedgesA = this.getIncidentHyperedges(nodeAgent, this.agent);
        if (incidentHyperedgesR.size() == 0 && incidentHyperedgesA.size() == 0) {
            return true;
        }
        Stream concat = Stream.concat(incidentHyperedgesR.keySet().stream(), incidentHyperedgesA.keySet().stream()).distinct();
        Set arityValues = concat.collect(Collectors.toSet());
        List allLabels = this.agent.getSignature().getControls().stream().map(x -> x.getNamedType().stringValue()).collect(Collectors.toList());
        boolean noMatchAtAll = false;
        for (Integer eachArity : arityValues) {
            noMatchAtAll = false;
            List<BigraphEntity.Link> heRedex = incidentHyperedgesR.get(eachArity);
            List<BigraphEntity.Link> heAgents = incidentHyperedgesA.get(eachArity);
            if (heRedex == null) {
                noMatchAtAll = true;
                continue;
            }
            if (heAgents == null) {
                noMatchAtAll = true;
                continue;
            }
            int lblMatchCount = 0;
            for (BigraphEntity.Link e1 : heRedex) {
                for (BigraphEntity.Link e2 : heAgents) {
                    for (String l : allLabels) {
                        Set<BigraphEntity.NodeEntity<?>> elR = this.getOfNodesForHyperedgeWithLabel(e1, l, this.redex);
                        Set<BigraphEntity.NodeEntity<?>> elA = this.getOfNodesForHyperedgeWithLabel(e2, l, this.agent);
                        if (elR.size() != elA.size()) continue;
                        ++lblMatchCount;
                    }
                    if (lblMatchCount == allLabels.size()) {
                        return true;
                    }
                    lblMatchCount = 0;
                }
            }
        }
        return noMatchAtAll;
    }

    public Set<BigraphEntity.NodeEntity<?>> getOfNodesForHyperedgeWithLabel(BigraphEntity.Link he, String label, Bigraph<?> bigraph) {
        Set<BigraphEntity.NodeEntity<?>> collect1 = bigraph.getPointsFromLink(he).stream().filter(BigraphEntityType::isPort).map(x -> bigraph.getNodeOfPort((BigraphEntity.Port)x)).distinct().filter(x -> x.getControl().getNamedType().stringValue().equals(label)).collect(Collectors.toSet());
        return collect1;
    }

    public Map<Integer, List<BigraphEntity.Link>> getIncidentHyperedges(BigraphEntity.NodeEntity<?> node, Bigraph<?> bigraph) {
        HashMap<Integer, List<BigraphEntity.Link>> heAll = new HashMap<Integer, List<BigraphEntity.Link>>();
        List collect = bigraph.getPorts(node).stream().map(arg_0 -> bigraph.getLinkOfPoint(arg_0)).collect(Collectors.toList());
        for (BigraphEntity.Link eachLink : collect) {
            long arity = bigraph.getPointsFromLink(eachLink).stream().distinct().count();
            heAll.putIfAbsent((int)arity, new ArrayList());
            ((List)heAll.get((int)arity)).add(eachLink);
        }
        return heAll;
    }

    public int degree(BigraphEntity.NodeEntity<?> node, Bigraph<?> bigraph) {
        return (int)bigraph.getPorts(node).stream().map(arg_0 -> bigraph.getLinkOfPoint(arg_0)).filter(Objects::nonNull).count();
    }

    public String getLabel(BigraphEntity.NodeEntity<?> node) {
        return node.getControl().getNamedType().stringValue();
    }

    public int numOfadj(BigraphEntity.NodeEntity<?> node, Bigraph<?> bigraph) {
        Set<BigraphEntity.NodeEntity<?>> collect1 = this.adj(node, bigraph);
        return collect1.size();
    }

    public Set<BigraphEntity.NodeEntity<?>> adj(BigraphEntity.NodeEntity<?> node, Bigraph<?> bigraph) {
        Collection collect = bigraph.getIncidentLinksOf(node);
        MutableSet collector = Sets.mutable.empty();
        for (BigraphEntity.Link x : collect) {
            Collection pointsFromLink = bigraph.getPointsFromLink(x);
            for (BigraphEntity p : pointsFromLink) {
                BigraphEntity.NodeEntity nodeOfPort;
                if (!BigraphEntityType.isPort((BigraphEntity)p) || (nodeOfPort = bigraph.getNodeOfPort((BigraphEntity.Port)p)) == node) continue;
                collector.add((Object)nodeOfPort);
            }
        }
        return collector;
    }
}

