/*
 * Decompiled with CFR 0.152.
 */
package org.bigraphs.framework.simulation.matching.pure;

import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import org.bigraphs.framework.core.impl.BigraphEntity;
import org.bigraphs.framework.core.impl.pure.PureBigraph;
import org.bigraphs.framework.core.impl.signature.DefaultDynamicSignature;
import org.bigraphs.framework.simulation.matching.AbstractDynamicMatchAdapter;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.factory.Maps;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class PureBigraphAgentAdapter
extends AbstractDynamicMatchAdapter<DefaultDynamicSignature, PureBigraph> {
    MutableMap<BigraphEntity<?>, LinkedList<AbstractDynamicMatchAdapter.ControlLinkPair>> linkOfNodesMap = Maps.mutable.empty();

    public PureBigraphAgentAdapter(PureBigraph bigraph) {
        super(bigraph);
    }

    public DefaultDynamicSignature getSignature() {
        return (DefaultDynamicSignature)super.getSignature();
    }

    @Override
    public void clearCache() {
        this.linkOfNodesMap.clear();
    }

    public LinkedList<AbstractDynamicMatchAdapter.ControlLinkPair> getLinksOfNode(BigraphEntity<?> node) {
        if (this.linkOfNodesMap.containsKey(node)) {
            return (LinkedList)this.linkOfNodesMap.get(node);
        }
        EObject instance = node.getInstance();
        LinkedList<AbstractDynamicMatchAdapter.ControlLinkPair> children = new LinkedList<AbstractDynamicMatchAdapter.ControlLinkPair>();
        EStructuralFeature portRef = instance.eClass().getEStructuralFeature("bPorts");
        if (Objects.nonNull(portRef)) {
            EList portList = (EList)instance.eGet(portRef);
            for (EObject eachPort : portList) {
                EStructuralFeature linkRef = eachPort.eClass().getEStructuralFeature("bLink");
                if (!Objects.nonNull(linkRef) || !Objects.nonNull(eachPort.eGet(linkRef))) continue;
                EObject obj = (EObject)eachPort.eGet(linkRef);
                try {
                    Optional<BigraphEntity.OuterName> first;
                    if (this.isBOuterName(obj)) {
                        first = this.getOuterNames().stream().filter(x -> x.getInstance().equals(obj)).findFirst();
                        children.add(new AbstractDynamicMatchAdapter.ControlLinkPair(node.getControl(), (BigraphEntity.Link)first.orElseThrow(this.throwableSupplier)));
                        continue;
                    }
                    if (!this.isBEdge(obj)) continue;
                    first = this.getEdges().stream().filter(x -> x.getInstance().equals(obj)).findFirst();
                    children.add(new AbstractDynamicMatchAdapter.ControlLinkPair(node.getControl(), (BigraphEntity.Link)first.orElseThrow(this.throwableSupplier)));
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.linkOfNodesMap.put(node, children);
        return children;
    }
}

