/*
 * Decompiled with CFR 0.152.
 */
package org.bigraphs.framework.simulation.matching.pure;

import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.bigraphs.framework.core.impl.pure.PureBigraph;
import org.bigraphs.framework.core.reactivesystem.BigraphMatch;
import org.bigraphs.framework.core.reactivesystem.ReactionRule;
import org.bigraphs.framework.simulation.matching.AbstractBigraphMatcher;
import org.bigraphs.framework.simulation.matching.MatchIterable;
import org.bigraphs.framework.simulation.matching.pure.PureBigraphMatchingEngine;
import org.bigraphs.framework.simulation.matching.pure.PureBigraphParametricMatch;
import org.bigraphs.framework.simulation.matching.pure.PureMatchIteratorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PureBigraphMatcher
extends AbstractBigraphMatcher<PureBigraph> {
    Logger logger = LoggerFactory.getLogger(PureBigraphMatcher.class);

    @Override
    public <M extends BigraphMatch<PureBigraph>> MatchIterable<M> match(PureBigraph agent, ReactionRule<PureBigraph> rule) {
        this.agent = agent;
        this.rule = rule;
        this.redex = rule.getRedex();
        PureBigraphMatchingEngine matchingEngine = this.instantiateEngine();
        Stopwatch timer0 = this.logger.isDebugEnabled() ? Stopwatch.createStarted() : null;
        MatchIterable<PureBigraphParametricMatch> bigraphMatches = new MatchIterable<PureBigraphParametricMatch>(new PureMatchIteratorImpl(matchingEngine));
        if (this.logger.isDebugEnabled()) {
            long elapsed0 = timer0.stop().elapsed(TimeUnit.NANOSECONDS);
            this.logger.debug("Complete Matching Time: {} (ms)", (Object)Float.valueOf((float)elapsed0 / 1000000.0f));
        }
        return bigraphMatches;
    }

    public PureBigraphMatchingEngine instantiateEngine() {
        return new PureBigraphMatchingEngine((PureBigraph)this.agent, (ReactionRule<PureBigraph>)this.rule);
    }
}

