/*
 * Decompiled with CFR 0.152.
 */
package org.bigraphs.framework.simulation.matching.pure;

import com.google.common.base.Stopwatch;
import it.uniud.mads.jlibbig.core.std.AgentMatch;
import it.uniud.mads.jlibbig.core.std.AgentMatcher;
import it.uniud.mads.jlibbig.core.std.Matcher;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.bigraphs.framework.converter.jlibbig.JLibBigBigraphDecoder;
import org.bigraphs.framework.converter.jlibbig.JLibBigBigraphEncoder;
import org.bigraphs.framework.core.Bigraph;
import org.bigraphs.framework.core.impl.pure.PureBigraph;
import org.bigraphs.framework.core.impl.signature.DefaultDynamicSignature;
import org.bigraphs.framework.core.reactivesystem.InstantiationMap;
import org.bigraphs.framework.core.reactivesystem.ReactionRule;
import org.bigraphs.framework.simulation.matching.BigraphMatchingEngine;
import org.bigraphs.framework.simulation.matching.BigraphMatchingSupport;
import org.bigraphs.framework.simulation.matching.pure.PureBigraphParametricMatch;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.impl.factory.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PureBigraphMatchingEngine
extends BigraphMatchingSupport
implements BigraphMatchingEngine<PureBigraph> {
    private final Logger logger = LoggerFactory.getLogger(PureBigraphMatchingEngine.class);
    private final MutableList<PureBigraphParametricMatch> matches = Lists.mutable.empty();
    private final JLibBigBigraphEncoder encoder = new JLibBigBigraphEncoder();
    private final JLibBigBigraphDecoder decoder = new JLibBigBigraphDecoder();
    it.uniud.mads.jlibbig.core.std.Bigraph jLibAgent;
    it.uniud.mads.jlibbig.core.std.Bigraph jLibRedex;
    Matcher matcher = new Matcher();
    AgentMatcher agentMatcher = new AgentMatcher();
    Iterable<? extends AgentMatch> jLibMatchIterator;
    boolean hasMatched = false;
    ReactionRule<PureBigraph> reactionRule;
    private Stopwatch matchingTimer;

    PureBigraphMatchingEngine(PureBigraph agent, ReactionRule<PureBigraph> reactionRule) {
        this.reactionRule = reactionRule;
        Stopwatch timer = this.logger.isDebugEnabled() ? Stopwatch.createStarted() : null;
        this.jLibAgent = this.encoder.encode(agent);
        this.jLibRedex = this.encoder.encode((PureBigraph)reactionRule.getRedex(), this.jLibAgent.getSignature());
        if (this.logger.isDebugEnabled() && Objects.nonNull(timer)) {
            this.logger.debug("Initialization time: {} (ms)", (Object)Float.valueOf((float)timer.stop().elapsed(TimeUnit.NANOSECONDS) / 1000000.0f));
        }
    }

    public List<PureBigraphParametricMatch> getMatches() {
        return this.matches;
    }

    public void beginMatch() {
        if (this.logger.isDebugEnabled()) {
            this.matchingTimer = Stopwatch.createStarted();
        }
        InstantiationMap instantationMap = this.reactionRule.getInstantationMap();
        int[] imArray = new int[instantationMap.getMappings().size()];
        for (int i = 0; i < imArray.length; ++i) {
            imArray[i] = (Integer)instantationMap.get(i).getValue();
        }
        it.uniud.mads.jlibbig.core.std.InstantiationMap eta = new it.uniud.mads.jlibbig.core.std.InstantiationMap(((PureBigraph)this.reactionRule.getRedex()).getSites().size(), imArray);
        int[] prms = new int[eta.getPlaceDomain()];
        boolean[] neededParam = new boolean[((PureBigraph)this.reactionRule.getRedex()).getSites().size()];
        for (int i = 0; i < eta.getPlaceDomain(); ++i) {
            int j = eta.getPlaceInstance(i);
            neededParam[j] = true;
            prms[i] = j;
        }
        this.jLibMatchIterator = this.agentMatcher.match(this.jLibAgent, this.jLibRedex, neededParam);
        this.hasMatched = true;
        this.logger.debug("Matches found?: {}", (Object)this.hasMatched());
    }

    public void createMatchResult() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Matching took: {} (ms)", (Object)Float.valueOf((float)this.matchingTimer.stop().elapsed(TimeUnit.NANOSECONDS) / 1000000.0f));
            this.matchingTimer.reset().start();
        }
        try {
            for (AgentMatch agentMatch : this.jLibMatchIterator) {
                PureBigraph context = null;
                PureBigraph redex = (PureBigraph)this.reactionRule.getRedex();
                PureBigraph redexImage = null;
                Bigraph<DefaultDynamicSignature> redexIdentity = null;
                LinkedList<PureBigraph> params = new LinkedList<PureBigraph>();
                PureBigraph paramWiring = null;
                PureBigraphParametricMatch matchResult = new PureBigraphParametricMatch(agentMatch, context, redex, redexImage, redexIdentity, paramWiring, params);
                this.matches.add((Object)matchResult);
            }
        }
        catch (AssertionError error) {
            ((Throwable)((Object)error)).printStackTrace();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Time to build the match result: {} ms", (Object)Float.valueOf((float)this.matchingTimer.stop().elapsed(TimeUnit.NANOSECONDS) / 1000000.0f));
        }
    }

    public boolean hasMatched() {
        return this.hasMatched;
    }
}

