/*
 * Decompiled with CFR 0.152.
 */
package org.bigraphs.framework.simulation.matching.pure;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bigraphs.framework.core.impl.BigraphEntity;
import org.bigraphs.framework.core.impl.pure.PureBigraph;
import org.bigraphs.framework.core.impl.signature.DefaultDynamicSignature;
import org.bigraphs.framework.simulation.matching.AbstractDynamicMatchAdapter;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Maps;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class PureBigraphRedexAdapter
extends AbstractDynamicMatchAdapter<DefaultDynamicSignature, PureBigraph> {
    MutableMap<BigraphEntity<?>, List<BigraphEntity<?>>> childMap = Maps.mutable.empty();
    MutableMap<BigraphEntity<?>, LinkedList<AbstractDynamicMatchAdapter.ControlLinkPair>> linkOfNodesMap = Maps.mutable.empty();

    public PureBigraphRedexAdapter(PureBigraph bigraph) {
        super(bigraph);
    }

    public DefaultDynamicSignature getSignature() {
        return (DefaultDynamicSignature)super.getSignature();
    }

    @Override
    public void clearCache() {
        this.childMap.clear();
        this.linkOfNodesMap.clear();
    }

    public List<BigraphEntity<?>> getChildrenWithSites(BigraphEntity<?> node) {
        if (this.childMap.containsKey(node)) {
            return (List)this.childMap.get(node);
        }
        EObject instance = node.getInstance();
        EStructuralFeature chldRef = instance.eClass().getEStructuralFeature("bChild");
        MutableList children = Lists.mutable.empty();
        if (chldRef != null) {
            EList childs = (EList)instance.eGet(chldRef);
            for (EObject eachChild : childs) {
                this.addPlaceToList((List<BigraphEntity<?>>)children, eachChild, true);
            }
        }
        this.childMap.put(node, (Object)children);
        return children;
    }

    public LinkedList<AbstractDynamicMatchAdapter.ControlLinkPair> getLinksOfNode(BigraphEntity<?> node) {
        if (this.linkOfNodesMap.containsKey(node)) {
            return (LinkedList)this.linkOfNodesMap.get(node);
        }
        EObject instance = node.getInstance();
        LinkedList<AbstractDynamicMatchAdapter.ControlLinkPair> children = new LinkedList<AbstractDynamicMatchAdapter.ControlLinkPair>();
        EStructuralFeature portRef = instance.eClass().getEStructuralFeature("bPorts");
        if (portRef != null) {
            EList portList = (EList)instance.eGet(portRef);
            for (EObject eachPort : portList) {
                EStructuralFeature linkRef = eachPort.eClass().getEStructuralFeature("bLink");
                if (!Objects.nonNull(linkRef) || !Objects.nonNull(eachPort.eGet(linkRef))) continue;
                EObject obj = (EObject)eachPort.eGet(linkRef);
                try {
                    if (!this.isBOuterName(obj)) continue;
                    Optional<BigraphEntity.OuterName> first = this.getOuterNames().stream().filter(x -> x.getInstance().equals(obj)).findFirst();
                    children.add(new AbstractDynamicMatchAdapter.ControlLinkPair(node.getControl(), (BigraphEntity.Link)first.orElseThrow(this.throwableSupplier)));
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.linkOfNodesMap.put(node, children);
        return children;
    }

    @Override
    public int degreeOf(BigraphEntity<?> nodeEntity) {
        EStructuralFeature prntRef;
        EObject instance = nodeEntity.getInstance();
        int cnt = 0;
        EStructuralFeature chldRef = instance.eClass().getEStructuralFeature("bChild");
        if (chldRef != null) {
            EList childs = (EList)instance.eGet(chldRef);
            for (EObject eObject : childs) {
                if (this.isBSite(eObject)) continue;
                ++cnt;
            }
        }
        if ((prntRef = instance.eClass().getEStructuralFeature("bPrnt")) != null && instance.eGet(prntRef) != null) {
            ++cnt;
        }
        return cnt;
    }
}

