/*
 * Decompiled with CFR 0.152.
 */
package org.bigraphs.framework.simulation.matching.pure;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bigraphs.framework.simulation.matching.pure.PureBigraphMatchingEngine;
import org.bigraphs.framework.simulation.matching.pure.PureBigraphParametricMatch;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.impl.factory.Lists;

public class PureMatchIteratorImpl
implements Iterator<PureBigraphParametricMatch> {
    private int cursor = 0;
    private MutableList<PureBigraphParametricMatch> matches = Lists.mutable.empty();
    private PureBigraphMatchingEngine matchingEngine;

    PureMatchIteratorImpl(PureBigraphMatchingEngine matchingEngine) {
        this.matchingEngine = matchingEngine;
        this.findMatches();
    }

    private void findMatches() {
        this.matchingEngine.beginMatch();
        if (this.matchingEngine.hasMatched()) {
            this.matchingEngine.createMatchResult();
        }
        this.matches = Lists.mutable.ofAll((Iterable)this.matchingEngine.getMatches());
    }

    @Override
    public boolean hasNext() {
        if (this.matches.isEmpty()) {
            return false;
        }
        return this.cursor != this.matches.size();
    }

    @Override
    public PureBigraphParametricMatch next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (PureBigraphParametricMatch)this.matches.get(this.cursor++);
    }
}

