/*
 * Decompiled with CFR 0.152.
 */
package org.bigraphs.framework.simulation.matching.pure;

import com.google.common.graph.Traverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bigraphs.framework.core.Bigraph;
import org.bigraphs.framework.core.BigraphEntityType;
import org.bigraphs.framework.core.Control;
import org.bigraphs.framework.core.impl.BigraphEntity;
import org.bigraphs.framework.core.impl.pure.PureBigraph;
import org.bigraphs.framework.simulation.matching.pure.IHSFilter;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Maps;

public class SubHypergraphIsoSearch {
    private final Bigraph<?> redex;
    private final Bigraph<?> agent;
    private final IHSFilter ihsFilter;
    private final MutableMap<BigraphEntity.NodeEntity<?>, List<BigraphEntity.NodeEntity<?>>> candidates;
    MutableMap<BigraphEntity.NodeEntity<Control<?, ?>>, Float> rankMap;
    private boolean initialized;
    Set<Embedding> embeddingSet = new HashSet<Embedding>();

    public SubHypergraphIsoSearch(Bigraph<?> redex, Bigraph<?> agent) {
        this.redex = redex;
        this.agent = agent;
        this.candidates = Maps.mutable.empty();
        this.rankMap = Maps.mutable.empty();
        this.ihsFilter = new IHSFilter(redex, agent);
        this.initialized = false;
    }

    public void init() {
        assert (this.redex.getNodes().size() != 0);
        if (!this.initialized) {
            for (BigraphEntity.NodeEntity u_i : this.redex.getNodes()) {
                this.candidates.putIfAbsent((Object)u_i, new ArrayList());
                this.computeRankFor((Map<BigraphEntity.NodeEntity<Control<?, ?>>, Float>)this.rankMap, (BigraphEntity.NodeEntity<Control<?, ?>>)u_i);
            }
            this.initialized = true;
        }
    }

    public void reset() {
        this.candidates.clear();
        this.embeddingSet.clear();
        this.initialized = false;
    }

    public boolean allCandidatesFound() {
        if (!this.initialized) {
            return false;
        }
        int linkCountRedex = this.redex.getAllLinks().size();
        int linkCountAgent = this.agent.getAllLinks().size();
        if (linkCountRedex == 0 && linkCountAgent == 0) {
            return true;
        }
        if (linkCountRedex > 0 && linkCountAgent > 0 && this.candidates.size() == this.redex.getNodes().size()) {
            return this.allCandidateNodesHaveValues(this.candidates);
        }
        return linkCountRedex == 0 && linkCountAgent > 0;
    }

    public void embeddings() {
        this.init();
        Optional startNode = this.rankMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).findFirst();
        BigraphEntity.NodeEntity u_s = startNode.isPresent() ? (BigraphEntity.NodeEntity)startNode.get().getKey() : (BigraphEntity.NodeEntity)((PureBigraph)this.redex).getNodes().get(0);
        for (BigraphEntity.NodeEntity v_s : this.agent.getNodes()) {
            if (!this.candidateGenWithBFS(u_s, v_s)) continue;
            Embedding emb = new Embedding();
            LinkedList cands = new LinkedList(this.candidates.keySet());
            this.recursiveSearch3(u_s, cands, 0, emb);
        }
    }

    private void computeRankFor(Map<BigraphEntity.NodeEntity<Control<?, ?>>, Float> rankMap, BigraphEntity.NodeEntity<Control<?, ?>> u) {
        float freq = this.freq(this.agent, u);
        float degree = (float)this.ihsFilter.degree(u, this.redex) * 1.0f;
        float rank = freq / degree;
        rankMap.put(u, Float.valueOf(rank));
    }

    public Map<BigraphEntity.NodeEntity<Control<?, ?>>, Float> computeRanks() {
        HashMap rankMap = new HashMap();
        for (BigraphEntity.NodeEntity u : this.redex.getNodes()) {
            float freq = this.freq(this.agent, u);
            float degree = (float)this.ihsFilter.degree(u, this.redex) * 1.0f;
            float rank = freq / degree;
            rankMap.put(u, Float.valueOf(rank));
        }
        return rankMap;
    }

    private float freq(Bigraph<?> agent, BigraphEntity.NodeEntity<Control<?, ?>> redexNode) {
        String label = this.ihsFilter.getLabel(redexNode);
        float sameLabelInAgent = (float)agent.getNodes().stream().filter(x -> x.getControl().getNamedType().stringValue().equals(label)).count() * 1.0f;
        return sameLabelInAgent;
    }

    private boolean candidateGen(BigraphEntity.NodeEntity<Control<?, ?>> u_s, BigraphEntity.NodeEntity<Control<?, ?>> v_s) {
        if (this.agent.getPortCount(v_s) > 0 && this.redex.getPortCount(u_s) > 0 && this.ihsFilter.condition1(u_s, v_s) && this.ihsFilter.condition2(u_s, v_s) && this.ihsFilter.condition3(u_s, v_s) && this.ihsFilter.condition4(u_s, v_s)) {
            ((List)this.candidates.get(u_s)).add(v_s);
            return true;
        }
        return false;
    }

    private boolean candidateGenWithBFS(BigraphEntity.NodeEntity<Control<?, ?>> u_s, BigraphEntity.NodeEntity<Control<?, ?>> v_s) {
        Traverser traverser = Traverser.forGraph(arg_0 -> this.redex.getOpenNeighborhoodOfVertex(arg_0));
        int rootCnt = this.redex.getRoots().size();
        BigraphEntity.RootEntity startNodes = new BigraphEntity[rootCnt];
        startNodes[0] = u_s;
        if (rootCnt > 1) {
            BigraphEntity.RootEntity topLevelRoot = this.redex.getTopLevelRoot(u_s);
            Iterator iterator = this.redex.getRoots().iterator();
            int ix = 1;
            while (iterator.hasNext()) {
                BigraphEntity.RootEntity root = (BigraphEntity.RootEntity)iterator.next();
                if (root == topLevelRoot) continue;
                startNodes[ix++] = root;
            }
        }
        for (BigraphEntity.RootEntity startNode : startNodes) {
            traverser.breadthFirst((Object)startNode).forEach(u_i -> {
                if (!BigraphEntityType.isNode((BigraphEntity)u_i)) {
                    return;
                }
                BigraphEntity.NodeEntity u = (BigraphEntity.NodeEntity)u_i;
                if (this.ihsFilter.condition1(u, v_s) && this.ihsFilter.condition2(u, v_s) && this.ihsFilter.condition3(u, v_s) && this.ihsFilter.condition4(u, v_s)) {
                    ((List)this.candidates.get((Object)u)).add(v_s);
                }
            });
        }
        boolean b = this.candidates.size() > 0 && this.candidates.values().stream().allMatch(x -> x.size() > 0) && this.candidates.values().stream().flatMap(Collection::stream).distinct().count() >= (long)this.candidates.size();
        return b;
    }

    private boolean allEmbeddingsNonNull(Embedding emb) {
        for (BigraphEntity.NodeEntity each : emb.values()) {
            if (each != null) continue;
            return false;
        }
        return true;
    }

    private boolean allCandidateNodesHaveValues(MutableMap<BigraphEntity.NodeEntity<?>, List<BigraphEntity.NodeEntity<?>>> candidates) {
        for (List each : candidates.values()) {
            if (each != null && each.size() != 0) continue;
            return false;
        }
        return true;
    }

    private void recursiveSearch3(BigraphEntity.NodeEntity u_s, LinkedList<BigraphEntity.NodeEntity<?>> cands, int index, Embedding emb) {
        if (index > cands.size()) {
            return;
        }
        if (emb.size() == this.candidates.size() && this.allEmbeddingsNonNull(emb)) {
            int singleMatchCnt = 0;
            for (Map.Entry next : emb.entrySet()) {
                List<BigraphEntity.NodeEntity<?>> incidentNodesRedex = this.getIncidentNodesOf((BigraphEntity.NodeEntity)next.getKey(), this.redex);
                List<BigraphEntity.NodeEntity<?>> incidentNodesAgent = this.getIncidentNodesOf((BigraphEntity.NodeEntity)next.getValue(), this.agent);
                List collect = incidentNodesAgent.stream().filter(emb::containsValue).collect(Collectors.toList());
                List collect1 = emb.entrySet().stream().filter(e -> collect.stream().anyMatch(x -> ((BigraphEntity.NodeEntity)e.getValue()).equals(x))).map(Map.Entry::getKey).collect(Collectors.toList());
                if (collect1.size() != incidentNodesRedex.size()) continue;
                ++singleMatchCnt;
            }
            if (singleMatchCnt == this.candidates.size()) {
                this.embeddingSet.add(new Embedding(emb));
            }
        } else {
            List nodeEntities = (List)this.candidates.get(cands.get(index));
            int nextIx = index + 1;
            for (BigraphEntity.NodeEntity n : nodeEntities) {
                emb.put(cands.get(index), n);
                this.recursiveSearch3(cands.get(index), cands, nextIx, emb);
                emb.remove(cands.get(index));
            }
        }
    }

    public Set<Embedding> getEmbeddingSet() {
        return this.embeddingSet;
    }

    private List<BigraphEntity.NodeEntity<?>> getIncidentNodesOf(BigraphEntity.NodeEntity<?> node, Bigraph<?> bigraph) {
        Collection incidentHyperedges = bigraph.getIncidentLinksOf(node);
        MutableList collector = Lists.mutable.empty();
        for (BigraphEntity.Link x : incidentHyperedges) {
            Collection pointsFromLink = bigraph.getPointsFromLink(x);
            for (BigraphEntity p : pointsFromLink) {
                BigraphEntity.NodeEntity nodeOfPort;
                if (!BigraphEntityType.isPort((BigraphEntity)p) || (nodeOfPort = bigraph.getNodeOfPort((BigraphEntity.Port)p)).equals(node) || collector.contains((Object)nodeOfPort)) continue;
                collector.add((Object)nodeOfPort);
            }
        }
        return collector;
    }

    public MutableMap<BigraphEntity.NodeEntity<?>, List<BigraphEntity.NodeEntity<?>>> getCandidates() {
        return this.candidates;
    }

    public static class Embedding
    extends HashMap<BigraphEntity.NodeEntity<?>, BigraphEntity.NodeEntity<?>> {
        public Embedding() {
        }

        public Embedding(Map<? extends BigraphEntity.NodeEntity<?>, ? extends BigraphEntity.NodeEntity<?>> m) {
            super(m);
        }
    }
}

