/*
 * Decompiled with CFR 0.152.
 */
package org.bigraphs.framework.simulation.modelchecking;

import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.bigraphs.framework.core.Bigraph;
import org.bigraphs.framework.core.BigraphFileModelManagement;
import org.bigraphs.framework.core.EcoreBigraph;
import org.bigraphs.framework.core.Signature;
import org.bigraphs.framework.core.exceptions.AgentIsNullException;
import org.bigraphs.framework.core.exceptions.AgentNotGroundException;
import org.bigraphs.framework.core.exceptions.AgentNotPrimeException;
import org.bigraphs.framework.core.exceptions.ReactiveSystemException;
import org.bigraphs.framework.core.providers.ExecutorServicePoolProvider;
import org.bigraphs.framework.core.reactivesystem.BigraphMatch;
import org.bigraphs.framework.core.reactivesystem.ReactionGraph;
import org.bigraphs.framework.core.reactivesystem.ReactionRule;
import org.bigraphs.framework.core.reactivesystem.ReactiveSystem;
import org.bigraphs.framework.core.reactivesystem.ReactiveSystemPredicate;
import org.bigraphs.framework.simulation.encoding.BigraphCanonicalForm;
import org.bigraphs.framework.simulation.exceptions.BigraphSimulationException;
import org.bigraphs.framework.simulation.exceptions.InvalidSimulationStrategy;
import org.bigraphs.framework.simulation.exceptions.ModelCheckerExecutorServiceNotProvided;
import org.bigraphs.framework.simulation.matching.AbstractBigraphMatcher;
import org.bigraphs.framework.simulation.modelchecking.BreadthFirstSimulationStrategy;
import org.bigraphs.framework.simulation.modelchecking.BreadthFirstStrategy;
import org.bigraphs.framework.simulation.modelchecking.ModelCheckingOptions;
import org.bigraphs.framework.simulation.modelchecking.ModelCheckingStrategy;
import org.bigraphs.framework.simulation.modelchecking.ModelCheckingStrategySupport;
import org.bigraphs.framework.simulation.modelchecking.RandomAgentModelCheckingStrategy;
import org.bigraphs.framework.simulation.modelchecking.predicates.PredicateChecker;
import org.bigraphs.framework.visualization.BigraphGraphvizExporter;
import org.bigraphs.framework.visualization.ReactionGraphExporter;
import org.jgrapht.GraphPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BigraphModelChecker<B extends Bigraph<? extends Signature<?>>> {
    private final Logger logger = LoggerFactory.getLogger(BigraphModelChecker.class);
    ExecutorService executorService;
    private final Class<B> genericType;
    protected ModelCheckingStrategy<B> modelCheckingStrategy;
    protected SimulationStrategy.Type simulationStrategyType;
    protected ReactiveSystemListener<B> reactiveSystemListener;
    protected BigraphCanonicalForm canonicalForm = BigraphCanonicalForm.createInstance(true);
    protected PredicateChecker<B> predicateChecker = null;
    protected ModelCheckingOptions options;
    final ReactiveSystem<B> reactiveSystem;
    ReactionGraph<B> reactionGraph;
    private static final ReactiveSystemListener<? extends Bigraph<? extends Signature<?>>> EMPTY_LISTENER = new EmptyReactiveSystemListener();

    public BigraphModelChecker(ReactiveSystem<B> reactiveSystem, ModelCheckingOptions options) {
        this(reactiveSystem, SimulationStrategy.Type.BFS, options);
    }

    public BigraphModelChecker(ReactiveSystem<B> reactiveSystem, SimulationStrategy.Type simulationStrategyType, ModelCheckingOptions options) {
        this(reactiveSystem, simulationStrategyType, options, null);
        this.onAttachListener(this);
    }

    public BigraphModelChecker(ReactiveSystem<B> reactiveSystem, SimulationStrategy.Type simulationStrategyType, ModelCheckingOptions options, ReactiveSystemListener<B> listener) {
        Optional.ofNullable(listener).map(this::setReactiveSystemListener).orElseGet(() -> this.setReactiveSystemListener(EMPTY_LISTENER));
        this.loadServiceExecutor();
        this.genericType = this.getGenericTypeClass();
        this.reactiveSystem = reactiveSystem;
        this.reactionGraph = new ReactionGraph();
        this.options = options;
        this.simulationStrategyType = simulationStrategyType;
        try {
            this.modelCheckingStrategy = this.createStrategy(this.simulationStrategyType);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public BigraphCanonicalForm acquireCanonicalForm() {
        BigraphCanonicalForm inst = ((ModelCheckingOptions.TransitionOptions)this.options.get(ModelCheckingOptions.Options.TRANSITION)).allowReducibleClasses() ? BigraphCanonicalForm.createInstance() : BigraphCanonicalForm.createInstance(true);
        if (((ModelCheckingOptions.TransitionOptions)this.options.get(ModelCheckingOptions.Options.TRANSITION)).isRewriteOpenLinks()) {
            inst.setRewriteOpenLinks(true);
        }
        return inst;
    }

    private void loadServiceExecutor() {
        ServiceLoader<ExecutorServicePoolProvider> load = ServiceLoader.load(ExecutorServicePoolProvider.class);
        load.reload();
        Iterator<ExecutorServicePoolProvider> iterator = load.iterator();
        if (iterator.hasNext()) {
            ExecutorServicePoolProvider next = iterator.next();
            this.executorService = next.provide();
        }
        if (this.executorService == null) {
            throw new ModelCheckerExecutorServiceNotProvided();
        }
    }

    private ModelCheckingStrategy<B> createStrategy(SimulationStrategy.Type simulationStrategyType) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<ModelCheckingStrategy> simulationStrategyClass = SimulationStrategy.getSimulationStrategyClass(simulationStrategyType);
        return simulationStrategyClass.getConstructor(BigraphModelChecker.class).newInstance(this);
    }

    public void execute() throws BigraphSimulationException, ReactiveSystemException {
        this.assertReactionSystemValid();
        this.doWork();
        this.prepareOutput();
    }

    public Future<ReactionGraph<B>> executeAsync() throws BigraphSimulationException, ReactiveSystemException {
        this.assertReactionSystemValid();
        return this.executorService.submit(() -> {
            this.doWork();
            return this.getReactionGraph();
        });
    }

    private void doWork() {
        this.reactiveSystemListener.onReactiveSystemStarted();
        this.modelCheckingStrategy.synthesizeTransitionSystem();
        if (this.modelCheckingStrategy instanceof ModelCheckingStrategySupport) {
            int occurrenceCount = ((ModelCheckingStrategySupport)this.modelCheckingStrategy).getOccurrenceCount();
            this.getReactionGraph().getGraphStats().setOccurrenceCount(occurrenceCount);
        }
        this.reactiveSystemListener.onReactiveSystemFinished();
    }

    protected void assertReactionSystemValid() throws ReactiveSystemException {
        if (this.reactiveSystem.getAgent() == null) {
            throw new AgentIsNullException();
        }
        if (!this.reactiveSystem.getAgent().isGround()) {
            throw new AgentNotGroundException();
        }
        if (!this.reactiveSystem.getAgent().isPrime()) {
            throw new AgentNotPrimeException();
        }
        if (Objects.isNull(this.modelCheckingStrategy)) {
            throw new InvalidSimulationStrategy();
        }
    }

    public ReactiveSystem<B> getReactiveSystem() {
        return this.reactiveSystem;
    }

    public List<ReactiveSystemPredicate<B>> getPredicates() {
        return new ArrayList<ReactiveSystemPredicate<B>>(this.reactiveSystem.getPredicates());
    }

    public AbstractBigraphMatcher<B> getMatcher() {
        return AbstractBigraphMatcher.create(this.genericType);
    }

    public synchronized ReactionGraph<B> getReactionGraph() {
        return this.reactionGraph;
    }

    public synchronized <A> A watch(Supplier<A> function) {
        if (this.options.isMeasureTime()) {
            Stopwatch timer = Stopwatch.createStarted();
            A apply = function.get();
            long elapsed = timer.stop().elapsed(TimeUnit.MILLISECONDS);
            this.logger.debug("Time (ms): {}", (Object)elapsed);
            return apply;
        }
        return function.get();
    }

    protected String exportState(B bigraph, String canonicalForm, String suffix) {
        block5: {
            ModelCheckingOptions.ExportOptions opts;
            if (Objects.nonNull(this.options.get(ModelCheckingOptions.Options.EXPORT)) && (opts = (ModelCheckingOptions.ExportOptions)this.options.get(ModelCheckingOptions.Options.EXPORT)).hasOutputStatesFolder()) {
                String label = "";
                try {
                    label = this.reactionGraph.getLabeledNodeByCanonicalForm(canonicalForm).isPresent() && this.reactionGraph.getLabeledNodeByCanonicalForm(canonicalForm).get() instanceof ReactionGraph.DefaultLabeledNode ? ((ReactionGraph.LabeledNode)this.reactionGraph.getLabeledNodeByCanonicalForm(canonicalForm).get()).getLabel() : String.format("state-%s.png", suffix);
                    if (opts.isXMIEnabled()) {
                        BigraphFileModelManagement.Store.exportAsInstanceModel((EcoreBigraph)((EcoreBigraph)bigraph), (OutputStream)new FileOutputStream(Paths.get(opts.getOutputStatesFolder().toString(), label) + ".xmi"));
                        this.logger.debug("Exporting state as xmi {}", (Object)label);
                    }
                    if (opts.isPNGEnabled()) {
                        BigraphGraphvizExporter.toPNG(bigraph, (boolean)true, (File)Paths.get(opts.getOutputStatesFolder().toString(), label + ".png").toFile());
                        this.logger.debug("Exporting state as png {}", (Object)label);
                    }
                    return label;
                }
                catch (IOException e) {
                    this.logger.error(e.toString());
                    if (label.isEmpty()) break block5;
                    return label;
                }
            }
        }
        return null;
    }

    private void onAttachListener(BigraphModelChecker<B> modelChecker) {
        if (modelChecker instanceof ReactiveSystemListener) {
            modelChecker.setReactiveSystemListener((ReactiveSystemListener)((Object)this));
        } else {
            modelChecker.setReactiveSystemListener(EMPTY_LISTENER);
        }
    }

    private Class<B> getGenericTypeClass() {
        try {
            String className = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0].getTypeName();
            Class<?> clazz = Class.forName(className);
            return clazz;
        }
        catch (Exception e) {
            throw new IllegalStateException("Class is not parametrized with a generic type!");
        }
    }

    void prepareOutput() {
        try {
            this.exportReactionGraph(this.getReactionGraph());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void exportReactionGraph(ReactionGraph<B> reactionGraph) throws IOException {
        ModelCheckingOptions.ExportOptions opts = (ModelCheckingOptions.ExportOptions)this.options.get(ModelCheckingOptions.Options.EXPORT);
        if (opts != null && opts.getReactionGraphFile() != null) {
            if (!reactionGraph.isEmpty()) {
                ReactionGraphExporter graphExporter = new ReactionGraphExporter(this.reactiveSystem);
                graphExporter.toPNG(reactionGraph, opts.getReactionGraphFile());
            } else {
                this.logger.debug("Trace is not exported because reaction graph is empty.");
            }
        } else {
            this.logger.debug("Output path for Trace wasn't set. Will not export.");
        }
    }

    public synchronized BigraphModelChecker<B> setReactiveSystemListener(ReactiveSystemListener<B> reactiveSystemListener) {
        this.reactiveSystemListener = reactiveSystemListener;
        return this;
    }

    public static class SimulationStrategy {
        public static <B extends Bigraph<? extends Signature<?>>> Class<? extends ModelCheckingStrategy> getSimulationStrategyClass(Type type) {
            switch (type) {
                case BFS: {
                    return BreadthFirstStrategy.class;
                }
                case RANDOM: {
                    return RandomAgentModelCheckingStrategy.class;
                }
                case SIMULATION: {
                    return BreadthFirstSimulationStrategy.class;
                }
            }
            return BreadthFirstStrategy.class;
        }

        public static enum Type {
            BFS,
            RANDOM,
            SIMULATION;

        }
    }

    public static interface ReactiveSystemListener<B extends Bigraph<? extends Signature<?>>> {
        default public void onReactiveSystemStarted() {
        }

        default public void onReactiveSystemFinished() {
        }

        default public void onCheckingReactionRule(ReactionRule<B> reactionRule) {
        }

        default public void onUpdateReactionRuleApplies(B agent, ReactionRule<B> reactionRule, BigraphMatch<B> matchResult) {
        }

        default public void onReactionIsNull() {
        }

        default public void onAllPredicateMatched(B currentAgent, String label) {
        }

        default public void onPredicateMatched(B currentAgent, ReactiveSystemPredicate<B> predicate) {
        }

        default public void onSubPredicateMatched(B currentAgent, ReactiveSystemPredicate<B> predicate, B context, B subBigraph, B redexOnly, B paramsOnly) {
        }

        default public void onPredicateViolated(B currentAgent, ReactiveSystemPredicate<B> predicate, GraphPath<ReactionGraph.LabeledNode, ReactionGraph.LabeledEdge> counterExampleTrace) {
        }

        default public void onError(Exception e) {
        }
    }

    private static class EmptyReactiveSystemListener<B extends Bigraph<? extends Signature<?>>>
    implements ReactiveSystemListener<B> {
        private EmptyReactiveSystemListener() {
        }
    }
}

