/*
 * Decompiled with CFR 0.152.
 */
package org.bigraphs.framework.simulation.modelchecking;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.bigraphs.framework.converter.jlibbig.JLibBigBigraphDecoder;
import org.bigraphs.framework.converter.jlibbig.JLibBigBigraphEncoder;
import org.bigraphs.framework.core.Bigraph;
import org.bigraphs.framework.core.Signature;
import org.bigraphs.framework.core.impl.pure.PureBigraph;
import org.bigraphs.framework.core.reactivesystem.BMatchResult;
import org.bigraphs.framework.core.reactivesystem.BigraphMatch;
import org.bigraphs.framework.core.reactivesystem.ReactionGraph;
import org.bigraphs.framework.core.reactivesystem.ReactionRule;
import org.bigraphs.framework.core.reactivesystem.ReactiveSystemPredicate;
import org.bigraphs.framework.simulation.matching.MatchIterable;
import org.bigraphs.framework.simulation.modelchecking.BigraphModelChecker;
import org.bigraphs.framework.simulation.modelchecking.ModelCheckingOptions;
import org.bigraphs.framework.simulation.modelchecking.ModelCheckingStrategySupport;
import org.bigraphs.framework.simulation.modelchecking.predicates.PredicateChecker;
import org.bigraphs.framework.simulation.modelchecking.predicates.SubBigraphMatchPredicate;
import org.bigraphs.framework.simulation.modelchecking.reactions.AbstractReactionRuleSupplier;
import org.bigraphs.framework.simulation.modelchecking.reactions.InOrderReactionRuleSupplier;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BreadthFirstStrategy<B extends Bigraph<? extends Signature<?>>>
extends ModelCheckingStrategySupport<B> {
    private final Logger logger = LoggerFactory.getLogger(BreadthFirstStrategy.class);
    protected PredicateChecker<B> predicateChecker;
    protected JLibBigBigraphDecoder decoder = new JLibBigBigraphDecoder();
    protected JLibBigBigraphEncoder encoder = new JLibBigBigraphEncoder();

    public BreadthFirstStrategy(BigraphModelChecker<B> modelChecker) {
        super(modelChecker);
    }

    @Override
    public synchronized void synthesizeTransitionSystem() {
        this.predicateChecker = new PredicateChecker(this.modelChecker.getReactiveSystem().getPredicates());
        ModelCheckingOptions options = this.modelChecker.options;
        if (Objects.nonNull(options.get(ModelCheckingOptions.Options.EXPORT))) {
            ModelCheckingOptions.ExportOptions opts = (ModelCheckingOptions.ExportOptions)options.get(ModelCheckingOptions.Options.EXPORT);
            this.modelChecker.getReactionGraph().setCanonicalNodeLabel(opts.getPrintCanonicalStateLabel().booleanValue());
        }
        ModelCheckingOptions.TransitionOptions transitionOptions = (ModelCheckingOptions.TransitionOptions)options.get(ModelCheckingOptions.Options.TRANSITION);
        boolean reactionGraphWithCycles = options.isReactionGraphWithCycles();
        this.logger.debug("Maximum transitions={}", (Object)transitionOptions.getMaximumTransitions());
        this.logger.debug("reactionGraphWithCycles={}", (Object)reactionGraphWithCycles);
        this.modelChecker.getReactionGraph().reset();
        ConcurrentLinkedDeque<Bigraph> workingQueue = new ConcurrentLinkedDeque<Bigraph>();
        Bigraph initialAgent = this.modelChecker.getReactiveSystem().getAgent();
        it.uniud.mads.jlibbig.core.std.Bigraph encoded = this.encoder.encode((PureBigraph)initialAgent);
        initialAgent = this.decoder.decode(encoded);
        String rootBfcs = this.modelChecker.acquireCanonicalForm().bfcs(initialAgent);
        workingQueue.add(initialAgent);
        AtomicInteger iterationCounter = new AtomicInteger(0);
        this.resetOccurrenceCounter();
        while (!workingQueue.isEmpty() && iterationCounter.get() < transitionOptions.getMaximumTransitions()) {
            ConcurrentLinkedQueue reactionResults = new ConcurrentLinkedQueue();
            Bigraph theAgent = (Bigraph)workingQueue.remove();
            String bfcfOfW = this.modelChecker.acquireCanonicalForm().bfcs(theAgent);
            InOrderReactionRuleSupplier inOrder = AbstractReactionRuleSupplier.createInOrder(this.modelChecker.getReactiveSystem().getReactionRules());
            Stream rrStream = Stream.generate(inOrder);
            if (options.isParallelRuleMatching()) {
                rrStream = (Stream)rrStream.parallel();
                assert (rrStream.isParallel());
            }
            rrStream.limit(this.modelChecker.getReactiveSystem().getReactionRules().size()).peek(x -> this.getListener().onCheckingReactionRule(x)).flatMap(eachRule -> {
                MatchIterable match = this.modelChecker.watch(() -> this.modelChecker.getMatcher().match(theAgent, (ReactionRule<Bigraph>)eachRule));
                for (BigraphMatch eachMatch : match) {
                    this.increaseOccurrenceCounter();
                    Bigraph reaction = null;
                    reaction = theAgent.getSites().isEmpty() || eachMatch.getParameters().isEmpty() ? this.getReactiveSystem().buildGroundReaction(theAgent, eachMatch, eachRule) : this.getReactiveSystem().buildParametricReaction(theAgent, eachMatch, eachRule);
                    Optional.ofNullable(reaction).map(x -> reactionResults.add(this.createMatchResult(eachRule, eachMatch, x, bfcfOfW, this.getOccurrenceCount()))).orElseGet(() -> {
                        this.getListener().onReactionIsNull();
                        return false;
                    });
                }
                return reactionResults.stream();
            }).forEachOrdered(matchResult -> {
                String bfcf = this.modelChecker.acquireCanonicalForm().bfcs(matchResult.getBigraph());
                String reactionLbl = (String)this.modelChecker.getReactiveSystem().getReactionRulesMap().inverse().get(matchResult.getReactionRule());
                if (!this.modelChecker.getReactionGraph().containsBigraph(bfcf)) {
                    this.modelChecker.getReactionGraph().addEdge(theAgent, bfcfOfW, matchResult.getBigraph(), bfcf, (BMatchResult)matchResult, reactionLbl);
                    workingQueue.add((Bigraph)matchResult.getBigraph());
                    this.getListener().onUpdateReactionRuleApplies(theAgent, matchResult.getReactionRule(), matchResult.getMatch());
                    this.modelChecker.exportState(matchResult.getBigraph(), bfcf, String.valueOf(matchResult.getOccurrenceCount()));
                    iterationCounter.incrementAndGet();
                } else if (reactionGraphWithCycles) {
                    this.modelChecker.getReactionGraph().addEdge(theAgent, bfcfOfW, matchResult.getBigraph(), bfcf, (BMatchResult)matchResult, reactionLbl);
                }
            });
            if (this.predicateChecker.getPredicates().isEmpty()) continue;
            if (this.predicateChecker.checkAll(theAgent)) {
                String label = "";
                Optional tmp = this.modelChecker.reactionGraph.getLabeledNodeByCanonicalForm(bfcfOfW);
                label = tmp.isPresent() && tmp.get() instanceof ReactionGraph.DefaultLabeledNode ? ((ReactionGraph.LabeledNode)tmp.get()).getLabel() : String.format("state-%s", String.valueOf(this.modelChecker.reactionGraph.getGraph().vertexSet().size()));
                this.getListener().onAllPredicateMatched(theAgent, label);
                this.modelChecker.getReactionGraph().getLabeledNodeByCanonicalForm(bfcfOfW).ifPresent(labeledNode -> this.predicateChecker.getPredicates().forEach(p -> this.modelChecker.getReactionGraph().addPredicateMatchToNode(labeledNode, p)));
                continue;
            }
            this.predicateChecker.getChecked().forEach((key, value) -> {
                if (!value.booleanValue()) {
                    try {
                        GraphPath pathBetween = DijkstraShortestPath.findPathBetween((Graph)this.modelChecker.getReactionGraph().getGraph(), (Object)((ReactionGraph.LabeledNode)this.modelChecker.getReactionGraph().getLabeledNodeByCanonicalForm(bfcfOfW).get()), (Object)((ReactionGraph.LabeledNode)this.modelChecker.getReactionGraph().getLabeledNodeByCanonicalForm(rootBfcs).get()));
                        this.logger.debug("Counter-example trace for predicate violation: start state={}, end state={}", pathBetween.getStartVertex(), pathBetween.getEndVertex());
                        this.getListener().onPredicateViolated(theAgent, (ReactiveSystemPredicate<Bigraph>)key, (GraphPath<ReactionGraph.LabeledNode, ReactionGraph.LabeledEdge>)pathBetween);
                    }
                    catch (Exception e) {
                        this.getListener().onError(e);
                    }
                } else {
                    this.getListener().onPredicateMatched(theAgent, (ReactiveSystemPredicate<Bigraph>)key);
                    if (key instanceof SubBigraphMatchPredicate) {
                        this.getListener().onSubPredicateMatched(theAgent, (ReactiveSystemPredicate<Bigraph>)key, (Bigraph)((SubBigraphMatchPredicate)((Object)key)).getContextBigraphResult(), (Bigraph)((SubBigraphMatchPredicate)((Object)key)).getSubBigraphResult(), (Bigraph)((SubBigraphMatchPredicate)((Object)key)).getSubRedexResult(), (Bigraph)((SubBigraphMatchPredicate)((Object)key)).getSubBigraphParamResult());
                    }
                    this.modelChecker.getReactionGraph().getLabeledNodeByCanonicalForm(bfcfOfW).ifPresent(labeledNode -> this.modelChecker.getReactionGraph().addPredicateMatchToNode(labeledNode, key));
                }
            });
        }
        this.logger.debug("Total States: {}", (Object)iterationCounter.get());
        this.logger.debug("Total Transitions: {}", (Object)this.modelChecker.getReactionGraph().getGraph().edgeSet().size());
        this.logger.debug("Total Occurrences: {}", (Object)this.getOccurrenceCount());
    }
}

