/*
 * Decompiled with CFR 0.152.
 */
package org.bigraphs.framework.simulation.modelchecking;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="model-checking", ignoreInvalidFields=true)
public class ModelCheckingOptions {
    private static final int DEFAULT_MAX_TRANSITIONS = Integer.MAX_VALUE;
    private Map<Options, Opts> optsMap = new ConcurrentHashMap<Options, Opts>();
    private ExportOptions exportOpts;
    private TransitionOptions transitionOpts;
    private boolean measureTime = false;
    private boolean parallelRuleMatching = false;
    private boolean reactionGraphWithCycles = true;

    ModelCheckingOptions() {
    }

    public static ExportOptions.Builder exportOpts() {
        return new ExportOptions.Builder();
    }

    public static TransitionOptions.Builder transitionOpts() {
        return new TransitionOptions.Builder();
    }

    public static ModelCheckingOptions create() {
        return new ModelCheckingOptions();
    }

    public ModelCheckingOptions and(Opts opts) {
        this.optsMap.put(opts.getType(), opts);
        if (opts.getType() == Options.TRANSITION) {
            this.transitionOpts = (TransitionOptions)opts;
        }
        if (opts.getType() == Options.EXPORT) {
            this.exportOpts = (ExportOptions)opts;
        }
        return this;
    }

    public void setMeasureTime(boolean measureTime) {
        this.measureTime = measureTime;
    }

    public boolean isMeasureTime() {
        return this.measureTime;
    }

    public ModelCheckingOptions doMeasureTime(boolean measureTime) {
        this.measureTime = measureTime;
        return this;
    }

    public void setParallelRuleMatching(boolean flag) {
        this.parallelRuleMatching = flag;
    }

    public ModelCheckingOptions withParallelRuleMatching(boolean flag) {
        this.parallelRuleMatching = flag;
        return this;
    }

    public boolean isParallelRuleMatching() {
        return this.parallelRuleMatching;
    }

    public boolean isReactionGraphWithCycles() {
        return this.reactionGraphWithCycles;
    }

    public ModelCheckingOptions setReactionGraphWithCycles(boolean reactionGraphWithCycles) {
        this.reactionGraphWithCycles = reactionGraphWithCycles;
        return this;
    }

    public <T extends Opts> T get(Options kind) {
        if (this.optsMap.size() == 0) {
            if (this.transitionOpts != null) {
                this.and(this.transitionOpts);
            }
            if (this.exportOpts != null) {
                this.and(this.exportOpts);
            }
        }
        if (this.optsMap.get((Object)kind) == null) {
            return null;
        }
        return (T)((Opts)kind.getOptionClassType().cast(this.optsMap.get((Object)kind)));
    }

    void setExportOptions(ExportOptions exportOpts) {
        this.exportOpts = exportOpts;
    }

    void setTransitionOptions(TransitionOptions transitionOpts) {
        this.transitionOpts = transitionOpts;
    }

    public static final class ExportOptions
    implements Opts {
        private File outputStatesFolder;
        private File reactionGraphFile;
        @Deprecated
        private File rewriteResultFolder;
        private Boolean printCanonicalStateLabel;
        private List<Format> formatsEnabled;

        ExportOptions() {
            this(new File("./states/"), new File("./transition_graph.png"), new File("./results/"), (Boolean)false, Format.XMI, Format.PNG);
        }

        ExportOptions(File outputStatesFolder, File reactionGraphFile, File rewriteResultFolder, Boolean printCanonicalStateLabel, Format ... formatsEnabled) {
            this(outputStatesFolder, reactionGraphFile, rewriteResultFolder, printCanonicalStateLabel, formatsEnabled == null || formatsEnabled.length == 0 ? List.of() : List.of(formatsEnabled));
        }

        ExportOptions(File outputStatesFolder, File reactionGraphFile, File rewriteResultFolder, Boolean printCanonicalStateLabel, List<Format> formatsEnabled) {
            this.outputStatesFolder = outputStatesFolder;
            this.reactionGraphFile = reactionGraphFile;
            this.rewriteResultFolder = rewriteResultFolder;
            this.printCanonicalStateLabel = printCanonicalStateLabel;
            this.formatsEnabled = formatsEnabled;
        }

        boolean isPNGEnabled() {
            return this.formatsEnabled != null && this.formatsEnabled.contains((Object)Format.PNG);
        }

        boolean isXMIEnabled() {
            return this.formatsEnabled != null && this.formatsEnabled.contains((Object)Format.XMI);
        }

        public File getOutputStatesFolder() {
            return this.outputStatesFolder;
        }

        public boolean hasOutputStatesFolder() {
            return Objects.nonNull(this.outputStatesFolder);
        }

        @Deprecated
        public boolean hasRewriteResultFolder() {
            return Objects.nonNull(this.rewriteResultFolder);
        }

        @Deprecated
        public File getRewriteResultFolder() {
            return this.rewriteResultFolder;
        }

        void setOutputStatesFolder(File outputStatesFolder) {
            this.outputStatesFolder = outputStatesFolder;
        }

        void setReactionGraphFile(File reactionGraphFile) {
            this.reactionGraphFile = reactionGraphFile;
        }

        @Deprecated
        void setRewriteResultFolder(File rewriteResultFolder) {
            this.rewriteResultFolder = rewriteResultFolder;
        }

        void setPrintCanonicalStateLabel(Boolean printCanonicalStateLabel) {
            this.printCanonicalStateLabel = printCanonicalStateLabel;
        }

        public List<Format> getFormatsEnabled() {
            return this.formatsEnabled;
        }

        public void setFormatsEnabled(List<Format> formatsEnabled) {
            this.formatsEnabled = formatsEnabled;
        }

        public Boolean getPrintCanonicalStateLabel() {
            return this.printCanonicalStateLabel;
        }

        public File getReactionGraphFile() {
            return this.reactionGraphFile;
        }

        public boolean hasReactionGraphFile() {
            return Objects.nonNull(this.reactionGraphFile);
        }

        @Override
        public Options getType() {
            return Options.EXPORT;
        }

        public Builder toBuilder() {
            return ModelCheckingOptions.exportOpts().setOutputStatesFolder(this.outputStatesFolder).setPrintCanonicalStateLabel(this.printCanonicalStateLabel).setReactionGraphFile(this.reactionGraphFile).setRewriteResultFolder(this.rewriteResultFolder).setFormatsEnabled(this.formatsEnabled);
        }

        public static enum Format {
            PNG,
            XMI;

        }

        public static class Builder {
            private File outputStatesFolder = null;
            private File reactionGraphFile = null;
            private List<Format> formatsEnabled = List.of();
            @Deprecated
            private File rewriteResultFolder = null;
            private Boolean printCanonicalStateLabel = false;

            public Builder setOutputStatesFolder(File outputStatesFolder) {
                this.outputStatesFolder = outputStatesFolder;
                return this;
            }

            public Builder setReactionGraphFile(File reactionGraphFile) {
                this.reactionGraphFile = reactionGraphFile;
                return this;
            }

            @Deprecated
            public Builder setRewriteResultFolder(File rewriteResultFolder) {
                this.rewriteResultFolder = rewriteResultFolder;
                return this;
            }

            public Builder setFormatsEnabled(List<Format> formatsEnabled) {
                this.formatsEnabled = formatsEnabled;
                return this;
            }

            public Builder disableAllFormats() {
                this.formatsEnabled = List.of();
                return this;
            }

            public Builder setPrintCanonicalStateLabel(boolean flag) {
                this.printCanonicalStateLabel = flag;
                return this;
            }

            public ExportOptions create() {
                return new ExportOptions(this.outputStatesFolder, this.reactionGraphFile, this.rewriteResultFolder, this.printCanonicalStateLabel, this.formatsEnabled);
            }
        }
    }

    public static final class TransitionOptions
    implements Opts {
        private int maximumTransitions = 100;
        private long maximumTime = 30L;
        private TimeUnit maximumTimeUnit = TimeUnit.SECONDS;
        private boolean allowReducibleClasses;
        private boolean rewriteOpenLinks;

        TransitionOptions() {
        }

        TransitionOptions(int maximumTransitions, long maximumTime, TimeUnit maximumTimeUnit, boolean allowReducibleClasses, boolean rewriteOpenLinks) {
            this.maximumTransitions = maximumTransitions;
            this.maximumTime = maximumTime;
            this.maximumTimeUnit = maximumTimeUnit;
            this.allowReducibleClasses = allowReducibleClasses;
            this.rewriteOpenLinks = rewriteOpenLinks;
        }

        void setMaximumTransitions(int maximumTransitions) {
            this.maximumTransitions = maximumTransitions;
        }

        void setMaximumTime(long maximumTime) {
            this.maximumTime = maximumTime;
        }

        void setMaximumTimeUnit(TimeUnit maximumTimeUnit) {
            this.maximumTimeUnit = maximumTimeUnit;
        }

        void setAllowReducibleClasses(boolean allowReducibleClasses) {
            this.allowReducibleClasses = allowReducibleClasses;
        }

        public int getMaximumTransitions() {
            return this.maximumTransitions;
        }

        public TimeUnit getMaximumTimeUnit() {
            return this.maximumTimeUnit;
        }

        public long getMaximumTime() {
            return this.maximumTime;
        }

        public boolean allowReducibleClasses() {
            return this.allowReducibleClasses;
        }

        public boolean isRewriteOpenLinks() {
            return this.rewriteOpenLinks;
        }

        @Override
        public Options getType() {
            return Options.TRANSITION;
        }

        public Builder toBuilder() {
            return ModelCheckingOptions.transitionOpts().rewriteOpenLinks(this.rewriteOpenLinks).allowReducibleClasses(this.allowReducibleClasses).setMaximumTransitions(this.maximumTransitions).setMaximumTime(this.maximumTime, this.maximumTimeUnit);
        }

        public static class Builder {
            private int maximumTransitions;
            private TimeUnit maximumTimeUnit = TimeUnit.SECONDS;
            private long maximumTime = 60L;
            private boolean reduceStates = true;
            private boolean rewriteOpenLinks = false;

            public Builder setMaximumTransitions(int maximumTransitions) {
                this.maximumTransitions = maximumTransitions;
                return this;
            }

            public Builder setMaximumTime(long maximumTime, TimeUnit maximumTimeUnit) {
                this.maximumTime = maximumTime;
                this.maximumTimeUnit = maximumTimeUnit;
                return this;
            }

            public Builder setMaximumTime(long maximumTime) {
                this.maximumTime = maximumTime;
                return this;
            }

            public Builder allowReducibleClasses(boolean reduceStates) {
                this.reduceStates = reduceStates;
                return this;
            }

            public Builder rewriteOpenLinks(boolean rewriteOpenLinks) {
                this.rewriteOpenLinks = rewriteOpenLinks;
                return this;
            }

            public TransitionOptions create() {
                return new TransitionOptions(this.maximumTransitions, this.maximumTime, this.maximumTimeUnit, this.reduceStates, this.rewriteOpenLinks);
            }
        }
    }

    public static interface Opts {
        public Options getType();
    }

    public static enum Options {
        TRANSITION(TransitionOptions.class),
        EXPORT(ExportOptions.class);

        private Class<?> optionClassType;

        private <T extends Opts> Options(Class<T> c) {
            this.optionClassType = c;
        }

        <T extends Opts> Class<T> getOptionClassType() {
            return this.optionClassType;
        }
    }
}

