/*
 * Decompiled with CFR 0.152.
 */
package org.bigraphs.framework.simulation.modelchecking;

import org.bigraphs.framework.core.Bigraph;
import org.bigraphs.framework.core.Signature;
import org.bigraphs.framework.core.reactivesystem.BMatchResult;
import org.bigraphs.framework.core.reactivesystem.BigraphMatch;
import org.bigraphs.framework.core.reactivesystem.ReactionRule;
import org.bigraphs.framework.core.reactivesystem.ReactiveSystem;
import org.bigraphs.framework.simulation.modelchecking.BigraphModelChecker;
import org.bigraphs.framework.simulation.modelchecking.ModelCheckingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModelCheckingStrategySupport<B extends Bigraph<? extends Signature<?>>>
implements ModelCheckingStrategy<B> {
    private Logger logger = LoggerFactory.getLogger(ModelCheckingStrategySupport.class);
    protected int occurrenceCounter = 0;
    protected BigraphModelChecker<B> modelChecker;

    public ModelCheckingStrategySupport(BigraphModelChecker<B> modelChecker) {
        this.modelChecker = modelChecker;
    }

    protected void increaseOccurrenceCounter() {
        ++this.occurrenceCounter;
    }

    protected void resetOccurrenceCounter() {
        this.occurrenceCounter = 0;
    }

    int getOccurrenceCount() {
        return this.occurrenceCounter;
    }

    MatchResult<B> createMatchResult(ReactionRule<B> reactionRule, BigraphMatch<B> next, B bigraph, int occurrenceCount) {
        return new MatchResult<B>(reactionRule, next, bigraph, "", occurrenceCount);
    }

    MatchResult<B> createMatchResult(ReactionRule<B> reactionRule, BigraphMatch<B> next, B bigraphRewritten, String bfcfOfInitialBigraph, int occurrenceCount) {
        return new MatchResult<B>(reactionRule, next, bigraphRewritten, bfcfOfInitialBigraph, occurrenceCount);
    }

    ReactiveSystem<B> getReactiveSystem() {
        return this.modelChecker.getReactiveSystem();
    }

    BigraphModelChecker.ReactiveSystemListener<B> getListener() {
        return this.modelChecker.reactiveSystemListener;
    }

    public static class MatchResult<B extends Bigraph<? extends Signature<?>>>
    implements BMatchResult<B> {
        private final ReactionRule<B> reactionRule;
        private final BigraphMatch<B> next;
        private final B bigraph;
        private final int occurrenceCount;
        private String canonicalStringOfResult = "";

        public MatchResult(ReactionRule<B> reactionRule, BigraphMatch<B> next, B bigraph, String bfcf, int occurrenceCount) {
            this.reactionRule = reactionRule;
            this.next = next;
            this.bigraph = bigraph;
            this.occurrenceCount = occurrenceCount;
            this.canonicalStringOfResult = bfcf;
        }

        public ReactionRule<B> getReactionRule() {
            return this.reactionRule;
        }

        public BigraphMatch<B> getMatch() {
            return this.next;
        }

        public B getBigraph() {
            return this.bigraph;
        }

        public int getOccurrenceCount() {
            return this.occurrenceCount;
        }

        public String getCanonicalString() {
            return this.canonicalStringOfResult;
        }

        public void setCanonicalStringOfResult(String canonicalStringOfResult) {
            this.canonicalStringOfResult = canonicalStringOfResult;
        }
    }
}

