/*
 * Decompiled with CFR 0.152.
 */
package org.bigraphs.framework.simulation.modelchecking;

import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Stream;
import org.bigraphs.framework.core.Bigraph;
import org.bigraphs.framework.core.Signature;
import org.bigraphs.framework.core.reactivesystem.BigraphMatch;
import org.bigraphs.framework.core.reactivesystem.ReactionRule;
import org.bigraphs.framework.simulation.encoding.BigraphCanonicalForm;
import org.bigraphs.framework.simulation.matching.MatchIterable;
import org.bigraphs.framework.simulation.modelchecking.BigraphModelChecker;
import org.bigraphs.framework.simulation.modelchecking.ModelCheckingOptions;
import org.bigraphs.framework.simulation.modelchecking.ModelCheckingStrategySupport;
import org.bigraphs.framework.simulation.modelchecking.reactions.AbstractReactionRuleSupplier;
import org.bigraphs.framework.simulation.modelchecking.reactions.InOrderReactionRuleSupplier;
import org.bigraphs.framework.simulation.modelchecking.reactions.RandomAgentMatchSupplier;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.MutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomAgentModelCheckingStrategy<B extends Bigraph<? extends Signature<?>>>
extends ModelCheckingStrategySupport<B> {
    private Logger logger = LoggerFactory.getLogger(RandomAgentModelCheckingStrategy.class);

    public RandomAgentModelCheckingStrategy(BigraphModelChecker<B> modelChecker) {
        super(modelChecker);
    }

    @Override
    public void synthesizeTransitionSystem() {
        int transitionCnt;
        ConcurrentLinkedDeque<Object> workingQueue = new ConcurrentLinkedDeque<Object>();
        ModelCheckingOptions options = this.modelChecker.options;
        BigraphCanonicalForm canonicalForm = this.modelChecker.canonicalForm;
        ModelCheckingOptions.TransitionOptions transitionOptions = (ModelCheckingOptions.TransitionOptions)options.get(ModelCheckingOptions.Options.TRANSITION);
        if (Objects.nonNull(options.get(ModelCheckingOptions.Options.EXPORT))) {
            ModelCheckingOptions.ExportOptions opts = (ModelCheckingOptions.ExportOptions)options.get(ModelCheckingOptions.Options.EXPORT);
            this.modelChecker.getReactionGraph().setCanonicalNodeLabel(opts.getPrintCanonicalStateLabel().booleanValue());
        }
        this.modelChecker.getReactionGraph().reset();
        workingQueue.add(this.modelChecker.getReactiveSystem().getAgent());
        this.resetOccurrenceCounter();
        for (transitionCnt = 0; !workingQueue.isEmpty() && transitionCnt < transitionOptions.getMaximumTransitions(); ++transitionCnt) {
            Bigraph theAgent = (Bigraph)workingQueue.remove();
            String bfcfOfW = canonicalForm.bfcs(theAgent);
            InOrderReactionRuleSupplier inOrder = AbstractReactionRuleSupplier.createInOrder(this.modelChecker.getReactiveSystem().getReactionRules());
            MutableList rewrittenAgents = Lists.mutable.empty();
            ((Stream)this.modelChecker.getReactiveSystem().getReactionRules().stream().parallel()).forEachOrdered(eachRule -> {
                this.modelChecker.reactiveSystemListener.onCheckingReactionRule(eachRule);
                MatchIterable match = this.modelChecker.watch(() -> this.modelChecker.getMatcher().match(theAgent, (ReactionRule<Bigraph>)eachRule));
                Iterator iterator = match.iterator();
                while (iterator.hasNext()) {
                    this.increaseOccurrenceCounter();
                    BigraphMatch next = (BigraphMatch)iterator.next();
                    Bigraph reaction = null;
                    reaction = next.getParameters().size() == 0 ? this.getReactiveSystem().buildGroundReaction(theAgent, next, eachRule) : this.getReactiveSystem().buildParametricReaction(theAgent, next, eachRule);
                    if (Objects.nonNull(reaction)) {
                        String bfcf = canonicalForm.bfcs(reaction);
                        String reactionLbl = (String)this.modelChecker.getReactiveSystem().getReactionRulesMap().inverse().get(eachRule);
                        rewrittenAgents.add((Object)reaction);
                        ModelCheckingStrategySupport.MatchResult<Bigraph> matchResult = this.createMatchResult(eachRule, next, reaction, bfcfOfW, this.getOccurrenceCount());
                        if (!this.modelChecker.getReactionGraph().containsBigraph(bfcf)) {
                            this.modelChecker.getReactionGraph().addEdge(theAgent, bfcfOfW, reaction, bfcf, matchResult, reactionLbl);
                            continue;
                        }
                        this.modelChecker.getReactionGraph().addEdge(theAgent, bfcfOfW, reaction, bfcf, matchResult, reactionLbl);
                        continue;
                    }
                    this.modelChecker.reactiveSystemListener.onReactionIsNull();
                }
            });
            if (rewrittenAgents.size() <= 0) continue;
            RandomAgentMatchSupplier randomSupplier = AbstractReactionRuleSupplier.createRandom(rewrittenAgents);
            workingQueue.add(randomSupplier.get());
        }
        this.logger.debug("Total Transitions: {}", (Object)transitionCnt);
        this.logger.debug("Total Occurrences: {}", (Object)this.getOccurrenceCount());
    }
}

